/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.hdwrCCA.provider;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Locale;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Debug {
    private String prefix;
    private static String args;
    private static Level specifiedLevel;
    private static Handler ch;
    private static Logger tl;
    public static final long TYPE_NONE = 0L;
    public static final long TYPE_ALL = -1L;
    public static final long TYPE_FINE;
    public static final long TYPE_FINER;
    public static final long TYPE_FINEST;
    public static final long TYPE_INFO = 1L;
    public static final long TYPE_INFORMATION = 1L;
    public static final long TYPE_WARN = 2L;
    public static final long TYPE_WARNING = 2L;
    public static final long TYPE_ERR = 4L;
    public static final long TYPE_ERROR = 4L;
    public static final long TYPE_FATAL = 8L;
    public static final long TYPE_DEFAULT_MESSAGE = 15L;
    public static final long TYPE_PUBLIC;
    public static final long TYPE_API = 16L;
    public static final long TYPE_CALLBACK = 32L;
    public static final long TYPE_ENTRY_EXIT = 64L;
    public static final long TYPE_ENTRY = 128L;
    public static final long TYPE_EXIT = 256L;
    public static final long TYPE_ERROR_EXC = 512L;
    public static final long TYPE_MISC_DATA = 1024L;
    public static final long TYPE_OBJ_CREATE = 2048L;
    public static final long TYPE_OBJ_DELETE = 4096L;
    public static final long TYPE_PRIVATE = 8192L;
    public static final long TYPE_STATIC = 32768L;
    public static final long TYPE_SVC = 65536L;
    public static final long TYPE_PERF = 131072L;
    public static final long TYPE_LEVEL1 = 262144L;
    public static final long TYPE_LEVEL2 = 524288L;
    public static final long TYPE_LEVEL3 = 0x100000L;
    private static final char[] hexDigits;

    public Debug(String name, String rbName) {
        if (tl == null) {
            tl = Logger.getLogger(name);
            ch = new ConsoleHandler();
            tl.addHandler(ch);
            tl.setLevel(specifiedLevel);
            ch.setLevel(specifiedLevel);
        }
    }

    public static void Help() {
        System.err.println();
        System.err.println("all       turn on all debugging");
        System.err.println("access    print all checkPermission results");
        System.err.println("jar       jar verification");
        System.err.println("policy    loading and granting");
        System.err.println("scl       permissions SecureClassLoader assigns");
        System.err.println();
        System.err.println("The following can be used with access:");
        System.err.println();
        System.err.println("stack     include stack trace");
        System.err.println("domain    dumps all domains in context");
        System.err.println("failure   before throwing exception, dump stack");
        System.err.println("          and domain that didn't have permission");
        System.err.println();
        System.exit(0);
    }

    public static Debug getInstance(String option) {
        return Debug.getInstance(option, option);
    }

    public static Debug getInstance(String option, String prefix) {
        if (Debug.isOn(option)) {
            return new Debug("com.ibm.crypto.hdwrCCA.provider.Debug", null);
        }
        return null;
    }

    public static boolean isOn(String option) {
        if (args == null) {
            return false;
        }
        if (args.indexOf("all") != -1) {
            return true;
        }
        return args.indexOf(option) != -1;
    }

    private String getParms(Object[] parms) {
        String result = " ";
        for (int i = 0; i < parms.length; ++i) {
            result = result + parms[i].toString() + " ";
        }
        return result;
    }

    public void data(long type, Object loggingClass, String loggingMethod, byte[] data) {
        Object[] parms = new Object[]{data};
        tl.log(Level.FINER, (String)loggingClass + " " + loggingMethod, parms);
    }

    public void entry(long type, Object loggingClass, String loggingMethod) {
        if (type == TYPE_FINE) {
            tl.logp(Level.FINE, (String)loggingClass, loggingMethod, "ENTRY");
        } else {
            tl.entering((String)loggingClass, loggingMethod);
        }
    }

    public void entry(long type, Object loggingClass, String loggingMethod, Object parm1) {
        Object[] parms = new Object[]{parm1};
        if (type == TYPE_FINE) {
            tl.logp(Level.FINE, (String)loggingClass, loggingMethod, "ENTRY {0}", parm1);
        } else {
            tl.entering((String)loggingClass, loggingMethod, parms);
        }
    }

    public void entry(long type, Object loggingClass, String loggingMethod, Object parm1, Object parm2) {
        Object[] parms = new Object[]{parm1, parm2};
        if (type == TYPE_FINE) {
            String msg = "ENTRY";
            if (!tl.isLoggable(Level.FINE)) {
                return;
            }
            for (int i = 0; i < parms.length; ++i) {
                msg = msg + " {" + i + "}";
            }
            tl.logp(Level.FINE, (String)loggingClass, loggingMethod, msg, parms);
        } else {
            tl.entering((String)loggingClass, loggingMethod, parms);
        }
    }

    public void entry(long type, Object loggingClass, String loggingMethod, Object[] parms) {
        if (type == TYPE_FINE) {
            String msg = "ENTRY";
            if (parms == null) {
                tl.logp(Level.FINER, (String)loggingClass, loggingMethod, msg);
                return;
            }
            if (!tl.isLoggable(Level.FINE)) {
                return;
            }
            for (int i = 0; i < parms.length; ++i) {
                msg = msg + " {" + i + "}";
            }
            tl.logp(Level.FINER, (String)loggingClass, loggingMethod, msg, parms);
        } else {
            tl.entering((String)loggingClass, loggingMethod, parms);
        }
    }

    public void exception(long type, Object loggingClass, String loggingMethod, Throwable throwable) {
        tl.log(Level.FINE, (String)loggingClass + " " + loggingMethod, throwable);
    }

    public void exit(long type, Object loggingClass, String loggingMethod) {
        if (type == TYPE_FINE) {
            tl.logp(Level.FINE, (String)loggingClass, loggingMethod, "RETURN");
        } else {
            tl.exiting((String)loggingClass, loggingMethod);
        }
    }

    public void exit(long type, Object loggingClass, String loggingMethod, byte retValue) {
        if (type == TYPE_FINE) {
            tl.logp(Level.FINE, (String)loggingClass, loggingMethod, "RETURN {0}", new Byte(retValue));
        } else {
            tl.exiting((String)loggingClass, loggingMethod, new Byte(retValue));
        }
    }

    public void exit(long type, Object loggingClass, String loggingMethod, short retValue) {
        if (type == TYPE_FINE) {
            tl.logp(Level.FINE, (String)loggingClass, loggingMethod, "RETURN {0}", new Short(retValue));
        } else {
            tl.exiting((String)loggingClass, loggingMethod, new Short(retValue));
        }
    }

    public void exit(long type, Object loggingClass, String loggingMethod, int retValue) {
        if (type == TYPE_FINE) {
            tl.logp(Level.FINE, (String)loggingClass, loggingMethod, "RETURN {0}", new Integer(retValue));
        } else {
            tl.exiting((String)loggingClass, loggingMethod, new Integer(retValue));
        }
    }

    public void exit(long type, Object loggingClass, String loggingMethod, long retValue) {
        if (type == TYPE_FINE) {
            tl.logp(Level.FINE, (String)loggingClass, loggingMethod, "RETURN {0}", new Long(retValue));
        } else {
            tl.exiting((String)loggingClass, loggingMethod, new Long(retValue));
        }
    }

    public void exit(long type, Object loggingClass, String loggingMethod, float retValue) {
        if (type == TYPE_FINE) {
            tl.logp(Level.FINE, (String)loggingClass, loggingMethod, "RETURN {0}", new Float(retValue));
        } else {
            tl.exiting((String)loggingClass, loggingMethod, new Float(retValue));
        }
    }

    public void exit(long type, Object loggingClass, String loggingMethod, double retValue) {
        if (type == TYPE_FINE) {
            tl.logp(Level.FINE, (String)loggingClass, loggingMethod, "RETURN {0}", new Double(retValue));
        } else {
            tl.exiting((String)loggingClass, loggingMethod, new Double(retValue));
        }
    }

    public void exit(long type, Object loggingClass, String loggingMethod, char retValue) {
        if (type == TYPE_FINE) {
            tl.logp(Level.FINE, (String)loggingClass, loggingMethod, "RETURN {0}", new Character(retValue));
        } else {
            tl.exiting((String)loggingClass, loggingMethod, new Character(retValue));
        }
    }

    public void exit(long type, Object loggingClass, String loggingMethod, boolean retValue) {
        if (type == TYPE_FINE) {
            tl.logp(Level.FINE, (String)loggingClass, loggingMethod, "RETURN {0}", new Boolean(retValue));
        } else {
            tl.exiting((String)loggingClass, loggingMethod, new Boolean(retValue));
        }
    }

    public void exit(long type, Object loggingClass, String loggingMethod, Object retValue) {
        if (type == TYPE_FINE) {
            tl.logp(Level.FINE, (String)loggingClass, loggingMethod, "RETURN {0}", retValue);
        } else {
            tl.exiting((String)loggingClass, loggingMethod, retValue);
        }
    }

    public void stackTrace(long type, Object loggingClass, String loggingMethod) {
        StringWriter sw = new StringWriter();
        new Throwable().printStackTrace(new PrintWriter(sw));
        tl.logp(Level.FINER, (String)loggingClass, loggingMethod, sw.toString());
    }

    public void stackTrace(long type, Object loggingClass, String loggingMethod, String text) {
        StringWriter sw = new StringWriter();
        new Throwable(text).printStackTrace(new PrintWriter(sw));
        Object[] parms = new Object[]{sw.toString()};
        tl.logp(Level.FINER, (String)loggingClass, loggingMethod, text, parms);
    }

    public void text(long type, Object loggingClass, String loggingMethod, String text) {
        tl.logp(Debug.longToLevel(type), (String)loggingClass, loggingMethod, text);
    }

    public void text(long type, Object loggingClass, String loggingMethod, String text, Object parm1) {
        Object[] parms = new Object[]{parm1};
        tl.logp(Debug.longToLevel(type), (String)loggingClass, loggingMethod, text, parms);
    }

    public void text(long type, Object loggingClass, String loggingMethod, String text, Object parm1, Object parm2) {
        Object[] parms = new Object[]{parm1, parm2};
        tl.logp(Debug.longToLevel(type), (String)loggingClass, loggingMethod, text, parms);
    }

    public void text(long type, Object loggingClass, String loggingMethod, String text, Object[] parms) {
        tl.logp(Debug.longToLevel(type), (String)loggingClass, loggingMethod, text, parms);
    }

    public static String toHexString(BigInteger b) {
        String hexValue = b.toString(16);
        StringBuffer buf = new StringBuffer(hexValue.length() * 2);
        if (hexValue.startsWith("-")) {
            buf.append("   -");
            hexValue = hexValue.substring(1);
        } else {
            buf.append("    ");
        }
        if (hexValue.length() % 2 != 0) {
            hexValue = "0" + hexValue;
        }
        int i = 0;
        while (i < hexValue.length()) {
            buf.append(hexValue.substring(i, i + 2));
            if ((i += 2) == hexValue.length()) continue;
            if (i % 64 == 0) {
                buf.append("\n    ");
                continue;
            }
            if (i % 8 != 0) continue;
            buf.append(" ");
        }
        return buf.toString();
    }

    private static String marshal(String args) {
        if (args != null) {
            String matched;
            StringBuffer target = new StringBuffer();
            StringBuffer source = new StringBuffer(args);
            String keyReg = "[Pp][Ee][Rr][Mm][Ii][Ss][Ss][Ii][Oo][Nn]=";
            String keyStr = "permission=";
            String reg = keyReg + "[a-zA-Z_$][a-zA-Z0-9_$]*([.][a-zA-Z_$][a-zA-Z0-9_$]*)*";
            Pattern pattern = Pattern.compile(reg);
            Matcher matcher = pattern.matcher(source);
            StringBuffer left = new StringBuffer();
            while (matcher.find()) {
                matched = matcher.group();
                target.append(matched.replaceFirst(keyReg, keyStr));
                target.append("  ");
                matcher.appendReplacement(left, "");
            }
            matcher.appendTail(left);
            source = left;
            keyReg = "[Cc][Oo][Dd][Ee][Bb][Aa][Ss][Ee]=";
            keyStr = "codebase=";
            reg = keyReg + "[^, ;]*";
            pattern = Pattern.compile(reg);
            matcher = pattern.matcher(source);
            left = new StringBuffer();
            while (matcher.find()) {
                matched = matcher.group();
                target.append(matched.replaceFirst(keyReg, keyStr));
                target.append("  ");
                matcher.appendReplacement(left, "");
            }
            matcher.appendTail(left);
            source = left;
            target.append(source.toString().toLowerCase(Locale.ENGLISH));
            return target.toString();
        }
        return null;
    }

    public static String toString(byte[] b) {
        if (b == null) {
            return "(null)";
        }
        StringBuilder sb = new StringBuilder(b.length * 3);
        for (int i = 0; i < b.length; ++i) {
            int k = b[i] & 0xFF;
            if (i != 0) {
                sb.append(':');
            }
            sb.append(hexDigits[k >>> 4]);
            sb.append(hexDigits[k & 0xF]);
        }
        return sb.toString();
    }

    public static Level longToLevel(long type) {
        int i = Debug.safeLongToInt(type);
        if (i <= Level.FINEST.intValue()) {
            return Level.FINEST;
        }
        if (i <= Level.FINER.intValue()) {
            return Level.FINER;
        }
        if (i <= Level.FINE.intValue()) {
            return Level.FINE;
        }
        if (i <= Level.CONFIG.intValue()) {
            return Level.CONFIG;
        }
        if (i <= Level.INFO.intValue()) {
            return Level.INFO;
        }
        if (i <= Level.WARNING.intValue()) {
            return Level.WARNING;
        }
        return Level.SEVERE;
    }

    public static int safeLongToInt(long l) {
        if (l < Integer.MIN_VALUE) {
            return Integer.MIN_VALUE;
        }
        if (l > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)l;
    }

    static {
        specifiedLevel = Level.ALL;
        ch = null;
        tl = null;
        args = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("java.security.debug");
            }
        });
        String args2 = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty("java.security.auth.debug");
            }
        });
        if ((args = args == null ? args2 : args + "," + args2) != null) {
            int dotPos;
            if ((args = Debug.marshal(args)).startsWith("ibmjcecca") && (dotPos = args.indexOf(".")) > 0 && dotPos < args.length()) {
                String argLevel = args.substring(dotPos + 1);
                if ("finest".equals(argLevel)) {
                    specifiedLevel = Level.FINEST;
                } else if ("finer".equals(argLevel)) {
                    specifiedLevel = Level.FINER;
                } else if ("fine".equals(argLevel)) {
                    specifiedLevel = Level.FINE;
                }
            }
            if (args.equals("help")) {
                Debug.Help();
            }
        }
        TYPE_FINE = Level.FINE.intValue();
        TYPE_FINER = Level.FINER.intValue();
        TYPE_FINEST = Level.FINEST.intValue();
        TYPE_PUBLIC = Level.FINER.intValue();
        hexDigits = "0123456789abcdef".toCharArray();
    }
}

