/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.hdwrCCA.provider;

import com.ibm.crypto.hdwrCCA.provider.Debug;
import com.ibm.crypto.hdwrCCA.provider.KeyPairUtils;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AlgIdDSA;
import com.ibm.security.x509.X509Key;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.Security;
import java.security.interfaces.DSAParams;
import java.security.spec.DSAParameterSpec;
import java.security.spec.InvalidParameterSpecException;

final class DSAPublicKey
extends X509Key
implements java.security.interfaces.DSAPublicKey,
Serializable {
    private BigInteger y;
    static int number = 0;
    private int id;
    private byte[] token;
    static final long serialVersionUID = 3427401475246011291L;
    private static Debug debug = Debug.getInstance("ibmjcecca");
    private static String className = "com.ibm.crypto.hdwrCCA.provider.DSAPublicKey";

    public DSAPublicKey(BigInteger y, BigInteger p, BigInteger q, BigInteger g) throws InvalidKeyException {
        if (debug != null) {
            Object[] parms = new Object[]{y, p, q, g};
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "DSAPublicKey", parms);
        }
        this.y = y;
        this.algid = new AlgIdDSA(p, q, g);
        KeyPairUtils util = new KeyPairUtils();
        try {
            this.key = new DerValue(2, y.toByteArray()).toByteArray();
            this.encode();
        }
        catch (IOException e) {
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "DSAPublicKey", e);
            }
            throw new InvalidKeyException("Could not DER encode y: " + e.getMessage());
        }
        try {
            DSAParams params = this.getParams();
            DSAParameterSpec tmpSpec = new DSAParameterSpec(params.getP(), params.getQ(), params.getG());
            util.initializeDSA(p.bitLength(), null, null, null, tmpSpec);
        }
        catch (InvalidParameterException e) {
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "DSAPublicKey", e);
            }
            throw new InvalidKeyException("Invalid DSA parameters specified.");
        }
        this.token = util.generateToken(this);
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "DSAPublicKey");
        }
    }

    public DSAPublicKey(byte[] encoded) throws InvalidKeyException {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "DSAPublicKey", (Object)encoded);
        }
        KeyPairUtils util = new KeyPairUtils();
        this.id = number++;
        this.decode(encoded);
        try {
            util.initializeDSA(this.getParams().getP().bitLength(), null, null, null, (DSAParameterSpec)this.getParams());
        }
        catch (InvalidParameterException e) {
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "DSAPublicKey", e);
            }
            throw new InvalidKeyException("Invalid DSA parameters specified.");
        }
        this.token = util.generateToken(this);
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "DSAPublicKey");
        }
    }

    @Override
    public BigInteger getY() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "getY");
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getY", this.y);
        }
        return this.y;
    }

    public byte[] getToken() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "getToken");
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getToken", this.token);
        }
        return this.token;
    }

    @Override
    public DSAParams getParams() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "getParams");
        }
        try {
            if (this.algid instanceof DSAParams) {
                if (debug != null) {
                    debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getParams", this.algid);
                }
                return (DSAParams)this.algid;
            }
            AlgorithmParameters algParams = this.algid.getAlgParameters();
            if (algParams == null) {
                if (debug != null) {
                    debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getParams", null);
                }
                return null;
            }
            DSAParameterSpec paramSpec = algParams.getParameterSpec(DSAParameterSpec.class);
            if (debug != null) {
                debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getParams", paramSpec);
            }
            return paramSpec;
        }
        catch (InvalidParameterSpecException e) {
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "getParams", e);
                debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getParams", null);
            }
            return null;
        }
    }

    protected void parseKeyBits() throws InvalidKeyException {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "parseKeyBits");
        }
        try {
            DerInputStream in = new DerInputStream(this.key);
            this.y = in.getInteger();
        }
        catch (IOException e) {
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "parseKeyBits", e);
            }
            throw new InvalidKeyException("Invalid key: y value\n" + e.getMessage());
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "parseKeyBits");
        }
    }

    public String toString() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "toString");
            debug.exit(Debug.TYPE_PUBLIC, className, "toString");
        }
        if (Security.getProvider("IBMJCE4758") == null && Security.getProvider("IBMJCECCA") == null) {
            return "IBMJCA4758 DSA Public Key:\n" + this.y.toString() + "\n";
        }
        return "IBMJCECCA DSA Public Key:\n" + this.y.toString() + "\n";
    }
}

