/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.hdwrCCA.provider;

import com.ibm.crypto.hdwrCCA.provider.DSAHWKeyParameterSpec;
import com.ibm.crypto.hdwrCCA.provider.DSAKeyHWAttributes;
import com.ibm.crypto.hdwrCCA.provider.DSAParameterGenerator;
import com.ibm.crypto.hdwrCCA.provider.Debug;
import com.ibm.crypto.hdwrCCA.provider.KeyPairUtils;
import com.ibm.crypto.hdwrCCA.provider.PlatformUtilities;
import java.security.AlgorithmParameterGenerator;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.DSAParameterSpec;
import java.security.spec.InvalidParameterSpecException;

public class DSAKeyPairGenerator
extends KeyPairGeneratorSpi {
    private int keySize = 512;
    SecureRandom random = null;
    private DSAParameterSpec params;
    private DSAKeyHWAttributes keyAttribs = null;
    private byte[] keyLabel;
    private static Debug debug = Debug.getInstance("ibmjcecca");
    private static String className = "com.ibm.crypto.hdwrCCA.provider.DSAKeyPairGenerator";

    public DSAKeyPairGenerator() {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "DSAKeyPairGenerator");
            debug.exit(Debug.TYPE_FINE, className, "DSAKeyPairGenerator");
        }
    }

    @Override
    public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException, InvalidParameterException {
        if (debug != null) {
            Object[] parms = new Object[]{params, random};
            debug.entry(Debug.TYPE_FINE, (Object)className, "initialize", parms);
        }
        if (params instanceof DSAHWKeyParameterSpec) {
            this.params = ((DSAHWKeyParameterSpec)params).getDSAParamSpec();
            this.keyAttribs = ((DSAHWKeyParameterSpec)params).getAttributes();
            String myLabel = ((DSAHWKeyParameterSpec)params).getLabelString();
            this.keyLabel = (byte[])(myLabel != null ? myLabel.getBytes(PlatformUtilities.CHARSET_ISO_8859_1) : null);
            this.keySize = ((DSAHWKeyParameterSpec)params).getKeySize();
            if (this.keySize < 512 || this.keySize > 1024 || this.keySize % 64 != 0) {
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "initialize", "(1) Modulus size must range from 512 to 1024 and be a multiple of 64");
                }
                throw new InvalidParameterException("Modulus size must range from 512 to 1024 and be a multiple of 64");
            }
        } else if (params instanceof DSAParameterSpec) {
            this.params = (DSAParameterSpec)params;
            this.keyAttribs = new DSAKeyHWAttributes(0, 3);
        } else {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "initialize", "DSAParameterSpec or DSAHWKeyParameterSpec expected");
            }
            throw new InvalidAlgorithmParameterException("Invalid AlgorithmParameter Spec. DSAParameterSpec or DSAHWKeyParameterSpec expected.");
        }
        this.random = random;
    }

    @Override
    public void initialize(int keySize, SecureRandom random) throws InvalidParameterException {
        if (debug != null) {
            Object[] parms = new Object[]{new Integer(keySize), random};
            debug.entry(Debug.TYPE_FINE, (Object)className, "initialize", parms);
        }
        if (this.keySize < 512 || this.keySize > 1024 || this.keySize % 64 != 0) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "initialize", "Modulus size must range from 512 to 1024 and be a multiple of 64");
            }
            throw new InvalidParameterException("Modulus size must range from 512 to 1024 and be a multiple of 64");
        }
        this.keySize = keySize;
        this.random = random;
        this.params = null;
        this.keyAttribs = new DSAKeyHWAttributes(0, 3);
        this.keyLabel = null;
    }

    @Override
    public KeyPair generateKeyPair() throws InternalError {
        KeyPairUtils util = new KeyPairUtils();
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "generateKeyPair");
        }
        if (this.params == null) {
            this.generateParameters();
        }
        if (this.keyAttribs == null) {
            this.keyAttribs = new DSAKeyHWAttributes(0, 3);
        }
        if (this.random == null) {
            this.random = new SecureRandom();
        }
        try {
            util.initializeDSA(this.params.getP().bitLength(), this.random, this.keyAttribs, this.keyLabel, this.params);
        }
        catch (InvalidParameterException e) {
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "generateKeyPair", e);
            }
            throw new InternalError("Invalid DSA parameters specified.");
        }
        byte[] token = util.generateToken(null);
        byte[] label = util.generateKeysFromSkeletonToken(token);
        KeyPair result = util.generateKeyPairFromInternalToken(label);
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "generateKeyPair", result);
        }
        return result;
    }

    private void generateParameters() throws Error {
        AlgorithmParameterGenerator gen;
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "generateParameters");
        }
        switch (this.keySize) {
            case 512: {
                this.params = new DSAParameterSpec(DSAParameterGenerator.p_512, DSAParameterGenerator.q_512, DSAParameterGenerator.g_512);
                if (debug != null) {
                    debug.exit(Debug.TYPE_FINE, className, "generateParameters 1");
                }
                return;
            }
            case 768: {
                this.params = new DSAParameterSpec(DSAParameterGenerator.p_768, DSAParameterGenerator.q_768, DSAParameterGenerator.g_768);
                if (debug != null) {
                    debug.exit(Debug.TYPE_FINE, className, "generateParameters 2");
                }
                return;
            }
            case 1024: {
                this.params = new DSAParameterSpec(DSAParameterGenerator.p_1024, DSAParameterGenerator.q_1024, DSAParameterGenerator.g_1024);
                if (debug != null) {
                    debug.exit(Debug.TYPE_FINE, className, "generateParameters 3");
                }
                return;
            }
        }
        try {
            gen = AlgorithmParameterGenerator.getInstance("DSA");
        }
        catch (NoSuchAlgorithmException e) {
            if (debug != null) {
                debug.exception(8192L, className, "generateParameters", e);
            }
            throw new Error();
        }
        gen.init(this.keySize, this.random);
        AlgorithmParameters algParams = gen.generateParameters();
        try {
            this.params = algParams.getParameterSpec(DSAParameterSpec.class);
        }
        catch (InvalidParameterSpecException e) {
            if (debug != null) {
                debug.exception(8192L, className, "generateParameters", e);
            }
            throw new Error();
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "generateParameters4");
        }
    }
}

