/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.hdwrCCA.provider;

import com.ibm.crypto.hdwrCCA.provider.DSAKeyHWAttributes;
import com.ibm.crypto.hdwrCCA.provider.Debug;
import com.ibm.crypto.hdwrCCA.provider.PlatformUtilities;
import java.math.BigInteger;
import java.security.InvalidParameterException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.DSAParameterSpec;

public class DSAHWKeyParameterSpec
implements AlgorithmParameterSpec {
    private DSAKeyHWAttributes attribs = null;
    private int keysize;
    private byte[] keyLabel = null;
    private DSAParameterSpec params;
    static final long serialVersionUID = 8846210499809506552L;
    private static Debug debug = Debug.getInstance("ibmjcecca");
    private static String className = "com.ibm.crypto.hdwrCCA.provider.DSAHWKeyParameterSpec";

    public DSAHWKeyParameterSpec(int strength, byte type) throws InvalidParameterException, IllegalArgumentException {
        if (debug != null) {
            Object[] parms = new Object[]{new Integer(strength), new Byte(type)};
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "DSAHWKeyParameterSpec", parms);
        }
        if (strength < 512 || strength > 1024 || strength % 64 != 0) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "DSAHWKeyParameterSpec", "modulus size must range from 512 to 1024 and be a multiple of 64 ");
            }
            throw new InvalidParameterException("Modulus size must range from 512 to 1024 and be a multiple of 64");
        }
        if (type != 0) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "DSAHWKeyParameterSpec", "Invalid key pair type ");
            }
            throw new IllegalArgumentException("Invalid key pair type");
        }
        this.attribs = new DSAKeyHWAttributes(type, 3);
        this.keysize = strength;
        this.keyLabel = null;
        this.params = null;
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "DSAHWKeyParameterSpec");
        }
    }

    public DSAHWKeyParameterSpec(int strength, String label) throws InvalidParameterException, IllegalArgumentException {
        this(strength, 0, label.getBytes(PlatformUtilities.CHARSET_ISO_8859_1));
    }

    public DSAHWKeyParameterSpec(int strength, byte type, byte[] label) throws InvalidParameterException, IllegalArgumentException {
        if (debug != null) {
            Object[] parms = new Object[]{new Integer(strength), new Byte(type), label};
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "DSAHWKeyParameterSpec", parms);
        }
        if (strength < 512 || strength > 1024 || strength % 64 != 0) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "DSAHWKeyParameterSpec", "Modulus size must range from 512 to 1024 and be a multiple of 64 ");
            }
            throw new InvalidParameterException("Modulus size must range from 512 to 1024 and be a multiple of 64");
        }
        if (type != 0) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "DSAHWKeyParameterSpec", "Invalid key pair type ");
            }
            throw new IllegalArgumentException("Invalid key pair type");
        }
        if (label != null && label.length > 64) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "DSAHWKeyParameterSpec", "Key label must be 64 bytes long");
            }
            throw new IllegalArgumentException("key label can be a maximum of 64 bytes long");
        }
        this.attribs = new DSAKeyHWAttributes(type, 3);
        this.keysize = strength;
        this.keyLabel = (byte[])label.clone();
        this.params = null;
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "DSAHWKeyParameterSpec");
        }
    }

    public DSAHWKeyParameterSpec(BigInteger p, BigInteger q, BigInteger g, String label) throws IllegalArgumentException {
        this(p, q, g, 0, label.getBytes(PlatformUtilities.CHARSET_ISO_8859_1));
    }

    public DSAHWKeyParameterSpec(BigInteger p, BigInteger q, BigInteger g, byte type, byte[] label) throws IllegalArgumentException {
        if (debug != null) {
            Object[] parms = new Object[]{p, q, g, new Byte(type), label};
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "DSAHWKeyParameterSpec", parms);
        }
        if (type != 0) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "DSAHWKeyParameterSpec", "Invalid key pair type ");
            }
            throw new IllegalArgumentException("Invalid key pair type");
        }
        if (label != null && label.length > 64) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "DSAHWKeyParameterSpec", "Key label must be 64 bytes long");
            }
            throw new IllegalArgumentException("key label can be a maximum of 64 bytes long");
        }
        this.attribs = new DSAKeyHWAttributes(type, 3);
        this.params = new DSAParameterSpec(p, q, g);
        this.keysize = p.bitLength();
        this.keyLabel = (byte[])label.clone();
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "DSAHWKeyParameterSpec");
        }
    }

    public DSAHWKeyParameterSpec(BigInteger p, BigInteger q, BigInteger g, byte type) throws IllegalArgumentException {
        if (debug != null) {
            Object[] parms = new Object[]{p, q, g, new Byte(type)};
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "DSAHWKeyParameterSpec", parms);
        }
        if (type != 0) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "DSAHWKeyParameterSpec", "Invalid key pair type");
            }
            throw new IllegalArgumentException("Invalid key pair type");
        }
        this.attribs = new DSAKeyHWAttributes(type, 3);
        this.params = new DSAParameterSpec(p, q, g);
        this.keysize = p.bitLength();
        this.keyLabel = null;
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "DSAHWKeyParameterSpec");
        }
    }

    public DSAHWKeyParameterSpec(BigInteger p, BigInteger q, BigInteger g, byte[] label) throws IllegalArgumentException {
        if (debug != null) {
            Object[] parms = new Object[]{p, q, g, label};
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "DSAHWKeyParameterSpec", parms);
        }
        if (label != null && label.length > 64) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "DSAHWKeyParameterSpec", "Key label must be 64 bytes long");
            }
            throw new IllegalArgumentException("key label can be a maximum of 64 bytes long");
        }
        this.attribs = new DSAKeyHWAttributes(0, 3);
        this.params = new DSAParameterSpec(p, q, g);
        this.keysize = p.bitLength();
        this.keyLabel = (byte[])label.clone();
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "DSAHWKeyParameterSpec");
        }
    }

    public DSAHWKeyParameterSpec(BigInteger p, BigInteger q, BigInteger g) throws IllegalArgumentException {
        if (debug != null) {
            Object[] parms = new Object[]{p, q, g};
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "DSAHWKeyParameterSpec", parms);
        }
        this.attribs = new DSAKeyHWAttributes(0, 3);
        this.params = new DSAParameterSpec(p, q, g);
        this.keysize = p.bitLength();
        this.keyLabel = null;
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "DSAHWKeyParameterSpec");
        }
    }

    public DSAHWKeyParameterSpec(DSAParameterSpec params, String label) throws IllegalArgumentException {
        this(params, 0, label.getBytes(PlatformUtilities.CHARSET_ISO_8859_1));
    }

    public DSAHWKeyParameterSpec(DSAParameterSpec params, byte type, byte[] label) throws IllegalArgumentException {
        if (debug != null) {
            Object[] parms = new Object[]{params, new Byte(type), label};
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "DSAHWKeyParameterSpec", parms);
        }
        if (type != 0) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "DSAHWKeyParameterSpec", "Invalid key pair type");
            }
            throw new IllegalArgumentException("Invalid key pair type");
        }
        if (label != null && label.length > 64) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "DSAHWKeyParameterSpec", "Key label must be 64 bytes long");
            }
            throw new IllegalArgumentException("key label can be a maximum of 64 bytes long");
        }
        this.attribs = new DSAKeyHWAttributes(type, 3);
        this.params = params;
        this.keysize = params.getP().bitLength();
        this.keyLabel = (byte[])label.clone();
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "DSAHWKeyParameterSpec");
        }
    }

    public DSAKeyHWAttributes getAttributes() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "getType");
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getType", this.attribs);
        }
        return this.attribs;
    }

    public int getKeySize() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "getKeySize");
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getKeySize", this.keysize);
        }
        return this.keysize;
    }

    public DSAParameterSpec getDSAParamSpec() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "getDSAParamSpec");
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getDSAParamSpec", this.params);
        }
        return this.params;
    }

    public byte[] getLabel() {
        byte[] result = null;
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "getLabel");
        }
        if (this.keyLabel != null) {
            result = (byte[])this.keyLabel.clone();
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getLabel", result);
        }
        return result;
    }

    public String getLabelString() {
        String returnLabel = null;
        if (this.keyLabel != null) {
            returnLabel = new String(this.keyLabel, PlatformUtilities.CHARSET_ISO_8859_1);
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getLabelString", returnLabel);
        }
        return returnLabel;
    }
}

