/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.hdwrCCA.provider;

import com.ibm.crypto.hdwrCCA.provider.CCAAlgorithmParameterSpec;
import com.ibm.crypto.hdwrCCA.provider.DESKey;
import com.ibm.crypto.hdwrCCA.provider.DESedeKey;
import com.ibm.crypto.hdwrCCA.provider.Debug;
import com.ibm.crypto.hdwrCCA.provider.HIKM;
import com.ibm.crypto.hdwrCCA.provider.HexDumpEncoder;
import com.ibm.crypto.hdwrCCA.provider.IBMJCECCA;
import com.ibm.crypto.hdwrCCA.provider.JCECCARuntimeException;
import com.ibm.crypto.hdwrCCA.provider.PlatformUtilities;
import com.ibm.crypto.hdwrCCA.provider.SymmetricKeyConstants;
import com.ibm.crypto.hdwrCCA.provider.SymmetricKeyUtils;
import com.ibm.crypto.hdwrCCA.provider.SymmetricKeyWrap;
import com.ibm.crypto.hdwrCCA.provider.TR31OptionalDataBlock;
import com.ibm.crypto.hdwrCCA.provider.hikmNativeInteger;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.Arrays;
import javax.crypto.Cipher;

public final class DESedeTR31KeyWrap
extends SymmetricKeyWrap {
    private static final HIKM hikm = new HIKM();
    private static final int DES_KEYFIELD_LENGTH = 16;
    private static final int DESEDE_KEYFIELD_LENGTH = 32;
    private SymmetricKeyWrap.CipherState state = SymmetricKeyWrap.CipherState.UNINITIALIZED;
    private Key transportKey = null;
    private SymmetricKeyConstants.KeyType unwrapKeyType = DEFAULT_UNWRAP_KEY_TYPE;
    private String unwrapLabel = null;
    private SymmetricKeyConstants.KeyUsage keyTypeUsage = null;
    private int optDataBlocksCount = 0;
    private TR31OptionalDataBlock[] optDataBlocks = null;
    private byte[] encodedOptDataBlocks = null;
    private int encodedOptDataBlocksLength = 0;
    private static Debug debug = Debug.getInstance("ibmjcecca");
    private static String className = "com.ibm.crypto.hdwrCCA.provider.DESedeTR31KeyWrap";
    private static HexDumpEncoder encoder = null;

    public DESedeTR31KeyWrap() {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "DESedeTR31KeyWrap");
        }
        IBMJCECCA.verifyJceJar();
        if (!IBMJCECCA.verifySelfIntegrity(this.getClass())) {
            SecurityException se = new SecurityException("The IBMJCECCA provider may have been tampered.");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "DESedeTR31KeyWrap", se);
                debug.exit(Debug.TYPE_FINE, className, "DESedeTR31KeyWrap");
            }
            throw se;
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "DESedeTR31KeyWrap");
        }
    }

    @Override
    protected int engineGetBlockSize() {
        UnsupportedOperationException uoe = new UnsupportedOperationException("This cipher does not support the getBlockSize operation");
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "engineGetBlockSize");
            debug.exception(Debug.TYPE_PUBLIC, className, "engineGetBlockSize", uoe);
            debug.exit(Debug.TYPE_FINE, className, "engineGetBlockSize");
        }
        throw uoe;
    }

    @Override
    protected int engineGetOutputSize(int inputLen) {
        int result = 0;
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineGetOutputSize", inputLen);
        }
        result = SymmetricKeyWrap.CipherState.UNWRAP == this.state ? 64 : 9992;
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineGetOutputSize", result);
        }
        return result;
    }

    @Override
    protected int engineGetKeySize(Key key) {
        int keySize;
        block4: {
            if (debug != null) {
                debug.entry(Debug.TYPE_FINE, (Object)className, "engineGetKeySize", key);
            }
            keySize = 128;
            try {
                keySize = Cipher.getMaxAllowedKeyLength("DESede");
            }
            catch (NoSuchAlgorithmException e) {
                if (debug == null) break block4;
                debug.exception(Debug.TYPE_PUBLIC, className, "engineGetKeySize", e);
            }
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineGetKeySize", keySize);
        }
        return keySize;
    }

    @Override
    protected void engineInit(int opmode, Key key, SecureRandom random) throws InvalidKeyException {
        if (debug != null) {
            Object[] parms = new Object[]{opmode, key, random};
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineInit", parms);
        }
        try {
            this.checkInitParms(opmode, key, null);
        }
        catch (InvalidAlgorithmParameterException parms) {
            // empty catch block
        }
        if (!(key instanceof DESedeKey)) {
            InvalidKeyException ike = new InvalidKeyException("Key must be an instance of com.ibm.crypto.hdwrCCA.provider.DESedeKey");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineInit", ike);
                debug.exit(Debug.TYPE_FINE, className, "engineInit");
            }
            throw ike;
        }
        this.state = opmode == 3 ? SymmetricKeyWrap.CipherState.WRAP : SymmetricKeyWrap.CipherState.UNWRAP;
        this.transportKey = key;
        this.keyTypeUsage = SymmetricKeyConstants.KeyUsage.OP_CIPHER;
        this.unwrapKeyType = DEFAULT_UNWRAP_KEY_TYPE;
        this.unwrapLabel = null;
        this.optDataBlocksCount = 0;
        this.optDataBlocks = new TR31OptionalDataBlock[this.optDataBlocksCount];
        this.encodedOptDataBlocks = null;
        this.encodedOptDataBlocksLength = 0;
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "engineInit");
        }
    }

    @Override
    protected void engineInit(int opmode, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (debug != null) {
            Object[] parms = new Object[]{opmode, key, params, random};
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineInit(1)", parms);
        }
        this.checkInitParms(opmode, key, params);
        if (!(key instanceof DESedeKey)) {
            InvalidKeyException ike = new InvalidKeyException("Key must be an instance of com.ibm.crypto.hdwrCCA.provider.DESedeKey");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineInit(1)", ike);
                debug.exit(Debug.TYPE_FINE, className, "engineInit(1)");
            }
            throw ike;
        }
        this.state = opmode == 3 ? SymmetricKeyWrap.CipherState.WRAP : SymmetricKeyWrap.CipherState.UNWRAP;
        this.transportKey = key;
        this.unwrapKeyType = DEFAULT_UNWRAP_KEY_TYPE;
        this.unwrapLabel = null;
        this.keyTypeUsage = SymmetricKeyConstants.KeyUsage.OP_CIPHER;
        this.optDataBlocksCount = 0;
        this.optDataBlocks = new TR31OptionalDataBlock[this.optDataBlocksCount];
        this.encodedOptDataBlocks = null;
        this.encodedOptDataBlocksLength = 0;
        CCAAlgorithmParameterSpec spec = (CCAAlgorithmParameterSpec)params;
        if (spec != null) {
            TR31OptionalDataBlock[] tempOptDataBlks;
            byte hwType = spec.getHwType();
            this.unwrapKeyType = SymmetricKeyConstants.KeyType.valueOfOrDefault(hwType, DEFAULT_UNWRAP_KEY_TYPE);
            this.unwrapLabel = spec.getLabel();
            this.keyTypeUsage = spec.getKeyUsage();
            if (null == this.keyTypeUsage) {
                this.keyTypeUsage = SymmetricKeyConstants.KeyUsage.OP_CIPHER;
            }
            if (null != (tempOptDataBlks = spec.getTR31OptionalDataBlocks())) {
                this.optDataBlocksCount = tempOptDataBlks.length;
                StringBuilder sb = new StringBuilder();
                int badIDCount = 0;
                for (int idx = 0; idx < this.optDataBlocksCount; ++idx) {
                    String id = tempOptDataBlks[idx].getOptDataID();
                    int idLength = 0;
                    if (null != id) {
                        idLength = id.length();
                    }
                    if (2 == idLength) continue;
                    if (0 < badIDCount) {
                        sb.append(", ");
                    }
                    sb.append(id);
                    sb.append(" (idx=");
                    sb.append(idx);
                    sb.append(")");
                    ++badIDCount;
                }
                if (0 < badIDCount) {
                    String badIDList = sb.toString();
                    InvalidParameterException ipe = null;
                    if (1 < badIDCount) {
                        ipe = new InvalidParameterException("The following optional block IDs (index) are not 2 characters: " + badIDList);
                    } else if (1 == badIDCount) {
                        ipe = new InvalidParameterException("The following optional block ID (index) is not 2 characters: " + badIDList);
                    }
                    if (debug != null) {
                        debug.exception(Debug.TYPE_PUBLIC, className, "engineInit(1)", ipe);
                        debug.exit(Debug.TYPE_FINE, className, "engineInit(1)");
                    }
                    throw ipe;
                }
                this.optDataBlocks = tempOptDataBlks;
            }
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "engineInit(1)");
        }
    }

    @Override
    protected void engineInit(int opmode, Key key, AlgorithmParameters params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (debug != null) {
            Object[] parms = new Object[]{opmode, key, params, random};
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineInit(2)", parms);
        }
        CCAAlgorithmParameterSpec spec = null;
        if (params != null) {
            try {
                spec = params.getParameterSpec(CCAAlgorithmParameterSpec.class);
            }
            catch (InvalidParameterSpecException ipse) {
                InvalidAlgorithmParameterException iape = new InvalidAlgorithmParameterException("Algorithm parameters not compatible or supported", ipse);
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, "engineInit(2)", iape);
                    debug.exit(Debug.TYPE_FINE, className, "engineInit(2)");
                }
                throw iape;
            }
        }
        this.engineInit(opmode, key, spec, random);
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "engineInit(2)");
        }
    }

    @Override
    protected byte[] engineWrap(Key key) throws InvalidKeyException {
        String keyLabel;
        DESKey desKey = null;
        DESedeKey desedeKey = null;
        int keyFieldLength = 0;
        byte[] srcKeyToken = null;
        byte[] unwrapKeyToken = null;
        byte[] wrapKeyToken = null;
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineWrap", key);
            encoder = new HexDumpEncoder();
        }
        if (key == null) {
            NullPointerException npe = new NullPointerException("Key to wrap is null");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineWrap", npe);
                debug.exit(Debug.TYPE_FINE, className, "engineWrap");
            }
            throw npe;
        }
        if (key.getFormat().equals("RAW")) {
            InvalidKeyException ike = new InvalidKeyException("Key to wrap must be a SECURE_INTERNAL_TOKEN or CKDS key");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineWrap", ike);
                debug.exit(Debug.TYPE_FINE, className, "engineWrap");
            }
            throw ike;
        }
        if (this.state != SymmetricKeyWrap.CipherState.WRAP) {
            IllegalStateException ise = new IllegalStateException("Cipher not initialized for wrap operation mode");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineWrap", ise);
                debug.exit(Debug.TYPE_FINE, className, "engineWrap");
            }
            throw ise;
        }
        if (key instanceof DESKey) {
            desKey = (DESKey)key;
            keyFieldLength = 16;
            if (desKey.getFormat().equalsIgnoreCase("CKDSLabel")) {
                keyLabel = String.format("%-64s", desKey.getLabelString());
                srcKeyToken = PlatformUtilities.getBytesPlatform(keyLabel);
            } else {
                srcKeyToken = desKey.getToken();
            }
        } else if (key instanceof DESedeKey) {
            desedeKey = (DESedeKey)key;
            keyFieldLength = 32;
            if (desedeKey.getFormat().equalsIgnoreCase("CKDSLabel")) {
                keyLabel = String.format("%-64s", desedeKey.getLabelString());
                srcKeyToken = PlatformUtilities.getBytesPlatform(keyLabel);
            } else {
                srcKeyToken = desedeKey.getToken();
            }
        } else {
            InvalidKeyException ike = new InvalidKeyException("Key to wrap must be a com.ibm.crypto.hdwrCCA.provider.DESKey or com.ibm.crypto.hdwrCCA.provider.DESedeKey");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineWrap", ike);
                debug.exit(Debug.TYPE_FINE, className, "engineWrap");
            }
            throw ike;
        }
        if (0 < this.optDataBlocksCount) {
            this.addOptionalDataBlocks();
        } else {
            this.encodedOptDataBlocks = new byte[0];
        }
        hikmNativeInteger optBlocksLen = new hikmNativeInteger(this.encodedOptDataBlocksLength);
        hikmNativeInteger returnCode = new hikmNativeInteger(0);
        hikmNativeInteger reasonCode = new hikmNativeInteger(0);
        byte[] exitData = new byte[]{};
        hikmNativeInteger exitDataLength = new hikmNativeInteger(0);
        byte[] ruleArray = null;
        int ruleCount = 0;
        StringBuilder ruleSB = new StringBuilder();
        ruleSB.append("VARXOR-A");
        ++ruleCount;
        if (this.keyTypeUsage.equals((Object)SymmetricKeyConstants.KeyUsage.OP_CIPHER) || this.keyTypeUsage.equals((Object)SymmetricKeyConstants.KeyUsage.OP_DATA)) {
            ruleSB.append("ENC     ");
            ++ruleCount;
            ruleSB.append("ENCDEC  ");
            ++ruleCount;
        } else {
            ruleSB.append("KEK     ");
            ++ruleCount;
            if (this.keyTypeUsage.equals((Object)SymmetricKeyConstants.KeyUsage.OP_EXPORTER)) {
                ruleSB.append("ENC-ONLY");
                ++ruleCount;
            } else {
                ruleSB.append("DEC-ONLY");
                ++ruleCount;
            }
        }
        ruleSB.append("EXP-ANY ");
        ruleArray = PlatformUtilities.getBytesPlatform(ruleSB.toString());
        hikmNativeInteger ruleArrayCount = new hikmNativeInteger(++ruleCount);
        byte[] keyVersion = PlatformUtilities.getBytesPlatform("00");
        hikmNativeInteger keyFieldLen = new hikmNativeInteger(keyFieldLength);
        hikmNativeInteger srckeyLen = new hikmNativeInteger(srcKeyToken.length);
        unwrapKeyToken = new byte[]{};
        hikmNativeInteger unwrapKeyLen = new hikmNativeInteger(unwrapKeyToken.length);
        desedeKey = (DESedeKey)this.transportKey;
        if (desedeKey.getFormat().equalsIgnoreCase("CKDSLabel")) {
            String keyLabel2 = String.format("%-64s", desedeKey.getLabelString());
            wrapKeyToken = PlatformUtilities.getBytesPlatform(keyLabel2);
        } else {
            wrapKeyToken = desedeKey.getToken();
        }
        hikmNativeInteger wrapKeyLen = new hikmNativeInteger(wrapKeyToken.length);
        byte[] TR31BlockBuffer = new byte[9992];
        hikmNativeInteger TR31BlockLength = new hikmNativeInteger(9992);
        if (null != debug) {
            String ruleArrayString = encoder.encodeBuffer(ruleArray);
            String keyVersionString = encoder.encodeBuffer(keyVersion);
            String srcKeyString = encoder.encodeBuffer(srcKeyToken);
            String unwrpKEKString = "NULL";
            String wrapKEKString = encoder.encodeBuffer(wrapKeyToken);
            String optBlocksString = "NULL";
            if (null != this.encodedOptDataBlocks && 0 < this.encodedOptDataBlocks.length) {
                optBlocksString = encoder.encodeBuffer(this.encodedOptDataBlocks);
            }
            String parmsReport = "\nDESedeTR31KeyWrap: CSNBT31X INPUT PARAMETERS \n    returnCode     : " + returnCode.getValue() + "\n    reasonCode     : " + reasonCode.getValue() + "\n    ruleArrayCnt   : " + ruleArrayCount.getValue() + "\n    ruleArray      : \n" + ruleArrayString + "\n    keyVersion     : " + keyVersionString + "\n    keyFieldLength : " + keyFieldLen.getValue() + "\n    srcKeyTokenLen : " + srckeyLen.getValue() + "\n    srcKeyToken    : \n" + srcKeyString + "\n    unwrpKEKTknLen : " + unwrapKeyLen.getValue() + "\n    unwrpKEKToken  : " + unwrpKEKString + "\n    wrapKEKTknLen  : " + wrapKeyLen.getValue() + "\n    wrapKEKToken   : \n" + wrapKEKString + "\n    optBlocksLen   : " + optBlocksLen.getValue() + "\n    optBlocks      : \n" + optBlocksString + "\n    TR31KeyBlockLen: " + TR31BlockLength.getValue() + "\n";
            debug.text(Debug.TYPE_FINEST, className, "engineWrap", parmsReport);
        }
        try {
            hikm.CSNBT31XJ(returnCode, reasonCode, exitDataLength, exitData, ruleArrayCount, ruleArray, keyVersion, keyFieldLen, srckeyLen, srcKeyToken, unwrapKeyLen, unwrapKeyToken, wrapKeyLen, wrapKeyToken, optBlocksLen, this.encodedOptDataBlocks, TR31BlockLength, TR31BlockBuffer);
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineWrap", e);
            }
            throw new RuntimeException("Hardware error from call CSNBT31X " + e);
        }
        if (debug != null) {
            debug.text(Debug.TYPE_FINE, className, "engineWrap", "CSNBT31X: return code = " + returnCode.getValue() + " reason code = " + reasonCode.getValue());
        }
        int TR31_KeyBlock_Length = TR31BlockLength.getValue();
        byte[] TR31_KeyBlock = new byte[TR31_KeyBlock_Length];
        for (int trimIdx = 0; trimIdx < TR31_KeyBlock_Length; ++trimIdx) {
            TR31_KeyBlock[trimIdx] = TR31BlockBuffer[trimIdx];
        }
        if (null != debug) {
            String exitDataString = "NULL";
            if (0 < exitDataLength.getValue()) {
                exitDataString = encoder.encodeBuffer(exitData);
            }
            String TR31BlockString = "NULL";
            if (0 < TR31_KeyBlock_Length) {
                TR31BlockString = encoder.encodeBuffer(TR31_KeyBlock);
            }
            String parmsReport = "\nDESedeTR31KeyWrap: CSNBT31X RETURN PARAMETERS \n    returnCode      : " + returnCode.getValue() + "\n    reasonCode      : " + reasonCode.getValue() + "\n    exitDataLen     : " + exitDataLength.getValue() + "\n    exitData        : " + exitDataString + "\n    TR31KeyBlockLen : " + TR31_KeyBlock_Length + "\n    TR31KeyBlock    : \n" + TR31BlockString + "\n";
            debug.text(Debug.TYPE_FINEST, className, "engineWrap", parmsReport);
        }
        if (returnCode.getValue() != 0) {
            JCECCARuntimeException re = new JCECCARuntimeException(1, "CSNBT31X", "Hardware error from call CSNBT31X returnCode " + returnCode.getValue() + " reasonCode " + reasonCode.getValue(), returnCode.getValue(), reasonCode.getValue());
            if (debug != null) {
                debug.exception(8192L, className, "engineWrap", re);
                debug.exit(8192L, className, "engineWrap");
            }
            throw re;
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineWrap", TR31_KeyBlock);
        }
        return TR31_KeyBlock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    protected Key engineUnwrap(byte[] TR31KeyBlock, String wrappedKeyAlgorithm, int wrappedKeyType) throws InvalidKeyException {
        desedeKey = null;
        resultKeyToken = null;
        unwrapKeyToken = null;
        wrapKeyToken = null;
        if (DESedeTR31KeyWrap.debug != null) {
            parms = new Object[]{TR31KeyBlock, wrappedKeyAlgorithm, wrappedKeyType};
            DESedeTR31KeyWrap.debug.entry(Debug.TYPE_FINE, (Object)DESedeTR31KeyWrap.className, "engineUnwrap", parms);
        }
        if (TR31KeyBlock == null) {
            npe = new NullPointerException("TR-31 KeyBlock is null");
            if (DESedeTR31KeyWrap.debug != null) {
                DESedeTR31KeyWrap.debug.exception(Debug.TYPE_PUBLIC, DESedeTR31KeyWrap.className, "engineUnwrap", npe);
                DESedeTR31KeyWrap.debug.exit(Debug.TYPE_FINE, DESedeTR31KeyWrap.className, "engineUnwrap");
            }
            throw npe;
        }
        if (0 == TR31KeyBlock.length) {
            ike = new InvalidKeyException("TR-31 KeyBlock is empty.");
            if (DESedeTR31KeyWrap.debug != null) {
                DESedeTR31KeyWrap.debug.exception(Debug.TYPE_PUBLIC, DESedeTR31KeyWrap.className, "engineUnwrap", ike);
                DESedeTR31KeyWrap.debug.exit(Debug.TYPE_FINE, DESedeTR31KeyWrap.className, "engineUnwrap");
            }
            throw ike;
        }
        if (!("DES".equalsIgnoreCase(wrappedKeyAlgorithm) || "DESede".equalsIgnoreCase(wrappedKeyAlgorithm) || "TripleDES".equalsIgnoreCase(wrappedKeyAlgorithm) || "3DES".equalsIgnoreCase(wrappedKeyAlgorithm))) {
            ike = new InvalidKeyException("Wrapped key algorithm must be DES or DESede");
            if (DESedeTR31KeyWrap.debug != null) {
                DESedeTR31KeyWrap.debug.exception(Debug.TYPE_PUBLIC, DESedeTR31KeyWrap.className, "engineUnwrap", ike);
                DESedeTR31KeyWrap.debug.exit(Debug.TYPE_FINE, DESedeTR31KeyWrap.className, "engineUnwrap");
            }
            throw ike;
        }
        if (wrappedKeyType != 3) {
            ike = new InvalidKeyException("Wrapped key type must be SECRET_KEY");
            if (DESedeTR31KeyWrap.debug != null) {
                DESedeTR31KeyWrap.debug.exception(Debug.TYPE_PUBLIC, DESedeTR31KeyWrap.className, "engineUnwrap", ike);
                DESedeTR31KeyWrap.debug.exit(Debug.TYPE_FINE, DESedeTR31KeyWrap.className, "engineUnwrap");
            }
            throw ike;
        }
        if (this.state != SymmetricKeyWrap.CipherState.UNWRAP) {
            ise = new IllegalStateException("Cipher not initialized for unwrap operation mode");
            if (DESedeTR31KeyWrap.debug != null) {
                DESedeTR31KeyWrap.debug.exception(Debug.TYPE_PUBLIC, DESedeTR31KeyWrap.className, "engineUnwrap", ise);
                DESedeTR31KeyWrap.debug.exit(Debug.TYPE_FINE, DESedeTR31KeyWrap.className, "engineUnwrap");
            }
            throw ise;
        }
        returnCode = new hikmNativeInteger(0);
        reasonCode = new hikmNativeInteger(0);
        exitData = new byte[]{};
        exitDataLength = new hikmNativeInteger(0);
        ruleArray = null;
        ruleCount = 0;
        ruleSB = new StringBuilder();
        ruleSB.append("INTERNAL");
        ++ruleCount;
        if (this.keyTypeUsage.equals((Object)SymmetricKeyConstants.KeyUsage.OP_EXPORTER)) {
            ruleSB.append("EXPORTER");
            ++ruleCount;
        } else if (this.keyTypeUsage.equals((Object)SymmetricKeyConstants.KeyUsage.OP_IMPORTER)) {
            ruleSB.append("IMPORTER");
            ++ruleCount;
        }
        ruleArray = PlatformUtilities.getBytesPlatform(ruleSB.toString());
        ruleArrayCount = new hikmNativeInteger(ruleCount);
        TR31KeyBlock_len = new hikmNativeInteger(TR31KeyBlock.length);
        desedeKey = (DESedeKey)this.transportKey;
        if (desedeKey.getFormat().equalsIgnoreCase("CKDSLabel")) {
            keyLabel = String.format("%-64s", new Object[]{desedeKey.getLabelString()});
            unwrapKeyToken = PlatformUtilities.getBytesPlatform(keyLabel);
        } else {
            unwrapKeyToken = desedeKey.getToken();
        }
        unwrapKeyLen = new hikmNativeInteger(unwrapKeyToken.length);
        wrapKeyToken = new byte[]{};
        wrapKeyLen = new hikmNativeInteger(wrapKeyToken.length);
        resultKeyToken = new byte[64];
        resultKeyLen = new hikmNativeInteger(resultKeyToken.length);
        numOptBlks = new hikmNativeInteger(0);
        cvSource = new hikmNativeInteger(0);
        protectionMethod = new hikmNativeInteger(0);
        if (null != DESedeTR31KeyWrap.debug) {
            ruleArrayString = DESedeTR31KeyWrap.encoder.encodeBuffer(ruleArray);
            unwrpKEKString = DESedeTR31KeyWrap.encoder.encodeBuffer(unwrapKeyToken);
            wrapKEKString = "NULL";
            TR31BlockString = DESedeTR31KeyWrap.encoder.encodeBuffer(TR31KeyBlock);
            resultTokenString = DESedeTR31KeyWrap.encoder.encodeBuffer(resultKeyToken);
            parmsReport = "\nDESedeTR31KeyWrap: CSNBT31I INPUT PARAMETERS \n    returnCode     : " + returnCode.getValue() + "\n    reasonCode     : " + reasonCode.getValue() + "\n    ruleArrayCnt   : " + ruleArrayCount.getValue() + "\n    ruleArray      : \n" + ruleArrayString + "\n    TR31KeyBlockLen: " + TR31KeyBlock_len.getValue() + "\n    TR31KeyBlock   : \n" + TR31BlockString + "\n    unwrpKEKTknLen : " + unwrapKeyLen.getValue() + "\n    unwrpKEKToken  : \n" + unwrpKEKString + "\n    wrapKEKTknLen  : " + wrapKeyLen.getValue() + "\n    wrapKEKToken   : " + wrapKEKString + "\n    outputKeyLen   : " + resultKeyLen.getValue() + "\n    outputKeySkel  : \n" + resultTokenString + "\n";
            DESedeTR31KeyWrap.debug.text(Debug.TYPE_FINEST, DESedeTR31KeyWrap.className, "engineUnwrap", parmsReport);
        }
        try {
            DESedeTR31KeyWrap.hikm.CSNBT31IJ(returnCode, reasonCode, exitDataLength, exitData, ruleArrayCount, ruleArray, TR31KeyBlock_len, TR31KeyBlock, unwrapKeyLen, unwrapKeyToken, wrapKeyLen, wrapKeyToken, resultKeyLen, resultKeyToken, numOptBlks, cvSource, protectionMethod);
        }
        catch (Exception e) {
            if (DESedeTR31KeyWrap.debug != null) {
                DESedeTR31KeyWrap.debug.exception(Debug.TYPE_PUBLIC, DESedeTR31KeyWrap.className, "engineUnwrap", e);
            }
            throw new RuntimeException("Hardware error from call CSNBT31I " + e);
        }
        if (DESedeTR31KeyWrap.debug != null) {
            DESedeTR31KeyWrap.debug.text(Debug.TYPE_FINE, DESedeTR31KeyWrap.className, "engineUnwrap", "CSNBT31I: return code = " + returnCode.getValue() + " reason code = " + reasonCode.getValue());
        }
        if (null != DESedeTR31KeyWrap.debug) {
            exitDataString = "NULL";
            if (0 < exitDataLength.getValue()) {
                exitDataString = DESedeTR31KeyWrap.encoder.encodeBuffer(exitData);
            }
            outKeyLen = resultKeyLen.getValue();
            resultKeyTokString = "NULL";
            if (0 < outKeyLen) {
                resultKeyTokString = DESedeTR31KeyWrap.encoder.encodeBuffer(resultKeyToken);
            }
            parmsReport = "\nDESedeTR31KeyWrap: CSNBT31I RETURN PARAMETERS \n    returnCode      : " + returnCode.getValue() + "\n    reasonCode      : " + reasonCode.getValue() + "\n    exitDataLen     : " + exitDataLength.getValue() + "\n    exitData        : " + exitDataString + "\n    outputKeyLen    : " + resultKeyLen.getValue() + "\n    outputKeyToken  : \n" + resultKeyTokString + "\n    numOptBlocks    : " + numOptBlks.getValue() + "\n    ctlVectorSource : " + cvSource.getValue() + "\n    protectionMethod: " + protectionMethod.getValue() + "\n";
            DESedeTR31KeyWrap.debug.text(Debug.TYPE_FINEST, DESedeTR31KeyWrap.className, "engineUnwrap", parmsReport);
        }
        if (returnCode.getValue() != 0) {
            re = new JCECCARuntimeException(1, "CSNBT31I", "Hardware error from call CSNBT31I returnCode " + returnCode.getValue() + " reasonCode " + reasonCode.getValue(), returnCode.getValue(), reasonCode.getValue());
            if (DESedeTR31KeyWrap.debug != null) {
                DESedeTR31KeyWrap.debug.exception(8192L, DESedeTR31KeyWrap.className, "engineUnwrap", re);
                DESedeTR31KeyWrap.debug.exit(8192L, DESedeTR31KeyWrap.className, "engineUnwrap");
            }
            throw re;
        }
        if ("DES".equalsIgnoreCase(wrappedKeyAlgorithm)) {
            try {
                key /* !! */  = new DESKey("ICSFToken", resultKeyToken);
                if (this.unwrapKeyType != SymmetricKeyConstants.KeyType.CKDS) ** GOTO lbl126
                actualLabel = SymmetricKeyUtils.storeProtectedKeyInCKDS(key /* !! */ , this.unwrapLabel);
                key /* !! */  = DESKey.newLabelKey(actualLabel);
            }
            finally {
                Arrays.fill(resultKeyToken, (byte)0);
            }
        } else {
            try {
                key /* !! */  = new DESedeKey("ICSFToken", resultKeyToken);
                if (this.unwrapKeyType == SymmetricKeyConstants.KeyType.CKDS) {
                    actualLabel = SymmetricKeyUtils.storeProtectedKeyInCKDS(key /* !! */ , this.unwrapLabel);
                    key /* !! */  = DESedeKey.newLabelKey(actualLabel);
                }
            }
            finally {
                Arrays.fill(resultKeyToken, (byte)0);
            }
        }
        if (DESedeTR31KeyWrap.debug != null) {
            DESedeTR31KeyWrap.debug.exit(Debug.TYPE_FINE, (Object)DESedeTR31KeyWrap.className, "engineUnwrap", key /* !! */ );
        }
        return key /* !! */ ;
    }

    private void checkInitParms(int opmode, Key key, AlgorithmParameterSpec params) throws InvalidKeyException, InvalidAlgorithmParameterException {
        byte specHwType;
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "checkInitParms");
        }
        if (opmode == 1 || opmode == 2) {
            UnsupportedOperationException uoe = new UnsupportedOperationException("This cipher does not support ENCRYPT_MODE or DECRYPT_MODE");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "checkInitParms", uoe);
                debug.exit(Debug.TYPE_FINE, className, "checkInitParms");
            }
            throw uoe;
        }
        if (opmode != 3 && opmode != 4) {
            InvalidParameterException ipe = new InvalidParameterException("The specified operation mode is not supported: " + opmode);
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "checkInitParms", ipe);
                debug.exit(Debug.TYPE_FINE, className, "checkInitParms");
            }
            throw ipe;
        }
        if (key == null) {
            NullPointerException npe = new NullPointerException("Key is null");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "checkInitParms", npe);
                debug.exit(Debug.TYPE_FINE, className, "checkInitParms");
            }
            throw npe;
        }
        if (key.getFormat().equals("RAW")) {
            InvalidKeyException ike = new InvalidKeyException("Key must be a SECURE_INTERNAL_TOKEN or CKDS hardware key");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "checkInitParms", ike);
                debug.exit(Debug.TYPE_FINE, className, "checkInitParms");
            }
            throw ike;
        }
        if (params == null) {
            if (debug != null) {
                debug.exit(Debug.TYPE_FINE, className, "checkInitParms");
            }
            return;
        }
        if (!(params instanceof CCAAlgorithmParameterSpec)) {
            InvalidAlgorithmParameterException iape = new InvalidAlgorithmParameterException("Not a supported algorithm parameter specification");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "checkInitParms", iape);
                debug.exit(Debug.TYPE_FINE, className, "checkInitParms");
            }
            throw iape;
        }
        CCAAlgorithmParameterSpec spec = (CCAAlgorithmParameterSpec)params;
        boolean specNoCvKEKFlag = spec.getNoCvKEK();
        if (specNoCvKEKFlag) {
            InvalidParameterException ipe = new InvalidParameterException("The NoCvKEK option is not supported by the TR-31 wrap and unwrap operations.");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "checkInitParms", ipe);
                debug.exit(Debug.TYPE_FINE, className, "checkInitParms");
            }
            throw ipe;
        }
        SymmetricKeyConstants.KeyUsage specKeyUsage = spec.getKeyUsage();
        if (specKeyUsage != null && !SymmetricKeyConstants.KeyUsage.singleKeys().contains((Object)specKeyUsage)) {
            InvalidParameterException iae = new InvalidParameterException("TR31 Key usage must represent a single key");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "checkInitParms", iae);
                debug.exit(Debug.TYPE_FINE, className, "checkInitParms");
            }
            throw iae;
        }
        if (opmode == 4 && SymmetricKeyConstants.KeyType.valueOfOrDefault(specHwType = spec.getHwType(), null) == SymmetricKeyConstants.KeyType.CLEAR) {
            InvalidAlgorithmParameterException iape = new InvalidAlgorithmParameterException("This cipher does not support unwrapping to a CLEAR key");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "checkInitParms", iape);
                debug.exit(Debug.TYPE_FINE, className, "checkInitParms");
            }
            throw iape;
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "checkInitParms");
        }
    }

    private void addOptionalDataBlocks() {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "addOptionalDataBlocks");
            encoder = new HexDumpEncoder();
        }
        byte[] optBlocksBuffer = new byte[9992];
        hikmNativeInteger ruleArrayCount = new hikmNativeInteger(0);
        byte[] ruleArray = new byte[]{};
        byte[] exitData = new byte[]{};
        hikmNativeInteger exitDataLength = new hikmNativeInteger(0);
        hikmNativeInteger optBlocksBufferLen = new hikmNativeInteger(optBlocksBuffer.length);
        hikmNativeInteger optBlocksCount = new hikmNativeInteger(0);
        hikmNativeInteger optBlocksLen = new hikmNativeInteger(0);
        for (int obIdx = 0; obIdx < this.optDataBlocksCount; ++obIdx) {
            hikmNativeInteger returnCode = new hikmNativeInteger(0);
            hikmNativeInteger reasonCode = new hikmNativeInteger(0);
            byte[] optBlockID = PlatformUtilities.getBytesPlatform(this.optDataBlocks[obIdx].getOptDataID());
            byte[] optBlockData = PlatformUtilities.getBytesPlatform(this.optDataBlocks[obIdx].getOptData());
            hikmNativeInteger optBlockDataLength = new hikmNativeInteger(optBlockData.length);
            if (null != debug) {
                String ruleArrayString = "NULL";
                if (null != ruleArray) {
                    ruleArrayString = encoder.encodeBuffer(ruleArray);
                }
                String optDataString = "NULL";
                int currentLen = optBlocksLen.getValue();
                if (0 < currentLen) {
                    byte[] bufferedData = new byte[currentLen];
                    for (int bdIdx = 0; bdIdx < currentLen; ++bdIdx) {
                        bufferedData[bdIdx] = optBlocksBuffer[bdIdx];
                    }
                    optDataString = encoder.encodeBuffer(bufferedData);
                }
                String blkIDString = "NULL";
                if (null != optBlockID) {
                    blkIDString = encoder.encodeBuffer(optBlockID);
                }
                String blkDataString = "NULL";
                if (null != optBlockData) {
                    blkDataString = encoder.encodeBuffer(optBlockData);
                }
                String parmsReport = "\nDESedeTR31KeyWrap: CSNBT31O INPUT PARAMETERS \n    returnCode     : " + returnCode.getValue() + "\n    reasonCode     : " + reasonCode.getValue() + "\n    ruleArrayCnt   : " + ruleArrayCount.getValue() + "\n    ruleArray      : \n" + ruleArrayString + "\n    OptDataBuffLen : " + optBlocksBufferLen.getValue() + "\n    OptBlocksCount : " + optBlocksCount.getValue() + "\n    OptBlocksLen   : " + optBlocksLen.getValue() + "\n    OptBlocks      : \n" + optDataString + "\n\n    NewOptBlockID  : " + blkIDString + "\n    NewOptDataLen  : " + optBlockDataLength.getValue() + "\n    NewOptBlockData: \n" + blkDataString + "\n";
                debug.text(Debug.TYPE_FINEST, className, "addOptionalDataBlocks", parmsReport);
            }
            try {
                hikm.CSNBT31OJ(returnCode, reasonCode, exitDataLength, exitData, ruleArrayCount, ruleArray, optBlocksBufferLen, optBlocksLen, optBlocksBuffer, optBlocksCount, optBlockID, optBlockDataLength, optBlockData);
            }
            catch (Exception e) {
                if (debug != null) {
                    debug.text(Debug.TYPE_FINE, className, "addOptionalDataBlocks", "Exception caught on iteration " + obIdx);
                    debug.exception(Debug.TYPE_PUBLIC, className, "addOptionalDataBlocks", e);
                }
                throw new RuntimeException("Hardware error from call CSNBT31O " + e);
            }
            if (debug != null) {
                debug.text(Debug.TYPE_FINE, className, "addOptionalDataBlocks", "CSNBT31O: return code = " + returnCode.getValue() + " reason code = " + reasonCode.getValue());
            }
            if (null != debug) {
                String optDataString = "NULL";
                int currentLen = optBlocksLen.getValue();
                if (0 < currentLen) {
                    byte[] bufferedData = new byte[currentLen];
                    for (int bdIdx = 0; bdIdx < currentLen; ++bdIdx) {
                        bufferedData[bdIdx] = optBlocksBuffer[bdIdx];
                    }
                    optDataString = encoder.encodeBuffer(bufferedData);
                }
                String parmsReport = "\nDESedeTR31KeyWrap: CSNBT31O RETURN PARAMETERS \n    returnCode     : " + returnCode.getValue() + "\n    reasonCode     : " + reasonCode.getValue() + "\n    OptDataBuffLen : " + optBlocksBufferLen.getValue() + "\n    OptBlocksCount : " + optBlocksCount.getValue() + "\n    OptBlocksLen   : " + optBlocksLen.getValue() + "\n    OptBlocks      : \n" + optDataString + "\n";
                debug.text(Debug.TYPE_FINEST, className, "addOptionalDataBlocks", parmsReport);
            }
            if (returnCode.getValue() == 0) continue;
            JCECCARuntimeException re = new JCECCARuntimeException(1, "CSNBT31O", "Hardware error from call CSNBT31O returnCode " + returnCode.getValue() + " reasonCode " + reasonCode.getValue() + " when adding optional data block at index " + obIdx, returnCode.getValue(), reasonCode.getValue());
            if (debug != null) {
                debug.exception(8192L, className, "addOptionalDataBlocks", re);
                debug.exit(8192L, className, "addOptionalDataBlocks");
            }
            throw re;
        }
        this.encodedOptDataBlocksLength = optBlocksLen.getValue();
        this.encodedOptDataBlocks = new byte[this.encodedOptDataBlocksLength];
        for (int odbIdx = 0; odbIdx < this.encodedOptDataBlocksLength; ++odbIdx) {
            this.encodedOptDataBlocks[odbIdx] = optBlocksBuffer[odbIdx];
        }
        optBlocksBuffer = null;
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "addOptionalDataBlocks");
        }
    }
}

