/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.hdwrCCA.provider;

import com.ibm.crypto.hdwrCCA.provider.CCAAlgorithmParameterSpec;
import com.ibm.crypto.hdwrCCA.provider.DESKey;
import com.ibm.crypto.hdwrCCA.provider.DESedeKey;
import com.ibm.crypto.hdwrCCA.provider.Debug;
import com.ibm.crypto.hdwrCCA.provider.IBMJCECCA;
import com.ibm.crypto.hdwrCCA.provider.JCECCARuntimeException;
import com.ibm.crypto.hdwrCCA.provider.PlatformUtilities;
import com.ibm.crypto.hdwrCCA.provider.SymmetricKeyConstants;
import com.ibm.crypto.hdwrCCA.provider.SymmetricKeyUtils;
import com.ibm.crypto.hdwrCCA.provider.SymmetricKeyWrap;
import java.lang.invoke.LambdaMetafactory;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.Arrays;
import java.util.function.IntPredicate;
import java.util.function.IntUnaryOperator;
import java.util.stream.IntStream;
import javax.crypto.Cipher;

public final class DESedeKeyWrap
extends SymmetricKeyWrap {
    private static final int DES_BLOCK_SIZE_BYTES = 8;
    private static final int OUTPUT_SIZE = 64;
    private SymmetricKeyWrap.CipherState state = SymmetricKeyWrap.CipherState.UNINITIALIZED;
    private Key transportKey = null;
    private SymmetricKeyConstants.KeyType unwrapKeyType = DEFAULT_UNWRAP_KEY_TYPE;
    private String unwrapLabel = null;
    private boolean NoCvKEKOption = false;
    private SymmetricKeyConstants.KeyUsage importedKeyUsage = null;
    private static Debug debug = Debug.getInstance("ibmjcecca");
    private static String className = "com.ibm.crypto.hdwrCCA.provider.DESedeKeyWrap";

    public DESedeKeyWrap() {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "DESedeKeyWrap");
        }
        IBMJCECCA.verifyJceJar();
        if (!IBMJCECCA.verifySelfIntegrity(this.getClass())) {
            SecurityException se = new SecurityException("The IBMJCECCA provider may have been tampered.");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "DESedeKeyWrap", se);
                debug.exit(Debug.TYPE_FINE, className, "DESedeKeyWrap");
            }
            throw se;
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "DESedeKeyWrap");
        }
    }

    @Override
    protected int engineGetBlockSize() {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "engineGetBlockSize");
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineGetBlockSize", 8);
        }
        return 8;
    }

    @Override
    protected int engineGetOutputSize(int inputLen) {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineGetOutputSize", inputLen);
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineGetOutputSize", 64);
        }
        return 64;
    }

    @Override
    protected int engineGetKeySize(Key key) {
        int keySize;
        block4: {
            if (debug != null) {
                debug.entry(Debug.TYPE_FINE, (Object)className, "engineGetKeySize", key);
            }
            keySize = 128;
            try {
                keySize = Cipher.getMaxAllowedKeyLength("DESede");
            }
            catch (NoSuchAlgorithmException e) {
                if (debug == null) break block4;
                debug.exception(Debug.TYPE_PUBLIC, className, "engineGetKeySize", e);
            }
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineGetKeySize", keySize);
        }
        return keySize;
    }

    @Override
    protected void engineInit(int opmode, Key key, SecureRandom random) throws InvalidKeyException {
        if (debug != null) {
            Object[] parms = new Object[]{opmode, key, random};
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineInit", parms);
        }
        try {
            DESedeKeyWrap.checkEngineInitParameters(opmode, key, null, random);
        }
        catch (InvalidAlgorithmParameterException parms) {
            // empty catch block
        }
        if (!(key instanceof DESedeKey)) {
            InvalidKeyException ike = new InvalidKeyException("Key must be an instance of com.ibm.crypto.hdwrCCA.provider.DESedeKey");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineInit", ike);
                debug.exit(Debug.TYPE_FINE, className, "engineInit");
            }
            throw ike;
        }
        this.state = opmode == 3 ? SymmetricKeyWrap.CipherState.WRAP : SymmetricKeyWrap.CipherState.UNWRAP;
        this.transportKey = key;
        this.unwrapKeyType = DEFAULT_UNWRAP_KEY_TYPE;
        this.unwrapLabel = null;
        this.NoCvKEKOption = false;
        this.importedKeyUsage = null;
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "engineInit");
        }
    }

    @Override
    protected void engineInit(int opmode, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (debug != null) {
            Object[] parms = new Object[]{opmode, key, params, random};
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineInit", parms);
        }
        DESedeKeyWrap.checkEngineInitParameters(opmode, key, params, random);
        if (null != params) {
            this.checkDESedeParameters(opmode, key, params);
        }
        if (!(key instanceof DESedeKey)) {
            InvalidKeyException ike = new InvalidKeyException("Key must be an instance of com.ibm.crypto.hdwrCCA.provider.DESedeKey");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineInit", ike);
                debug.exit(Debug.TYPE_FINE, className, "engineInit");
            }
            throw ike;
        }
        this.state = opmode == 3 ? SymmetricKeyWrap.CipherState.WRAP : SymmetricKeyWrap.CipherState.UNWRAP;
        this.transportKey = key;
        this.unwrapKeyType = DEFAULT_UNWRAP_KEY_TYPE;
        this.unwrapLabel = null;
        this.NoCvKEKOption = false;
        this.importedKeyUsage = null;
        CCAAlgorithmParameterSpec spec = (CCAAlgorithmParameterSpec)params;
        if (spec != null) {
            byte hwType = spec.getHwType();
            this.unwrapKeyType = SymmetricKeyConstants.KeyType.valueOfOrDefault(hwType, DEFAULT_UNWRAP_KEY_TYPE);
            this.unwrapLabel = spec.getLabel();
            this.NoCvKEKOption = spec.getNoCvKEK();
            this.importedKeyUsage = spec.getKeyUsage();
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "engineInit");
        }
    }

    @Override
    protected void engineInit(int opmode, Key key, AlgorithmParameters params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (debug != null) {
            Object[] parms = new Object[]{opmode, key, params, random};
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineInit", parms);
        }
        CCAAlgorithmParameterSpec spec = null;
        if (params != null) {
            try {
                spec = params.getParameterSpec(CCAAlgorithmParameterSpec.class);
            }
            catch (InvalidParameterSpecException ipse) {
                InvalidAlgorithmParameterException iape = new InvalidAlgorithmParameterException("Algorithm parameters not compatible or supported", ipse);
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, "engineInit", iape);
                    debug.exit(Debug.TYPE_FINE, className, "engineInit");
                }
                throw iape;
            }
        }
        DESedeKeyWrap.checkEngineInitParameters(opmode, key, spec, random);
        if (null != spec) {
            this.checkDESedeParameters(opmode, key, spec);
        }
        if (!(key instanceof DESedeKey)) {
            InvalidKeyException ike = new InvalidKeyException("Key must be an instance of com.ibm.crypto.hdwrCCA.provider.DESedeKey");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineInit", ike);
                debug.exit(Debug.TYPE_FINE, className, "engineInit");
            }
            throw ike;
        }
        this.state = opmode == 3 ? SymmetricKeyWrap.CipherState.WRAP : SymmetricKeyWrap.CipherState.UNWRAP;
        this.transportKey = key;
        this.unwrapKeyType = DEFAULT_UNWRAP_KEY_TYPE;
        this.unwrapLabel = null;
        this.NoCvKEKOption = false;
        this.importedKeyUsage = null;
        if (spec != null) {
            byte hwType = spec.getHwType();
            this.unwrapKeyType = SymmetricKeyConstants.KeyType.valueOfOrDefault(hwType, DEFAULT_UNWRAP_KEY_TYPE);
            this.unwrapLabel = spec.getLabel();
            this.NoCvKEKOption = spec.getNoCvKEK();
            this.importedKeyUsage = spec.getKeyUsage();
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "engineInit");
        }
    }

    private void checkDESedeParameters(int opmode, Key key, AlgorithmParameterSpec params) throws InvalidAlgorithmParameterException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "checkDESedeParameters");
        }
        CCAAlgorithmParameterSpec spec = (CCAAlgorithmParameterSpec)params;
        boolean specNoCVflag = spec.getNoCvKEK();
        SymmetricKeyConstants.KeyUsage specImportedKeyUsage = spec.getKeyUsage();
        if (!specNoCVflag) {
            if (opmode == 4 && specImportedKeyUsage != null && !SymmetricKeyConstants.KeyUsage.singleKeys().contains((Object)specImportedKeyUsage)) {
                InvalidParameterException iae = new InvalidParameterException("Key usage must represent a single key");
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, "checkDESedeParameters", iae);
                    debug.exit(Debug.TYPE_FINE, className, "checkDESedeParameters");
                }
                throw iae;
            }
        } else {
            if (opmode != 4) {
                InvalidParameterException ipe = new InvalidParameterException("The NoCvKEK option is only allowed when in unwrap mode.");
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, "checkDESedeParameters", ipe);
                    debug.exit(Debug.TYPE_FINE, className, "checkDESedeParameters");
                }
                throw ipe;
            }
            if (null == specImportedKeyUsage) {
                InvalidParameterException ipe = new InvalidParameterException("If the NoCvKEK option is specified then the imported key usage must be specified.");
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, "checkDESedeParameters", ipe);
                    debug.exit(Debug.TYPE_FINE, className, "checkDESedeParameters");
                }
                throw ipe;
            }
            if (specImportedKeyUsage != SymmetricKeyConstants.KeyUsage.OP_IMPORTER && specImportedKeyUsage != SymmetricKeyConstants.KeyUsage.OP_EXPORTER) {
                InvalidParameterException ipe = new InvalidParameterException("Imported key usage must be either OP_IMPORTER or OP_EXPORTER because the NoCvKEK option is only allowed for a key encrypting key.");
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, "checkDESedeParameters", ipe);
                    debug.exit(Debug.TYPE_FINE, className, "checkDESedeParameters");
                }
                throw ipe;
            }
            byte specTypeOfKey = spec.getHwType();
            if (specTypeOfKey != 0) {
                InvalidParameterException ipe = new InvalidParameterException("The NoCvKEK option is only allowed for a key encrypting key in the CKDS");
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, "checkDESedeParameters", ipe);
                    debug.exit(Debug.TYPE_PUBLIC, className, "checkDESedeParameters");
                }
                throw ipe;
            }
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "checkDESedeParameters");
        }
    }

    @Override
    protected byte[] engineWrap(Key key) throws InvalidKeyException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineWrap", key);
        }
        if (key == null) {
            NullPointerException npe = new NullPointerException("Key is null");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineWrap", npe);
                debug.exit(Debug.TYPE_FINE, className, "engineWrap");
            }
            throw npe;
        }
        if (!(key instanceof DESKey) && !(key instanceof DESedeKey)) {
            InvalidKeyException ike = new InvalidKeyException("Key must be a com.ibm.crypto.hdwrCCA.provider.DESKey or com.ibm.crypto.hdwrCCA.provider.DESedeKey");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineWrap", ike);
                debug.exit(Debug.TYPE_FINE, className, "engineWrap");
            }
            throw ike;
        }
        if (key.getFormat().equals("RAW")) {
            InvalidKeyException ike = new InvalidKeyException("Key must be a SECURE_INTERNAL_TOKEN or CKDS key");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineWrap", ike);
                debug.exit(Debug.TYPE_FINE, className, "engineWrap");
            }
            throw ike;
        }
        if (this.state != SymmetricKeyWrap.CipherState.WRAP) {
            IllegalStateException ise = new IllegalStateException("Cipher not initialized for wrap operation mode");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineWrap", ise);
                debug.exit(Debug.TYPE_FINE, className, "engineWrap");
            }
            throw ise;
        }
        String keyTypeString = "TOKEN   ";
        byte[] wrappingTokenOrLabel = this.transportKey.getEncoded();
        byte[] tokenOrLabel = key.getEncoded();
        if (PlatformUtilities.isLinux()) {
            wrappingTokenOrLabel = PlatformUtilities.convertBytesIfKeyLabelETOA(wrappingTokenOrLabel);
            tokenOrLabel = PlatformUtilities.convertBytesIfKeyLabelETOA(tokenOrLabel);
        }
        byte[] externalToken = SymmetricKeyUtils.keyExport(keyTypeString, tokenOrLabel, wrappingTokenOrLabel);
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineWrap", externalToken);
        }
        return externalToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    protected Key engineUnwrap(byte[] wrappedKey, String wrappedKeyAlgorithm, int wrappedKeyType) throws InvalidKeyException {
        if (DESedeKeyWrap.debug != null) {
            parms = new Object[]{wrappedKey, wrappedKeyAlgorithm, wrappedKeyType};
            DESedeKeyWrap.debug.entry(Debug.TYPE_FINE, (Object)DESedeKeyWrap.className, "engineUnwrap", parms);
        }
        if (wrappedKey == null) {
            npe = new NullPointerException("Wrapped key is null");
            if (DESedeKeyWrap.debug != null) {
                DESedeKeyWrap.debug.exception(Debug.TYPE_PUBLIC, DESedeKeyWrap.className, "engineUnwrap", npe);
                DESedeKeyWrap.debug.exit(Debug.TYPE_FINE, DESedeKeyWrap.className, "engineUnwrap");
            }
            throw npe;
        }
        if (!("DES".equalsIgnoreCase(wrappedKeyAlgorithm) || "DESede".equalsIgnoreCase(wrappedKeyAlgorithm) || "TripleDES".equalsIgnoreCase(wrappedKeyAlgorithm) || "3DES".equalsIgnoreCase(wrappedKeyAlgorithm))) {
            ike = new InvalidKeyException("Wrapped key algorithm must be DES or DESede");
            if (DESedeKeyWrap.debug != null) {
                DESedeKeyWrap.debug.exception(Debug.TYPE_PUBLIC, DESedeKeyWrap.className, "engineUnwrap", ike);
                DESedeKeyWrap.debug.exit(Debug.TYPE_FINE, DESedeKeyWrap.className, "engineUnwrap");
            }
            throw ike;
        }
        if (wrappedKeyType != 3) {
            ike = new InvalidKeyException("Wrapped key type must be SECRET_KEY");
            if (DESedeKeyWrap.debug != null) {
                DESedeKeyWrap.debug.exception(Debug.TYPE_PUBLIC, DESedeKeyWrap.className, "engineUnwrap", ike);
                DESedeKeyWrap.debug.exit(Debug.TYPE_FINE, DESedeKeyWrap.className, "engineUnwrap");
            }
            throw ike;
        }
        if (wrappedKey.length != 64) {
            ike = new InvalidKeyException("Wrapped key must be 64 bytes long");
            if (DESedeKeyWrap.debug != null) {
                DESedeKeyWrap.debug.exception(Debug.TYPE_PUBLIC, DESedeKeyWrap.className, "engineUnwrap", ike);
                DESedeKeyWrap.debug.exit(Debug.TYPE_FINE, DESedeKeyWrap.className, "engineUnwrap");
            }
            throw ike;
        }
        if (this.state != SymmetricKeyWrap.CipherState.UNWRAP) {
            ise = new IllegalStateException("Cipher not initialized for unwrap operation mode");
            if (DESedeKeyWrap.debug != null) {
                DESedeKeyWrap.debug.exception(Debug.TYPE_PUBLIC, DESedeKeyWrap.className, "engineUnwrap", ise);
                DESedeKeyWrap.debug.exit(Debug.TYPE_FINE, DESedeKeyWrap.className, "engineUnwrap");
            }
            throw ise;
        }
        keyTypeString = "TOKEN   ";
        if (this.importedKeyUsage != null) {
            switch (1.$SwitchMap$com$ibm$crypto$hdwrCCA$provider$SymmetricKeyConstants$KeyUsage[this.importedKeyUsage.ordinal()]) {
                case 1: {
                    keyTypeString = "IMPORTER";
                    break;
                }
                case 2: {
                    keyTypeString = "EXPORTER";
                    break;
                }
                case 3: {
                    keyTypeString = "DATA    ";
                    break;
                }
                case 4: {
                    keyTypeString = "CIPHER  ";
                    break;
                }
            }
        }
        skeletonToken = null;
        if (this.NoCvKEKOption) {
            if (null != DESedeKeyWrap.debug) {
                txt = "\nThe NoCvKEK option is specified.\nCreating a skeleton token assuming that the key is 112-bit DESede.";
                DESedeKeyWrap.debug.text(Debug.TYPE_FINE, DESedeKeyWrap.className, "engineUnwrap", txt);
            }
            ruleArrayBuilder = "DES     INTERNALKEYLN16 NOCV-KEK";
            ruleArrayNum = 4;
            skeletonToken = SymmetricKeyUtils.keyTokenBuild(keyTypeString, ruleArrayNum, ruleArrayBuilder);
        }
        unwrappingTokenOrLabel = this.transportKey.getEncoded();
        if (PlatformUtilities.isLinux()) {
            unwrappingTokenOrLabel = PlatformUtilities.convertBytesIfKeyLabelETOA(unwrappingTokenOrLabel);
        }
        internalToken = SymmetricKeyUtils.keyImport(keyTypeString, wrappedKey, unwrappingTokenOrLabel, skeletonToken);
        if ((this.importedKeyUsage == SymmetricKeyConstants.KeyUsage.OP_CIPHER || this.importedKeyUsage == SymmetricKeyConstants.KeyUsage.OP_DATA) && ("DESede".equalsIgnoreCase(wrappedKeyAlgorithm) || "TripleDES".equalsIgnoreCase(wrappedKeyAlgorithm) || "3DES".equalsIgnoreCase(wrappedKeyAlgorithm)) && (isRightHalfKeyMissing = IntStream.rangeClosed(24, 31).map((IntUnaryOperator)LambdaMetafactory.metafactory(null, null, null, (I)I, lambda$engineUnwrap$0(byte[] int ), (I)I)((byte[])internalToken)).allMatch((IntPredicate)LambdaMetafactory.metafactory(null, null, null, (I)Z, lambda$engineUnwrap$1(int ), (I)Z)()))) {
            ccae = new JCECCARuntimeException(1, "CSNBKIM", "Imported key is not a usable DESede key", 0, 0);
            if (DESedeKeyWrap.debug != null) {
                DESedeKeyWrap.debug.exception(Debug.TYPE_PUBLIC, DESedeKeyWrap.className, "engineUnwrap", ccae);
                DESedeKeyWrap.debug.exit(Debug.TYPE_FINE, DESedeKeyWrap.className, "engineUnwrap");
            }
            throw ccae;
        }
        if ("DES".equalsIgnoreCase(wrappedKeyAlgorithm)) {
            try {
                key /* !! */  = new DESKey("ICSFToken", internalToken);
                if (this.unwrapKeyType != SymmetricKeyConstants.KeyType.CKDS) ** GOTO lbl86
                actualLabel = SymmetricKeyUtils.storeProtectedKeyInCKDS(key /* !! */ , this.unwrapLabel);
                key /* !! */  = DESKey.newLabelKey(actualLabel);
            }
            finally {
                Arrays.fill(internalToken, (byte)0);
            }
        } else {
            try {
                key /* !! */  = new DESedeKey("ICSFToken", internalToken);
                if (this.unwrapKeyType == SymmetricKeyConstants.KeyType.CKDS) {
                    actualLabel = SymmetricKeyUtils.storeProtectedKeyInCKDS(key /* !! */ , this.unwrapLabel);
                    key /* !! */  = DESedeKey.newLabelKey(actualLabel);
                }
            }
            finally {
                Arrays.fill(internalToken, (byte)0);
            }
        }
        if (DESedeKeyWrap.debug != null) {
            DESedeKeyWrap.debug.exit(Debug.TYPE_FINE, (Object)DESedeKeyWrap.className, "engineUnwrap", key /* !! */ );
        }
        return key /* !! */ ;
    }

    private static /* synthetic */ boolean lambda$engineUnwrap$1(int byteValue) {
        return byteValue == 0;
    }

    private static /* synthetic */ int lambda$engineUnwrap$0(byte[] internalToken, int bytePosition) {
        return internalToken[bytePosition];
    }
}

