/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.hdwrCCA.provider;

import com.ibm.crypto.hdwrCCA.provider.CCAAlgorithmParameterSpec;
import com.ibm.crypto.hdwrCCA.provider.DESKeyGenerator;
import com.ibm.crypto.hdwrCCA.provider.DESedeKey;
import com.ibm.crypto.hdwrCCA.provider.Debug;
import com.ibm.crypto.hdwrCCA.provider.HIKM;
import com.ibm.crypto.hdwrCCA.provider.HardwareProfile;
import com.ibm.crypto.hdwrCCA.provider.HexDumpEncoder;
import com.ibm.crypto.hdwrCCA.provider.IBMJCECCA;
import com.ibm.crypto.hdwrCCA.provider.JCECCARuntimeException;
import com.ibm.crypto.hdwrCCA.provider.PlatformUtilities;
import com.ibm.crypto.hdwrCCA.provider.SymmetricKeyConstants;
import com.ibm.crypto.hdwrCCA.provider.SymmetricKeyUtils;
import com.ibm.crypto.hdwrCCA.provider.TokenPair;
import com.ibm.crypto.hdwrCCA.provider.hikmNativeInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import javax.crypto.KeyGeneratorSpi;
import javax.crypto.SecretKey;

public final class DESedeKeyGenerator
extends KeyGeneratorSpi {
    private static final int DEFAULT_DESEDE_KEYSIZE = 168;
    private static final SymmetricKeyConstants.KeyUsage DEFAULT_DESEDE_KEY_USAGE = SymmetricKeyConstants.KeyUsage.OP_DATA;
    private SecureRandom random = null;
    private int keysize = 168;
    private boolean genHWkeyToken = false;
    private boolean storeKey1InCKDS = false;
    private String key1CKDSLabel = null;
    private byte keyTokenWrapMode = (byte)10;
    private boolean generatePairOfKeys = false;
    private SymmetricKeyConstants.KeyUsage keyUsage = null;
    private boolean NoCvKEKOption = false;
    private SecretKey key2EncryptingKey = null;
    private static Debug debug = Debug.getInstance("ibmjcecca");
    private static String className = "com.ibm.crypto.hdwrCCA.provider.DESedeKeyGenerator";

    public DESedeKeyGenerator() {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "DESedeKeyGenerator");
        }
        IBMJCECCA.verifyJceJar();
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "DESedeKeyGenerator");
        }
    }

    @Override
    protected void engineInit(SecureRandom random) {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineInit", random);
        }
        this.NoCvKEKOption = false;
        this.random = random;
        this.keysize = 168;
        this.genHWkeyToken = false;
        this.keyTokenWrapMode = (byte)10;
        this.generatePairOfKeys = false;
        this.keyUsage = null;
        this.storeKey1InCKDS = false;
        this.key1CKDSLabel = null;
        this.key2EncryptingKey = null;
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "engineInit");
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void engineInit(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        int specKeySize;
        block51: {
            block53: {
                String labelInfo;
                byte specWrappingMode;
                block55: {
                    block54: {
                        boolean specNoCVflag;
                        SecretKey specKey2KEK;
                        byte specKeyType;
                        SymmetricKeyConstants.KeyUsage specKeyUsage;
                        CCAAlgorithmParameterSpec paramSpec;
                        block49: {
                            block52: {
                                block50: {
                                    if (debug != null) {
                                        debug.entry(Debug.TYPE_FINE, className, "engineInit", params, random);
                                    }
                                    if (!(params instanceof CCAAlgorithmParameterSpec)) {
                                        InvalidAlgorithmParameterException iape = new InvalidAlgorithmParameterException("Triple DES key generation parameter spec must be a CCAAlgorithmParameterSpec.");
                                        if (debug != null) {
                                            debug.exception(Debug.TYPE_PUBLIC, className, "engineInit", iape);
                                            debug.exit(Debug.TYPE_FINE, className, "engineInit");
                                        }
                                        throw iape;
                                    }
                                    paramSpec = (CCAAlgorithmParameterSpec)params;
                                    specKeySize = paramSpec.getKeySize();
                                    if (specKeySize == 0) {
                                        specKeySize = 168;
                                    }
                                    if ((specKeyUsage = paramSpec.getKeyUsage()) == null) {
                                        specKeyUsage = DEFAULT_DESEDE_KEY_USAGE;
                                    }
                                    specWrappingMode = paramSpec.getTokenWrappingMode();
                                    specKeyType = paramSpec.getHwType();
                                    specKey2KEK = paramSpec.getKey2KeyEncryptingKey();
                                    specNoCVflag = paramSpec.getNoCvKEK();
                                    if (specNoCVflag && specKeyType != 2) {
                                        if (specKeyUsage != SymmetricKeyConstants.KeyUsage.OPEX_EXPORTER_IMPORTER && specKeyUsage != SymmetricKeyConstants.KeyUsage.OPEX_IMPORTER_EXPORTER) {
                                            InvalidParameterException ipe = new InvalidParameterException("The NoCvKEK option is only allowed for a key encrypting key in the CKDS");
                                            if (debug != null) {
                                                debug.exception(Debug.TYPE_PUBLIC, className, "engineInit", ipe);
                                                debug.exit(Debug.TYPE_PUBLIC, className, "engineInit");
                                            }
                                            throw ipe;
                                        }
                                        if (specKeyType != 0) {
                                            InvalidParameterException ipe = new InvalidParameterException("The NoCvKEK option is only allowed for a key encrypting key in the CKDS");
                                            if (debug != null) {
                                                debug.exception(Debug.TYPE_PUBLIC, className, "engineInit", ipe);
                                                debug.exit(Debug.TYPE_PUBLIC, className, "engineInit");
                                            }
                                            throw ipe;
                                        }
                                    }
                                    if (!paramSpec.isSecureInternalToken()) break block49;
                                    if (!(specWrappingMode != 11 && specWrappingMode != 12 || HardwareProfile.getIsEnhancedWrappingPresent())) {
                                        RuntimeException e = new RuntimeException("WRAPPING_MODE_ECB and WRAPPING_MODE_CBC wrapping modes not supported on this combination of ICSF and/or hardware.");
                                        if (null != debug) {
                                            debug.exception(Debug.TYPE_PUBLIC, className, "engineInit", e);
                                            debug.exit(Debug.TYPE_FINE, className, "engineInit");
                                        }
                                        throw e;
                                    }
                                    this.random = null;
                                    this.keysize = specKeySize;
                                    this.genHWkeyToken = true;
                                    this.keyTokenWrapMode = specWrappingMode;
                                    this.keyUsage = specKeyUsage;
                                    this.storeKey1InCKDS = false;
                                    this.key1CKDSLabel = null;
                                    this.NoCvKEKOption = false;
                                    switch (this.keyUsage) {
                                        case OPEX_EXPORTER_IMPORTER: 
                                        case OPEX_IMPORTER_EXPORTER: {
                                            if (specKeySize != 112) {
                                                InvalidParameterException ipe = new InvalidParameterException("EXPORTER and IMPORTER keys must have keysize equal to 112");
                                                if (debug != null) {
                                                    debug.exception(Debug.TYPE_PUBLIC, className, "engineInit", ipe);
                                                    debug.exit(Debug.TYPE_FINE, className, "engineInit");
                                                }
                                                throw ipe;
                                            }
                                            this.generatePairOfKeys = true;
                                            this.key2EncryptingKey = DESedeKeyGenerator.checkKeyEncryptingKey(specKey2KEK);
                                            break;
                                        }
                                        case OP_DATA: {
                                            this.generatePairOfKeys = false;
                                            this.key2EncryptingKey = null;
                                            break;
                                        }
                                        default: {
                                            InvalidParameterException ipe = new InvalidParameterException("Not a supported key usage: " + (Object)((Object)specKeyUsage));
                                            if (debug != null) {
                                                debug.exception(Debug.TYPE_PUBLIC, className, "engineInit", ipe);
                                                debug.exit(Debug.TYPE_FINE, className, "engineInit");
                                            }
                                            throw ipe;
                                        }
                                    }
                                    if (specWrappingMode != 11) break block50;
                                    if (debug != null) {
                                        debug.text(Debug.TYPE_PUBLIC, className, "engineInit", "A CCAAlgorithmParameterSpec is specified, keyType is SECURE_INTERNAL_TOKEN and wrapping mode is ECB. The DESede key will be generated as a secret hardware key using the WRAPPING_MODE_ECB token wrapping mode.");
                                    }
                                    break block51;
                                }
                                if (specWrappingMode != 12) break block52;
                                if (debug != null) {
                                    debug.text(Debug.TYPE_PUBLIC, className, "engineInit", "A CCAAlgorithmParameterSpec is specified, keyType is SECURE_INTERNAL_TOKEN and wrapping mode is CBC. The DESede key will be generated as a secret hardware key using the WRAPPING_MODE_CBC token wrapping mode.");
                                }
                                break block51;
                            }
                            if (specWrappingMode == 10) {
                                if (debug != null) {
                                    debug.text(Debug.TYPE_PUBLIC, className, "engineInit", "A CCAAlgorithmParameterSpec is specified, keyType is SECURE_INTERNAL_TOKEN. The DESede key will be generated as a secret hardware key using the default token wrapping mode.");
                                }
                                break block51;
                            } else {
                                InvalidParameterException ipe = new InvalidParameterException("Wrapping mode value is not recognized: " + specWrappingMode);
                                if (debug != null) {
                                    debug.exception(Debug.TYPE_PUBLIC, className, "engineInit", ipe);
                                    debug.exit(Debug.TYPE_FINE, className, "engineInit");
                                }
                                throw ipe;
                            }
                        }
                        if (specKeyType != 0) break block53;
                        if (!(specWrappingMode != 11 && specWrappingMode != 12 || HardwareProfile.getIsEnhancedWrappingPresent())) {
                            RuntimeException e = new RuntimeException("WRAPPING_MODE_ECB and WRAPPING_MODE_CBC wrapping modes not supported on this combination of ICSF and/or hardware.");
                            if (null != debug) {
                                debug.exception(Debug.TYPE_PUBLIC, className, "engineInit", e);
                                debug.exit(Debug.TYPE_FINE, className, "engineInit");
                            }
                            throw e;
                        }
                        this.random = null;
                        this.keysize = specKeySize;
                        this.genHWkeyToken = true;
                        this.keyTokenWrapMode = specWrappingMode;
                        this.keyUsage = specKeyUsage;
                        this.storeKey1InCKDS = true;
                        this.key1CKDSLabel = paramSpec.getLabel();
                        this.NoCvKEKOption = false;
                        switch (this.keyUsage) {
                            case OPEX_EXPORTER_IMPORTER: 
                            case OPEX_IMPORTER_EXPORTER: {
                                if (specKeySize != 112) {
                                    InvalidParameterException ipe = new InvalidParameterException("EXPORTER and IMPORTER keys must have keysize equal to 112");
                                    if (debug != null) {
                                        debug.exception(Debug.TYPE_PUBLIC, className, "engineInit", ipe);
                                        debug.exit(Debug.TYPE_FINE, className, "engineInit");
                                    }
                                    throw ipe;
                                }
                                this.generatePairOfKeys = true;
                                this.key2EncryptingKey = DESedeKeyGenerator.checkKeyEncryptingKey(specKey2KEK);
                                this.NoCvKEKOption = specNoCVflag;
                                break;
                            }
                            case OP_DATA: {
                                this.generatePairOfKeys = false;
                                this.key2EncryptingKey = null;
                                break;
                            }
                            default: {
                                InvalidParameterException ipe = new InvalidParameterException("Not a supported key usage: " + (Object)((Object)specKeyUsage));
                                if (debug != null) {
                                    debug.exception(Debug.TYPE_PUBLIC, className, "engineInit", ipe);
                                    debug.exit(Debug.TYPE_FINE, className, "engineInit");
                                }
                                throw ipe;
                            }
                        }
                        if (specWrappingMode != 11) break block54;
                        if (debug != null) {
                            labelInfo = "A CKDS label will be generated for the new entry.";
                            if (null != this.key1CKDSLabel && !"".equals(this.key1CKDSLabel)) {
                                labelInfo = "The following user-specified CKDS label will be used: " + this.key1CKDSLabel;
                            }
                            debug.text(Debug.TYPE_PUBLIC, className, "engineInit", "A CCAAlgorithmParameterSpec is specified, keyType is CKDS. The DESede key will be generated as a secret hardware key and stored in the CKDS. The CKDS entry will be wrapped using the WRAPPING_MODE_ECB wrapping mode. " + labelInfo);
                        }
                        break block51;
                    }
                    if (specWrappingMode != 12) break block55;
                    if (debug != null) {
                        labelInfo = "A CKDS label will be generated for the new entry.";
                        if (null != this.key1CKDSLabel && !"".equals(this.key1CKDSLabel)) {
                            labelInfo = "The following user-specified CKDS label will be used: " + this.key1CKDSLabel;
                        }
                        debug.text(Debug.TYPE_PUBLIC, className, "engineInit", "A CCAAlgorithmParameterSpec is specified, keyType is CKDS. The DESede key will be generated as a secret hardware key and stored in the CKDS. The CKDS entry will be wrapped using the WRAPPING_MODE_CBC wrapping mode. " + labelInfo);
                    }
                    break block51;
                }
                if (specWrappingMode == 10) {
                    if (debug != null) {
                        labelInfo = "A CKDS label will be generated for the new entry.";
                        if (null != this.key1CKDSLabel && !"".equals(this.key1CKDSLabel)) {
                            labelInfo = "The following user-specified CKDS label will be used: " + this.key1CKDSLabel;
                        }
                        debug.text(Debug.TYPE_PUBLIC, className, "engineInit", "A CCAAlgorithmParameterSpec is specified, keyType is CKDS. The DESede key will be generated as a secret hardware key and stored in the CKDS. The CKDS entry will be wrapped using the default wrapping mode. " + labelInfo);
                    }
                    break block51;
                } else {
                    InvalidParameterException ipe = new InvalidParameterException("Wrapping mode value is not recognized: " + specWrappingMode);
                    if (debug != null) {
                        debug.exception(Debug.TYPE_PUBLIC, className, "engineInit", ipe);
                        debug.exit(Debug.TYPE_FINE, className, "engineInit");
                    }
                    throw ipe;
                }
            }
            this.random = random;
            this.keysize = specKeySize;
            this.genHWkeyToken = false;
            this.keyTokenWrapMode = (byte)10;
            this.generatePairOfKeys = false;
            this.keyUsage = null;
            this.storeKey1InCKDS = false;
            this.key1CKDSLabel = null;
            this.key2EncryptingKey = null;
            this.NoCvKEKOption = false;
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineInit", "A CCAAlgorithmParameterSpec is specified, keyType is CLEAR. The DESede key will be generated as a clear key.");
            }
        }
        if (specKeySize != 112 && specKeySize != 168) {
            InvalidParameterException ipe = new InvalidParameterException("Wrong keysize: must be equal to 112 or 168");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineInit", ipe);
                debug.exit(Debug.TYPE_FINE, className, "engineInit");
            }
            throw ipe;
        }
        if (null != random && this.genHWkeyToken) {
            InvalidAlgorithmParameterException iape = new InvalidAlgorithmParameterException("It is not valid to specify a source of randomness for a secret hardware DESede key.");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineInit", iape);
                debug.exit(Debug.TYPE_FINE, className, "engineInit");
            }
            throw iape;
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "engineInit");
        }
    }

    @Override
    protected void engineInit(int keysize, SecureRandom random) {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "engineInit", keysize, random);
        }
        if (keysize != 112 && keysize != 168) {
            InvalidParameterException ipe = new InvalidParameterException("Wrong keysize: must be equal to 112 or 168");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineInit", ipe);
                debug.exit(Debug.TYPE_FINE, className, "engineInit");
            }
            throw ipe;
        }
        this.engineInit(random);
        this.keysize = keysize;
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "engineInit");
        }
    }

    private static final SecretKey checkKeyEncryptingKey(SecretKey keyEncryptingKey) {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "checkKeyEncryptingKey", keyEncryptingKey);
        }
        if (keyEncryptingKey == null) {
            InvalidParameterException ipe = new InvalidParameterException("A Key Encrypting Key is required");
            if (debug != null) {
                debug.exception(8192L, className, "checkKeyEncryptingKey", ipe);
                debug.exit(8192L, className, "checkKeyEncryptingKey");
            }
            throw ipe;
        }
        if (!(keyEncryptingKey instanceof DESedeKey)) {
            InvalidParameterException ipe = new InvalidParameterException("The Key Encrypting Key must be an instance of com.ibm.crypto.hdwrCCA.provider.DESedeKey");
            if (debug != null) {
                debug.exception(8192L, className, "checkKeyEncryptingKey", ipe);
                debug.exit(8192L, className, "checkKeyEncryptingKey");
            }
            throw ipe;
        }
        if (keyEncryptingKey.getFormat().equalsIgnoreCase("RAW")) {
            InvalidParameterException ipe = new InvalidParameterException("The Key Encrypting Key must be a hardware key");
            if (debug != null) {
                debug.exception(8192L, className, "checkKeyEncryptingKey", ipe);
                debug.exit(8192L, className, "checkKeyEncryptingKey");
            }
            throw ipe;
        }
        if (debug != null) {
            debug.exit(8192L, (Object)className, "checkKeyEncryptingKey", keyEncryptingKey);
        }
        return keyEncryptingKey;
    }

    @Override
    protected SecretKey engineGenerateKey() {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "engineGenerateKey");
        }
        DESedeKey desedeKey = null;
        if (this.genHWkeyToken) {
            if (this.generatePairOfKeys) {
                TokenPair pairOfTokens = this.generatePairOfICSFTokens();
                byte[] primaryToken = pairOfTokens.getPrimaryToken();
                byte[] secondaryToken = pairOfTokens.getSecondaryToken();
                try {
                    desedeKey = new DESedeKey("ICSFToken", primaryToken, secondaryToken);
                }
                catch (InvalidKeyException ike) {
                    if (debug != null) {
                        debug.exception(Debug.TYPE_PUBLIC, className, "engineGenerateKey", ike);
                        debug.exit(Debug.TYPE_FINE, className, "engineGenerateKey");
                    }
                    throw new RuntimeException("Key type: ICSFToken. " + ike.getMessage(), ike);
                }
                finally {
                    Arrays.fill(primaryToken, (byte)0);
                    Arrays.fill(secondaryToken, (byte)0);
                }
                if (this.storeKey1InCKDS) {
                    try {
                        String actualLabel = SymmetricKeyUtils.storeProtectedKeyInCKDS(desedeKey, this.key1CKDSLabel);
                        desedeKey = DESedeKey.newLabelKeyWithPairedToken(actualLabel, desedeKey.getPairedExternalToken());
                    }
                    catch (InvalidKeyException ike) {
                        if (debug != null) {
                            debug.exception(Debug.TYPE_PUBLIC, className, "engineGenerateKey", ike);
                            debug.exit(Debug.TYPE_FINE, className, "engineGenerateKey");
                        }
                        throw new RuntimeException("Key type: CKDSLabel. " + ike.getMessage(), ike);
                    }
                }
            } else {
                byte[] token = this.generateHWKeyToken();
                try {
                    desedeKey = new DESedeKey("ICSFToken", token);
                }
                catch (InvalidKeyException ike) {
                    if (debug != null) {
                        debug.exception(Debug.TYPE_PUBLIC, className, "engineGenerateKey", ike);
                        debug.exit(Debug.TYPE_FINE, className, "engineGenerateKey");
                    }
                    throw new RuntimeException("Key type: ICSFToken    " + ike.getMessage(), ike);
                }
                finally {
                    Arrays.fill(token, (byte)0);
                }
                if (this.storeKey1InCKDS) {
                    try {
                        String actualLabel = SymmetricKeyUtils.storeProtectedKeyInCKDS(desedeKey, this.key1CKDSLabel);
                        desedeKey = DESedeKey.newLabelKey(actualLabel);
                    }
                    catch (Exception ex) {
                        if (debug != null) {
                            debug.exception(Debug.TYPE_PUBLIC, className, "engineGenerateKey", ex);
                            debug.exit(Debug.TYPE_FINE, className, "engineGenerateKey");
                        }
                        throw new RuntimeException("Error storing key " + this.key1CKDSLabel + " in the CKDS. " + ex.getMessage(), ex);
                    }
                }
            }
        } else {
            if (this.random == null) {
                try {
                    this.random = SecureRandom.getInstance("IBMSecureRandom", "IBMJCECCA");
                }
                catch (NoSuchAlgorithmException | NoSuchProviderException e) {
                    if (debug != null) {
                        debug.exception(Debug.TYPE_PUBLIC, className, "engineGenerateKey", e);
                    }
                    this.random = new SecureRandom();
                }
            }
            byte[] rawkey = new byte[24];
            if (this.keysize == 168) {
                this.random.nextBytes(rawkey);
                DESKeyGenerator.setParityBit(rawkey, 0);
                DESKeyGenerator.setParityBit(rawkey, 8);
                DESKeyGenerator.setParityBit(rawkey, 16);
            } else if (this.keysize == 112) {
                byte[] tmpkey = new byte[16];
                this.random.nextBytes(tmpkey);
                DESKeyGenerator.setParityBit(tmpkey, 0);
                DESKeyGenerator.setParityBit(tmpkey, 8);
                System.arraycopy(tmpkey, 0, rawkey, 0, tmpkey.length);
                System.arraycopy(tmpkey, 0, rawkey, 16, 8);
                Arrays.fill(tmpkey, (byte)0);
            } else {
                InvalidParameterException e = new InvalidParameterException("Wrong keysize: must be equal to 112 or 168");
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, "engineGenerateKey", e);
                    debug.exit(Debug.TYPE_FINE, className, "engineGenerateKey");
                }
                throw e;
            }
            try {
                desedeKey = new DESedeKey(rawkey);
            }
            catch (InvalidKeyException ike) {
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, "engineGenerateKey", ike);
                    debug.exit(Debug.TYPE_FINE, className, "engineGenerateKey");
                }
                throw new RuntimeException(ike.getMessage());
            }
            finally {
                Arrays.fill(rawkey, (byte)0);
            }
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineGenerateKey", desedeKey);
        }
        return desedeKey;
    }

    private byte[] generateHWKeyToken() {
        String kekKeyId2String;
        String kekKeyId1String;
        String exitDataString;
        byte[] genKeyId2;
        byte[] genKeyId1;
        byte[] keyType1;
        byte[] keyLength;
        HexDumpEncoder encoder = null;
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "generateHWKeyToken");
            encoder = new HexDumpEncoder();
        }
        HIKM hikm = new HIKM();
        hikmNativeInteger returnCode = new hikmNativeInteger(0);
        hikmNativeInteger reasonCode = new hikmNativeInteger(0);
        hikmNativeInteger exitDataLength = new hikmNativeInteger(0);
        byte[] exitData = new byte[]{};
        byte[] kekKeyId1 = new byte[64];
        byte[] kekKeyId2 = new byte[64];
        byte[] keyForm = PlatformUtilities.getBytesPlatform("OP  ");
        if (this.keysize == 168) {
            keyLength = PlatformUtilities.getBytesPlatform("KEYLN24 ");
        } else if (this.keysize == 112) {
            keyLength = PlatformUtilities.getBytesPlatform("KEYLN16 ");
        } else {
            InvalidParameterException e = new InvalidParameterException("Wrong keysize: must be equal to 112 or 168");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "generateHWKeyToken", e);
                debug.exit(Debug.TYPE_FINE, className, "generateHWKeyToken");
            }
            throw e;
        }
        byte[] keyType2 = new byte[8];
        if (this.keyTokenWrapMode != 10) {
            keyType1 = PlatformUtilities.getBytesPlatform("TOKEN   ");
            genKeyId1 = SymmetricKeyUtils.generateSymmetricDESSkeletonToken(this.keysize, this.keyTokenWrapMode);
            genKeyId2 = (byte[])genKeyId1.clone();
        } else {
            keyType1 = PlatformUtilities.getBytesPlatform("DATA    ");
            genKeyId1 = new byte[64];
            genKeyId2 = (byte[])genKeyId1.clone();
        }
        if (null != debug) {
            exitDataString = encoder.encodeBuffer(exitData);
            kekKeyId1String = encoder.encodeBuffer(kekKeyId1);
            kekKeyId2String = encoder.encodeBuffer(kekKeyId2);
            String keyFormString = encoder.encodeBuffer(keyForm);
            String keyLengthString = encoder.encodeBuffer(keyLength);
            String keyType1String = encoder.encodeBuffer(keyType1);
            String keyType2String = encoder.encodeBuffer(keyType2);
            String genKeyId1String = encoder.encodeBuffer(genKeyId1);
            String genKeyId2String = encoder.encodeBuffer(genKeyId2);
            String parmsReport = "\nDESedeKeyGenerator: CSNBKGN INPUT PARAMETERS \n    exitDataLen: " + exitDataLength.getValue() + "\n    exitData   : " + exitDataString + "\n    kekKeyId1  :\n" + kekKeyId1String + "\n    kekKeyId2  :\n" + kekKeyId2String + "\n    keyForm    : " + keyFormString + "\n    keyLength  : " + keyLengthString + "\n    keyType1   : " + keyType1String + "\n    keyType2   : " + keyType2String + "\n    genKeyId1  :\n" + genKeyId1String + "\n    genKeyId2  :\n" + genKeyId2String + "\n";
            debug.text(Debug.TYPE_FINEST, className, "generateHWKeyToken", parmsReport);
        }
        try {
            hikm.CSNBKGNJ(returnCode, reasonCode, exitDataLength, exitData, keyForm, keyLength, keyType1, keyType2, kekKeyId1, kekKeyId2, genKeyId1, genKeyId2);
        }
        catch (IllegalArgumentException e) {
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "generateHWKeyToken", e);
                debug.exit(Debug.TYPE_FINE, className, "generateHWKeyToken");
            }
            throw new RuntimeException("Hardware error from call CSNBKGN " + e);
        }
        if (debug != null) {
            debug.text(Debug.TYPE_FINE, className, "generateHWKeyToken", "CSNBKGN: return code = " + returnCode.getValue() + " reason code = " + reasonCode.getValue());
        }
        if (debug != null) {
            exitDataString = encoder.encodeBuffer(exitData);
            kekKeyId1String = encoder.encodeBuffer(kekKeyId1);
            kekKeyId2String = encoder.encodeBuffer(kekKeyId2);
            String genKeyId1String = encoder.encodeBuffer(genKeyId1);
            String genKeyId2String = encoder.encodeBuffer(genKeyId2);
            String parmsReport = "\nDESedeKeyGenerator: CSNBKGN RETURN PARAMETERS: \n    returnCode : " + returnCode.getValue() + "\n    reasonCode : " + reasonCode.getValue() + "\n    exitDataLen: " + exitDataLength.getValue() + "\n    exitData   : " + exitDataString + "\n    kekKeyId1  :\n" + kekKeyId1String + "\n    kekKeyId2  :\n" + kekKeyId2String + "\n    genKeyId1  :\n" + genKeyId1String + "\n    genKeyId2  :\n" + genKeyId2String + "\n";
            debug.text(Debug.TYPE_FINEST, className, "generateHWKeyToken", parmsReport);
        }
        if (returnCode.getValue() != 0) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "generateHWKeyToken", "Hardware error from call CSNBKGN returnCode=" + returnCode.getValue() + " reasonCode=" + reasonCode.getValue());
                debug.exit(Debug.TYPE_FINE, className, "generateHWKeyToken");
            }
            throw new JCECCARuntimeException(1, "CSNBKGN", "Hardware error from call CSNBKGN returnCode " + returnCode.getValue() + " reasonCode " + reasonCode.getValue(), returnCode.getValue(), reasonCode.getValue());
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "generateHWKeyToken", genKeyId1);
        }
        return genKeyId1;
    }

    private final TokenPair generatePairOfICSFTokens() {
        if (debug != null) {
            debug.entry(8192L, className, "generatePairOfICSFTokens");
        }
        String keyType1String = null;
        String keyType2String = null;
        switch (this.keyUsage) {
            case OPEX_EXPORTER_IMPORTER: {
                keyType1String = "EXPORTER";
                keyType2String = "IMPORTER";
                break;
            }
            default: {
                keyType1String = "IMPORTER";
                keyType2String = "EXPORTER";
            }
        }
        String keyFormString = "OPEX";
        String keyLengthString = this.keysize == 112 ? "KEYLN16 " : "KEYLN24 ";
        byte[] kekKeyIdentifier1 = null;
        byte[] kekKeyIdentifier2 = this.key2EncryptingKey.getEncoded();
        byte[] generatedKeyIdentifier1 = null;
        byte[] generatedKeyIdentifier2 = null;
        if (PlatformUtilities.isLinux() && this.key2EncryptingKey.getFormat().equals("CKDSLabel")) {
            kekKeyIdentifier2 = PlatformUtilities.convertBytesETOA(kekKeyIdentifier2);
        }
        if (this.keyTokenWrapMode != 10 || this.NoCvKEKOption) {
            generatedKeyIdentifier1 = DESedeKeyGenerator.buildSkeletonToken(keyType1String, "INTERNAL", keyLengthString, this.keyTokenWrapMode == 12, this.NoCvKEKOption);
            generatedKeyIdentifier2 = DESedeKeyGenerator.buildSkeletonToken(keyType2String, "EXTERNAL", keyLengthString, this.keyTokenWrapMode == 12, false);
            keyType1String = "TOKEN   ";
            keyType2String = "TOKEN   ";
        }
        TokenPair result = SymmetricKeyUtils.keyGenerate(keyFormString, keyLengthString, keyType1String, keyType2String, kekKeyIdentifier1, kekKeyIdentifier2, generatedKeyIdentifier1, generatedKeyIdentifier2);
        if (debug != null) {
            debug.exit(8192L, (Object)className, "generatePairOfICSFTokens", result);
        }
        return result;
    }

    private static final byte[] buildSkeletonToken(String keyType, String ruleArrayTokenType, String ruleArrayKeyLength, boolean doEnhancedKeyWrapping, boolean setNoCVoption) {
        if (debug != null) {
            Object[] parms = new Object[]{keyType, ruleArrayTokenType, ruleArrayKeyLength, doEnhancedKeyWrapping, setNoCVoption};
            debug.entry(8192L, (Object)className, "buildSkeletonToken", parms);
        }
        int ruleArrayCount = 3;
        String ruleArray = "DES     ";
        ruleArray = ruleArray + ruleArrayTokenType;
        ruleArray = ruleArray + ruleArrayKeyLength;
        if (doEnhancedKeyWrapping) {
            ruleArray = ruleArray + "WRAP-ENH";
            ++ruleArrayCount;
        }
        if (setNoCVoption) {
            ruleArray = ruleArray + "NOCV-KEK";
            ++ruleArrayCount;
        }
        byte[] skeletonToken = SymmetricKeyUtils.keyTokenBuild(keyType, ruleArrayCount, ruleArray);
        if (debug != null) {
            debug.exit(8192L, (Object)className, "buildSkeletonToken", skeletonToken);
        }
        return skeletonToken;
    }
}

