/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.hdwrCCA.provider;

import com.ibm.crypto.hdwrCCA.provider.DESedeKey;
import com.ibm.crypto.hdwrCCA.provider.DESedeKeySpec;
import com.ibm.crypto.hdwrCCA.provider.Debug;
import com.ibm.crypto.hdwrCCA.provider.IBMJCECCA;
import com.ibm.crypto.hdwrCCA.provider.KeyLabelKeySpec;
import java.security.InvalidKeyException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactorySpi;
import javax.crypto.spec.SecretKeySpec;

public final class DESedeKeyFactory
extends SecretKeyFactorySpi {
    private static Debug debug = Debug.getInstance("ibmjcecca");
    private static String className = "com.ibm.crypto.hdwrCCA.tools.DESedeKeyFactory";

    public DESedeKeyFactory() {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "DESedeKeyFactory");
        }
        IBMJCECCA.verifyJceJar();
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "DESedeKeyFactory");
        }
    }

    @Override
    protected SecretKey engineGenerateSecret(KeySpec keySpec) throws InvalidKeySpecException {
        DESedeKey desEdeKey;
        block12: {
            desEdeKey = null;
            if (debug != null) {
                debug.entry(Debug.TYPE_FINE, (Object)className, "engineGenerateSecret", keySpec);
            }
            if (keySpec == null || !(keySpec instanceof DESedeKeySpec) && !(keySpec instanceof javax.crypto.spec.DESedeKeySpec) && !(keySpec instanceof SecretKeySpec) && !(keySpec instanceof KeyLabelKeySpec)) {
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "engineGenerateSecret", "Inappropriate key specification");
                    debug.exit(Debug.TYPE_FINE, className, "engineGenerateSecret");
                }
                throw new InvalidKeySpecException("Inappropriate key specification");
            }
            try {
                if (keySpec instanceof SecretKeySpec) {
                    SecretKeySpec skeySpec = (SecretKeySpec)keySpec;
                    byte[] keyBytes = skeySpec.getEncoded();
                    javax.crypto.spec.DESedeKeySpec desEdeKeySpec = new javax.crypto.spec.DESedeKeySpec(keyBytes);
                    desEdeKey = new DESedeKey(desEdeKeySpec.getKey());
                } else if (keySpec instanceof KeyLabelKeySpec) {
                    String ckdsLabel = ((KeyLabelKeySpec)keySpec).getLabelString();
                    desEdeKey = DESedeKey.newLabelKey(ckdsLabel);
                } else if (keySpec instanceof DESedeKeySpec) {
                    DESedeKeySpec desEdeKeySpec = (DESedeKeySpec)keySpec;
                    desEdeKey = new DESedeKey(desEdeKeySpec.getType(), desEdeKeySpec.getKey());
                } else {
                    javax.crypto.spec.DESedeKeySpec desEdeKeySpec = (javax.crypto.spec.DESedeKeySpec)keySpec;
                    desEdeKey = new DESedeKey(desEdeKeySpec.getKey());
                }
            }
            catch (InvalidKeyException e) {
                if (debug == null) break block12;
                debug.exception(Debug.TYPE_PUBLIC, className, "engineGenerateSecret", e);
            }
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineGenerateSecret", desEdeKey);
        }
        return desEdeKey;
    }

    protected KeySpec engineGetKeySpec(SecretKey key, Class keySpec) throws InvalidKeySpecException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "engineGetKeySpec", key, keySpec);
        }
        try {
            if (key != null && key instanceof SecretKey && key.getAlgorithm().equalsIgnoreCase("DESede")) {
                Class<?> desEdeKeySpecCCA = Class.forName("com.ibm.crypto.hdwrCCA.provider.DESedeKeySpec");
                String keyFormat = key.getFormat();
                if (keySpec != null && desEdeKeySpecCCA.isAssignableFrom(keySpec)) {
                    if ("RAW".equals(keyFormat) || "ICSFToken".equals(keyFormat) || "CKDSLabel".equals(keyFormat)) {
                        if (debug != null) {
                            debug.exit(Debug.TYPE_FINE, className, "engineGetKeySpec");
                        }
                        return new DESedeKeySpec(key.getEncoded(), keyFormat);
                    }
                    if (debug != null) {
                        debug.text(Debug.TYPE_PUBLIC, className, "engineGetKeySpec", "Inappropriate key format");
                    }
                    throw new InvalidKeySpecException("Inappropriate key format");
                }
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "engineGetKeySpec", "Inappropriate key specification");
                }
                throw new InvalidKeySpecException("Inappropriate key specification");
            }
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineGetKeySpec", "Inappropriate key format/algorithm");
            }
            throw new InvalidKeySpecException("Inappropriate key format/algorithm");
        }
        catch (InvalidKeyException e) {
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineGetKeySpec", e);
            }
            throw new InvalidKeySpecException("Secret key has wrong size");
        }
        catch (ClassNotFoundException e) {
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineGetKeySpec", e);
            }
            throw new InvalidKeySpecException("Unsupported key specification: " + e.getMessage());
        }
    }

    @Override
    protected SecretKey engineTranslateKey(SecretKey key) throws InvalidKeyException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineTranslateKey", key);
        }
        try {
            if (key != null && key.getAlgorithm().equalsIgnoreCase("DESede") && key.getFormat().equalsIgnoreCase("RAW")) {
                if (key instanceof DESedeKey) {
                    if (debug != null) {
                        debug.exit(Debug.TYPE_FINE, (Object)className, "engineTranslateKey1", key);
                    }
                    return key;
                }
                javax.crypto.spec.DESedeKeySpec desEdeKeySpec = (javax.crypto.spec.DESedeKeySpec)this.engineGetKeySpec(key, (Class)javax.crypto.spec.DESedeKeySpec.class);
                SecretKey secretKey = this.engineGenerateSecret(desEdeKeySpec);
                if (debug != null) {
                    debug.exit(Debug.TYPE_FINE, (Object)className, "engineTranslateKey2", secretKey);
                }
                return secretKey;
            }
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineTranslateKey", "Inappropriate key format/algorithm");
            }
            throw new InvalidKeyException("Inappropriate key format/algorithm");
        }
        catch (InvalidKeySpecException e) {
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineTranslateKey", e);
            }
            throw new InvalidKeyException("Cannot translate key");
        }
    }
}

