/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.hdwrCCA.provider;

import com.ibm.crypto.hdwrCCA.provider.DESConstants;
import com.ibm.crypto.hdwrCCA.provider.DESCrypt;
import com.ibm.crypto.hdwrCCA.provider.Debug;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;

class DESedeCrypt
extends DESCrypt
implements DESConstants {
    private static Debug debug = Debug.getInstance("ibmjcecca");
    private static String className = "com.ibm.crypto.hdwrCCA.provider.DESedeCrypt";

    DESedeCrypt() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "DESedeCrypt");
            debug.exit(Debug.TYPE_PUBLIC, className, "DESedeCrypt");
        }
    }

    @Override
    void init(Key key) throws InvalidKeyException {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "init", key);
        }
        if (key == null) {
            throw new InvalidKeyException("Key missing");
        }
        if (!key.getAlgorithm().equalsIgnoreCase("DESede") && !key.getAlgorithm().equalsIgnoreCase("TripleDES")) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "init", "Wrong algorithm: DESede or TripleDES required");
            }
            throw new InvalidKeyException("Wrong algorithm: DESede or TripleDES required");
        }
        if (!key.getFormat().equalsIgnoreCase("RAW")) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "init", "Wrong format: RAW bytes needed");
            }
            throw new InvalidKeyException("Wrong format: RAW bytes needed");
        }
        byte[] keys = key.getEncoded();
        if (keys == null) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "init", "RAW bytes missing");
            }
            throw new InvalidKeyException("RAW bytes missing");
        }
        if (keys.length != 24) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "init", "Wrong key size");
            }
            throw new InvalidKeyException("Wrong key size");
        }
        this.rawKey = keys;
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "init");
        }
    }

    @Override
    void init(Key key, AlgorithmParameterSpec params) throws InvalidKeyException {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "init", key, params);
        }
        this.init(key);
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "init");
        }
    }
}

