/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.hdwrCCA.provider;

import com.ibm.crypto.hdwrCCA.provider.CipherBlockChaining;
import com.ibm.crypto.hdwrCCA.provider.CipherFeedback;
import com.ibm.crypto.hdwrCCA.provider.ConstructKeys;
import com.ibm.crypto.hdwrCCA.provider.DESConstants;
import com.ibm.crypto.hdwrCCA.provider.DESedeCrypt;
import com.ibm.crypto.hdwrCCA.provider.Debug;
import com.ibm.crypto.hdwrCCA.provider.ElectronicCodeBook;
import com.ibm.crypto.hdwrCCA.provider.FeedbackCipher;
import com.ibm.crypto.hdwrCCA.provider.FullHardwareCrypt;
import com.ibm.crypto.hdwrCCA.provider.HardwareProfile;
import com.ibm.crypto.hdwrCCA.provider.IBMJCECCA;
import com.ibm.crypto.hdwrCCA.provider.ICVSelection;
import com.ibm.crypto.hdwrCCA.provider.JCECCARuntimeException;
import com.ibm.crypto.hdwrCCA.provider.JCEHdwrUtils;
import com.ibm.crypto.hdwrCCA.provider.OutputFeedback;
import com.ibm.crypto.hdwrCCA.provider.PCBC;
import com.ibm.crypto.hdwrCCA.provider.PKCS5Padding;
import com.ibm.crypto.hdwrCCA.provider.Padding;
import com.ibm.crypto.hdwrCCA.provider.PlatformUtilities;
import com.ibm.crypto.hdwrCCA.provider.SymmetricCipher;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;

public final class DESedeCipher
extends CipherSpi
implements DESConstants {
    private byte[] buffer;
    private int unitBytes;
    private int buffered;
    private int diffBlocksize;
    private Padding padding;
    private Key specifiedKey;
    private SymmetricCipher cipher;
    private SecureRandom initRandom;
    private boolean jitOptimized;
    protected int cipherMode;
    private String cipherModeString;
    private String jitCipherModeString;
    private boolean decrypting;
    protected static final int ECB_MODE = 0;
    protected static final int CBC_MODE = 1;
    protected static final int CFB_MODE = 2;
    protected static final int OFB_MODE = 3;
    protected static final int PCBC_MODE = 4;
    private boolean isLabel;
    private boolean isToken;
    private int useHdwr;
    private int HSize;
    private byte[] keyToken;
    private JCEHdwrUtils hdwrUtils;
    private int lcfbLen;
    private ICVSelection icvMode;
    protected DESedeCrypt rawAlg;
    private static Debug debug = Debug.getInstance("ibmjcecca");
    private static String className = "com.ibm.crypto.hdwrCCA.provider.DESedeCipher";

    public DESedeCipher() {
        block6: {
            this.buffer = null;
            this.unitBytes = 0;
            this.buffered = 0;
            this.diffBlocksize = 8;
            this.padding = null;
            this.specifiedKey = null;
            this.cipher = null;
            this.initRandom = null;
            this.jitOptimized = false;
            this.jitCipherModeString = null;
            this.decrypting = false;
            this.isLabel = false;
            this.isToken = false;
            this.useHdwr = 0;
            this.HSize = 60;
            this.keyToken = null;
            this.lcfbLen = 0;
            this.icvMode = ICVSelection.ICV_INITIAL;
            if (debug != null) {
                debug.entry(Debug.TYPE_FINE, className, "DESedeCipher");
            }
            IBMJCECCA.verifyJceJar();
            if (!IBMJCECCA.verifySelfIntegrity(this.getClass())) {
                SecurityException se = new SecurityException("The IBMJCECCA provider may have been tampered.");
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "DESedeCipher", "The IBMJCECCA provider may have been tampered.");
                    debug.exception(Debug.TYPE_PUBLIC, className, "DESedeCipher", se);
                    debug.exit(Debug.TYPE_FINE, className, "DESedeCipher");
                }
                throw se;
            }
            try {
                this.setRawAlg();
                this.unitBytes = 8;
                this.buffer = new byte[16];
                this.engineSetMode("ECB");
                this.padding = new PKCS5Padding();
            }
            catch (NoSuchAlgorithmException ex) {
                if (debug == null) break block6;
                debug.exception(Debug.TYPE_PUBLIC, className, "DESedeCipher", ex);
            }
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "DESedeCipher");
        }
    }

    public DESedeCipher(String mode, String paddingScheme) throws NoSuchAlgorithmException, NoSuchPaddingException {
        this.buffer = null;
        this.unitBytes = 0;
        this.buffered = 0;
        this.diffBlocksize = 8;
        this.padding = null;
        this.specifiedKey = null;
        this.cipher = null;
        this.initRandom = null;
        this.jitOptimized = false;
        this.jitCipherModeString = null;
        this.decrypting = false;
        this.isLabel = false;
        this.isToken = false;
        this.useHdwr = 0;
        this.HSize = 60;
        this.keyToken = null;
        this.lcfbLen = 0;
        this.icvMode = ICVSelection.ICV_INITIAL;
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "DESedeCipher", mode, paddingScheme);
        }
        IBMJCECCA.verifyJceJar();
        if (!IBMJCECCA.verifySelfIntegrity(this.getClass())) {
            SecurityException se = new SecurityException("The IBMJCECCA provider may have been tampered.");
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "DESedeCipher", "The IBMJCECCA provider may have been tampered.");
                debug.exception(Debug.TYPE_PUBLIC, className, "DESedeCipher", se);
                debug.exit(Debug.TYPE_FINE, className, "DESedeCipher");
            }
            throw se;
        }
        this.setRawAlg();
        this.unitBytes = 8;
        this.buffer = new byte[16];
        this.engineSetMode(mode);
        this.engineSetPadding(paddingScheme);
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "DESedeCipher");
        }
    }

    protected void setRawAlg() {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "setRawAlg");
        }
        this.rawAlg = new DESedeCrypt();
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "setRawAlg");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void engineSetMode(String mode) throws NoSuchAlgorithmException {
        String modeUpperCase;
        block19: {
            OutputFeedback ofb;
            block21: {
                block20: {
                    int numInt;
                    if (debug != null) {
                        debug.entry(Debug.TYPE_FINE, (Object)className, "engineSetMode", mode);
                    }
                    if (mode == null) {
                        NoSuchAlgorithmException nsae = new NoSuchAlgorithmException("Cipher mode can not be null.");
                        if (debug == null) throw nsae;
                        debug.text(Debug.TYPE_PUBLIC, className, "engineSetMode", "Cipher mode can not be null.");
                        debug.exception(Debug.TYPE_PUBLIC, className, "engineSetMode", nsae);
                        debug.exit(Debug.TYPE_FINE, className, "engineSetMode");
                        throw nsae;
                    }
                    this.cipherModeString = modeUpperCase = mode.toUpperCase();
                    this.jitCipherModeString = modeUpperCase;
                    if (modeUpperCase.equals("ECB")) {
                        this.cipherMode = 0;
                        ElectronicCodeBook ecb = new ElectronicCodeBook();
                        ecb.setEmbeddedCipher(this.rawAlg);
                        this.cipher = ecb;
                        if (debug == null) return;
                        debug.exit(Debug.TYPE_FINE, className, "engineSetMode ECB");
                        return;
                    }
                    if (modeUpperCase.equals("CBC")) {
                        this.cipherMode = 1;
                        CipherBlockChaining cbc = new CipherBlockChaining();
                        cbc.setEmbeddedCipher(this.rawAlg);
                        this.cipher = cbc;
                        if (debug == null) return;
                        debug.exit(Debug.TYPE_FINE, className, "engineSetMode CBC");
                        return;
                    }
                    if (modeUpperCase.startsWith("CFB")) {
                        CipherFeedback cfb;
                        block18: {
                            this.cipherMode = 2;
                            this.jitCipherModeString = "CFB";
                            cfb = null;
                            if (mode.length() > 3) {
                                int numInt2;
                                Integer num = null;
                                try {
                                    num = Integer.valueOf(mode.substring(3));
                                }
                                catch (NumberFormatException e) {
                                    NoSuchAlgorithmException nsae = new NoSuchAlgorithmException("Algorithm mode: " + mode + " not implemented.");
                                    if (debug == null) throw nsae;
                                    debug.text(Debug.TYPE_PUBLIC, className, "engineSetMode", "Algorithm mode: " + mode + " not implemented.");
                                    debug.exception(Debug.TYPE_PUBLIC, className, "engineSetMode", nsae);
                                    debug.exit(Debug.TYPE_FINE, className, "engineSetMode");
                                    throw nsae;
                                }
                                if (num != null && num > 0 && (numInt2 = num.intValue()) % 8 == 0 && (this.unitBytes = numInt2 >> 3) <= 8) {
                                    cfb = new CipherFeedback(this.unitBytes);
                                    this.lcfbLen = this.unitBytes;
                                    if (!this.cipherModeString.equals("CFB") && !HardwareProfile.getIsOfbCfbGcmSupported()) {
                                        this.useHdwr = 1;
                                        if (debug != null) {
                                            debug.text(Debug.TYPE_PUBLIC, className, "engineSetMode", "(1) Setting useHdwr = 1 (use software)");
                                        }
                                    }
                                    this.specifiedKey = null;
                                    this.keyToken = null;
                                    this.hdwrUtils = null;
                                    break block18;
                                } else {
                                    NoSuchAlgorithmException nsae = new NoSuchAlgorithmException("Invalid algorithm mode: " + mode);
                                    if (debug == null) throw nsae;
                                    debug.text(Debug.TYPE_PUBLIC, className, "engineSetMode", "Invalid algorithm mode: " + mode);
                                    debug.exception(Debug.TYPE_PUBLIC, className, "engineSetMode", nsae);
                                    debug.exit(Debug.TYPE_FINE, className, "engineSetMode");
                                    throw nsae;
                                }
                            }
                            cfb = new CipherFeedback();
                        }
                        cfb.setEmbeddedCipher(this.rawAlg);
                        this.cipher = cfb;
                        if (debug == null) return;
                        debug.exit(Debug.TYPE_FINE, className, "engineSetMode CFB");
                        return;
                    }
                    if (!modeUpperCase.startsWith("OFB")) break block19;
                    this.cipherMode = 3;
                    this.jitCipherModeString = "OFB";
                    ofb = null;
                    if (mode.length() <= 3) break block20;
                    Integer num = null;
                    try {
                        num = Integer.valueOf(mode.substring(3));
                    }
                    catch (NumberFormatException e) {
                        NoSuchAlgorithmException nsae = new NoSuchAlgorithmException("Algorithm mode: " + mode + " not implemented.");
                        if (debug == null) throw nsae;
                        debug.text(Debug.TYPE_PUBLIC, className, "engineSetMode", "Algorithm mode: " + mode + " not implemented.");
                        debug.exception(Debug.TYPE_PUBLIC, className, "engineSetMode", nsae);
                        debug.exit(Debug.TYPE_FINE, className, "engineSetMode");
                        throw nsae;
                    }
                    if (num != null && num > 0 && (numInt = num.intValue()) % 8 == 0 && (this.unitBytes = numInt >> 3) <= 8) {
                        ofb = new OutputFeedback(this.unitBytes);
                        if (debug != null) {
                            debug.text(Debug.TYPE_FINE, className, "engineSetMode", "Algorithm mode: " + modeUpperCase + "  ** See method inline comments for notes about this special case.");
                        }
                        break block21;
                    } else {
                        NoSuchAlgorithmException nsae = new NoSuchAlgorithmException("Invalid algorithm mode: " + mode);
                        if (debug == null) throw nsae;
                        debug.text(Debug.TYPE_PUBLIC, className, "engineSetMode", "Invalid algorithm mode: " + mode);
                        debug.exception(Debug.TYPE_PUBLIC, className, "engineSetMode", nsae);
                        debug.exit(Debug.TYPE_FINE, className, "engineSetMode");
                        throw nsae;
                    }
                }
                ofb = new OutputFeedback();
            }
            ofb.setEmbeddedCipher(this.rawAlg);
            this.cipher = ofb;
            if (debug == null) return;
            debug.exit(Debug.TYPE_FINE, className, "engineSetMode OFB");
            return;
        }
        if (modeUpperCase.equals("PCBC")) {
            this.cipherMode = 4;
            PCBC pcbc = new PCBC();
            pcbc.setEmbeddedCipher(this.rawAlg);
            this.cipher = pcbc;
            if (debug == null) return;
            debug.exit(Debug.TYPE_FINE, className, "engineSetMode PCBC");
            return;
        }
        NoSuchAlgorithmException nsae = new NoSuchAlgorithmException("Cipher mode: " + mode + " not found");
        if (debug == null) throw nsae;
        debug.text(Debug.TYPE_PUBLIC, className, "engineSetMode", "Cipher mode: " + mode + " not found");
        debug.exception(Debug.TYPE_PUBLIC, className, "engineSetMode", nsae);
        debug.exit(Debug.TYPE_FINE, className, "engineSetMode");
        throw nsae;
    }

    @Override
    protected void engineSetPadding(String paddingScheme) throws NoSuchPaddingException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineSetPadding", paddingScheme);
        }
        if (paddingScheme == null) {
            NoSuchPaddingException nspe = new NoSuchPaddingException("null padding");
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineSetPadding", "null padding");
                debug.exception(Debug.TYPE_PUBLIC, className, "engineSetPadding", nspe);
                debug.exit(Debug.TYPE_FINE, className, "engineSetPadding");
            }
            throw nspe;
        }
        if (paddingScheme.equalsIgnoreCase("PKCS5Padding")) {
            this.padding = new PKCS5Padding();
            if (debug != null) {
                debug.exit(Debug.TYPE_FINE, className, "engineSetPadding1");
            }
        } else if (paddingScheme.equalsIgnoreCase("NoPadding")) {
            this.padding = null;
        } else {
            NoSuchPaddingException nspe = new NoSuchPaddingException("Padding: " + paddingScheme + " not implemented");
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineSetPadding", "Padding: " + paddingScheme + " not implemented");
                debug.exception(Debug.TYPE_PUBLIC, className, "engineSetPadding", nspe);
                debug.exit(Debug.TYPE_FINE, className, "engineSetPadding");
            }
            throw nspe;
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineSetPadding2", this.padding);
        }
    }

    @Override
    protected int engineGetBlockSize() {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "engineGetBlockSize");
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineGetBlockSize", new Integer(8));
        }
        return 8;
    }

    @Override
    protected int engineGetOutputSize(int inputLen) {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineGetOutputSize", new Integer(inputLen));
        }
        int totalLen = this.buffered + inputLen;
        if (this.padding == null) {
            if (debug != null) {
                debug.exit(Debug.TYPE_FINE, (Object)className, "engineGetOutputSize1", totalLen);
            }
            return totalLen;
        }
        if (this.decrypting) {
            if (debug != null) {
                debug.exit(Debug.TYPE_FINE, (Object)className, "engineGetOutputSize2", totalLen);
            }
            return totalLen;
        }
        if (this.unitBytes != 8) {
            if (totalLen < this.diffBlocksize) {
                if (debug != null) {
                    debug.exit(Debug.TYPE_FINE, (Object)className, "engineGetOutputSize3", this.diffBlocksize);
                }
                return this.diffBlocksize;
            }
            if (debug != null) {
                debug.exit(Debug.TYPE_FINE, (Object)className, "engineGetOutputSize4", totalLen + 8 - (totalLen - this.diffBlocksize) % 8);
            }
            return totalLen + 8 - (totalLen - this.diffBlocksize) % 8;
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineGetOutputSize5", totalLen + this.padding.padLength(totalLen));
        }
        return totalLen + this.padding.padLength(totalLen);
    }

    @Override
    protected byte[] engineGetIV() {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "engineGetIV");
        }
        if (this.cipherMode == 0) {
            if (debug != null) {
                debug.exit(Debug.TYPE_FINE, (Object)className, "engineGetIV1", null);
            }
            return null;
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineGetIV2", ((FeedbackCipher)((Object)this.cipher)).getIV());
        }
        return ((FeedbackCipher)((Object)this.cipher)).getIV();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void engineInit(int opmode, Key key, SecureRandom random) throws InvalidKeyException {
        block83: {
            InvalidKeyException ike;
            String env;
            InvalidKeyException ike2;
            if (debug != null) {
                Object[] parms = new Object[]{new Integer(opmode), key, random};
                debug.entry(Debug.TYPE_FINE, (Object)className, "engineInit1", parms);
            }
            if (key == null) {
                ike2 = new InvalidKeyException("No key given");
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "engineInit", "No key given");
                    debug.exception(Debug.TYPE_PUBLIC, className, "engineInit", ike2);
                    debug.exit(Debug.TYPE_FINE, className, "engineInit");
                }
                throw ike2;
            }
            this.initRandom = random;
            this.specifiedKey = key;
            this.useHdwr = 0;
            this.keyToken = null;
            this.hdwrUtils = null;
            this.jitOptimized = false;
            if (key.getFormat().equalsIgnoreCase("RAW")) {
                this.jitOptimized = this.jitOptimizationAvailable();
                if (this.jitOptimized) {
                    this.useHdwr = 2;
                    if (debug != null) {
                        debug.text(Debug.TYPE_PUBLIC, className, "engineInit", "(1a) Setting useHdwr = 2 (use hardware)");
                    }
                    this.hdwrUtils = new JCEHdwrUtils();
                }
            }
            if (PlatformUtilities.isLinux() && key.getFormat().equalsIgnoreCase("RAW") && !this.jitOptimized) {
                RuntimeException re = new RuntimeException("DESede clear key operations are not supported in this environment for mode " + this.cipherModeString);
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, "engineInit", re);
                    debug.exit(Debug.TYPE_FINE, className, "engineInit");
                }
                throw re;
            }
            if (key.getFormat().equalsIgnoreCase("CKDSLabel")) {
                this.isToken = false;
                this.isLabel = true;
            } else if (key.getFormat().equalsIgnoreCase("ICSFToken")) {
                this.isToken = true;
                this.isLabel = false;
            } else {
                this.isToken = false;
                this.isLabel = false;
            }
            if (this.cipherMode != 1 && this.cipherMode != 0 && this.cipherMode != 2 && this.cipherMode != 3 && this.isLabel) {
                ike2 = new InvalidKeyException("A CKDS label key can only be used with ECB, CFB, OFB or CBC mode.");
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "engineInit", "A CKDS label key can only be used with ECB, CFB, OFB or CBC mode.");
                    debug.exception(Debug.TYPE_PUBLIC, className, "engineInit", ike2);
                    debug.exit(Debug.TYPE_FINE, className, "engineInit");
                }
                throw ike2;
            }
            if (this.cipherMode != 1 && this.isToken) {
                ike2 = new InvalidKeyException("An ICSF token key can only be used with CBC mode.");
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "engineInit", "An ICSF token key can only be used with CBC mode.");
                    debug.exception(Debug.TYPE_PUBLIC, className, "engineInit", ike2);
                    debug.exit(Debug.TYPE_FINE, className, "engineInit");
                }
                throw ike2;
            }
            if (opmode == 2 || opmode == 4) {
                if (this.cipherMode != 0) {
                    ike2 = new InvalidKeyException("Parameters missing");
                    if (debug != null) {
                        debug.text(Debug.TYPE_PUBLIC, className, "engineInit", "Parameters missing");
                        debug.exception(Debug.TYPE_PUBLIC, className, "engineInit", ike2);
                        debug.exit(Debug.TYPE_FINE, className, "engineInit");
                    }
                    throw ike2;
                }
                this.decrypting = true;
            } else {
                this.decrypting = false;
            }
            this.buffered = 0;
            this.diffBlocksize = 8;
            if (this.cipherMode == 0 || random == null) {
                block82: {
                    String env2;
                    this.cipher.init(key);
                    if (!this.isLabel && !this.isToken) {
                        this.rawAlg.initDesKey(!this.decrypting);
                    }
                    if (!(this.jitOptimized || this.cipherMode != 1 && this.cipherMode != 0)) {
                        env2 = System.getProperty("ibm.DES.usehdwr.size");
                        if (env2 != null) {
                            this.HSize = new Integer(env2);
                        }
                        if (this.HSize == -1 && key.getFormat().equalsIgnoreCase("RAW")) {
                            this.useHdwr = 1;
                            if (debug != null) {
                                debug.text(Debug.TYPE_PUBLIC, className, "engineInit", "(2) Setting useHdwr = 1 (use software)");
                            }
                            this.specifiedKey = null;
                            this.keyToken = null;
                            this.hdwrUtils = null;
                        }
                    }
                    if (this.cipherMode == 2 && this.useHdwr == 0) {
                        if (!this.isLabel) {
                            env2 = System.getProperty("ibm.DES.usehdwr.size");
                            if (env2 != null) {
                                this.HSize = new Integer(env2);
                            }
                            if (this.HSize == -1 && key.getFormat().equalsIgnoreCase("RAW")) {
                                this.useHdwr = 1;
                                if (debug != null) {
                                    debug.text(Debug.TYPE_PUBLIC, className, "engineInit", "(2a) Setting useHdwr = 1 (use software)");
                                }
                                this.specifiedKey = null;
                                this.keyToken = null;
                                this.hdwrUtils = null;
                            }
                        } else if (this.cipherModeString.equals("CFB")) {
                            this.useHdwr = 2;
                            if (debug != null) {
                                debug.text(Debug.TYPE_PUBLIC, className, "engineInit", "(3) Setting useHdwr = 2 (use hardware)");
                            }
                            this.hdwrUtils = new JCEHdwrUtils();
                            this.keyToken = this.hdwrUtils.initHdwr(key, this.cipher.getIV());
                        } else if (HardwareProfile.getIsOfbCfbGcmSupported()) {
                            this.useHdwr = 2;
                            if (debug != null) {
                                debug.text(Debug.TYPE_PUBLIC, className, "engineInit", "(3a) Setting useHdwr = 2 (use hardware)");
                            }
                            this.hdwrUtils = new JCEHdwrUtils();
                            this.keyToken = this.hdwrUtils.initHdwr(key, this.cipher.getIV());
                        } else {
                            ike2 = new InvalidKeyException("(1) Requested operation not supported in this environment for a key in this format.");
                            if (debug != null) {
                                debug.text(Debug.TYPE_PUBLIC, className, "engineInit", "(1) Requested operation not supported in this environment for a key in this format.");
                                debug.exception(Debug.TYPE_PUBLIC, className, "engineInit", ike2);
                                debug.exit(Debug.TYPE_FINE, className, "engineInit");
                            }
                            throw ike2;
                        }
                    }
                    if (this.cipherMode == 3 && this.useHdwr == 0) {
                        if (this.isLabel) {
                            if (HardwareProfile.getIsOfbCfbGcmSupported()) {
                                this.useHdwr = 2;
                                if (debug != null) {
                                    debug.text(Debug.TYPE_PUBLIC, className, "engineInit", "(3b) Setting useHdwr = 2 (use hardware)");
                                }
                                this.hdwrUtils = new JCEHdwrUtils();
                                this.keyToken = this.hdwrUtils.initHdwr(key, this.cipher.getIV());
                                break block82;
                            } else {
                                ike2 = new InvalidKeyException("(2) Requested operation not supported in this environment for a key in this format.");
                                if (debug != null) {
                                    debug.text(Debug.TYPE_PUBLIC, className, "engineInit", "(2) Requested operation not supported in this environment for a key in this format.");
                                    debug.exception(Debug.TYPE_PUBLIC, className, "engineInit", ike2);
                                    debug.exit(Debug.TYPE_FINE, className, "engineInit");
                                }
                                throw ike2;
                            }
                        }
                        env2 = System.getProperty("ibm.DES.usehdwr.size");
                        if (env2 != null) {
                            this.HSize = new Integer(env2);
                        }
                        if (this.HSize == -1 && key.getFormat().equalsIgnoreCase("RAW")) {
                            this.useHdwr = 1;
                            if (debug != null) {
                                debug.text(Debug.TYPE_PUBLIC, className, "engineInit", "(4) Setting useHdwr = 1 (use software)");
                            }
                            this.specifiedKey = null;
                            this.keyToken = null;
                            this.hdwrUtils = null;
                        }
                    }
                }
                if (this.jitOptimized) {
                    this.keyToken = this.cipherMode == 2 || this.cipherMode == 3 ? this.hdwrUtils.initHdwr("DESede", this.jitCipherModeString, !this.decrypting, key, this.cipher.getIV(), this.unitBytes) : this.hdwrUtils.initHdwr("DESede", this.jitCipherModeString, !this.decrypting, key, this.cipher.getIV());
                }
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "engineInit", "(1) ibm.DES.usehdwr.size set (or defaulted) to " + this.HSize);
                    debug.exit(Debug.TYPE_FINE, className, "engineInit1");
                }
                return;
            }
            byte[] iv = new byte[8];
            random.nextBytes(iv);
            IvParameterSpec ivSpec = new IvParameterSpec(iv);
            try {
                this.cipher.init(key, ivSpec);
                if (!this.isLabel && !this.isToken) {
                    this.rawAlg.initDesKey(!this.decrypting);
                }
            }
            catch (InvalidAlgorithmParameterException e) {
                InvalidKeyException ike3 = new InvalidKeyException(e);
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, "engineInit", ike3);
                }
                throw ike3;
            }
            if (this.cipherMode == 1 && this.useHdwr == 0) {
                env = System.getProperty("ibm.DES.usehdwr.size");
                if (env != null) {
                    this.HSize = new Integer(env);
                }
                if (this.HSize == -1 && key.getFormat().equalsIgnoreCase("RAW")) {
                    this.useHdwr = 1;
                    if (debug != null) {
                        debug.text(Debug.TYPE_PUBLIC, className, "engineInit", "(5) Setting useHdwr = 1 (use software)");
                    }
                    this.specifiedKey = null;
                    this.keyToken = null;
                    this.hdwrUtils = null;
                }
            }
            if (this.cipherMode == 2 && this.useHdwr == 0) {
                if (!this.isLabel) {
                    env = System.getProperty("ibm.DES.usehdwr.size");
                    if (env != null) {
                        this.HSize = new Integer(env);
                    }
                    if (this.HSize == -1 && key.getFormat().equalsIgnoreCase("RAW")) {
                        this.useHdwr = 1;
                        if (debug != null) {
                            debug.text(Debug.TYPE_PUBLIC, className, "engineInit", "(5a) Setting useHdwr = 1 (use software)");
                        }
                        this.specifiedKey = null;
                        this.keyToken = null;
                        this.hdwrUtils = null;
                    }
                } else if (this.cipherModeString.equals("CFB")) {
                    this.useHdwr = 2;
                    if (debug != null) {
                        debug.text(Debug.TYPE_PUBLIC, className, "engineInit", "(5b) Setting useHdwr = 2 (use hardware)");
                    }
                    this.hdwrUtils = new JCEHdwrUtils();
                    this.keyToken = this.hdwrUtils.initHdwr(key, this.cipher.getIV());
                } else if (HardwareProfile.getIsOfbCfbGcmSupported()) {
                    this.useHdwr = 2;
                    if (debug != null) {
                        debug.text(Debug.TYPE_PUBLIC, className, "engineInit", "(5c) Setting useHdwr = 2 (use hardware)");
                    }
                    this.hdwrUtils = new JCEHdwrUtils();
                    this.keyToken = this.hdwrUtils.initHdwr(key, this.cipher.getIV());
                } else {
                    ike = new InvalidKeyException("(1) Requested operation not supported in this environment for a key in this format.");
                    if (debug != null) {
                        debug.text(Debug.TYPE_PUBLIC, className, "engineInit", "(1) Requested operation not supported in this environment for a key in this format.");
                        debug.exception(Debug.TYPE_PUBLIC, className, "engineInit", ike);
                        debug.exit(Debug.TYPE_FINE, className, "engineInit");
                    }
                    throw ike;
                }
            }
            if (this.cipherMode == 3 && this.useHdwr == 0) {
                if (this.isLabel) {
                    if (HardwareProfile.getIsOfbCfbGcmSupported()) {
                        this.useHdwr = 2;
                        if (debug != null) {
                            debug.text(Debug.TYPE_PUBLIC, className, "engineInit", "(6) Setting useHdwr = 2 (use hardware)");
                        }
                        this.hdwrUtils = new JCEHdwrUtils();
                        this.keyToken = this.hdwrUtils.initHdwr(key, this.cipher.getIV());
                        break block83;
                    } else {
                        ike = new InvalidKeyException("(4) Requested operation not supported in this environment for a key in this format.");
                        if (debug != null) {
                            debug.text(Debug.TYPE_PUBLIC, className, "engineInit", "(4) Requested operation not supported in this environment for a key in this format.");
                            debug.exception(Debug.TYPE_PUBLIC, className, "engineInit", ike);
                            debug.exit(Debug.TYPE_FINE, className, "engineInit");
                        }
                        throw ike;
                    }
                }
                env = System.getProperty("ibm.DES.usehdwr.size");
                if (env != null) {
                    this.HSize = new Integer(env);
                }
                if (this.HSize == -1 && key.getFormat().equalsIgnoreCase("RAW")) {
                    this.useHdwr = 1;
                    if (debug != null) {
                        debug.text(Debug.TYPE_PUBLIC, className, "engineInit", "(7) Setting useHdwr = 1 (use software)");
                    }
                    this.specifiedKey = null;
                    this.keyToken = null;
                    this.hdwrUtils = null;
                }
            }
        }
        if (this.jitOptimized) {
            this.keyToken = this.cipherMode == 2 || this.cipherMode == 3 ? this.hdwrUtils.initHdwr("DESede", this.jitCipherModeString, !this.decrypting, key, this.cipher.getIV(), this.unitBytes) : this.hdwrUtils.initHdwr("DESede", this.jitCipherModeString, !this.decrypting, key, this.cipher.getIV());
        }
        this.icvMode = ICVSelection.ICV_INITIAL;
        if (debug != null) {
            debug.text(Debug.TYPE_PUBLIC, className, "engineInit", "(2) ibm.DES.usehdwr.size set (or defaulted) to " + this.HSize);
            debug.text(Debug.TYPE_PUBLIC, className, "engineInit", "(1) icvMode set (or defaulted) to " + (Object)((Object)this.icvMode));
            debug.exit(Debug.TYPE_FINE, className, "engineInit1");
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void engineInit(int opmode, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        block76: {
            InvalidKeyException ike;
            String env;
            block79: {
                byte[] iv;
                block80: {
                    block77: {
                        block78: {
                            InvalidKeyException ike2;
                            if (debug != null) {
                                Object[] parms = new Object[]{new Integer(opmode), key, params, random};
                                debug.entry(Debug.TYPE_FINE, (Object)className, "engineInit", parms);
                            }
                            if (key == null) {
                                ike2 = new InvalidKeyException("No key given");
                                if (debug != null) {
                                    debug.text(Debug.TYPE_PUBLIC, className, "engineInit", "No key given");
                                    debug.exception(Debug.TYPE_PUBLIC, className, "engineInit", ike2);
                                    debug.exit(Debug.TYPE_FINE, className, "engineInit");
                                }
                                throw ike2;
                            }
                            this.initRandom = random;
                            this.specifiedKey = key;
                            this.useHdwr = 0;
                            this.keyToken = null;
                            this.hdwrUtils = null;
                            this.jitOptimized = false;
                            if (key.getFormat().equalsIgnoreCase("RAW")) {
                                this.jitOptimized = this.jitOptimizationAvailable();
                                if (this.jitOptimized) {
                                    this.useHdwr = 2;
                                    if (debug != null) {
                                        debug.text(Debug.TYPE_PUBLIC, className, "engineInit", "(7a) Setting useHdwr = 2 (use hardware)");
                                    }
                                    this.hdwrUtils = new JCEHdwrUtils();
                                }
                            }
                            if (PlatformUtilities.isLinux() && key.getFormat().equalsIgnoreCase("RAW") && !this.jitOptimized) {
                                RuntimeException re = new RuntimeException("DESede clear key operations are not supported in this environment for mode " + this.cipherModeString);
                                if (debug != null) {
                                    debug.exception(Debug.TYPE_PUBLIC, className, "engineInit", re);
                                    debug.exit(Debug.TYPE_FINE, className, "engineInit");
                                }
                                throw re;
                            }
                            if (key.getFormat().equalsIgnoreCase("CKDSLabel")) {
                                this.isLabel = true;
                                this.isToken = false;
                            } else if (key.getFormat().equalsIgnoreCase("ICSFToken")) {
                                this.isLabel = false;
                                this.isToken = true;
                            } else {
                                this.isLabel = false;
                                this.isToken = false;
                            }
                            if (this.cipherMode != 1 && this.cipherMode != 0 && this.cipherMode != 3 && this.cipherMode != 2 && this.isLabel) {
                                ike2 = new InvalidKeyException("A CKDS label key can only be used with ECB, CFB, OFB or CBC mode.");
                                if (debug != null) {
                                    debug.text(Debug.TYPE_PUBLIC, className, "engineInit", "A CKDS label key can only be used with ECB, CFB, OFB or CBC mode.");
                                    debug.exception(Debug.TYPE_PUBLIC, className, "engineInit", ike2);
                                    debug.exit(Debug.TYPE_FINE, className, "engineInit");
                                }
                                throw ike2;
                            }
                            if (this.cipherMode != 1 && this.isToken) {
                                ike2 = new InvalidKeyException("An ICSF token key can only be used with CBC mode.");
                                if (debug != null) {
                                    debug.text(Debug.TYPE_PUBLIC, className, "engineInit", "An ICSF token key can only be used with CBC mode.");
                                    debug.exception(Debug.TYPE_PUBLIC, className, "engineInit", ike2);
                                    debug.exit(Debug.TYPE_FINE, className, "engineInit");
                                }
                                throw ike2;
                            }
                            iv = new byte[8];
                            if (opmode == 2 || opmode == 4) {
                                if (this.cipherMode != 0 && params == null) {
                                    InvalidAlgorithmParameterException iape = new InvalidAlgorithmParameterException("Parameters missing");
                                    if (debug != null) {
                                        debug.text(Debug.TYPE_PUBLIC, className, "engineInit", "Parameters missing");
                                        debug.exception(Debug.TYPE_PUBLIC, className, "engineInit", iape);
                                        debug.exit(Debug.TYPE_FINE, className, "engineInit");
                                    }
                                    throw iape;
                                }
                                this.decrypting = true;
                            } else {
                                this.decrypting = false;
                            }
                            this.buffered = 0;
                            this.diffBlocksize = 8;
                            if (this.cipherMode == 0) {
                                String env2;
                                this.cipher.init(key);
                                if (!this.isLabel && !this.isToken) {
                                    this.rawAlg.initDesKey(!this.decrypting);
                                }
                                if ((env2 = System.getProperty("ibm.DES.usehdwr.size")) != null) {
                                    this.HSize = new Integer(env2);
                                }
                                if (this.HSize == -1 && !this.jitOptimized) {
                                    this.useHdwr = 1;
                                    if (debug != null) {
                                        debug.text(Debug.TYPE_PUBLIC, className, "engineInit", "(8) Setting useHdwr = 1 (use software)");
                                    }
                                    this.specifiedKey = null;
                                    this.keyToken = null;
                                    this.hdwrUtils = null;
                                }
                                if (this.jitOptimized) {
                                    this.keyToken = this.hdwrUtils.initHdwr("DESede", this.jitCipherModeString, !this.decrypting, key, this.cipher.getIV());
                                }
                                if (debug != null) {
                                    debug.text(Debug.TYPE_PUBLIC, className, "engineInit", "(3) ibm.DES.usehdwr.size set (or defaulted) to " + this.HSize);
                                    debug.exit(Debug.TYPE_FINE, className, "engineInit2");
                                }
                                return;
                            }
                            if (params == null) break block77;
                            if (!(params instanceof IvParameterSpec)) break block78;
                            this.cipher.init(key, (IvParameterSpec)params);
                            iv = ((IvParameterSpec)params).getIV();
                            if (this.cipherMode == 2 || this.cipherMode == 3) {
                                if (!this.isLabel && !this.isToken) {
                                    this.rawAlg.initDesKey(true);
                                }
                                break block79;
                            } else if (!this.isLabel && !this.isToken) {
                                this.rawAlg.initDesKey(!this.decrypting);
                            }
                            break block79;
                        }
                        InvalidAlgorithmParameterException iape = new InvalidAlgorithmParameterException("Wrong parameter type: IV expected");
                        if (debug != null) {
                            debug.text(Debug.TYPE_PUBLIC, className, "engineInit", "Wrong parameter type: IV expected");
                            debug.exception(Debug.TYPE_PUBLIC, className, "engineInit", iape);
                            debug.exit(Debug.TYPE_FINE, className, "engineInit");
                        }
                        throw iape;
                    }
                    if (random != null) break block80;
                    this.cipher.init(key);
                    if (this.cipherMode == 2 || this.cipherMode == 3) {
                        if (!this.isLabel && !this.isToken) {
                            this.rawAlg.initDesKey(true);
                        }
                        break block79;
                    } else if (!this.isLabel && !this.isToken) {
                        this.rawAlg.initDesKey(!this.decrypting);
                    }
                    break block79;
                }
                random.nextBytes(iv);
                IvParameterSpec spec = new IvParameterSpec(iv);
                this.cipher.init(key, spec);
                if (this.cipherMode == 2 || this.cipherMode == 3) {
                    if (!this.isLabel && !this.isToken) {
                        this.rawAlg.initDesKey(true);
                    }
                } else if (!this.isLabel && !this.isToken) {
                    this.rawAlg.initDesKey(!this.decrypting);
                }
            }
            if (this.cipherMode == 1 && this.useHdwr == 0) {
                env = System.getProperty("ibm.DES.usehdwr.size");
                if (env != null) {
                    this.HSize = new Integer(env);
                }
                if (this.HSize == -1) {
                    this.useHdwr = 1;
                    if (debug != null) {
                        debug.text(Debug.TYPE_PUBLIC, className, "engineInit", "(9) Setting useHdwr = 1 (use software)");
                    }
                    this.specifiedKey = null;
                    this.keyToken = null;
                    this.hdwrUtils = null;
                }
            }
            if (this.cipherMode == 2) {
                if (this.isToken) {
                    ike = new InvalidKeyException("(5) Requested operation not supported in this environment for a key in this format.");
                    if (debug != null) {
                        debug.text(Debug.TYPE_PUBLIC, className, "engineInit", "(5) Requested operation not supported in this environment for a key in this format.");
                        debug.exception(Debug.TYPE_PUBLIC, className, "engineInit", ike);
                        debug.exit(Debug.TYPE_FINE, className, "engineInit");
                    }
                    throw ike;
                }
                this.icvMode = ICVSelection.ICV_INITIAL;
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "engineInit", "(2) icvMode set (or defaulted) to " + (Object)((Object)this.icvMode));
                }
                if (this.useHdwr == 0) {
                    if (!this.isLabel) {
                        env = System.getProperty("ibm.DES.usehdwr.size");
                        if (env != null) {
                            this.HSize = new Integer(env);
                        }
                        if (this.HSize == -1) {
                            this.useHdwr = 1;
                            if (debug != null) {
                                debug.text(Debug.TYPE_PUBLIC, className, "engineInit", "(11) Setting useHdwr = 1 (use software)");
                            }
                            this.specifiedKey = null;
                            this.keyToken = null;
                            this.hdwrUtils = null;
                        }
                    } else if (this.cipherModeString.equals("CFB")) {
                        this.useHdwr = 2;
                        if (debug != null) {
                            debug.text(Debug.TYPE_PUBLIC, className, "engineInit", "(11a) Setting useHdwr = 2 (use hardware)");
                        }
                        this.hdwrUtils = new JCEHdwrUtils();
                        this.keyToken = this.hdwrUtils.initHdwr(key, this.cipher.getIV());
                    } else if (HardwareProfile.getIsOfbCfbGcmSupported()) {
                        this.useHdwr = 2;
                        if (debug != null) {
                            debug.text(Debug.TYPE_PUBLIC, className, "engineInit", "(11b) Setting useHdwr = 2 (use hardware)");
                        }
                        this.hdwrUtils = new JCEHdwrUtils();
                        this.keyToken = this.hdwrUtils.initHdwr(key, this.cipher.getIV());
                    } else {
                        ike = new InvalidKeyException("(6) Requested operation not supported in this environment for a key in this format.");
                        if (debug != null) {
                            debug.text(Debug.TYPE_PUBLIC, className, "engineInit", "(6) Requested operation not supported in this environment for a key in this format.");
                            debug.exception(Debug.TYPE_PUBLIC, className, "engineInit", ike);
                            debug.exit(Debug.TYPE_FINE, className, "engineInit");
                        }
                        throw ike;
                    }
                }
            }
            if (this.cipherMode == 3) {
                if (this.isToken) {
                    ike = new InvalidKeyException("(7) Requested operation not supported in this environment for a key in this format.");
                    if (debug != null) {
                        debug.text(Debug.TYPE_PUBLIC, className, "engineInit", "(7) Requested operation not supported in this environment for a key in this format.");
                        debug.exception(Debug.TYPE_PUBLIC, className, "engineInit", ike);
                        debug.exit(Debug.TYPE_FINE, className, "engineInit");
                    }
                    throw ike;
                }
                this.icvMode = ICVSelection.ICV_INITIAL;
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "engineInit", "(3) icvMode set (or defaulted) to " + (Object)((Object)this.icvMode));
                }
                if (this.useHdwr == 0) {
                    if (this.isLabel) {
                        if (HardwareProfile.getIsOfbCfbGcmSupported()) {
                            this.useHdwr = 2;
                            if (debug != null) {
                                debug.text(Debug.TYPE_PUBLIC, className, "engineInit", "(11c) Setting useHdwr = 2 (use hardware)");
                            }
                            this.hdwrUtils = new JCEHdwrUtils();
                            this.keyToken = this.hdwrUtils.initHdwr(key, this.cipher.getIV());
                            break block76;
                        } else {
                            ike = new InvalidKeyException("(8) Requested operation not supported in this environment for a key in this format.");
                            if (debug != null) {
                                debug.text(Debug.TYPE_PUBLIC, className, "engineInit", "(8) Requested operation not supported in this environment for a key in this format.");
                                debug.exception(Debug.TYPE_PUBLIC, className, "engineInit", ike);
                                debug.exit(Debug.TYPE_FINE, className, "engineInit");
                            }
                            throw ike;
                        }
                    }
                    env = System.getProperty("ibm.DES.usehdwr.size");
                    if (env != null) {
                        this.HSize = new Integer(env);
                    }
                    if (this.HSize == -1) {
                        this.useHdwr = 1;
                        if (debug != null) {
                            debug.text(Debug.TYPE_PUBLIC, className, "engineInit", "(11d) Setting useHdwr = 1 (use software)");
                        }
                        this.specifiedKey = null;
                        this.keyToken = null;
                        this.hdwrUtils = null;
                    }
                }
            }
        }
        if (this.jitOptimized) {
            this.keyToken = this.cipherMode == 2 || this.cipherMode == 3 ? this.hdwrUtils.initHdwr("DESede", this.jitCipherModeString, !this.decrypting, key, this.cipher.getIV(), this.unitBytes) : this.hdwrUtils.initHdwr("DESede", this.jitCipherModeString, !this.decrypting, key, this.cipher.getIV());
        }
        if (debug != null) {
            debug.text(Debug.TYPE_PUBLIC, className, "engineInit", "(4) ibm.DES.usehdwr.size set (or defaulted) to " + this.HSize);
            debug.exit(Debug.TYPE_FINE, className, "engineInit2");
        }
    }

    @Override
    protected void engineInit(int opmode, Key key, AlgorithmParameters params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        InvalidKeyException ike;
        IvParameterSpec ivSpec = null;
        if (debug != null) {
            Object[] parms = new Object[]{new Integer(opmode), key, params, random};
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineInit", parms);
        }
        if (key == null) {
            ike = new InvalidKeyException("No key given");
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineInit", "No key given");
                debug.exception(Debug.TYPE_PUBLIC, className, "engineInit", ike);
                debug.exit(Debug.TYPE_FINE, className, "engineInit");
            }
            throw ike;
        }
        this.initRandom = random;
        this.specifiedKey = key;
        this.useHdwr = 0;
        this.keyToken = null;
        this.hdwrUtils = null;
        if (key.getFormat().equalsIgnoreCase("CKDSLabel")) {
            this.isLabel = true;
            this.isToken = false;
        } else if (key.getFormat().equalsIgnoreCase("ICSFToken")) {
            this.isLabel = false;
            this.isToken = true;
        } else {
            this.isLabel = false;
            this.isToken = false;
        }
        if (this.cipherMode != 1 && this.cipherMode != 0 && this.cipherMode != 3 && this.cipherMode != 2 && this.isLabel) {
            ike = new InvalidKeyException("A CKDS label key can only be used with ECB, CFB, OFB or CBC mode.");
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineInit", "A CKDS label key can only be used with ECB, CFB, OFB or CBC mode.");
                debug.exception(Debug.TYPE_PUBLIC, className, "engineInit", ike);
                debug.exit(Debug.TYPE_FINE, className, "engineInit");
            }
            throw ike;
        }
        if (this.cipherMode != 1 && this.isToken) {
            ike = new InvalidKeyException("An ICSF token key can only be used with CBC mode.");
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineInit", "An ICSF token key can only be used with CBC mode.");
                debug.exception(Debug.TYPE_PUBLIC, className, "engineInit", ike);
                debug.exit(Debug.TYPE_FINE, className, "engineInit");
            }
            throw ike;
        }
        if (params != null) {
            try {
                ivSpec = params.getParameterSpec(IvParameterSpec.class);
            }
            catch (InvalidParameterSpecException ipse) {
                InvalidAlgorithmParameterException iape = new InvalidAlgorithmParameterException("Wrong parameter type: IV expected");
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "engineInit", "Wrong parameter type: IV expected");
                    debug.exception(Debug.TYPE_PUBLIC, className, "engineInit", iape);
                    debug.exit(Debug.TYPE_FINE, className, "engineInit");
                }
                throw iape;
            }
        }
        this.engineInit(opmode, key, ivSpec, random);
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "engineInit");
        }
    }

    @Override
    protected byte[] engineUpdate(byte[] input, int inputOffset, int inputLen) {
        byte[] out;
        block6: {
            byte[] output = null;
            out = null;
            if (debug != null) {
                Object[] parms = new Object[]{input, new Integer(inputOffset), new Integer(inputLen)};
                debug.entry(Debug.TYPE_FINE, (Object)className, "engineUpdate", parms);
            }
            try {
                output = new byte[this.engineGetOutputSize(inputLen)];
                int len = this.engineUpdate(input, inputOffset, inputLen, output, 0);
                if (len < output.length) {
                    out = new byte[len];
                    System.arraycopy(output, 0, out, 0, len);
                } else {
                    out = output;
                }
            }
            catch (ShortBufferException e) {
                if (debug == null) break block6;
                debug.exception(Debug.TYPE_PUBLIC, className, "engineUpdate", e);
            }
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineUpdate", out);
        }
        return out;
    }

    @Override
    protected int engineUpdate(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException {
        if (debug != null) {
            Object[] parms = new Object[]{input, new Integer(inputOffset), new Integer(inputLen), output, new Integer(outputOffset)};
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineUpdate", parms);
        }
        int len = this.buffered + inputLen;
        if (this.padding != null && this.decrypting) {
            len -= 8;
        }
        len = len < 0 ? 0 : len;
        len -= len % this.unitBytes;
        if (output == null || output.length - outputOffset < len) {
            ShortBufferException sbe = new ShortBufferException("Output buffer must be (at least) " + len + " bytes long");
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineUpdate", "Output buffer must be (at least) " + len + " bytes long");
                debug.exception(Debug.TYPE_PUBLIC, className, "engineUpdate", sbe);
                debug.exit(Debug.TYPE_FINE, className, "engineUpdate");
            }
            throw sbe;
        }
        if (this.useHdwr == 0 && this.cipherMode == 2 && (!this.cipherModeString.equals("CFB") && HardwareProfile.getIsOfbCfbGcmSupported() || this.cipherModeString.equals("CFB") && HardwareProfile.getIsDESCryptoAssistPresent()) && !this.isToken && this.HSize <= inputLen) {
            this.useHdwr = 2;
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineUpdate", "(11e) Setting useHdwr = 2 (use hardware)");
            }
            this.hdwrUtils = new JCEHdwrUtils();
            try {
                this.keyToken = this.hdwrUtils.initHdwr(this.specifiedKey, this.cipher.getIV());
            }
            catch (Exception ex) {
                RuntimeException rte = new RuntimeException("Unable to create keyToken.", ex);
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "engineUpdate", "Unable to create keyToken.");
                    debug.exception(Debug.TYPE_PUBLIC, className, "engineUpdate", rte);
                    debug.exit(Debug.TYPE_FINE, className, "engineUpdate");
                }
                throw rte;
            }
        }
        if (this.useHdwr == 0 && this.cipherMode == 3 && HardwareProfile.getIsOfbCfbGcmSupported() && !this.isToken && this.HSize <= inputLen) {
            this.useHdwr = 2;
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineUpdate", "(12) Setting useHdwr = 2 (use hardware)");
            }
            this.hdwrUtils = new JCEHdwrUtils();
            try {
                this.keyToken = this.hdwrUtils.initHdwr(this.specifiedKey, this.cipher.getIV());
            }
            catch (Exception ex) {
                RuntimeException rte = new RuntimeException("Unable to create keyToken.", ex);
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "engineUpdate", "Unable to create keyToken.");
                    debug.exception(Debug.TYPE_PUBLIC, className, "engineUpdate", rte);
                    debug.exit(Debug.TYPE_FINE, className, "engineUpdate");
                }
                throw rte;
            }
        }
        if (this.useHdwr == 0) {
            if ((this.cipherMode == 1 || this.cipherMode == 0 && HardwareProfile.getIs3DESCryptoAssistPresent()) && this.HSize <= inputLen || this.isLabel || this.isToken) {
                this.useHdwr = 2;
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "engineUpdate", "(13) Setting useHdwr = 2 (use hardware)");
                }
                this.hdwrUtils = new JCEHdwrUtils();
                try {
                    this.keyToken = this.hdwrUtils.initHdwr(this.specifiedKey, this.cipher.getIV());
                }
                catch (Exception ex) {
                    RuntimeException rte = new RuntimeException("Unable to create keyToken.", ex);
                    if (debug != null) {
                        debug.text(Debug.TYPE_PUBLIC, className, "engineUpdate", "Unable to create keyToken.");
                        debug.exception(Debug.TYPE_PUBLIC, className, "engineUpdate", rte);
                        debug.exit(Debug.TYPE_FINE, className, "engineUpdate");
                    }
                    throw rte;
                }
            } else {
                this.useHdwr = 1;
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "engineUpdate", "(14) Setting useHdwr = 1 (use software)");
                }
                this.specifiedKey = null;
                this.keyToken = null;
                this.hdwrUtils = null;
            }
        }
        if (len > 0) {
            int bufferedConsumed;
            int inputConsumed;
            block42: {
                byte[] in = new byte[len];
                inputConsumed = len - this.buffered;
                bufferedConsumed = this.buffered;
                if (inputConsumed < 0) {
                    inputConsumed = 0;
                    bufferedConsumed = len;
                }
                if (this.buffered != 0) {
                    System.arraycopy(this.buffer, 0, in, 0, bufferedConsumed);
                }
                if (inputConsumed > 0) {
                    System.arraycopy(input, inputOffset, in, bufferedConsumed, inputConsumed);
                }
                try {
                    if (this.useHdwr == 2) {
                        try {
                            if (this.decrypting) {
                                this.hdwrUtils.decrypt(in, 0, len, output, outputOffset, this.keyToken, "DES", this.cipherMode, this.lcfbLen, this.icvMode);
                            } else {
                                this.hdwrUtils.encrypt(in, 0, len, output, outputOffset, this.keyToken, "DES", this.cipherMode, this.lcfbLen, this.icvMode);
                            }
                            if (this.icvMode.equals((Object)ICVSelection.ICV_INITIAL)) {
                                this.icvMode = ICVSelection.ICV_CONTINUE;
                            }
                            if (debug != null) {
                                debug.text(Debug.TYPE_PUBLIC, className, "engineUpdate", "(4) icvMode set (or defaulted) to " + (Object)((Object)this.icvMode));
                            }
                            break block42;
                        }
                        catch (JCECCARuntimeException jcex) {
                            if (debug != null) {
                                debug.exception(Debug.TYPE_PUBLIC, className, "engineUpdate", jcex);
                                debug.exit(Debug.TYPE_FINE, className, "engineUpdate");
                            }
                            throw jcex;
                        }
                    }
                    if (this.decrypting) {
                        this.cipher.decrypt(in, 0, len, output, outputOffset);
                    } else {
                        this.cipher.encrypt(in, 0, len, output, outputOffset);
                    }
                }
                catch (IllegalBlockSizeException e) {
                    if (debug == null) break block42;
                    debug.exception(Debug.TYPE_PUBLIC, className, "engineUpdate", e);
                }
            }
            if (this.unitBytes != 8) {
                this.diffBlocksize = len < this.diffBlocksize ? (this.diffBlocksize -= len) : 8 - (len - this.diffBlocksize) % 8;
            }
            inputLen -= inputConsumed;
            inputOffset += inputConsumed;
            outputOffset += len;
            this.buffered -= bufferedConsumed;
            if (this.buffered > 0) {
                System.arraycopy(this.buffer, bufferedConsumed, this.buffer, 0, this.buffered);
            }
        }
        if (inputLen > 0) {
            System.arraycopy(input, inputOffset, this.buffer, this.buffered, inputLen);
        }
        this.buffered += inputLen;
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineUpdate", len < 0 ? 0 : len);
        }
        return len < 0 ? 0 : len;
    }

    @Override
    protected byte[] engineDoFinal(byte[] input, int inputOffset, int inputLen) throws IllegalBlockSizeException, BadPaddingException {
        byte[] out;
        block7: {
            byte[] output = null;
            out = null;
            if (debug != null) {
                Object[] parms = new Object[]{input, new Integer(inputOffset), new Integer(inputLen)};
                debug.entry(Debug.TYPE_FINE, (Object)className, "engineDoFinal", parms);
            }
            try {
                output = new byte[this.engineGetOutputSize(inputLen)];
                int len = this.engineDoFinal(input, inputOffset, inputLen, output, 0);
                if (len < output.length) {
                    out = new byte[len];
                    if (len != 0) {
                        System.arraycopy(output, 0, out, 0, len);
                    }
                } else {
                    out = output;
                }
            }
            catch (ShortBufferException e) {
                if (debug == null) break block7;
                debug.exception(Debug.TYPE_PUBLIC, className, "engineDoFinal", e);
            }
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineDoFinal", out);
        }
        return out;
    }

    @Override
    protected int engineDoFinal(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws IllegalBlockSizeException, ShortBufferException, BadPaddingException {
        int totalLen;
        int paddedLen = totalLen = this.buffered + inputLen;
        int paddingLen = 0;
        if (debug != null) {
            Object[] parms = new Object[]{input, new Integer(inputOffset), new Integer(inputLen), output, new Integer(outputOffset)};
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineDoFinal", parms);
        }
        if (this.unitBytes != 8) {
            if (totalLen < this.diffBlocksize) {
                this.diffBlocksize -= totalLen;
            } else {
                this.diffBlocksize = 8 - (totalLen - this.diffBlocksize) % 8;
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "engineDoFinal", "diffBlocksize = 8 - ((totalLen - diffBlocksize) % 8) =  " + this.diffBlocksize);
                }
            }
            paddingLen = this.diffBlocksize;
        } else if (this.padding != null) {
            paddingLen = this.padding.padLength(totalLen);
        }
        if (debug != null) {
            debug.text(Debug.TYPE_PUBLIC, className, "engineDoFinal", "blockSize checking  " + this.diffBlocksize + " " + paddingLen + " " + this.decrypting);
        }
        if (this.diffBlocksize > 0 && this.diffBlocksize != 8 && this.padding != null && this.decrypting && this.cipherMode != 2 && this.cipherMode != 3) {
            IllegalBlockSizeException ibse = new IllegalBlockSizeException("Input length must be multiple of 8 when decrypting with padded cipher");
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineDoFinal", "Input length must be multiple of 8 when decrypting with padded cipher");
                debug.exception(Debug.TYPE_PUBLIC, className, "engineDoFinal", ibse);
                debug.exit(Debug.TYPE_FINE, className, "engineDoFinal");
            }
            throw ibse;
        }
        if (!this.decrypting && this.padding != null) {
            paddedLen += paddingLen;
        }
        if (output == null) {
            output = new byte[]{};
        }
        if (!(output.length - outputOffset >= paddedLen || this.decrypting && this.padding != null)) {
            ShortBufferException sbe = new ShortBufferException("Output buffer too short: " + (output.length - outputOffset) + " bytes given, " + paddedLen + " bytes needed");
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineDoFinal", "Output buffer too short: " + (output.length - outputOffset) + " bytes given, " + paddedLen + " bytes needed");
                debug.exception(Debug.TYPE_PUBLIC, className, "engineDoFinal", sbe);
                debug.exit(Debug.TYPE_FINE, className, "engineDoFinal");
            }
            throw sbe;
        }
        if (this.useHdwr == 0 && this.cipherMode == 2) {
            if ((!this.cipherModeString.equals("CFB") && HardwareProfile.getIsOfbCfbGcmSupported() || this.cipherModeString.equals("CFB") && HardwareProfile.getIsDESCryptoAssistPresent()) && !this.isToken && this.HSize <= inputLen) {
                this.useHdwr = 2;
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "engineDoFinal", "(15) Setting useHdwr = 2 (use hardware)");
                }
                this.hdwrUtils = new JCEHdwrUtils();
                try {
                    this.keyToken = this.hdwrUtils.initHdwr(this.specifiedKey, this.cipher.getIV());
                }
                catch (Exception ex) {
                    RuntimeException rte = new RuntimeException("Unable to create keyToken.", ex);
                    if (debug != null) {
                        debug.text(Debug.TYPE_PUBLIC, className, "engineDoFinal", "Unable to create keyToken.");
                        debug.exception(Debug.TYPE_PUBLIC, className, "engineDoFinal", rte);
                        debug.exit(Debug.TYPE_FINE, className, "engineDoFinal");
                    }
                    throw rte;
                }
            } else {
                this.useHdwr = 1;
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "engineDoFinal", "(15a) Setting useHdwr = 1 (use software)");
                }
                this.specifiedKey = null;
                this.keyToken = null;
                this.hdwrUtils = null;
            }
        }
        if (this.useHdwr == 0 && this.cipherMode == 3) {
            if (HardwareProfile.getIsOfbCfbGcmSupported() && !this.isToken && this.HSize <= inputLen) {
                this.useHdwr = 2;
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "engineDoFinal", "(15b) Setting useHdwr = 2 (use hardware)");
                }
                this.hdwrUtils = new JCEHdwrUtils();
                try {
                    this.keyToken = this.hdwrUtils.initHdwr(this.specifiedKey, this.cipher.getIV());
                }
                catch (Exception ex) {
                    RuntimeException rte = new RuntimeException("Unable to create keyToken.", ex);
                    if (debug != null) {
                        debug.text(Debug.TYPE_PUBLIC, className, "engineDoFinal", "Unable to create keyToken.");
                        debug.exception(Debug.TYPE_PUBLIC, className, "engineDoFinal", rte);
                        debug.exit(Debug.TYPE_FINE, className, "engineDoFinal");
                    }
                    throw rte;
                }
            } else {
                this.useHdwr = 1;
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "engineDoFinal", "(15c) Setting useHdwr = 1 (use software)");
                }
                this.specifiedKey = null;
                this.keyToken = null;
                this.hdwrUtils = null;
            }
        }
        if (this.useHdwr == 0) {
            if ((this.cipherMode == 1 || this.cipherMode == 0 && HardwareProfile.getIs3DESCryptoAssistPresent()) && this.HSize <= inputLen || this.isLabel || this.isToken) {
                this.useHdwr = 2;
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "engineDoFinal", "(16) Setting useHdwr = 2 (use hardware)");
                }
                this.hdwrUtils = new JCEHdwrUtils();
                try {
                    this.keyToken = this.hdwrUtils.initHdwr(this.specifiedKey, this.cipher.getIV());
                }
                catch (Exception ex) {
                    RuntimeException rte = new RuntimeException("Unable to create keyToken.", ex);
                    if (debug != null) {
                        debug.text(Debug.TYPE_PUBLIC, className, "engineDoFinal", "Unable to create keyToken.");
                        debug.exception(Debug.TYPE_PUBLIC, className, "engineDoFinal", rte);
                        debug.exit(Debug.TYPE_FINE, className, "engineDoFinal");
                    }
                    throw rte;
                }
            } else {
                this.useHdwr = 1;
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "engineDoFinal", "(17) Setting useHdwr = 1 (use software)");
                }
                this.specifiedKey = null;
                this.keyToken = null;
                this.hdwrUtils = null;
            }
        }
        byte[] outWithPadding = null;
        byte[] finalBuf = null;
        if (this.padding == null || this.decrypting) {
            byte[] out = output;
            int outOffset = outputOffset;
            if (this.padding != null) {
                outWithPadding = new byte[totalLen];
                out = outWithPadding;
                outOffset = 0;
            }
            if (this.buffered == 0 && inputOffset == 0) {
                totalLen = this.finalNoPadding(input, inputOffset, out, outOffset, inputLen);
            } else {
                finalBuf = new byte[totalLen];
                System.arraycopy(this.buffer, 0, finalBuf, 0, this.buffered);
                if (inputLen != 0) {
                    System.arraycopy(input, inputOffset, finalBuf, this.buffered, inputLen);
                }
                totalLen = this.finalNoPadding(finalBuf, 0, out, outOffset, totalLen);
            }
        } else {
            finalBuf = new byte[paddedLen];
            if (this.buffered != 0) {
                System.arraycopy(this.buffer, 0, finalBuf, 0, this.buffered);
            }
            if (inputLen != 0) {
                System.arraycopy(input, inputOffset, finalBuf, this.buffered, inputLen);
            }
            this.padding.padWithLen(finalBuf, totalLen, paddingLen);
            totalLen = this.finalNoPadding(finalBuf, 0, output, outputOffset, paddedLen);
        }
        if (this.decrypting && this.padding != null) {
            int padStart = this.padding.unpad(outWithPadding, 0, totalLen);
            if (padStart < 0) {
                BadPaddingException bpe = new BadPaddingException("Given final block not properly padded");
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "engineDoFinal", "Given final block not properly padded");
                    debug.exception(Debug.TYPE_PUBLIC, className, "engineDoFinal", bpe);
                    debug.exit(Debug.TYPE_FINE, className, "engineDoFinal");
                }
                throw bpe;
            }
            totalLen = padStart;
            if (output.length - outputOffset < totalLen) {
                ShortBufferException sbe = new ShortBufferException("Output buffer too short: " + (output.length - outputOffset) + " bytes given, " + paddedLen + " bytes needed");
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "engineDoFinal", "Output buffer too short: " + (output.length - outputOffset) + " bytes given, " + paddedLen + " bytes needed");
                    debug.exception(Debug.TYPE_PUBLIC, className, "engineDoFinal", sbe);
                    debug.exit(Debug.TYPE_FINE, className, "engineDoFinal");
                }
                throw sbe;
            }
            for (int i = 0; i < totalLen; ++i) {
                output[outputOffset + i] = outWithPadding[i];
            }
        }
        this.buffered = 0;
        this.diffBlocksize = 8;
        if (this.cipherMode != 0) {
            FeedbackCipher fc = (FeedbackCipher)((Object)this.cipher);
            fc.reset();
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineDoFinal", totalLen);
        }
        if (this.hdwrUtils != null) {
            this.icvMode = ICVSelection.ICV_INITIAL;
            if (this.cipherMode == 1) {
                try {
                    this.engineInit(this.decrypting ? 2 : 1, this.specifiedKey, new IvParameterSpec(this.cipher.getIV()), this.initRandom);
                }
                catch (Exception ex) {
                    RuntimeException rte = new RuntimeException("Unable to reinitialize keyToken.", ex);
                    if (debug != null) {
                        debug.text(Debug.TYPE_PUBLIC, className, "engineDoFinal", "Unable to reinitialize keyToken.");
                        debug.exception(Debug.TYPE_PUBLIC, className, "engineDoFinal", rte);
                        debug.exit(Debug.TYPE_FINE, className, "engineDoFinal");
                    }
                    throw rte;
                }
            }
        }
        if (debug != null) {
            debug.text(Debug.TYPE_PUBLIC, className, "engineDoFinal", "(5) icvMode set (or defaulted) to " + (Object)((Object)this.icvMode));
        }
        return totalLen;
    }

    private int finalNoPadding(byte[] in, int inOff, byte[] out, int outOff, int len) throws IllegalBlockSizeException {
        if (debug != null) {
            Object[] parms = new Object[]{in, new Integer(inOff), out, new Integer(outOff), new Integer(len)};
            debug.entry(Debug.TYPE_FINE, (Object)className, "finalNoPadding", parms);
        }
        if (in == null || len == 0) {
            if (debug != null) {
                debug.exit(Debug.TYPE_FINE, (Object)className, "finalNoPadding", 0);
            }
            return 0;
        }
        if (this.cipherMode != 2 && this.cipherMode != 3 && len % this.unitBytes != 0) {
            IllegalBlockSizeException ibse;
            if (this.padding != null) {
                ibse = new IllegalBlockSizeException("Input length (with padding) not multiple of " + this.unitBytes + " bytes");
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "finalNoPadding", "Input length (with padding) not multiple of " + this.unitBytes + " bytes");
                    debug.exception(Debug.TYPE_PUBLIC, className, "finalNoPadding", ibse);
                    debug.exit(Debug.TYPE_FINE, className, "finalNoPadding");
                }
                throw ibse;
            }
            ibse = new IllegalBlockSizeException("Input length not multiple of " + this.unitBytes + " bytes");
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "finalNoPadding", "Input length not multiple of " + this.unitBytes + " bytes");
                debug.exception(Debug.TYPE_PUBLIC, className, "finalNoPadding", ibse);
                debug.exit(Debug.TYPE_FINE, className, "finalNoPadding");
            }
            throw ibse;
        }
        if (this.useHdwr == 2) {
            if ((this.cipherMode == 2 || this.cipherMode == 3) && HardwareProfile.getIsHCR7780OrLaterPresent()) {
                this.icvMode = this.icvMode.equals((Object)ICVSelection.ICV_INITIAL) ? ICVSelection.ICV_ONLY : ICVSelection.ICV_FINAL;
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "finalNoPadding", "(6) icvMode set (or defaulted) to " + (Object)((Object)this.icvMode));
                }
            }
            try {
                if (this.decrypting) {
                    this.hdwrUtils.decrypt(in, inOff, len, out, outOff, this.keyToken, "DES", this.cipherMode, this.lcfbLen, this.icvMode);
                }
                this.hdwrUtils.encrypt(in, inOff, len, out, outOff, this.keyToken, "DES", this.cipherMode, this.lcfbLen, this.icvMode);
            }
            catch (JCECCARuntimeException jcex) {
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, "finalNoPadding", jcex);
                    debug.exit(Debug.TYPE_FINE, className, "finalNoPadding");
                }
                throw jcex;
            }
        } else if (this.decrypting) {
            this.cipher.decrypt(in, inOff, len, out, outOff);
        } else {
            this.cipher.encrypt(in, inOff, len, out, outOff);
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "finalNoPadding", len);
        }
        return len;
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        AlgorithmParameters params = null;
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "engineGetParameters");
        }
        if (this.cipherMode == 0) {
            if (debug != null) {
                debug.exit(Debug.TYPE_FINE, (Object)className, "engineGetParameters", null);
            }
            return null;
        }
        byte[] tiv = this.engineGetIV();
        if (tiv == null) {
            return null;
        }
        IvParameterSpec ivSpec = new IvParameterSpec(tiv);
        String provider = null;
        provider = Security.getProvider("IBMJCECCA") == null ? "IBMJCE4758" : "IBMJCECCA";
        try {
            params = AlgorithmParameters.getInstance("DESede", provider);
        }
        catch (NoSuchAlgorithmException nsae) {
            RuntimeException rte = new RuntimeException(provider + " called, but not configured");
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineGetParameters", provider + " called, but not configured");
                debug.exception(Debug.TYPE_PUBLIC, className, "engineGetParameters", nsae);
                debug.exception(Debug.TYPE_PUBLIC, className, "engineGetParameters", rte);
                debug.exit(Debug.TYPE_FINE, className, "engineGetParameters");
            }
            throw rte;
        }
        catch (NoSuchProviderException nspe) {
            RuntimeException rte = new RuntimeException(provider + " called, but not configured");
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineGetParameters", provider + " called, but not configured");
                debug.exception(Debug.TYPE_PUBLIC, className, "engineGetParameters", nspe);
                debug.exception(Debug.TYPE_PUBLIC, className, "engineGetParameters", rte);
                debug.exit(Debug.TYPE_FINE, className, "engineGetParameters");
            }
            throw rte;
        }
        try {
            params.init(ivSpec);
        }
        catch (InvalidParameterSpecException ipse) {
            RuntimeException rte = new RuntimeException("IvParameterSpec not supported");
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineGetParameters", "IvParameterSpec not supported");
                debug.exception(Debug.TYPE_PUBLIC, className, "engineGetParameters", ipse);
                debug.exception(Debug.TYPE_PUBLIC, className, "engineGetParameters", rte);
                debug.exit(Debug.TYPE_FINE, className, "engineGetParameters");
            }
            throw rte;
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineGetParameters", params);
        }
        return params;
    }

    @Override
    protected int engineGetKeySize(Key key) {
        int keySize;
        block6: {
            keySize = 192;
            if (debug != null) {
                debug.entry(Debug.TYPE_FINE, (Object)className, "engineGetKeySize", key);
            }
            if (key != null && key.getFormat().equals("RAW")) {
                keySize = key.getEncoded().length * 8;
            } else {
                try {
                    keySize = Cipher.getMaxAllowedKeyLength("DESede");
                }
                catch (NoSuchAlgorithmException e) {
                    if (debug == null) break block6;
                    debug.exception(Debug.TYPE_PUBLIC, className, "engineGetKeySize", e);
                }
            }
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineGetKeySize", keySize);
        }
        return keySize;
    }

    @Override
    protected byte[] engineWrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
        byte[] result;
        block14: {
            result = null;
            if (debug != null) {
                debug.entry(Debug.TYPE_FINE, (Object)className, "engineWrap", key);
            }
            if (null == key) {
                InvalidKeyException ike3 = new InvalidKeyException("The key specified to wrap() must not be null.");
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, "engineWrap", ike3);
                }
                throw ike3;
            }
            if (key instanceof PublicKey) {
                InvalidKeyException ike1 = new InvalidKeyException("PublicKey is not a key type supported by wrap() in this cipher.");
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, "engineWrap", ike1);
                }
                throw ike1;
            }
            if (key instanceof PrivateKey) {
                InvalidKeyException ike2 = new InvalidKeyException("PrivateKey is not a key type supported by wrap() in this cipher.");
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, "engineWrap", ike2);
                }
                throw ike2;
            }
            try {
                String keyType = key.getFormat();
                if (!"RAW".equalsIgnoreCase(keyType)) {
                    String ikeMsg = "This cipher can only wrap RAW keys. Specified key is type " + keyType + ".";
                    InvalidKeyException ike = new InvalidKeyException(ikeMsg);
                    if (debug != null) {
                        debug.text(Debug.TYPE_PUBLIC, className, "engineWrap", ikeMsg);
                        debug.exception(Debug.TYPE_PUBLIC, className, "engineWrap", ike);
                        debug.exit(Debug.TYPE_FINE, className, "engineWrap");
                    }
                    throw ike;
                }
                byte[] encodedKey = key.getEncoded();
                if (encodedKey == null || encodedKey.length == 0) {
                    InvalidKeyException ike = new InvalidKeyException("Cannot get an encoding of the key to be wrapped");
                    if (debug != null) {
                        debug.text(Debug.TYPE_PUBLIC, className, "engineWrap", "Cannot get an encoding of the key to be wrapped");
                        debug.exception(Debug.TYPE_PUBLIC, className, "engineWrap", ike);
                        debug.exit(Debug.TYPE_FINE, className, "engineWrap");
                    }
                    throw ike;
                }
                result = this.engineDoFinal(encodedKey, 0, encodedKey.length);
            }
            catch (BadPaddingException e) {
                if (debug == null) break block14;
                debug.exception(Debug.TYPE_PUBLIC, className, "engineWrap", e);
            }
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineWrap", result);
        }
        return result;
    }

    @Override
    protected Key engineUnwrap(byte[] wrappedKey, String wrappedKeyAlgorithm, int wrappedKeyType) throws InvalidKeyException, NoSuchAlgorithmException {
        byte[] encodedKey;
        if (debug != null) {
            Object[] parms = new Object[]{wrappedKey, wrappedKeyAlgorithm, new Integer(wrappedKeyType)};
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineUnwrap", parms);
        }
        SecretKey result = null;
        if (null == wrappedKeyAlgorithm || "".equals(wrappedKeyAlgorithm)) {
            NoSuchAlgorithmException nsae = new NoSuchAlgorithmException("The wrappedKeyAlgorithm name specified to unwrap() must not be null or empty.");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineUnwrap", nsae);
            }
            throw nsae;
        }
        if (null == wrappedKey || 0 == wrappedKey.length) {
            InvalidKeyException ike = new InvalidKeyException("The wrapped key specified to unwrap() must not be null or empty.");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineUnwrap", ike);
            }
            throw ike;
        }
        if (wrappedKeyType == 1) {
            InvalidKeyException ike1 = new InvalidKeyException("PublicKey is not a key type supported by unwrap() in this cipher.");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineUnwrap", ike1);
            }
            throw ike1;
        }
        if (wrappedKeyType == 2) {
            InvalidKeyException ike2 = new InvalidKeyException("PrivateKey is not a key type supported by unwrap() in this cipher.");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineUnwrap", ike2);
            }
            throw ike2;
        }
        if (wrappedKeyType != 3) {
            InvalidKeyException ike3 = new InvalidKeyException("Unrecognized key type specified to unwrap().");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineUnwrap", ike3);
            }
            throw ike3;
        }
        try {
            encodedKey = this.engineDoFinal(wrappedKey, 0, wrappedKey.length);
        }
        catch (BadPaddingException ePadding) {
            InvalidKeyException ike = new InvalidKeyException(ePadding);
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineUnwrap", ePadding);
                debug.exception(Debug.TYPE_PUBLIC, className, "engineUnwrap", ike);
                debug.exit(Debug.TYPE_FINE, className, "engineUnwrap");
            }
            throw ike;
        }
        catch (IllegalBlockSizeException eBlockSize) {
            InvalidKeyException ike = new InvalidKeyException(eBlockSize);
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineUnwrap", eBlockSize);
                debug.exception(Debug.TYPE_PUBLIC, className, "engineUnwrap", ike);
                debug.exit(Debug.TYPE_FINE, className, "engineUnwrap");
            }
            throw ike;
        }
        result = ConstructKeys.constructSecretKey(encodedKey, wrappedKeyAlgorithm);
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineUnwrap", result);
        }
        return result;
    }

    private boolean jitOptimizationAvailable() {
        boolean result = false;
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "jitOptimizationAvailable", "algorithm: DESede   mode: " + this.cipherModeString);
        }
        result = FullHardwareCrypt.isSupportedByHardware("DESede", this.cipherModeString);
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "jitOptimizationAvailable", result);
        }
        return result;
    }
}

