/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.hdwrCCA.provider;

import com.ibm.crypto.hdwrCCA.provider.Debug;
import com.ibm.crypto.hdwrCCA.provider.HexDumpEncoder;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import java.io.IOException;
import java.security.AlgorithmParametersSpi;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.spec.IvParameterSpec;

public final class DESParameters
extends AlgorithmParametersSpi {
    private byte[] iv;
    private static Debug debug = Debug.getInstance("ibmjcecca");
    private static String className = "com.ibm.crypto.hdwrCCA.tools.DESParameters";

    @Override
    protected void engineInit(AlgorithmParameterSpec paramSpec) throws InvalidParameterSpecException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineInit", paramSpec);
        }
        if (!(paramSpec instanceof IvParameterSpec)) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineInit", "Inappropriate parameter specification");
            }
            throw new InvalidParameterSpecException("Inappropriate parameter specification");
        }
        byte[] iv = ((IvParameterSpec)paramSpec).getIV();
        if (iv.length != 8) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineInit", "IV not 8 bytes long");
            }
            throw new InvalidParameterSpecException("IV not 8 bytes long");
        }
        this.iv = (byte[])iv.clone();
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "engineInit");
        }
    }

    @Override
    protected void engineInit(byte[] encoded) throws IOException {
        DerInputStream der = null;
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineInit", (Object)encoded);
        }
        try {
            der = new DerInputStream(encoded);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineInit", e);
            }
            throw new IOException(e.getMessage());
        }
        byte[] tmpIv = der.getOctetString();
        if (der.available() != 0) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineInit", "IV parsing error: extra data");
            }
            throw new IOException("IV parsing error: extra data");
        }
        if (tmpIv.length != 8) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineInit", "IV not 8 bytes long");
            }
            throw new IOException("IV not 8 bytes long");
        }
        this.iv = tmpIv;
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "engineInit");
        }
    }

    @Override
    protected void engineInit(byte[] encoded, String decodingMethod) throws IOException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "engineInit", encoded, decodingMethod);
        }
        this.engineInit(encoded);
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "engineInit");
        }
    }

    protected AlgorithmParameterSpec engineGetParameterSpec(Class paramSpec) throws InvalidParameterSpecException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineGetParameterSpec", paramSpec);
        }
        try {
            Class<?> ivParamSpec = Class.forName("javax.crypto.spec.IvParameterSpec");
            if (ivParamSpec.isAssignableFrom(paramSpec)) {
                if (debug != null) {
                    debug.exit(Debug.TYPE_FINE, (Object)className, "engineGetParameterSpec", new IvParameterSpec(this.iv));
                }
                return new IvParameterSpec(this.iv);
            }
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineGetParameterSpec", "Inappropriate parameter specification");
            }
            throw new InvalidParameterSpecException("Inappropriate parameter specification");
        }
        catch (ClassNotFoundException e) {
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineGetParameterSpec", e);
            }
            throw new InvalidParameterSpecException("Unsupported parameter specification: " + e.getMessage());
        }
    }

    @Override
    protected byte[] engineGetEncoded() throws IOException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "engineGetEncoded");
        }
        DerOutputStream out = new DerOutputStream();
        out.putOctetString(this.iv);
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineGetEncoded", out.toByteArray());
        }
        return out.toByteArray();
    }

    @Override
    protected byte[] engineGetEncoded(String encodingMethod) throws IOException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineGetEncoded", encodingMethod);
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineGetEncoded", this.engineGetEncoded());
        }
        return this.engineGetEncoded();
    }

    @Override
    protected String engineToString() {
        String ivString = "\n    iv:\n[";
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "engineToString");
        }
        HexDumpEncoder encoder = new HexDumpEncoder();
        ivString = ivString + encoder.encodeBuffer(this.iv);
        ivString = ivString + "]\n";
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineToString", ivString);
        }
        return ivString;
    }
}

