/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.hdwrCCA.provider;

import com.ibm.crypto.hdwrCCA.provider.DESKey;
import com.ibm.crypto.hdwrCCA.provider.DESKeySpec;
import com.ibm.crypto.hdwrCCA.provider.Debug;
import com.ibm.crypto.hdwrCCA.provider.IBMJCECCA;
import com.ibm.crypto.hdwrCCA.provider.KeyLabelKeySpec;
import java.security.InvalidKeyException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactorySpi;
import javax.crypto.spec.SecretKeySpec;

public final class DESKeyFactory
extends SecretKeyFactorySpi {
    private static Debug debug = Debug.getInstance("ibmjcecca");
    private static String className = "com.ibm.crypto.hdwrCCA.tools.DESKeyFactory";

    public DESKeyFactory() {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "DESKeyFactory");
        }
        IBMJCECCA.verifyJceJar();
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "DESKeyFactory");
        }
    }

    @Override
    protected SecretKey engineGenerateSecret(KeySpec keySpec) throws InvalidKeySpecException {
        DESKey desKey;
        block12: {
            desKey = null;
            if (debug != null) {
                debug.entry(Debug.TYPE_FINE, (Object)className, "engineGenerateSecret", keySpec);
            }
            if (keySpec == null || !(keySpec instanceof DESKeySpec) && !(keySpec instanceof javax.crypto.spec.DESKeySpec) && !(keySpec instanceof SecretKeySpec) && !(keySpec instanceof KeyLabelKeySpec)) {
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "engineGenerateSecret", "Inappropriate key specification");
                }
                throw new InvalidKeySpecException("Inappropriate key specification");
            }
            try {
                if (keySpec instanceof SecretKeySpec) {
                    SecretKeySpec skeySpec = (SecretKeySpec)keySpec;
                    byte[] keyBytes = skeySpec.getEncoded();
                    javax.crypto.spec.DESKeySpec desKeySpec = new javax.crypto.spec.DESKeySpec(keyBytes);
                    desKey = new DESKey(desKeySpec.getKey());
                } else if (keySpec instanceof KeyLabelKeySpec) {
                    String ckdsLabel = ((KeyLabelKeySpec)keySpec).getLabelString();
                    desKey = DESKey.newLabelKey(ckdsLabel);
                } else if (keySpec instanceof DESKeySpec) {
                    DESKeySpec desKeySpec = (DESKeySpec)keySpec;
                    desKey = new DESKey(desKeySpec.getType(), desKeySpec.getKey());
                } else {
                    javax.crypto.spec.DESKeySpec desKeySpec = (javax.crypto.spec.DESKeySpec)keySpec;
                    desKey = new DESKey(desKeySpec.getKey());
                }
            }
            catch (InvalidKeyException e) {
                if (debug == null) break block12;
                debug.exception(Debug.TYPE_PUBLIC, className, "engineGenerateSecret", e);
            }
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineGenerateSecret", desKey);
        }
        return desKey;
    }

    protected KeySpec engineGetKeySpec(SecretKey key, Class keySpec) throws InvalidKeySpecException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "engineGetKeySpec", key, keySpec);
        }
        try {
            if (key != null && key instanceof SecretKey && key.getAlgorithm().equalsIgnoreCase("DES")) {
                Class<?> desKeySpecCCA = Class.forName("com.ibm.crypto.hdwrCCA.provider.DESKeySpec");
                String keyFormat = key.getFormat();
                if (keySpec != null && desKeySpecCCA.isAssignableFrom(keySpec)) {
                    if ("RAW".equalsIgnoreCase(keyFormat) || "ICSFToken".equalsIgnoreCase(keyFormat) || "CKDSLabel".equalsIgnoreCase(keyFormat)) {
                        if (debug != null) {
                            debug.exit(Debug.TYPE_FINE, className, "engineGetKeySpec");
                        }
                        return new DESKeySpec(key.getEncoded(), keyFormat);
                    }
                    if (debug != null) {
                        debug.text(Debug.TYPE_PUBLIC, className, "engineGetKeySpec", "Inappropriate key format");
                    }
                    throw new InvalidKeySpecException("Inappropriate key format");
                }
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "engineGetKeySpec", "Inappropriate key specification");
                }
                throw new InvalidKeySpecException("Inappropriate key specification");
            }
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineGetKeySpec", "Inappropriate key or algorithm");
            }
            throw new InvalidKeySpecException("Inappropriate key or algorithm");
        }
        catch (InvalidKeyException e) {
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineGetKeySpec", e);
            }
            throw new InvalidKeySpecException("Secret key has wrong size");
        }
        catch (ClassNotFoundException e) {
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineGetKeySpec", e);
            }
            throw new InvalidKeySpecException("Unsupported key specification: " + e.getMessage());
        }
    }

    @Override
    protected SecretKey engineTranslateKey(SecretKey key) throws InvalidKeyException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineTranslateKey", key);
        }
        try {
            if (key != null && key.getAlgorithm().equalsIgnoreCase("DES") && key.getFormat().equalsIgnoreCase("RAW")) {
                if (key instanceof DESKey) {
                    if (debug != null) {
                        debug.exit(Debug.TYPE_FINE, (Object)className, "engineTranslateKey1", key);
                    }
                    return key;
                }
                javax.crypto.spec.DESKeySpec desKeySpec = (javax.crypto.spec.DESKeySpec)this.engineGetKeySpec(key, (Class)javax.crypto.spec.DESKeySpec.class);
                if (debug != null) {
                    debug.exit(Debug.TYPE_FINE, (Object)className, "engineTranslateKey2", this.engineGenerateSecret(desKeySpec));
                }
                return this.engineGenerateSecret(desKeySpec);
            }
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineTranslateKey1", "Inappropriate key format/algorithm");
            }
            throw new InvalidKeyException("Inappropriate key format/algorithm");
        }
        catch (InvalidKeySpecException e) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineTranslateKey1", "Cannot translate key");
            }
            throw new InvalidKeyException("Cannot translate key");
        }
    }
}

