/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.hdwrCCA.provider;

import com.ibm.crypto.hdwrCCA.provider.DESKeyGenerator;
import com.ibm.crypto.hdwrCCA.provider.Debug;
import com.ibm.crypto.hdwrCCA.provider.LabelUtils;
import com.ibm.crypto.hdwrCCA.provider.PlatformUtilities;
import com.ibm.crypto.hdwrCCA.provider.SymmetricKeyUtils;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.security.InvalidKeyException;
import java.util.Arrays;
import javax.crypto.SecretKey;

public class DESKey
implements SecretKey {
    static final long serialVersionUID = 3275551846378258804L;
    private String keyType;
    private byte[] key;
    private byte[] icsfToken;
    private byte[] ckdsLabel;
    private static Debug debug = Debug.getInstance("ibmjcecca");
    private static String className = "com.ibm.crypto.hdwrCCA.provider.DESKey";

    DESKey(byte[] key) throws InvalidKeyException {
        this(key, 0);
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "DESKey", (Object)key);
        }
        this.keyType = "RAW";
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "DESKey");
        }
    }

    DESKey(String keyType, byte[] keyOrTokenOrLabel) throws InvalidKeyException {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "DESKey", keyType, keyOrTokenOrLabel);
        }
        this.keyType = keyType;
        if ("RAW".equals(this.keyType)) {
            int numKeyBytes = 0;
            if (keyOrTokenOrLabel != null) {
                numKeyBytes = keyOrTokenOrLabel.length;
            }
            if (keyOrTokenOrLabel == null || numKeyBytes != 8) {
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "DESKey", "Wrong key size");
                    debug.exit(Debug.TYPE_PUBLIC, className, "DESKey");
                }
                throw new InvalidKeyException("Wrong key size");
            }
            this.icsfToken = null;
            this.ckdsLabel = null;
            this.key = new byte[8];
            DESKeyGenerator.setParityBit(keyOrTokenOrLabel, 0);
            System.arraycopy(keyOrTokenOrLabel, 0, this.key, 0, 8);
        } else if ("ICSFToken".equals(this.keyType)) {
            if (null == keyOrTokenOrLabel || 0 == keyOrTokenOrLabel.length) {
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "DESKey", "Key token must not have zero length.");
                    debug.exit(Debug.TYPE_PUBLIC, className, "DESKey");
                }
                throw new InvalidKeyException("Key token must not have zero length.");
            }
            this.key = null;
            this.icsfToken = (byte[])keyOrTokenOrLabel.clone();
            this.ckdsLabel = null;
        } else if ("CKDSLabel".equals(this.keyType)) {
            if (null == keyOrTokenOrLabel || 0 == keyOrTokenOrLabel.length) {
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "DESKey", "Key label must not have zero length.");
                    debug.exit(Debug.TYPE_PUBLIC, className, "DESKey");
                }
                throw new InvalidKeyException("Key label must not have zero length.");
            }
            this.key = null;
            this.icsfToken = null;
            this.ckdsLabel = LabelUtils.padLabel(keyOrTokenOrLabel, PlatformUtilities.CHARSET_IBM_1047);
        } else {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "DESKey", "Key type must be RAW, ICSFToken, or CKDSLabel.");
                debug.exit(Debug.TYPE_PUBLIC, className, "DESKey");
            }
            throw new InvalidKeyException("Key type must be RAW, ICSFToken, or CKDSLabel.");
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "DESKey");
        }
    }

    DESKey(byte[] key, int offset) throws InvalidKeyException {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "DESKey", key, new Integer(offset));
        }
        if (key == null || key.length - offset < 8) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "DESKey", "Wrong key size");
                debug.exit(Debug.TYPE_PUBLIC, className, "DESKey");
            }
            throw new InvalidKeyException("Wrong key size");
        }
        this.key = new byte[8];
        DESKeyGenerator.setParityBit(key, offset);
        System.arraycopy(key, offset, this.key, 0, 8);
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "DESKey");
        }
    }

    static DESKey newLabelKey(String label) throws InvalidKeyException {
        return new DESKey("CKDSLabel", label.getBytes(PlatformUtilities.CHARSET_IBM_1047));
    }

    @Override
    public byte[] getEncoded() {
        byte[] returnValue = null;
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "getEncoded");
        }
        if ("RAW".equals(this.keyType)) {
            returnValue = (byte[])this.key.clone();
        } else if ("ICSFToken".equals(this.keyType)) {
            try {
                returnValue = this.getToken();
            }
            catch (Exception ex) {
                returnValue = null;
            }
        } else if ("CKDSLabel".equals(this.keyType)) {
            try {
                returnValue = this.getLabel();
            }
            catch (Exception ex) {
                returnValue = null;
            }
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getEncoded", returnValue);
        }
        return returnValue;
    }

    public byte[] getToken() throws InvalidKeyException {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "getToken");
        }
        if ("ICSFToken".equals(this.keyType)) {
            if (debug != null) {
                debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getToken", (byte[])this.icsfToken.clone());
            }
        } else {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "getToken", "Only an ICSFToken key has an ICSF token.");
                debug.exit(Debug.TYPE_PUBLIC, className, "getToken");
            }
            throw new InvalidKeyException("Only an ICSFToken key has an ICSF token.");
        }
        return (byte[])this.icsfToken.clone();
    }

    public byte[] getLabel() throws InvalidKeyException {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "getLabel");
        }
        if ("CKDSLabel".equals(this.keyType)) {
            if (debug != null) {
                debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getLabel", (byte[])this.ckdsLabel.clone());
            }
        } else {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "getLabel", "Only a CKDSLabel key has a CKDS label.");
                debug.exit(Debug.TYPE_PUBLIC, className, "getLabel");
            }
            throw new InvalidKeyException("Only a CKDSLabel key has a CKDS label.");
        }
        return (byte[])this.ckdsLabel.clone();
    }

    public String getLabelString() throws InvalidKeyException {
        if (!"CKDSLabel".equals(this.keyType)) {
            InvalidKeyException ike = new InvalidKeyException("Only a CKDSLabel key has a CKDS label.");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "getLabelString", ike);
                debug.exit(Debug.TYPE_PUBLIC, className, "getLabelString");
            }
            throw ike;
        }
        String returnLabel = new String(this.ckdsLabel, PlatformUtilities.CHARSET_IBM_1047);
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getLabelString", returnLabel);
        }
        return returnLabel;
    }

    @Override
    public String getAlgorithm() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "getAlgorithm");
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getAlgorithm", "DES");
        }
        return "DES";
    }

    @Override
    public String getFormat() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "getFormat");
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getFormat", this.keyType);
        }
        return this.keyType;
    }

    public void deleteCKDSEntry() throws InvalidKeyException {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "deleteCKDSEntry");
        }
        SymmetricKeyUtils.deleteCKDSEntry(this);
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "deleteCKDSEntry");
        }
    }

    public int hashCode() {
        int retval = 0;
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "hashCode");
        }
        byte[] keyData = this.getEncoded();
        for (int i = 1; i < keyData.length; ++i) {
            retval += keyData[i] * i;
        }
        retval ^= "des".hashCode();
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "hashCode", retval);
        }
        return retval;
    }

    public boolean equals(Object obj) {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "equals", obj);
        }
        if (this == obj) {
            if (debug != null) {
                debug.exit(Debug.TYPE_PUBLIC, (Object)className, "equals1", true);
            }
            return true;
        }
        if (!(obj instanceof DESKey)) {
            if (debug != null) {
                debug.exit(Debug.TYPE_PUBLIC, (Object)className, "equals2", false);
            }
            return false;
        }
        String thatAlg = ((DESKey)obj).getAlgorithm();
        if (!thatAlg.equalsIgnoreCase("DES")) {
            if (debug != null) {
                debug.exit(Debug.TYPE_PUBLIC, (Object)className, "equals3", false);
            }
            return false;
        }
        String thatKeyType = ((DESKey)obj).getFormat();
        if (!thatKeyType.equals(this.keyType)) {
            if (debug != null) {
                debug.exit(Debug.TYPE_PUBLIC, (Object)className, "equals5", false);
            }
            return false;
        }
        byte[] thiskeyData = null;
        byte[] thatkeyData = null;
        try {
            thiskeyData = this.getEncoded();
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "equals6", e);
                debug.exit(Debug.TYPE_PUBLIC, (Object)className, "equals6", false);
            }
            return false;
        }
        try {
            thatkeyData = ((DESKey)obj).getEncoded();
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "equals7", e);
                debug.exit(Debug.TYPE_PUBLIC, (Object)className, "equals7", false);
            }
            return false;
        }
        boolean ret = Arrays.equals(thiskeyData, thatkeyData);
        Arrays.fill(thatkeyData, (byte)0);
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "equals8", ret);
        }
        return ret;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "readObject", s);
        }
        s.defaultReadObject();
        if ("RAW".equals(this.keyType)) {
            this.key = (byte[])this.key.clone();
            this.icsfToken = null;
            this.ckdsLabel = null;
        } else if ("ICSFToken".equals(this.keyType)) {
            this.key = null;
            this.icsfToken = (byte[])this.icsfToken.clone();
            this.ckdsLabel = null;
        } else if ("CKDSLabel".equals(this.keyType)) {
            this.key = null;
            this.icsfToken = null;
            this.ckdsLabel = (byte[])this.ckdsLabel.clone();
        }
        if (debug != null) {
            debug.exit(8192L, className, "readObject");
        }
    }

    protected void finalize() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "finalize");
        }
        if (this.key != null) {
            Arrays.fill(this.key, (byte)0);
            this.key = null;
        } else if (null != this.icsfToken) {
            Arrays.fill(this.icsfToken, (byte)0);
            this.icsfToken = null;
        } else if (null != this.ckdsLabel) {
            Arrays.fill(this.ckdsLabel, (byte)0);
            this.ckdsLabel = null;
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "finalize");
        }
    }
}

