/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.hdwrCCA.provider;

import com.ibm.crypto.hdwrCCA.provider.Debug;
import com.ibm.crypto.hdwrCCA.provider.JCECCARuntimeException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;

class CustomCertPathBuilder {
    private boolean trustcacerts = true;
    private KeyStore caks = null;
    private String providerName = null;
    private ArrayList certPath = null;
    private Certificate trustAnchor;
    private static Debug debug = Debug.getInstance("ibmjceracf");
    private static String className = "com.ibm.crypto.hdwrCCA.provider.CustomCertpathBuilder";
    private boolean certTrustChainCheck = true;

    CustomCertPathBuilder() throws IOException {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "CustomCertPathBuilder");
        }
        String trustChainCheck = System.getProperty("ibm.hw.racfkeystore.trustchaincheck");
        if (debug != null) {
            debug.text(Debug.TYPE_PUBLIC, className, "CustomCertPathBuilder", "ibm.hw.racfkeystore.trustchaincheck=[" + trustChainCheck + "]");
        }
        if (trustChainCheck != null && trustChainCheck.equalsIgnoreCase("false")) {
            this.certTrustChainCheck = false;
        }
        this.certPath = new ArrayList();
        try {
            this.caks = this.getCacertsKeyStore();
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "CustomCertPathBuilder", e);
            }
            throw new IOException(e.getMessage());
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "CustomCertPathBuilder");
        }
    }

    private boolean buildChain(X509Certificate certToVerify, Vector chain, Hashtable certs) {
        Principal issuer;
        Principal subject;
        if (debug != null) {
            Object[] parms = new Object[]{certToVerify, chain, certs};
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "buildChain", parms);
        }
        if ((subject = certToVerify.getSubjectDN()).equals(issuer = certToVerify.getIssuerDN())) {
            chain.addElement(certToVerify);
            if (debug != null) {
                debug.exit(Debug.TYPE_PUBLIC, className, "buildChain 1 true");
            }
            return true;
        }
        Vector vec = (Vector)certs.get(issuer);
        if (vec == null) {
            if (debug != null) {
                debug.exit(Debug.TYPE_PUBLIC, className, "buildChain 2 false");
            }
            return false;
        }
        Enumeration issuerCerts = vec.elements();
        while (issuerCerts.hasMoreElements()) {
            X509Certificate issuerCert = (X509Certificate)issuerCerts.nextElement();
            PublicKey issuerPubKey = issuerCert.getPublicKey();
            try {
                certToVerify.verify(issuerPubKey);
            }
            catch (Exception e) {
                continue;
            }
            if (!this.buildChain(issuerCert, chain, certs)) continue;
            chain.addElement(certToVerify);
            if (debug != null) {
                debug.exit(Debug.TYPE_PUBLIC, className, "buildChain 3 true");
            }
            return true;
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "buildChain 4 false");
        }
        return false;
    }

    protected void build(X509Certificate cert, ArrayList certs) throws Exception {
        if (debug != null) {
            Object[] parms = new Object[]{cert, certs};
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "build", parms);
        }
        this.certPath.clear();
        certs.trimToSize();
        Certificate[] chain = new Certificate[certs.size()];
        for (int i = 0; i < certs.size(); ++i) {
            chain[i] = (Certificate)certs.get(i);
        }
        if (certs.isEmpty()) {
            throw new InvalidAlgorithmParameterException("Invalid");
        }
        if (this.certTrustChainCheck && certs.size() == 1 && chain[0].equals(cert) && !this.isSelfSigned(cert)) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "build", "certs.size()=" + certs.size() + " selfSigned=" + this.isSelfSigned(cert));
            }
            throw new InvalidAlgorithmParameterException("Invalid, complete trust chain is not possible");
        }
        this.build(cert, chain);
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "build");
        }
    }

    private void build(X509Certificate certToVerify, Certificate[] certs) throws Exception {
        if (debug != null) {
            Object[] parms = new Object[]{certToVerify, certs};
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "build", parms);
        }
        Hashtable hash = new Hashtable();
        for (int i = 0; i < certs.length; ++i) {
            Principal subjectDN = ((X509Certificate)certs[i]).getSubjectDN();
            Vector<Certificate> vec = (Vector<Certificate>)hash.get(subjectDN);
            if (vec == null) {
                vec = new Vector<Certificate>();
                vec.addElement(certs[i]);
            } else if (!vec.contains(certs[i])) {
                vec.addElement(certs[i]);
            }
            hash.put(subjectDN, vec);
        }
        Certificate[] chain = null;
        Vector orderedChain = new Vector();
        Principal subject = certToVerify.getSubjectDN();
        if (this.buildChain(certToVerify, orderedChain, hash)) {
            int j = 0;
            chain = new Certificate[orderedChain.size()];
            for (int l = orderedChain.size() - 1; l >= 0; --l) {
                chain[j] = (Certificate)orderedChain.elementAt(l);
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "build", "chain entry " + j + " is " + ((X509Certificate)chain[j]).getSubjectDN());
                }
                ++j;
            }
        } else {
            throw new CertificateException("Failed to establish chain from the given certificates");
        }
        for (int i = 0; i < chain.length - 1; ++i) {
            PublicKey pubKey = chain[i + 1].getPublicKey();
            try {
                chain[i].verify(pubKey);
                continue;
            }
            catch (Exception e) {
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, "build", e);
                }
                throw new CertificateException("Certificate chain does not verify: " + e.getMessage());
            }
        }
        Certificate topCert = chain[chain.length - 1];
        if (!this.isTrusted(topCert)) {
            boolean verified = false;
            Certificate rootCert = null;
            if (this.trustcacerts && this.caks != null) {
                Enumeration<String> aliases = this.caks.aliases();
                while (aliases.hasMoreElements()) {
                    String name = aliases.nextElement();
                    rootCert = this.caks.getCertificate(name);
                    if (rootCert == null) continue;
                    try {
                        topCert.verify(rootCert.getPublicKey());
                        verified = true;
                        break;
                    }
                    catch (JCECCARuntimeException ignoredCcaException) {
                        if (debug == null) continue;
                        int returnCode = ignoredCcaException.getReturnCode();
                        int reasonCode = ignoredCcaException.getReasonCode();
                        StringBuilder debugMsg = new StringBuilder();
                        debugMsg.append("Certificate was not verified. ");
                        if (returnCode == 8 && reasonCode == 11000) {
                            debugMsg.append("The following exception can be ignored: ");
                        } else if (returnCode == 8 && reasonCode == 72) {
                            debugMsg.append("The value specified for length parameter is not valid: ");
                        } else if (returnCode == 8 && reasonCode == 11008) {
                            debugMsg.append("The public or private key values are not valid and the key cannot be used to verify the certificate. Re-create the key and retry: ");
                        }
                        debugMsg.append(ignoredCcaException.getMessage());
                        debug.text(Debug.TYPE_PUBLIC, className, "build", debugMsg.toString());
                    }
                    catch (Exception ignoredException) {
                        if (debug == null) continue;
                        StringBuilder debugMsg = new StringBuilder();
                        debugMsg.append("Certificate was not verified. ");
                        debugMsg.append(ignoredException.getClass().getName() + ": ");
                        debugMsg.append(ignoredException.getMessage());
                        debug.text(Debug.TYPE_PUBLIC, className, "build", debugMsg.toString());
                    }
                }
            }
            if (verified) {
                Certificate[] tmpCerts = new Certificate[chain.length + 1];
                System.arraycopy(chain, 0, tmpCerts, 0, chain.length);
                tmpCerts[tmpCerts.length - 1] = rootCert;
                chain = tmpCerts;
                this.trustAnchor = rootCert;
            }
            if (!verified && this.isSelfSigned((X509Certificate)topCert)) {
                this.trustAnchor = topCert;
            }
            if (!verified && !this.isSelfSigned((X509Certificate)topCert)) {
                throw new CertificateException("Certificate chain does not verify");
            }
        } else {
            this.trustAnchor = topCert;
        }
        this.certPath = new ArrayList();
        for (int i = 0; i < chain.length - 1; ++i) {
            this.certPath.add(chain[i]);
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "build");
        }
    }

    protected List getCertificates() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "getCertificates");
        }
        if (this.certPath != null) {
            if (debug != null) {
                debug.exit(Debug.TYPE_PUBLIC, className, "getCertificates");
            }
            return this.certPath;
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "getCertificates");
        }
        return null;
    }

    protected Certificate getTrustedCert() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "getTrustedCert");
        }
        X509Certificate testCert = (X509Certificate)this.trustAnchor;
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "getTrustedCert");
        }
        return this.trustAnchor;
    }

    private boolean isTrusted(Certificate cert) throws Exception {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "isTrusted", cert);
        }
        if (this.trustcacerts && this.caks != null && this.caks.getCertificateAlias(cert) != null) {
            if (debug != null) {
                debug.exit(Debug.TYPE_PUBLIC, className, "isTrusted");
            }
            return true;
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "isTrusted");
        }
        return false;
    }

    private boolean isSelfSigned(X509Certificate cert) {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "isSelfSigned", cert);
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "isSelfSigned");
        }
        return cert.getSubjectDN().equals(cert.getIssuerDN());
    }

    private KeyStore getCacertsKeyStore() throws Exception {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "getCacertsKeyStore");
        }
        String sep = File.separator;
        File file = new File(System.getProperty("java.home") + sep + "lib" + sep + "security" + sep + "cacerts");
        if (!file.exists()) {
            return null;
        }
        FileInputStream fis = new FileInputStream(file);
        KeyStore caks = null;
        try {
            caks = KeyStore.getInstance("jks");
        }
        catch (KeyStoreException e) {
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "getCacertsKeyStore", e);
            }
            caks = KeyStore.getInstance("jks");
        }
        caks.load(fis, null);
        fis.close();
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "getCacertsKeyStore");
        }
        return caks;
    }
}

