/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.hdwrCCA.provider;

import com.ibm.crypto.hdwrCCA.provider.Debug;
import com.ibm.crypto.hdwrCCA.provider.HIKM;
import com.ibm.crypto.hdwrCCA.provider.HardwareProfile;
import com.ibm.crypto.hdwrCCA.provider.HexDumpEncoder;
import com.ibm.crypto.hdwrCCA.provider.JCECCARuntimeException;
import com.ibm.crypto.hdwrCCA.provider.PlatformUtilities;
import com.ibm.crypto.hdwrCCA.provider.hikmNativeInteger;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.x509.AlgorithmId;
import java.io.IOException;
import java.math.BigInteger;
import java.security.SignatureException;

final class Crypto {
    private hikmNativeInteger returnCode = new hikmNativeInteger(0);
    private hikmNativeInteger reasonCode = new hikmNativeInteger(0);
    private byte[] exitData = new byte[4];
    private hikmNativeInteger exitDataLength = new hikmNativeInteger(0);
    private hikmNativeInteger signatureBitLength = new hikmNativeInteger(0);
    private hikmNativeInteger signatureFieldLength;
    private byte[] signatureField;
    private boolean longBuffers = false;
    private int maxSignatureLength = 256;
    private final int MAX_DIGEST_LENGTH = 64;
    private final int RSAPSS_SALT_BYTES_LENGTH = 4;
    private static Debug debug = Debug.getInstance("ibmjcecca");
    private static String className = "com.ibm.crypto.hdwrCCA.provider.Crypto";
    private static HexDumpEncoder encoder = debug != null ? new HexDumpEncoder() : null;

    public Crypto() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "Crypto");
        }
        this.longBuffers = HardwareProfile.getIs4096RNGLSupported();
        if (this.longBuffers) {
            this.maxSignatureLength = 512;
        }
        if (debug != null) {
            String info = new String(HardwareProfile.getICSFlevel() + ": 4096RNGLSupported = " + this.longBuffers);
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "Crypto", info);
        }
    }

    private boolean processVerify(byte[] key, byte[] data, int off, int len, byte[] sig, int sigOff, int sigLen, Algorithm algorithm) {
        String exitDataString;
        byte[] ruleArray;
        hikmNativeInteger ruleArrayCount;
        if (debug != null) {
            Object[] parms = new Object[]{key, data, new Integer(off), new Integer(len), sig, new Integer(sigOff), new Integer(sigLen), algorithm};
            debug.entry(8192L, (Object)className, "processVerify", parms);
        }
        if (debug != null) {
            debug.text(8192L, className, "processVerify", "key.length = " + key.length);
            debug.text(8192L, className, "processVerify", "key " + encoder.encodeBuffer(key));
        }
        HIKM hikm = new HIKM();
        hikmNativeInteger keyLength = new hikmNativeInteger(key.length);
        hikmNativeInteger hashLength = new hikmNativeInteger(len);
        byte[] hash = new byte[len];
        System.arraycopy(data, off, hash, 0, hashLength.getValue());
        if (algorithm == Algorithm.DSA) {
            if (debug != null) {
                debug.text(8192L, className, "processVerify", "verify.DSA");
            }
            ruleArrayCount = new hikmNativeInteger(0);
            ruleArray = new byte[]{};
        } else if (algorithm == Algorithm.RSA) {
            if (debug != null) {
                debug.text(8192L, className, "processVerify", "verify.RSA");
            }
            ruleArrayCount = new hikmNativeInteger(1);
            ruleArray = PlatformUtilities.getBytesPlatform("PKCS-1.1");
        } else if (algorithm == Algorithm.RSAPSS) {
            ruleArrayCount = new hikmNativeInteger(4);
            ruleArray = PlatformUtilities.getBytesPlatform(this.getRsaPssRuleString(len));
        } else {
            if (debug != null) {
                debug.text(8192L, className, "processVerify", "verify.ECDSA");
            }
            ruleArrayCount = new hikmNativeInteger(1);
            ruleArray = PlatformUtilities.getBytesPlatform("ECDSA   ");
        }
        this.signatureFieldLength = new hikmNativeInteger(sigLen);
        this.signatureField = new byte[this.signatureFieldLength.getValue()];
        System.arraycopy(sig, sigOff, this.signatureField, 0, this.signatureFieldLength.getValue());
        if (PlatformUtilities.isZOS()) {
            key = PlatformUtilities.convertBytesIfKeyLabelATOE(key);
        }
        if (null != debug) {
            exitDataString = "\n" + encoder.encodeBuffer(this.exitData);
            String ruleArrayString = "\n" + encoder.encodeBuffer(ruleArray);
            String keyString = "\n" + encoder.encodeBuffer(key);
            String hashString = "XXX";
            String sigString = "\n" + encoder.encodeBuffer(this.signatureField);
            String parmsReport = "\nJCEHdwrUtils: CSNDDSV INPUT PARAMETERS \n    returnCode  : " + this.returnCode.getValue() + "\n    reasonCode  : " + this.reasonCode.getValue() + "\n    exitDataLen : " + this.exitDataLength.getValue() + "\n    exitData    : " + exitDataString + "\n    ruleArrayCount: " + ruleArrayCount.getValue() + "\n    ruleArray     : " + ruleArrayString + "\n    keyLength   : " + keyLength.getValue() + "\n    key         : " + keyString + "\n    hashLength  : " + hashLength.getValue() + "\n    hash        : " + hashString + "\n    signatureLen: " + this.signatureFieldLength.getValue() + "\n    signature   : " + sigString + "\n";
            debug.text(Debug.TYPE_FINEST, className, "processVerify", parmsReport);
        }
        try {
            hikm.CSNDDSVJ(this.returnCode, this.reasonCode, this.exitDataLength, this.exitData, ruleArrayCount, ruleArray, keyLength, key, hashLength, hash, this.signatureFieldLength, this.signatureField);
        }
        catch (IllegalArgumentException e) {
            if (debug != null) {
                debug.exception(8192L, className, "processVerify", e);
            }
            throw new RuntimeException("Hardware error from call CSNDDSV " + e);
        }
        if (debug != null) {
            debug.text(Debug.TYPE_FINE, className, "processVerify", "CSNDDSV: return code = " + this.returnCode.getValue() + " reason code = " + this.reasonCode.getValue());
        }
        if (null != debug) {
            exitDataString = "\n" + encoder.encodeBuffer(this.exitData);
            String parmsReport = "\nJCEHdwrUtils: CSNDDSV RETURN PARAMETERS \n    returnCode  : " + this.returnCode.getValue() + "\n    reasonCode  : " + this.reasonCode.getValue() + "\n    exitDataLen : " + this.exitDataLength.getValue() + "\n    exitData    : " + exitDataString + "\n";
            debug.text(Debug.TYPE_FINEST, className, "processVerify", parmsReport);
        }
        if (this.returnCode.getValue() == 4 && (this.reasonCode.getValue() == 11000 || this.reasonCode.getValue() == 429)) {
            if (debug != null) {
                debug.exit(8192L, (Object)className, "processVerify1", false);
            }
            return false;
        }
        if (this.returnCode.getValue() != 0) {
            if (debug != null) {
                debug.text(8192L, className, "processVerify", "Hardware error from call CSNDDSV returnCode=" + this.returnCode.getValue() + ", reasonCode=" + this.reasonCode.getValue());
            }
            throw new JCECCARuntimeException(1, "CSNDDSV", "Hardware error from call CSNDDSV returnCode " + this.returnCode.getValue() + " reasonCode " + this.reasonCode.getValue(), this.returnCode.getValue(), this.reasonCode.getValue());
        }
        if (debug != null) {
            debug.exit(8192L, (Object)className, "processVerify2", new Boolean(true));
        }
        return true;
    }

    private byte[] processSign(byte[] key, byte[] data, int off, int len, Algorithm algorithm) {
        String exitDataString;
        byte[] ruleArray;
        hikmNativeInteger ruleArrayCount;
        if (debug != null) {
            Object[] parms = new Object[]{key, data, new Integer(off), new Integer(len), algorithm};
            debug.entry(8192L, (Object)className, "processSign", parms);
        }
        if (debug != null) {
            debug.text(8192L, className, "processSign", "key.length = " + key.length);
            debug.text(8192L, className, "processSign", "key " + encoder.encodeBuffer(key));
        }
        HIKM hikm = new HIKM();
        hikmNativeInteger keyLength = new hikmNativeInteger(key.length);
        hikmNativeInteger hashLength = new hikmNativeInteger(len);
        byte[] hash = new byte[len];
        byte[] keyCopy = new byte[keyLength.getValue()];
        System.arraycopy(key, 0, keyCopy, 0, keyLength.getValue());
        if (PlatformUtilities.isZOS()) {
            keyCopy = PlatformUtilities.convertBytesIfKeyLabelATOE(keyCopy);
        }
        System.arraycopy(data, off, hash, 0, hashLength.getValue());
        if (algorithm == Algorithm.DSA) {
            ruleArrayCount = new hikmNativeInteger(0);
            ruleArray = new byte[]{};
        } else if (algorithm == Algorithm.RSA) {
            ruleArrayCount = new hikmNativeInteger(1);
            ruleArray = PlatformUtilities.getBytesPlatform("PKCS-1.1");
        } else if (algorithm == Algorithm.RSAPSS) {
            ruleArrayCount = new hikmNativeInteger(4);
            ruleArray = PlatformUtilities.getBytesPlatform(this.getRsaPssRuleString(len));
        } else {
            ruleArrayCount = new hikmNativeInteger(1);
            ruleArray = PlatformUtilities.getBytesPlatform("ECDSA   ");
        }
        if (debug != null) {
            debug.text(8192L, className, "processSign", "hikm");
        }
        this.signatureFieldLength = new hikmNativeInteger(this.maxSignatureLength);
        this.signatureField = new byte[this.maxSignatureLength];
        if (null != debug) {
            exitDataString = "\n" + encoder.encodeBuffer(this.exitData);
            String ruleArrayString = "\n" + encoder.encodeBuffer(ruleArray);
            String keyString = "\n" + encoder.encodeBuffer(keyCopy);
            String hashString = "XXX";
            String parmsReport = "\nJCEHdwrUtils: CSNDDSGJ INPUT PARAMETERS \n    returnCode  : " + this.returnCode.getValue() + "\n    reasonCode  : " + this.reasonCode.getValue() + "\n    exitDataLen : " + this.exitDataLength.getValue() + "\n    exitData    : " + exitDataString + "\n    ruleArrayCount: " + ruleArrayCount.getValue() + "\n    ruleArray     : " + ruleArrayString + "\n    keyLength   : " + keyLength.getValue() + "\n    key         : " + keyString + "\n    hashLength  : " + hashLength.getValue() + "\n    hash        : " + hashString + "\n    sigFieldLen : " + this.signatureFieldLength.getValue() + "\n";
            debug.text(Debug.TYPE_FINEST, className, "processSign", parmsReport);
        }
        try {
            hikm.CSNDDSGJ(this.returnCode, this.reasonCode, this.exitDataLength, this.exitData, ruleArrayCount, ruleArray, keyLength, keyCopy, hashLength, hash, this.signatureFieldLength, this.signatureBitLength, this.signatureField);
        }
        catch (IllegalArgumentException e) {
            if (debug != null) {
                debug.exception(8192L, className, "processSign", e);
            }
            throw new RuntimeException("Hardware error from call CSNDDSG " + e);
        }
        if (debug != null) {
            debug.text(Debug.TYPE_FINE, className, "processSign", "CSNDDSG: return code = " + this.returnCode.getValue() + " reason code = " + this.reasonCode.getValue());
        }
        if (null != debug) {
            exitDataString = "\n" + encoder.encodeBuffer(this.exitData);
            String sigString = "\n" + encoder.encodeBuffer(this.signatureField);
            String parmsReport = "\nJCEHdwrUtils: CSNDDSGJ RETURN PARAMETERS \n    returnCode  : " + this.returnCode.getValue() + "\n    reasonCode  : " + this.reasonCode.getValue() + "\n    exitDataLen : " + this.exitDataLength.getValue() + "\n    exitData    : " + exitDataString + "\n    sigFieldLen : " + this.signatureFieldLength.getValue() + "\n    sigBitLen   : " + this.signatureBitLength.getValue() + "\n    signature   : " + sigString + "\n";
            debug.text(Debug.TYPE_FINEST, className, "processSign", parmsReport);
        }
        if (this.returnCode.getValue() != 0) {
            if (debug != null) {
                debug.text(8192L, className, "processSign", "CSNDDSG returnCode=" + this.returnCode.getValue() + ", reasonCode=" + this.reasonCode.getValue());
            }
            throw new JCECCARuntimeException(1, "CSNDDSG", "Hardware error from call CSNDDSG returnCode " + this.returnCode.getValue() + " reasonCode " + this.reasonCode.getValue(), this.returnCode.getValue(), this.reasonCode.getValue());
        }
        if (debug != null) {
            debug.text(8192L, className, "processSign", "signatureFieldLength = " + this.signatureFieldLength.getValue());
            debug.text(8192L, className, "processSign", "signatureField = " + this.signatureField);
        }
        byte[] tmp = new byte[this.signatureFieldLength.getValue()];
        System.arraycopy(this.signatureField, 0, tmp, 0, tmp.length);
        if (debug != null) {
            debug.exit(8192L, (Object)className, "processSign", tmp);
        }
        return tmp;
    }

    byte[] sign(byte[] key, byte[] data, int off, int len, Algorithm algorithm, boolean hash, String id) throws SignatureException {
        if (debug != null) {
            Object[] parms = new Object[]{key, data, new Integer(off), new Integer(len), algorithm, new Boolean(hash), id};
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "sign", parms);
        }
        int digestLen = 0;
        if (hash) {
            if (len > 64) {
                if (algorithm != Algorithm.RSAPSS || len - 4 > 64) {
                    digestLen = 64;
                    if (debug != null) {
                        debug.text(Debug.TYPE_PUBLIC, className, "sign", "Digest length greater than maximum supported digest length, len = " + len + ", MAX_DIGEST_LENGTH = " + 64);
                    }
                }
            } else {
                digestLen = len;
            }
        }
        if (algorithm == Algorithm.DSA) {
            byte[] temp = new byte[20];
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "sign", "sign.DSA");
            }
            byte[] sig = this.processSign(key, data, 0, data.length, algorithm);
            try {
                DerOutputStream out = new DerOutputStream(100);
                System.arraycopy(sig, 0, temp, 0, temp.length);
                BigInteger tempInt = new BigInteger(1, temp);
                out.putInteger(tempInt);
                System.arraycopy(sig, 20, temp, 0, temp.length);
                tempInt = new BigInteger(1, temp);
                out.putInteger(tempInt);
                DerValue result = new DerValue(48, out.toByteArray());
                if (debug != null) {
                    debug.exit(Debug.TYPE_PUBLIC, (Object)className, "sign1", result.toByteArray());
                }
                return result.toByteArray();
            }
            catch (IOException e) {
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, "sign", e);
                }
                throw new SignatureException("Error encoding signature");
            }
        }
        if (algorithm == Algorithm.RSA) {
            byte[] signData = null;
            int signDataLen = 0;
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "sign", "sign.RSA");
            }
            if (hash) {
                byte[] dt = new byte[digestLen];
                System.arraycopy(data, off, dt, 0, digestLen);
                try {
                    AlgorithmId algid = AlgorithmId.get((String)id);
                    DerOutputStream idOut = new DerOutputStream();
                    algid.encode(idOut);
                    DerValue[] value = new DerValue[]{new DerValue(idOut.toByteArray()), new DerValue(4, dt)};
                    DerOutputStream out = new DerOutputStream();
                    out.putSequence(value);
                    signData = out.toByteArray();
                    signDataLen = signData.length;
                }
                catch (Exception ex) {
                    if (debug != null) {
                        debug.exception(Debug.TYPE_PUBLIC, className, "sign", ex);
                    }
                    throw new SignatureException("Error encoding signature");
                }
            } else {
                signDataLen = len - off;
                signData = new byte[signDataLen];
                System.arraycopy(data, off, signData, 0, signDataLen);
            }
            byte[] result = this.processSign(key, signData, 0, signDataLen, algorithm);
            if (debug != null) {
                debug.exit(Debug.TYPE_PUBLIC, (Object)className, "sign2", result);
            }
            return result;
        }
        if (debug != null) {
            debug.text(Debug.TYPE_PUBLIC, className, "sign", "sign.ECDSA");
        }
        byte[] signature = this.processSign(key, data, off, len, algorithm);
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "sign3", signature);
        }
        return signature;
    }

    boolean verify(byte[] key, byte[] data, int off, int len, byte[] sig, int sigOff, int sigLen, Algorithm algorithm, boolean hash, String id) throws SignatureException {
        if (debug != null) {
            Object[] parms = new Object[]{key, data, new Integer(off), new Integer(len), sig, new Integer(sigOff), new Integer(sigLen), algorithm, hash, id};
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "verify", parms);
        }
        if (algorithm == Algorithm.DSA) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "verify", "verify.DSA");
            }
            byte[] tempSig = new byte[40];
            try {
                DerInputStream in = new DerInputStream(sig);
                DerValue[] integers = in.getSequence(2);
                byte[] rPrime = integers[0].getInteger().toByteArray();
                byte[] sPrime = integers[1].getInteger().toByteArray();
                int length = rPrime.length;
                if (length > 20) {
                    System.arraycopy(rPrime, length - 20, tempSig, 0, 20);
                } else {
                    System.arraycopy(rPrime, 0, tempSig, 20 - length, length);
                }
                length = sPrime.length;
                if (length > 20) {
                    System.arraycopy(sPrime, length - 20, tempSig, 20, 20);
                } else {
                    System.arraycopy(sPrime, 0, tempSig, 40 - length, length);
                }
            }
            catch (IOException e) {
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, "verify", e);
                }
                throw new SignatureException("Invalid encoding for signature :" + e);
            }
            boolean result = this.processVerify(key, data, off, len, tempSig, 0, tempSig.length, algorithm);
            if (debug != null) {
                debug.exit(Debug.TYPE_PUBLIC, (Object)className, "verify1", result);
            }
            return result;
        }
        if (algorithm == Algorithm.RSA) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "verify", "verify.RSA");
            }
            byte[] verData = null;
            int verDataLen = 0;
            if (hash) {
                int digestLen = 0;
                if (len > 64) {
                    digestLen = 64;
                    if (debug != null) {
                        debug.text(Debug.TYPE_PUBLIC, className, "verify", "Digest length greater than maximum supported digest length, len = " + len + ", MAX_DIGEST_LENGTH = " + 64);
                    }
                } else {
                    digestLen = len;
                }
                byte[] dt = new byte[digestLen];
                System.arraycopy(data, off, dt, 0, digestLen);
                try {
                    DerOutputStream idOut = new DerOutputStream();
                    AlgorithmId algid = AlgorithmId.get((String)id);
                    algid.encode(idOut);
                    DerValue[] value = new DerValue[]{new DerValue(idOut.toByteArray()), new DerValue(4, dt)};
                    DerOutputStream out = new DerOutputStream();
                    out.putSequence(value);
                    verData = out.toByteArray();
                    verDataLen = verData.length;
                }
                catch (Exception ex) {
                    if (debug != null) {
                        debug.exception(Debug.TYPE_PUBLIC, className, "verify", ex);
                    }
                    throw new SignatureException("Error encoding signature");
                }
            } else {
                verDataLen = len - off;
                verData = new byte[verDataLen];
                System.arraycopy(data, off, verData, 0, verDataLen);
            }
            boolean result = this.processVerify(key, verData, 0, verDataLen, sig, sigOff, sigLen, algorithm);
            if (debug != null) {
                debug.exit(Debug.TYPE_PUBLIC, (Object)className, "verify2", result);
            }
            return result;
        }
        if (debug != null) {
            debug.text(Debug.TYPE_PUBLIC, className, "verify", "verify.ECDSA");
        }
        boolean result = this.processVerify(key, data, off, len, sig, sigOff, sigLen, algorithm);
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "verify3", result);
        }
        return result;
    }

    private String getRsaPssRuleString(int dataLen) {
        String s = "RSA     PKCS-PSSHASH    ";
        switch (dataLen) {
            case 24: {
                s = s + "SHA-1   ";
                break;
            }
            case 32: {
                s = s + "SHA-224 ";
                break;
            }
            case 36: {
                s = s + "SHA-256 ";
                break;
            }
            case 52: {
                s = s + "SHA-384 ";
                break;
            }
            case 68: {
                s = s + "SHA-512 ";
                break;
            }
            default: {
                s = "RSA     PKCS-PSS";
            }
        }
        return s;
    }

    static enum Algorithm {
        DSA,
        RSA,
        ECDSA,
        RSAPSS;

    }
}

