/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.hdwrCCA.provider;

import com.ibm.crypto.hdwrCCA.provider.Debug;
import com.ibm.crypto.hdwrCCA.provider.HexDumpEncoder;
import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.util.Arrays;

public class CrtToken {
    private static Debug debug = Debug.getInstance("ibmjcecca");
    private static String className = "com.ibm.crypto.hdwrCCA.provider.CrtToken";
    private byte[] token_identifier = new byte[1];
    private byte[] version = new byte[1];
    private byte[] length_of_key_token_struct = new byte[2];
    private byte[] ignored_prv_ext_token_header_area = new byte[4];
    private byte[] private_section_id = new byte[1];
    private byte[] private_section_version = new byte[1];
    private byte[] private_section_length = new byte[2];
    private byte[] private_sha1_hash_value_private_key = new byte[20];
    private byte[] private_reserved_1 = new byte[4];
    private byte[] private_key_format_and_security = new byte[1];
    private byte[] private_reserved_2 = new byte[1];
    private byte[] private_sha1_hash_value_keyname = new byte[20];
    private byte[] private_key_use_flag = new byte[4];
    private byte[] private_prime_P_length = new byte[2];
    private byte[] private_prime_Q_length = new byte[2];
    private byte[] private_dp_length = new byte[2];
    private byte[] private_dq_length = new byte[2];
    private byte[] private_U_length = new byte[2];
    private byte[] private_modulus_n_length = new byte[2];
    private byte[] private_reserved_3 = new byte[4];
    private byte[] private_padding_field_length = new byte[2];
    private byte[] private_reserved_4 = new byte[4];
    private byte[] private_reserved_5 = new byte[16];
    private byte[] private_reserved_6 = new byte[32];
    private byte[] private_random_number_confounder = new byte[8];
    private byte[] private_prime_P = null;
    private byte[] private_prime_Q = null;
    private byte[] private_dp = null;
    private byte[] private_dq = null;
    private byte[] private_U = null;
    private byte[] private_padding = null;
    private byte[] private_modulus_n = null;
    private byte[] public_section_id = new byte[1];
    private byte[] public_section_version = new byte[1];
    private byte[] public_section_length = new byte[2];
    private byte[] public_reserved_1 = new byte[2];
    private byte[] public_key_exponent_field_length = new byte[2];
    private byte[] public_key_modulus_length = new byte[2];
    private byte[] public_key_modulus_field_length = new byte[2];
    private byte[] public_key_exponent = null;
    private byte[] private_key_name_section_id = new byte[1];
    private byte[] private_key_name_version = new byte[1];
    private byte[] private_key_name_section_length = new byte[2];
    private byte[] private_key_name = new byte[64];
    private int ppp;
    private int qqq;
    private int rrr;
    private int sss;
    private int uuu;
    private int xxx;
    private int nnn;
    private int pubxxx;

    public CrtToken(byte[] externalToken, byte[] internalToken) {
        String offsetString;
        StringBuffer sb;
        int offset = 0;
        HexDumpEncoder encoder = null;
        if (debug != null) {
            encoder = new HexDumpEncoder();
            sb = new StringBuffer("external token length in decimal = ");
            if (null == externalToken) {
                sb = sb.append("0");
            } else {
                sb = sb.append(externalToken.length);
                sb = sb.append("\nexternal token: \n");
                String exttokenString = encoder.encodeBuffer(externalToken);
                sb = sb.append(exttokenString);
            }
            sb = sb.append("\n\ninternal token length in decimal = ");
            if (null == internalToken) {
                sb = sb.append("0");
            } else {
                sb = sb.append(internalToken.length);
                sb = sb.append("\ninternal token: \n");
                String inttokenString = encoder.encodeBuffer(internalToken);
                sb = sb.append(inttokenString);
            }
            String tkLenString = new String(sb);
            debug.text(8192L, className, "CrtToken", tkLenString);
        }
        System.arraycopy(externalToken, offset, this.token_identifier, 0, this.token_identifier.length);
        System.arraycopy(externalToken, offset += this.token_identifier.length, this.version, 0, this.version.length);
        System.arraycopy(externalToken, offset += this.version.length, this.length_of_key_token_struct, 0, this.length_of_key_token_struct.length);
        System.arraycopy(externalToken, offset += this.length_of_key_token_struct.length, this.ignored_prv_ext_token_header_area, 0, this.ignored_prv_ext_token_header_area.length);
        System.arraycopy(externalToken, offset += this.ignored_prv_ext_token_header_area.length, this.private_section_id, 0, this.private_section_id.length);
        System.arraycopy(externalToken, offset += this.private_section_id.length, this.private_section_version, 0, this.private_section_version.length);
        System.arraycopy(externalToken, offset += this.private_section_version.length, this.private_section_length, 0, this.private_section_length.length);
        System.arraycopy(externalToken, offset += this.private_section_length.length, this.private_sha1_hash_value_private_key, 0, this.private_sha1_hash_value_private_key.length);
        System.arraycopy(externalToken, offset += this.private_sha1_hash_value_private_key.length, this.private_reserved_1, 0, this.private_reserved_1.length);
        System.arraycopy(externalToken, offset += this.private_reserved_1.length, this.private_key_format_and_security, 0, this.private_key_format_and_security.length);
        System.arraycopy(externalToken, offset += this.private_key_format_and_security.length, this.private_reserved_2, 0, this.private_reserved_2.length);
        System.arraycopy(externalToken, offset += this.private_reserved_2.length, this.private_sha1_hash_value_keyname, 0, this.private_sha1_hash_value_keyname.length);
        System.arraycopy(externalToken, offset += this.private_sha1_hash_value_keyname.length, this.private_key_use_flag, 0, this.private_key_use_flag.length);
        System.arraycopy(externalToken, offset += this.private_key_use_flag.length, this.private_prime_P_length, 0, this.private_prime_P_length.length);
        System.arraycopy(externalToken, offset += this.private_prime_P_length.length, this.private_prime_Q_length, 0, this.private_prime_Q_length.length);
        System.arraycopy(externalToken, offset += this.private_prime_Q_length.length, this.private_dp_length, 0, this.private_dp_length.length);
        System.arraycopy(externalToken, offset += this.private_dp_length.length, this.private_dq_length, 0, this.private_dq_length.length);
        System.arraycopy(externalToken, offset += this.private_dq_length.length, this.private_U_length, 0, this.private_U_length.length);
        System.arraycopy(externalToken, offset += this.private_U_length.length, this.private_modulus_n_length, 0, this.private_modulus_n_length.length);
        System.arraycopy(externalToken, offset += this.private_modulus_n_length.length, this.private_reserved_3, 0, this.private_reserved_3.length);
        System.arraycopy(externalToken, offset += this.private_reserved_3.length, this.private_padding_field_length, 0, this.private_padding_field_length.length);
        System.arraycopy(externalToken, offset += this.private_padding_field_length.length, this.private_reserved_4, 0, this.private_reserved_4.length);
        System.arraycopy(externalToken, offset += this.private_reserved_4.length, this.private_reserved_5, 0, this.private_reserved_5.length);
        System.arraycopy(externalToken, offset += this.private_reserved_5.length, this.private_reserved_6, 0, this.private_reserved_6.length);
        System.arraycopy(externalToken, offset += this.private_reserved_6.length, this.private_random_number_confounder, 0, this.private_random_number_confounder.length);
        this.ppp = this.hextoDec(this.private_prime_P_length);
        this.private_prime_P = new byte[this.ppp];
        System.arraycopy(externalToken, offset += this.private_random_number_confounder.length, this.private_prime_P, 0, this.ppp);
        this.qqq = this.hextoDec(this.private_prime_Q_length);
        this.private_prime_Q = new byte[this.qqq];
        System.arraycopy(externalToken, offset += this.ppp, this.private_prime_Q, 0, this.qqq);
        this.rrr = this.hextoDec(this.private_dp_length);
        this.private_dp = new byte[this.rrr];
        System.arraycopy(externalToken, offset += this.qqq, this.private_dp, 0, this.rrr);
        this.sss = this.hextoDec(this.private_dq_length);
        this.private_dq = new byte[this.sss];
        System.arraycopy(externalToken, offset += this.rrr, this.private_dq, 0, this.sss);
        this.uuu = this.hextoDec(this.private_U_length);
        this.private_U = new byte[this.uuu];
        System.arraycopy(externalToken, offset += this.sss, this.private_U, 0, this.uuu);
        this.xxx = this.hextoDec(this.private_padding_field_length);
        this.private_padding = new byte[this.xxx];
        System.arraycopy(externalToken, offset += this.uuu, this.private_padding, 0, this.xxx);
        this.nnn = this.hextoDec(this.private_modulus_n_length);
        this.private_modulus_n = new byte[this.nnn];
        System.arraycopy(externalToken, offset += this.xxx, this.private_modulus_n, 0, this.nnn);
        offset += this.nnn;
        if (debug != null) {
            sb = new StringBuffer("offset = ");
            sb = sb.append(offset);
            offsetString = new String(sb);
            debug.text(8192L, className, "CrtToken", offsetString);
            this.printTokenPrivfields();
        }
        System.arraycopy(externalToken, offset, this.public_section_id, 0, this.public_section_id.length);
        System.arraycopy(externalToken, offset += this.public_section_id.length, this.public_section_version, 0, this.public_section_version.length);
        System.arraycopy(externalToken, offset += this.public_section_version.length, this.public_section_length, 0, this.public_section_length.length);
        System.arraycopy(externalToken, offset += this.public_section_length.length, this.public_reserved_1, 0, this.public_reserved_1.length);
        System.arraycopy(externalToken, offset += this.public_reserved_1.length, this.public_key_exponent_field_length, 0, this.public_key_exponent_field_length.length);
        System.arraycopy(externalToken, offset += this.public_key_exponent_field_length.length, this.public_key_modulus_length, 0, this.public_key_modulus_length.length);
        System.arraycopy(externalToken, offset += this.public_key_modulus_length.length, this.public_key_modulus_field_length, 0, this.public_key_modulus_field_length.length);
        this.pubxxx = this.hextoDec(this.public_key_exponent_field_length);
        this.public_key_exponent = new byte[this.pubxxx];
        System.arraycopy(externalToken, offset += this.public_key_modulus_field_length.length, this.public_key_exponent, 0, this.pubxxx);
        offset += this.pubxxx;
        if (debug != null) {
            this.printTokenPubfields();
        }
        if (debug != null) {
            sb = new StringBuffer("offset = ");
            sb = sb.append(offset);
            offsetString = new String(sb);
            debug.text(8192L, className, "CrtToken", offsetString);
        }
        if (offset != this.hextoDec(this.length_of_key_token_struct)) {
            if (debug != null) {
                sb = new StringBuffer("there are more private key info exists");
                offsetString = new String(sb);
                debug.text(8192L, className, "CrtToken", offsetString);
            }
            System.arraycopy(externalToken, offset, this.private_key_name_section_id, 0, this.private_key_name_section_id.length);
            if ((offset += this.private_key_name_section_id.length) != externalToken.length) {
                System.arraycopy(externalToken, offset, this.private_key_name_version, 0, this.private_key_name_version.length);
                offset += this.private_key_name_version.length;
            }
            if (offset != externalToken.length) {
                System.arraycopy(externalToken, offset, this.private_key_name_section_length, 0, this.private_key_name_section_length.length);
                offset += this.private_key_name_section_length.length;
            }
            if (offset != externalToken.length) {
                System.arraycopy(externalToken, offset, this.private_key_name, 0, this.private_key_name.length);
                offset += this.private_key_name.length;
            }
            this.printAdditionalPrivField();
        }
    }

    private boolean isThisTokenType(byte[] tokenId) {
        byte[] thisTokenId = new byte[]{this.token_identifier[0]};
        return Arrays.equals(tokenId, thisTokenId);
    }

    public byte getKeyFormatSecurityFromToken() {
        byte format_and_security = this.private_key_format_and_security[0];
        return format_and_security;
    }

    private BigInteger getModulusFromToken() {
        BigInteger n = new BigInteger(1, this.private_modulus_n);
        if (debug != null) {
            StringBuffer sb = new StringBuffer("\noriginal byte array private_modulus_n: \n");
            sb = sb.append(CrtToken.printByteArray(this.private_modulus_n));
            String nString = new String(sb);
            debug.text(8192L, className, "CrtToken", nString);
        }
        n = new BigInteger(1, this.private_modulus_n);
        return n;
    }

    private BigInteger getPrimeExponentPFromToken() {
        BigInteger ex1 = new BigInteger(1, this.private_dp);
        return ex1;
    }

    private BigInteger getPrimeExponentQFromToken() {
        BigInteger ex2 = new BigInteger(1, this.private_dq);
        return ex2;
    }

    private BigInteger getPrivate_U() {
        BigInteger co = new BigInteger(1, this.private_U);
        return co;
    }

    private BigInteger getPrimePFromToken() {
        BigInteger p = new BigInteger(1, this.private_prime_P);
        return p;
    }

    private BigInteger getPrimeQFromToken() {
        BigInteger q = new BigInteger(1, this.private_prime_Q);
        return q;
    }

    public BigInteger getPublicExponentFromToken() {
        BigInteger pubEx = new BigInteger(1, this.public_key_exponent);
        return pubEx;
    }

    RSAPrivateCrtKeySpec generatePrivateCrtKeySpec() throws IOException {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "generatePrivateCrtKeySpec");
        }
        BigInteger p = this.getPrimePFromToken();
        BigInteger q = this.getPrimeQFromToken();
        BigInteger n = this.getModulusFromToken();
        BigInteger e = this.getPublicExponentFromToken();
        BigInteger ex1 = this.getPrimeExponentPFromToken();
        BigInteger ex2 = this.getPrimeExponentQFromToken();
        BigInteger co = this.getPrivate_U();
        BigInteger d = BigInteger.ONE;
        byte[] theTokenType = new byte[]{30};
        boolean isExternalToken = this.isThisTokenType(theTokenType);
        if (!isExternalToken) {
            IOException ioe = new IOException("Not an external token");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "generatePrivateCrtKeySpec", ioe);
                debug.exit(Debug.TYPE_PUBLIC, className, "generatePrivateCrtKeySpec");
            }
            throw ioe;
        }
        byte key_format_sec = this.getKeyFormatSecurityFromToken();
        if (key_format_sec != 64) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "generatePrivateCrtKeySpec", "The private key must be unencrypted");
                debug.exit(Debug.TYPE_PUBLIC, (Object)className, "generatePrivateCrtKeySpec", null);
            }
            return null;
        }
        if (debug != null) {
            StringBuffer sb = new StringBuffer("\nd = ");
            sb = sb.append(d.toString());
            sb = sb.append("\n");
            sb = sb.append("e = ");
            sb = sb.append(e.toString());
            sb = sb.append("\n");
            sb = sb.append("P = ");
            sb = sb.append(p.toString());
            sb = sb.append("\n");
            sb = sb.append("Q = ");
            sb = sb.append(q.toString());
            sb = sb.append("\n");
            sb = sb.append("n = ");
            sb = sb.append(n.toString());
            sb = sb.append("\n");
            sb = sb.append("co = ");
            sb = sb.append(co.toString());
            sb = sb.append("\n");
            sb = sb.append("ex1 = ");
            sb = sb.append(ex1.toString());
            sb = sb.append("\n");
            sb = sb.append("ex2 = ");
            sb = sb.append(ex2.toString());
            sb = sb.append("\n");
            String paramString = new String(sb);
            debug.text(8192L, className, "generatePrivateCrtKeySpec", paramString);
        }
        RSAPrivateCrtKeySpec privateCrtKeySpec = new RSAPrivateCrtKeySpec(n, e, d, p, q, ex1, ex2, co);
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "generatePrivateCrtKeySpec", privateCrtKeySpec);
        }
        return privateCrtKeySpec;
    }

    public PrivateKey generatePrivateCrtkey() throws Exception {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "generatePrivateCrtkey");
        }
        try {
            RSAPrivateCrtKeySpec keySpec = this.generatePrivateCrtKeySpec();
            if (keySpec == null) {
                if (debug != null) {
                    debug.exit(Debug.TYPE_PUBLIC, (Object)className, "generatePrivateCrtkey", null);
                }
                return null;
            }
            KeyFactory keyFactory = KeyFactory.getInstance("RSA", "IBMJCE");
            PrivateKey privKey = keyFactory.generatePrivate(keySpec);
            if (debug != null) {
                debug.exit(Debug.TYPE_PUBLIC, (Object)className, "generatePrivateCrtkey", privKey);
            }
            return privKey;
        }
        catch (IOException ioe) {
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "generatePrivateCrtkey", ioe);
                debug.exit(Debug.TYPE_PUBLIC, className, "generatePrivateCrtkey");
            }
            throw ioe;
        }
        catch (Exception e) {
            ProviderException pe = new ProviderException(e.getMessage());
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "generatePrivateCrtkey", e);
                debug.exception(Debug.TYPE_PUBLIC, className, "generatePrivateCrtkey", pe);
                debug.exit(Debug.TYPE_PUBLIC, className, "generatePrivateCrtkey");
            }
            throw pe;
        }
    }

    private int hextoDec(byte[] hexArray) {
        String hexString = CrtToken.printByteArray(hexArray).trim();
        int intValue = Integer.parseInt(hexString, 16);
        return intValue;
    }

    private static String printByteArray(byte[] array) {
        StringBuffer stringBuf = new StringBuffer();
        for (int i = 0; i < array.length; ++i) {
            if (i % 32 == 0 && i > 0) {
                stringBuf.append("\n");
            }
            if (i % 4 == 0) {
                stringBuf.append("    ");
            }
            stringBuf.append(CrtToken.byteToString(array[i]));
        }
        String val = new String(stringBuf);
        return val;
    }

    private static String byteToString(int n) {
        char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        char[] buf = new char[]{HEX_DIGITS[n >>> 4 & 0xF], HEX_DIGITS[n & 0xF]};
        return new String(buf);
    }

    private void printTokenPrivfields() {
        StringBuffer sb = new StringBuffer("this.token_identifier: \n");
        sb = sb.append(CrtToken.printByteArray(this.token_identifier));
        sb = sb.append("\nthis.version: \n");
        sb = sb.append(CrtToken.printByteArray(this.version));
        sb = sb.append("\nthis.length_of_key_token_struct: \n");
        sb = sb.append(CrtToken.printByteArray(this.length_of_key_token_struct));
        sb = sb.append("\nthis.ignored_prv_ext_token_header_area: \n");
        sb = sb.append(CrtToken.printByteArray(this.ignored_prv_ext_token_header_area));
        sb = sb.append("\nthis.private_section_id: \n");
        sb = sb.append(CrtToken.printByteArray(this.private_section_id));
        sb = sb.append("\nthis.private_section_version: \n");
        sb = sb.append(CrtToken.printByteArray(this.private_section_version));
        sb = sb.append("\nthis.private_section_length: \n");
        sb = sb.append(CrtToken.printByteArray(this.private_section_length));
        sb = sb.append("\nthis.private_sha1_hash_value_private_key: \n");
        sb = sb.append(CrtToken.printByteArray(this.private_sha1_hash_value_private_key));
        sb = sb.append("\nthis.private_reserved_1: \n");
        sb = sb.append(CrtToken.printByteArray(this.private_reserved_1));
        sb = sb.append("\nthis.private_key_format_and_security: \n");
        sb = sb.append(CrtToken.printByteArray(this.private_key_format_and_security));
        sb = sb.append("\nthis.private_reserved_2: \n");
        sb = sb.append(CrtToken.printByteArray(this.private_reserved_2));
        sb = sb.append("\nthis.private_sha1_hash_value_keyname: \n");
        sb = sb.append(CrtToken.printByteArray(this.private_sha1_hash_value_keyname));
        sb = sb.append("\nthis.private_key_use_flag: \n");
        sb = sb.append(CrtToken.printByteArray(this.private_key_use_flag));
        sb = sb.append("\nthis.private_prime_P_length in hex: \n");
        sb = sb.append(CrtToken.printByteArray(this.private_prime_P_length));
        sb = sb.append("\nthis.private_prime_Q_length in hex: \n");
        sb = sb.append(CrtToken.printByteArray(this.private_prime_Q_length));
        sb = sb.append("\nthis.private_dp_length in hex: \n");
        sb = sb.append(CrtToken.printByteArray(this.private_dp_length));
        sb = sb.append("\nthis.private_dq_length in hex: \n");
        sb = sb.append(CrtToken.printByteArray(this.private_dq_length));
        sb = sb.append("\nthis.private_U_length in hex: \n");
        sb = sb.append(CrtToken.printByteArray(this.private_U_length));
        sb = sb.append("\nthis.private_modulus_n_length in hex: \n");
        sb = sb.append(CrtToken.printByteArray(this.private_modulus_n_length));
        sb = sb.append("\nthis.private_reserved_3: \n");
        sb = sb.append(CrtToken.printByteArray(this.private_reserved_3));
        sb = sb.append("\nthis.private_padding_field_length in hex: \n");
        sb = sb.append(CrtToken.printByteArray(this.private_padding_field_length));
        sb = sb.append("\nthis.private_reserved_4: \n");
        sb = sb.append(CrtToken.printByteArray(this.private_reserved_4));
        sb = sb.append("\nthis.private_reserved_5: \n");
        sb = sb.append(CrtToken.printByteArray(this.private_reserved_5));
        sb = sb.append("\nthis.private_reserved_6: \n");
        sb = sb.append(CrtToken.printByteArray(this.private_reserved_6));
        sb = sb.append("\nthis.private_random_number_confounder: \n");
        sb = sb.append(CrtToken.printByteArray(this.private_random_number_confounder));
        sb = sb.append("\nthe length of private_prime_P in decimal: \n");
        sb = sb.append(this.ppp);
        sb = sb.append("\nthis.private_prime_P: \n");
        sb = sb.append(CrtToken.printByteArray(this.private_prime_P));
        sb = sb.append("\nthe length of private_prime_Q in decimal: \n");
        sb = sb.append(this.qqq);
        sb = sb.append("\nthis.private_prime_Q: \n");
        sb = sb.append(CrtToken.printByteArray(this.private_prime_Q));
        sb = sb.append("\nthe length of private_prime_dp in decimal: \n");
        sb = sb.append(this.rrr);
        sb = sb.append("\nthis.private_dp: \n");
        sb = sb.append(CrtToken.printByteArray(this.private_dp));
        sb = sb.append("\nthe length of private_prime_dq in decimal: \n");
        sb = sb.append(this.sss);
        sb = sb.append("\nthis.private_dq: \n");
        sb = sb.append(CrtToken.printByteArray(this.private_dq));
        sb = sb.append("\nthe length of private_U in decimal: \n");
        sb = sb.append(this.uuu);
        sb = sb.append("\nthis.private_U: \n");
        sb = sb.append(CrtToken.printByteArray(this.private_U));
        sb = sb.append("\nthe length of private_padding in decimal: \n");
        sb = sb.append(this.xxx);
        sb = sb.append("\nthis.private_padding: \n");
        sb = sb.append(CrtToken.printByteArray(this.private_padding));
        sb = sb.append("\nthe length of private_modulus_n in decimal: \n");
        sb = sb.append(this.nnn);
        sb = sb.append("\nthis.private_modulus_n: \n");
        sb = sb.append(CrtToken.printByteArray(this.private_modulus_n));
        String privFieldString = new String(sb);
        debug.text(8192L, className, "printTokenPrivfields", privFieldString);
    }

    private void printTokenPubfields() {
        StringBuffer sb = new StringBuffer("this.public_section_id: \n");
        sb = sb.append(CrtToken.printByteArray(this.public_section_id));
        sb = sb.append("\nthis.public_section_version: \n");
        sb = sb.append(CrtToken.printByteArray(this.public_section_version));
        sb = sb.append("\nthis.public_section_length: \n");
        sb = sb.append(CrtToken.printByteArray(this.public_section_length));
        sb = sb.append("\nthis.public_reserved_1: \n");
        sb = sb.append(CrtToken.printByteArray(this.public_reserved_1));
        sb = sb.append("\nthis.public_key_exponent_field_length: \n");
        sb = sb.append(this.hextoDec(this.public_key_exponent_field_length));
        sb = sb.append("\nthis.public_key_modulus_length: \n");
        sb = sb.append(this.hextoDec(this.public_key_modulus_length));
        sb = sb.append("\nthe length of public_key_exponent in decimal is \n");
        sb = sb.append(this.pubxxx);
        sb = sb.append("\nthis.public_key_exponent: \n");
        sb = sb.append(CrtToken.printByteArray(this.public_key_exponent));
        String pubFieldString = new String(sb);
        debug.text(8192L, className, "printTokenPubfields", pubFieldString);
    }

    private void printAdditionalPrivField() {
        StringBuffer sb = new StringBuffer("this.private_key_name_section_id: ");
        sb = sb.append(CrtToken.printByteArray(this.private_key_name_section_id));
        String privNameIDString = new String(sb);
        debug.text(8192L, className, "printAdditionalPrivField", privNameIDString);
        sb = sb.append("\nthis.private_key_name_version: ");
        sb = sb.append(CrtToken.printByteArray(this.private_key_name_version));
        String privNameVerString = new String(sb);
        debug.text(8192L, className, "printAdditionalPrivField", privNameVerString);
        sb = sb.append("\nthis.private_key_name_section_length: ");
        sb = sb.append(CrtToken.printByteArray(this.private_key_name_section_length));
        String privNameLenString = new String(sb);
        debug.text(8192L, className, "printAdditionalPrivField", privNameLenString);
        sb = sb.append("\nthis.private_key_name: ");
        sb = sb.append(CrtToken.printByteArray(this.private_key_name));
        String privNameString = new String(sb);
        debug.text(8192L, className, "printAdditionalPrivField", privNameString);
    }
}

