/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.hdwrCCA.provider;

import com.ibm.crypto.hdwrCCA.provider.Debug;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Security;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;

final class ConstructKeys {
    private static Debug debug = Debug.getInstance("ibmjcecca");
    private static String className = "com.ibm.crypto.hdwrCCA.provider.ConstructKeys";

    ConstructKeys() {
    }

    static final PublicKey constructPublicKey(byte[] encodedKey, String encodedKeyAlgorithm) throws InvalidKeyException, NoSuchAlgorithmException {
        PublicKey key;
        block13: {
            key = null;
            if (debug != null) {
                debug.entry(Debug.TYPE_PUBLIC, className, "constructPublicKey", encodedKey, encodedKeyAlgorithm);
            }
            try {
                KeyFactory keyFactory = null;
                keyFactory = Security.getProvider("IBMJCECCA") == null ? KeyFactory.getInstance(encodedKeyAlgorithm, "IBMJCE4758") : KeyFactory.getInstance(encodedKeyAlgorithm, "IBMJCECCA");
                X509EncodedKeySpec keySpec = new X509EncodedKeySpec(encodedKey);
                key = keyFactory.generatePublic(keySpec);
            }
            catch (NoSuchAlgorithmException nsae) {
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, "constructPublicKey", nsae);
                }
                try {
                    KeyFactory keyFactory = KeyFactory.getInstance(encodedKeyAlgorithm);
                    X509EncodedKeySpec keySpec = new X509EncodedKeySpec(encodedKey);
                    key = keyFactory.generatePublic(keySpec);
                }
                catch (NoSuchAlgorithmException nsae2) {
                    if (debug != null) {
                        debug.exception(Debug.TYPE_PUBLIC, className, "constructPublicKey", nsae2);
                    }
                    throw new NoSuchAlgorithmException("No installed providers can create keys for the " + encodedKeyAlgorithm + "algorithm");
                }
                catch (InvalidKeySpecException ikse2) {
                    if (debug != null) {
                        debug.exception(Debug.TYPE_PUBLIC, className, "constructPublicKey", ikse2);
                    }
                }
            }
            catch (InvalidKeySpecException ikse) {
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, "constructPublicKey", ikse);
                }
            }
            catch (NoSuchProviderException nspe) {
                if (debug == null) break block13;
                debug.exception(Debug.TYPE_PUBLIC, className, "constructPublicKey", nspe);
            }
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "constructPublicKey", key);
        }
        return key;
    }

    static final PrivateKey constructPrivateKey(byte[] encodedKey, String encodedKeyAlgorithm) throws InvalidKeyException, NoSuchAlgorithmException {
        PrivateKey key;
        block13: {
            key = null;
            if (debug != null) {
                debug.entry(Debug.TYPE_PUBLIC, className, "constructPrivateKey", encodedKey, encodedKeyAlgorithm);
            }
            try {
                KeyFactory keyFactory = null;
                keyFactory = Security.getProvider("IBMJCECCA") == null ? KeyFactory.getInstance(encodedKeyAlgorithm, "IBMJCE4758") : KeyFactory.getInstance(encodedKeyAlgorithm, "IBMJCECCA");
                PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(encodedKey);
                key = keyFactory.generatePrivate(keySpec);
            }
            catch (NoSuchAlgorithmException nsae) {
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, "constructPrivateKey", nsae);
                }
                try {
                    KeyFactory keyFactory = KeyFactory.getInstance(encodedKeyAlgorithm);
                    PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(encodedKey);
                    key = keyFactory.generatePrivate(keySpec);
                }
                catch (NoSuchAlgorithmException nsae2) {
                    if (debug != null) {
                        debug.exception(Debug.TYPE_PUBLIC, className, "constructPrivateKey", nsae2);
                    }
                    throw new NoSuchAlgorithmException("No installed providers can create keys for the " + encodedKeyAlgorithm + "algorithm");
                }
                catch (InvalidKeySpecException ikse2) {
                    if (debug != null) {
                        debug.exception(Debug.TYPE_PUBLIC, className, "constructPrivateKey", ikse2);
                    }
                }
            }
            catch (InvalidKeySpecException ikse) {
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, "constructPrivateKey", ikse);
                }
            }
            catch (NoSuchProviderException nspe) {
                if (debug == null) break block13;
                debug.exception(Debug.TYPE_PUBLIC, className, "constructPrivateKey", nspe);
            }
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "constructPrivateKey", key);
        }
        return key;
    }

    static final SecretKey constructSecretKey(byte[] encodedKey, String encodedKeyAlgorithm) {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "constructSecretKey", encodedKey, encodedKeyAlgorithm);
        }
        SecretKeySpec secretKey = new SecretKeySpec(encodedKey, encodedKeyAlgorithm);
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "constructSecretKey", secretKey);
        }
        return secretKey;
    }
}

