/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.hdwrCCA.provider;

import com.ibm.crypto.hdwrCCA.provider.Debug;
import com.ibm.crypto.hdwrCCA.provider.FeedbackCipher;
import com.ibm.crypto.hdwrCCA.provider.SymmetricCipher;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.RC2ParameterSpec;
import javax.crypto.spec.RC5ParameterSpec;

class CipherFeedbackWithParams
extends SymmetricCipher
implements FeedbackCipher {
    private static final String MODE_NAME = "CFB";
    private byte[] k;
    private byte[] register = null;
    private SymmetricCipher embeddedCipher;
    private byte[] iv = null;
    private int blockSize = -1;
    private int numBytes = 8;
    private static Debug debug = Debug.getInstance("ibmjcecca");
    private static String className = "com.ibm.crypto.hdwrCCA.provider.CipherFeedbackWithParams";

    CipherFeedbackWithParams() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "CipherFeedbackWithParams");
            debug.exit(Debug.TYPE_PUBLIC, className, "CipherFeedbackWithParams");
        }
    }

    CipherFeedbackWithParams(int numBytes) {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "CipherFeedbackWithParams", new Integer(numBytes));
        }
        this.numBytes = numBytes;
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "CipherFeedbackWithParams");
        }
    }

    @Override
    public String getFeedback() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "getFeedback");
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getFeedback", MODE_NAME);
        }
        return MODE_NAME;
    }

    @Override
    public byte[] getIV() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "getIV");
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getIV", this.iv);
        }
        return this.iv;
    }

    void setEmbeddedCipher(SymmetricCipher embeddedCipher) throws NoSuchAlgorithmException {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "setEmbeddedCipher", embeddedCipher);
        }
        if (embeddedCipher == null || (this.blockSize = embeddedCipher.getBlockSize()) <= 0) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "setEmbeddedCipher", "Incompatible algorithm type and mode");
            }
            throw new NoSuchAlgorithmException("Incompatible algorithm type and mode");
        }
        this.embeddedCipher = embeddedCipher;
        this.k = new byte[this.blockSize];
        this.register = new byte[this.blockSize];
        if (this.numBytes > this.blockSize) {
            this.numBytes = this.blockSize;
        }
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "setEmbeddedCipher");
        }
    }

    @Override
    int getBlockSize() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "getBlockSize");
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getBlockSize", new Integer(this.blockSize));
        }
        return this.blockSize;
    }

    int getStreamUnitSize() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "getStreamUnitSize");
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getStreamUnitSize", new Integer(this.numBytes * 8));
        }
        return this.numBytes * 8;
    }

    @Override
    void init(Key key) throws InvalidKeyException {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "init", key);
        }
        this.embeddedCipher.init(key);
        SecureRandom random = null;
        try {
            random = SecureRandom.getInstance("IBMSecureRandom");
        }
        catch (NoSuchAlgorithmException e) {
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "init", e);
            }
            random = new SecureRandom();
        }
        this.iv = new byte[this.blockSize];
        random.nextBytes(this.iv);
        System.arraycopy(this.iv, 0, this.register, 0, this.blockSize);
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "init");
        }
    }

    @Override
    void init(Key key, AlgorithmParameterSpec params) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "init", key, params);
        }
        if (params != null && params instanceof IvParameterSpec) {
            IvParameterSpec ivSpec = (IvParameterSpec)params;
            this.iv = ivSpec.getIV();
            if (this.iv == null || this.iv.length != 8 && this.iv.length != 16) {
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "init", "Wrong IV length: must be 8 or 16 bytes long");
                }
                throw new InvalidAlgorithmParameterException("Wrong IV length: must be 8 or 16 bytes long");
            }
            System.arraycopy(this.iv, 0, this.register, 0, this.blockSize);
            this.embeddedCipher.init(key);
        } else if (params != null && params instanceof RC5ParameterSpec) {
            this.iv = ((RC5ParameterSpec)params).getIV();
            if (this.iv == null || this.iv.length != 8) {
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "init", "Wrong IV length1: must be 8 bytes long");
                }
                throw new InvalidAlgorithmParameterException("Wrong IV length: must be 8 bytes long");
            }
            System.arraycopy(this.iv, 0, this.register, 0, this.blockSize);
            this.embeddedCipher.init(key, params);
        } else if (params != null && params instanceof RC2ParameterSpec) {
            this.iv = ((RC2ParameterSpec)params).getIV();
            if (this.iv == null || this.iv.length != 8) {
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "init", "Wrong IV length1: must be 8 bytes long");
                }
                throw new InvalidAlgorithmParameterException("Wrong IV length: must be 8 bytes long");
            }
            System.arraycopy(this.iv, 0, this.register, 0, this.blockSize);
            this.embeddedCipher.init(key, params);
        } else {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "init", "Wrong parameter type: IV, RC5 or RC2 ParameterSpec expected");
            }
            throw new InvalidAlgorithmParameterException("Wrong parameter type: IV, RC5 or RC2 ParameterSpec expected");
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "init");
        }
    }

    @Override
    public void reset() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "reset");
        }
        System.arraycopy(this.iv, 0, this.register, 0, this.blockSize);
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "reset");
        }
    }

    @Override
    void encrypt(byte[] plain, int plainOffset, int plainLen, byte[] cipher, int cipherOffset) throws IllegalBlockSizeException {
        int loopCount;
        if (debug != null) {
            Object[] parms = new Object[]{plain, new Integer(plainOffset), new Integer(plainLen), cipher, new Integer(cipherOffset)};
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "encrypt", parms);
        }
        int len = this.blockSize - this.numBytes;
        int endIndex = plainOffset + plainLen;
        int oddBytes = plainLen % this.numBytes;
        if (len == 0) {
            for (loopCount = plainLen / this.numBytes; loopCount > 0; --loopCount) {
                this.embeddedCipher.encrypt(this.register, 0, this.blockSize, this.k, 0);
                for (int i = 0; i < this.blockSize; ++i) {
                    byte by = (byte)(this.k[i] ^ plain[i + plainOffset]);
                    cipher[i + cipherOffset] = by;
                    this.register[i] = by;
                }
                plainOffset += this.numBytes;
                cipherOffset += this.numBytes;
            }
            if (oddBytes > 0) {
                this.embeddedCipher.encrypt(this.register, 0, this.blockSize, this.k, 0);
                for (int i = 0; i < oddBytes; ++i) {
                    byte by = (byte)(this.k[i] ^ plain[i + plainOffset]);
                    cipher[i + cipherOffset] = by;
                    this.register[i] = by;
                }
            }
        } else {
            while (loopCount > 0) {
                this.embeddedCipher.encrypt(this.register, 0, this.blockSize, this.k, 0);
                System.arraycopy(this.register, this.numBytes, this.register, 0, len);
                for (int i = 0; i < this.numBytes; ++i) {
                    byte by = (byte)(this.k[i] ^ plain[i + plainOffset]);
                    cipher[i + cipherOffset] = by;
                    this.register[i + len] = by;
                }
                plainOffset += this.numBytes;
                cipherOffset += this.numBytes;
                --loopCount;
            }
            if (oddBytes != 0) {
                this.embeddedCipher.encrypt(this.register, 0, this.blockSize, this.k, 0);
                System.arraycopy(this.register, this.numBytes, this.register, 0, len);
                for (int i = 0; i < oddBytes; ++i) {
                    byte by = (byte)(this.k[i] ^ plain[i + plainOffset]);
                    cipher[i + cipherOffset] = by;
                    this.register[i + len] = by;
                }
            }
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "encrypt");
        }
    }

    @Override
    void decrypt(byte[] cipher, int cipherOffset, int cipherLen, byte[] plain, int plainOffset) throws IllegalBlockSizeException {
        int loopCount;
        if (debug != null) {
            Object[] parms = new Object[]{cipher, new Integer(cipherOffset), new Integer(cipherLen), plain, new Integer(plainOffset)};
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "decrypt", parms);
        }
        int len = this.blockSize - this.numBytes;
        int endIndex = cipherOffset + cipherLen;
        int oddBytes = cipherLen % this.numBytes;
        if (len == 0) {
            for (loopCount = cipherLen / this.numBytes; loopCount > 0; --loopCount) {
                this.embeddedCipher.encrypt(this.register, 0, this.blockSize, this.k, 0);
                for (int i = 0; i < this.blockSize; ++i) {
                    this.register[i] = cipher[i + cipherOffset];
                    plain[i + plainOffset] = (byte)(cipher[i + cipherOffset] ^ this.k[i]);
                }
                plainOffset += this.numBytes;
                cipherOffset += this.numBytes;
            }
            if (oddBytes > 0) {
                this.embeddedCipher.encrypt(this.register, 0, this.blockSize, this.k, 0);
                for (int i = 0; i < oddBytes; ++i) {
                    this.register[i] = cipher[i + cipherOffset];
                    plain[i + plainOffset] = (byte)(cipher[i + cipherOffset] ^ this.k[i]);
                }
            }
        } else {
            while (loopCount > 0) {
                this.embeddedCipher.encrypt(this.register, 0, this.blockSize, this.k, 0);
                System.arraycopy(this.register, this.numBytes, this.register, 0, len);
                for (int i = 0; i < this.numBytes; ++i) {
                    this.register[i + len] = cipher[i + cipherOffset];
                    plain[i + plainOffset] = (byte)(cipher[i + cipherOffset] ^ this.k[i]);
                }
                plainOffset += this.numBytes;
                cipherOffset += this.numBytes;
                --loopCount;
            }
            if (oddBytes != 0) {
                this.embeddedCipher.encrypt(this.register, 0, this.blockSize, this.k, 0);
                System.arraycopy(this.register, this.numBytes, this.register, 0, len);
                for (int i = 0; i < oddBytes; ++i) {
                    this.register[i + len] = cipher[i + cipherOffset];
                    plain[i + plainOffset] = (byte)(cipher[i + cipherOffset] ^ this.k[i]);
                }
            }
        }
        if (debug != null) {
            debug.text(Debug.TYPE_PUBLIC, className, "decrypt", "plain = " + plain.toString());
            debug.exit(Debug.TYPE_PUBLIC, className, "decrypt");
        }
    }
}

