/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.hdwrCCA.provider;

import com.ibm.crypto.hdwrCCA.provider.AESKey;
import com.ibm.crypto.hdwrCCA.provider.DESKey;
import com.ibm.crypto.hdwrCCA.provider.DESedeKey;
import com.ibm.crypto.hdwrCCA.provider.Debug;
import com.ibm.crypto.hdwrCCA.provider.FeedbackCipher;
import com.ibm.crypto.hdwrCCA.provider.SymmetricCipher;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.spec.IvParameterSpec;

class CipherFeedback
extends SymmetricCipher
implements FeedbackCipher {
    private static final String MODE_NAME = "CFB";
    private byte[] k;
    private byte[] register = null;
    private SymmetricCipher embeddedCipher;
    private byte[] iv = null;
    private int blockSize = -1;
    private int numBytes = 8;
    private static Debug debug = Debug.getInstance("ibmjcecca");
    private static String className = "com.ibm.crypto.hdwrCCA.provider.CipherFeedback";

    CipherFeedback() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "CipherFeedback");
            debug.exit(Debug.TYPE_PUBLIC, className, "CipherFeedback");
        }
    }

    CipherFeedback(int numBytes) {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "CipherFeedback", new Integer(numBytes));
        }
        this.numBytes = numBytes;
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "CipherFeedback");
        }
    }

    @Override
    public String getFeedback() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "getFeedback");
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getFeedback", MODE_NAME);
        }
        return MODE_NAME;
    }

    @Override
    public byte[] getIV() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "getIV");
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getIV", this.iv);
        }
        return this.iv;
    }

    void setEmbeddedCipher(SymmetricCipher embeddedCipher) throws NoSuchAlgorithmException {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "setEmbeddedCipher", embeddedCipher);
        }
        if (embeddedCipher == null || (this.blockSize = embeddedCipher.getBlockSize()) <= 0) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "setEmbeddedCipher", "Incompatible algorithm type and mode");
            }
            throw new NoSuchAlgorithmException("Incompatible algorithm type and mode");
        }
        this.embeddedCipher = embeddedCipher;
        this.k = new byte[this.blockSize];
        this.register = new byte[this.blockSize];
        if (this.numBytes > this.blockSize) {
            this.numBytes = this.blockSize;
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "setEmbeddedCipher");
        }
    }

    @Override
    int getBlockSize() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "getBlockSize");
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getBlockSize", new Integer(this.blockSize));
        }
        return this.blockSize;
    }

    int getStreamUnitSize() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "getStreamUnitSize");
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getStreamUnitSize", new Integer(this.numBytes * 8));
        }
        return this.numBytes * 8;
    }

    @Override
    void init(Key key) throws InvalidKeyException {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "init", key);
        }
        if (!key.getFormat().equalsIgnoreCase("CKDSLabel")) {
            this.embeddedCipher.init(key);
        }
        SecureRandom random = null;
        try {
            random = SecureRandom.getInstance("IBMSecureRandom");
        }
        catch (NoSuchAlgorithmException e) {
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "init", e);
            }
            random = new SecureRandom();
        }
        this.iv = new byte[this.blockSize];
        random.nextBytes(this.iv);
        System.arraycopy(this.iv, 0, this.register, 0, this.blockSize);
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "init");
        }
    }

    @Override
    void init(Key key, AlgorithmParameterSpec params) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "init", key, params);
        }
        if (key == null) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "init", "Key must not be null. ");
            }
            throw new InvalidKeyException("Key must not be null. ");
        }
        if (!key.getFormat().equalsIgnoreCase("CKDSLabel") && !key.getFormat().equalsIgnoreCase("ICSFToken")) {
            this.embeddedCipher.init(key);
        }
        if (params != null && params instanceof IvParameterSpec) {
            IvParameterSpec ivSpec = (IvParameterSpec)params;
            this.iv = ivSpec.getIV();
            if (key instanceof DESKey || key instanceof DESedeKey) {
                if (this.iv == null || this.iv.length != 8) {
                    if (debug != null) {
                        if (this.iv == null) {
                            debug.text(Debug.TYPE_PUBLIC, className, "init", "Wrong IV length: must be 8 bytes long. Len is null");
                        } else {
                            debug.text(Debug.TYPE_PUBLIC, className, "init", "Wrong IV length: must be 8 bytes long. Len is " + this.iv.length);
                        }
                    }
                    throw new InvalidAlgorithmParameterException("Wrong IV length: must be 8 bytes long");
                }
            } else if (key instanceof AESKey) {
                if (this.iv == null || this.iv.length != 16) {
                    if (debug != null) {
                        if (this.iv == null) {
                            debug.text(Debug.TYPE_PUBLIC, className, "init", "Wrong IV length: must be 8 bytes long. Len is null");
                        } else {
                            debug.text(Debug.TYPE_PUBLIC, className, "init", "Wrong IV length: must be 8 bytes long. Len is " + this.iv.length);
                        }
                    }
                    throw new InvalidAlgorithmParameterException("Wrong IV length: must be 16 bytes long");
                }
            } else if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "init", " Invalid Key Type" + key.getAlgorithm());
            }
        } else {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "init", "Wrong parameter type: IV expected");
            }
            throw new InvalidAlgorithmParameterException("Wrong parameter type: IV expected");
        }
        System.arraycopy(this.iv, 0, this.register, 0, this.blockSize);
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "init");
        }
    }

    @Override
    public void reset() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "reset");
        }
        System.arraycopy(this.iv, 0, this.register, 0, this.blockSize);
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "reset");
        }
    }

    @Override
    void encrypt(byte[] plain, int plainOffset, int plainLen, byte[] cipher, int cipherOffset) throws IllegalBlockSizeException {
        int loopCount;
        if (debug != null) {
            Object[] parms = new Object[]{plain, new Integer(plainOffset), new Integer(plainLen), cipher, new Integer(cipherOffset)};
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "encrypt", parms);
        }
        int len = this.blockSize - this.numBytes;
        int endIndex = plainOffset + plainLen;
        int oddBytes = plainLen % this.numBytes;
        if (len == 0) {
            for (loopCount = plainLen / this.numBytes; loopCount > 0; --loopCount) {
                this.embeddedCipher.encrypt(this.register, 0, this.blockSize, this.k, 0);
                for (int i = 0; i < this.blockSize; ++i) {
                    byte by = (byte)(this.k[i] ^ plain[i + plainOffset]);
                    cipher[i + cipherOffset] = by;
                    this.register[i] = by;
                }
                plainOffset += this.numBytes;
                cipherOffset += this.numBytes;
            }
            if (oddBytes > 0) {
                this.embeddedCipher.encrypt(this.register, 0, this.blockSize, this.k, 0);
                for (int i = 0; i < oddBytes; ++i) {
                    byte by = (byte)(this.k[i] ^ plain[i + plainOffset]);
                    cipher[i + cipherOffset] = by;
                    this.register[i] = by;
                }
            }
        } else {
            while (loopCount > 0) {
                this.embeddedCipher.encrypt(this.register, 0, this.blockSize, this.k, 0);
                System.arraycopy(this.register, this.numBytes, this.register, 0, len);
                for (int i = 0; i < this.numBytes; ++i) {
                    byte by = (byte)(this.k[i] ^ plain[i + plainOffset]);
                    cipher[i + cipherOffset] = by;
                    this.register[i + len] = by;
                }
                plainOffset += this.numBytes;
                cipherOffset += this.numBytes;
                --loopCount;
            }
            if (oddBytes != 0) {
                this.embeddedCipher.encrypt(this.register, 0, this.blockSize, this.k, 0);
                System.arraycopy(this.register, this.numBytes, this.register, 0, len);
                for (int i = 0; i < oddBytes; ++i) {
                    byte by = (byte)(this.k[i] ^ plain[i + plainOffset]);
                    cipher[i + cipherOffset] = by;
                    this.register[i + len] = by;
                }
            }
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "encrypt");
        }
    }

    @Override
    void decrypt(byte[] cipher, int cipherOffset, int cipherLen, byte[] plain, int plainOffset) throws IllegalBlockSizeException {
        int loopCount;
        if (debug != null) {
            Object[] parms = new Object[]{cipher, new Integer(cipherOffset), new Integer(cipherLen), plain, new Integer(plainOffset)};
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "decrypt", parms);
        }
        int len = this.blockSize - this.numBytes;
        int endIndex = cipherOffset + cipherLen;
        int oddBytes = cipherLen % this.numBytes;
        if (len == 0) {
            for (loopCount = cipherLen / this.numBytes; loopCount > 0; --loopCount) {
                this.embeddedCipher.encrypt(this.register, 0, this.blockSize, this.k, 0);
                for (int i = 0; i < this.blockSize; ++i) {
                    this.register[i] = cipher[i + cipherOffset];
                    plain[i + plainOffset] = (byte)(cipher[i + cipherOffset] ^ this.k[i]);
                }
                plainOffset += this.numBytes;
                cipherOffset += this.numBytes;
            }
            if (oddBytes > 0) {
                this.embeddedCipher.encrypt(this.register, 0, this.blockSize, this.k, 0);
                for (int i = 0; i < oddBytes; ++i) {
                    this.register[i] = cipher[i + cipherOffset];
                    plain[i + plainOffset] = (byte)(cipher[i + cipherOffset] ^ this.k[i]);
                }
            }
        } else {
            while (loopCount > 0) {
                this.embeddedCipher.encrypt(this.register, 0, this.blockSize, this.k, 0);
                System.arraycopy(this.register, this.numBytes, this.register, 0, len);
                for (int i = 0; i < this.numBytes; ++i) {
                    this.register[i + len] = cipher[i + cipherOffset];
                    plain[i + plainOffset] = (byte)(cipher[i + cipherOffset] ^ this.k[i]);
                }
                plainOffset += this.numBytes;
                cipherOffset += this.numBytes;
                --loopCount;
            }
            if (oddBytes != 0) {
                this.embeddedCipher.encrypt(this.register, 0, this.blockSize, this.k, 0);
                System.arraycopy(this.register, this.numBytes, this.register, 0, len);
                for (int i = 0; i < oddBytes; ++i) {
                    this.register[i + len] = cipher[i + cipherOffset];
                    plain[i + plainOffset] = (byte)(cipher[i + cipherOffset] ^ this.k[i]);
                }
            }
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "decrypt");
        }
    }
}

