/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.hdwrCCA.provider;

import com.ibm.crypto.hdwrCCA.provider.AESKey;
import com.ibm.crypto.hdwrCCA.provider.DESedeKey;
import com.ibm.crypto.hdwrCCA.provider.Debug;
import com.ibm.crypto.hdwrCCA.provider.SymmetricKeyConstants;
import com.ibm.crypto.hdwrCCA.provider.TR31OptionalDataBlock;
import java.security.InvalidParameterException;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.SecretKey;
import javax.crypto.spec.OAEPParameterSpec;

public class CCAAlgorithmParameterSpec
implements AlgorithmParameterSpec {
    private static Debug debug = Debug.getInstance("ibmjcecca");
    private static String className = "com.ibm.crypto.hdwrCCA.provider.CCAAlgorithmParameterSpec";
    public static final byte CKDS = 0;
    @Deprecated
    public static final byte PROTECTED = 1;
    public static final byte CLEAR = 2;
    public static final byte SECURE_INTERNAL_TOKEN = 3;
    public static final byte WRAPPING_MODE_DEFAULT = 10;
    public static final byte WRAPPING_MODE_ECB = 11;
    public static final byte WRAPPING_MODE_CBC = 12;
    private int keySize = 0;
    private byte hwType = (byte)3;
    private String keyLabel = null;
    private OAEPParameterSpec oaepSpec = null;
    private byte keyTokenWrapMode = (byte)10;
    private boolean NoCvKEKOption = false;
    TR31OptionalDataBlock[] tr31OptDataBlocks = null;
    private SymmetricKeyConstants.KeyUsage keyUsage = null;
    private SecretKey key2KeyEncryptingKey = null;

    public CCAAlgorithmParameterSpec() {
        this.NoCvKEKOption = false;
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "CCAAlgorithmParameterSpec");
            debug.exit(Debug.TYPE_PUBLIC, className, "CCAAlgorithmParameterSpec");
        }
    }

    public CCAAlgorithmParameterSpec(int size) {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "CCAAlgorithmParameterSpec", new Integer(size));
        }
        this.setKeySize(size);
        this.NoCvKEKOption = false;
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "CCAAlgorithmParameterSpec");
        }
    }

    public CCAAlgorithmParameterSpec(byte hwType) {
        if (debug != null) {
            String typeParm = CCAAlgorithmParameterSpec.parseHwType(hwType);
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "CCAAlgorithmParameterSpec", hwType + " => " + typeParm);
        }
        this.setHwType(hwType);
        this.NoCvKEKOption = false;
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "CCAAlgorithmParameterSpec");
        }
    }

    public CCAAlgorithmParameterSpec(int size, byte hwType) {
        if (debug != null) {
            String typeParm = CCAAlgorithmParameterSpec.parseHwType(hwType);
            debug.entry(Debug.TYPE_PUBLIC, className, "CCAAlgorithmParameterSpec", size, hwType + " => " + typeParm);
        }
        this.setKeySize(size);
        this.setHwType(hwType);
        this.NoCvKEKOption = false;
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "CCAAlgorithmParameterSpec");
        }
    }

    public CCAAlgorithmParameterSpec(int size, byte hwType, String label) {
        if (debug != null) {
            String typeParm = CCAAlgorithmParameterSpec.parseHwType(hwType);
            Object[] parms = new Object[]{size, hwType + " => " + typeParm, label};
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "CCAAlgorithmParameterSpec", parms);
        }
        this.setKeySize(size);
        this.setHwType(hwType);
        this.setLabel(label);
        this.NoCvKEKOption = false;
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "CCAAlgorithmParameterSpec");
        }
    }

    public CCAAlgorithmParameterSpec(byte hwType, String label) {
        if (debug != null) {
            String typeParm = CCAAlgorithmParameterSpec.parseHwType(hwType);
            debug.entry(Debug.TYPE_PUBLIC, className, "CCAAlgorithmParameterSpec", hwType + " => " + typeParm, label);
        }
        this.setHwType(hwType);
        this.setLabel(label);
        this.NoCvKEKOption = false;
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "CCAAlgorithmParameterSpec");
        }
    }

    public CCAAlgorithmParameterSpec(int size, byte hwType, String label, byte wrappingMode) {
        if (debug != null) {
            String typeParm = CCAAlgorithmParameterSpec.parseHwType(hwType);
            String wrapParm = CCAAlgorithmParameterSpec.parseTokenWrappingMode(wrappingMode);
            Object[] parms = new Object[]{size, hwType + " => " + typeParm, label, wrappingMode + " => " + wrapParm};
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "CCAAlgorithmParameterSpec", parms);
        }
        this.setKeySize(size);
        this.setLabel(label);
        this.setHwType(hwType);
        this.setTokenWrappingMode(wrappingMode);
        this.NoCvKEKOption = false;
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "CCAAlgorithmParameterSpec");
        }
    }

    public int getKeySize() {
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getKeySize", this.keySize);
        }
        return this.keySize;
    }

    public void setKeySize(int size) {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "setKeySize", size);
        }
        this.keySize = size;
    }

    public byte getHwType() {
        if (debug != null) {
            String typeParm = CCAAlgorithmParameterSpec.parseHwType(this.hwType);
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getHwType", this.hwType + " => " + typeParm);
        }
        return this.hwType;
    }

    public void setHwType(byte hwTypeVal) {
        if (debug != null) {
            String typeParm = CCAAlgorithmParameterSpec.parseHwType(hwTypeVal);
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "setHwType", hwTypeVal + " => " + typeParm);
        }
        if (hwTypeVal != 1 && hwTypeVal != 3 && hwTypeVal != 0 && hwTypeVal != 2) {
            InvalidParameterException ipe = new InvalidParameterException("hwTypeVal must be CCAAlgorithmParameterSpec.CLEAR, CCAAlgorithmParameterSpec.SECURE_INTERNAL_TOKEN, or CCAAlgorithmParameterSpec.CKDS");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "setHwType", ipe);
            }
            throw ipe;
        }
        this.hwType = hwTypeVal;
    }

    private static final String parseHwType(byte hwTypeVal) {
        switch (hwTypeVal) {
            case 2: {
                return "CLEAR";
            }
            case 1: {
                return "PROTECTED";
            }
            case 3: {
                return "SECURE_INTERNAL_TOKEN";
            }
            case 0: {
                return "CKDS";
            }
        }
        return "Unrecognized value";
    }

    public String getLabel() {
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getLabel", this.keyLabel);
        }
        return this.keyLabel;
    }

    public void setLabel(String label) {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "setLabel", label);
        }
        if (null != label && !"".equals(label) && label.length() > 64) {
            InvalidParameterException ipe = new InvalidParameterException("Label length must be 64 characters or less.");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "setLabel", ipe);
            }
            throw ipe;
        }
        this.keyLabel = label;
    }

    public byte getTokenWrappingMode() {
        if (debug != null) {
            String tokenParm = CCAAlgorithmParameterSpec.parseTokenWrappingMode(this.keyTokenWrapMode);
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getTokenWrappingMode", this.keyTokenWrapMode + " => " + tokenParm);
        }
        return this.keyTokenWrapMode;
    }

    public void setTokenWrappingMode(byte wrappingMode) throws InvalidParameterException {
        if (debug != null) {
            String tokenParm = CCAAlgorithmParameterSpec.parseTokenWrappingMode(wrappingMode);
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "setTokenWrappingMode", wrappingMode + " => " + tokenParm);
        }
        if (wrappingMode == 10) {
            this.keyTokenWrapMode = (byte)10;
        } else if (wrappingMode == 12) {
            this.keyTokenWrapMode = (byte)12;
        } else if (wrappingMode == 11) {
            this.keyTokenWrapMode = (byte)11;
        } else {
            InvalidParameterException ipe = new InvalidParameterException("Key token wrapping mode must be set to WRAPPING_MODE_DEFAULT, WRAPPING_MODE_CBC, or WRAPPING_MODE_ECB.");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "setTokenWrappingMode", ipe);
            }
            throw ipe;
        }
    }

    private static final String parseTokenWrappingMode(byte wrappingMode) {
        switch (wrappingMode) {
            case 10: {
                return "DEFAULT";
            }
            case 12: {
                return "CBC";
            }
            case 11: {
                return "ECB";
            }
        }
        return "Unrecognized value";
    }

    public void setOAEPParameterSpec(OAEPParameterSpec oaepSpec) {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "setOAEPParameterSpec", oaepSpec);
        }
        this.oaepSpec = oaepSpec;
    }

    public OAEPParameterSpec getOAEPParameterSpec() {
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getOAEPParameterSpec", this.oaepSpec);
        }
        return this.oaepSpec;
    }

    public void setNoCvKEK(boolean NoCvKEK) {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "setNoCvKEK", NoCvKEK);
        }
        this.NoCvKEKOption = NoCvKEK;
    }

    public boolean getNoCvKEK() {
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getNoCvKEK", this.NoCvKEKOption);
        }
        return this.NoCvKEKOption;
    }

    public void setTR31OptionalDataBlocks(TR31OptionalDataBlock[] OptData) {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "setTR31OptionalDataBlocks(1)", OptData);
        }
        int numBlocks = 0;
        if (null != OptData) {
            numBlocks = OptData.length;
        }
        this.tr31OptDataBlocks = new TR31OptionalDataBlock[numBlocks];
        for (int idx = 0; idx < numBlocks; ++idx) {
            this.tr31OptDataBlocks[idx] = new TR31OptionalDataBlock(OptData[idx].getOptDataID(), OptData[idx].getOptData());
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "setTR31OptionalDataBlocks(1)");
        }
    }

    public void setTR31OptionalDataBlock(TR31OptionalDataBlock OptData) {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "setTR31OptionalDataBlock", OptData);
        }
        int numBlocks = 0;
        if (null != OptData) {
            numBlocks = 1;
        }
        this.tr31OptDataBlocks = new TR31OptionalDataBlock[numBlocks];
        if (null != OptData) {
            this.tr31OptDataBlocks[0] = new TR31OptionalDataBlock(OptData.getOptDataID(), OptData.getOptData());
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "setTR31OptionalDataBlock");
        }
    }

    public TR31OptionalDataBlock[] getTR31OptionalDataBlocks() {
        TR31OptionalDataBlock[] returnData = null;
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "getTR31OptionalDataBlocks");
        }
        int numBlocks = 0;
        if (null != this.tr31OptDataBlocks) {
            numBlocks = this.tr31OptDataBlocks.length;
        }
        returnData = new TR31OptionalDataBlock[numBlocks];
        for (int idx = 0; idx < numBlocks; ++idx) {
            returnData[idx] = new TR31OptionalDataBlock(this.tr31OptDataBlocks[idx].getOptDataID(), this.tr31OptDataBlocks[idx].getOptData());
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getTR31OptionalDataBlocks", returnData);
        }
        return returnData;
    }

    public void setKeyUsage(SymmetricKeyConstants.KeyUsage keyUsage) {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "setKeyUsage", (Object)keyUsage);
        }
        this.keyUsage = keyUsage;
    }

    public SymmetricKeyConstants.KeyUsage getKeyUsage() {
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getKeyUsage", (Object)this.keyUsage);
        }
        return this.keyUsage;
    }

    public void setKey2KeyEncryptingKey(SecretKey key2KeyEncryptingKey) {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "setKey2KeyEncryptingKey", key2KeyEncryptingKey);
        }
        CCAAlgorithmParameterSpec.checkKeyEncryptingKey(key2KeyEncryptingKey);
        this.key2KeyEncryptingKey = key2KeyEncryptingKey;
    }

    public SecretKey getKey2KeyEncryptingKey() {
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getKey2KeyEncryptingKey", this.key2KeyEncryptingKey);
        }
        return this.key2KeyEncryptingKey;
    }

    protected boolean isSecureInternalToken() {
        boolean isSecureInternalToken;
        if (debug != null) {
            debug.entry(8192L, (Object)className, "isSecureInternalToken", this.hwType);
        }
        boolean bl = isSecureInternalToken = this.hwType == 3 || this.hwType == 1;
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "isSecureInternalToken", isSecureInternalToken);
        }
        return isSecureInternalToken;
    }

    private static final void checkKeyEncryptingKey(SecretKey key) {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "checkKeyEncryptingKey", key);
        }
        if (key != null && !(key instanceof DESedeKey) && !(key instanceof AESKey)) {
            InvalidParameterException ipe = new InvalidParameterException("Key Encrypting Key must be an instance of com.ibm.crypto.hdwrCCA.provider.DESedeKey or com.ibm.crypto.hdwrCCA.provider.AESKey");
            if (debug != null) {
                debug.exception(8192L, className, "checkKeyEncryptingKey", ipe);
                debug.exit(8192L, className, "checkKeyEncryptingKey");
            }
            throw ipe;
        }
        if (key != null && "RAW".equals(key.getFormat())) {
            InvalidParameterException ipe = new InvalidParameterException("Key Encrypting Key must be a SECURE_INTERNAL_TOKEN or CKDS key");
            if (debug != null) {
                debug.exception(8192L, className, "checkKeyEncryptingKey", ipe);
                debug.exit(8192L, className, "checkKeyEncryptingKey");
            }
            throw ipe;
        }
        if (debug != null) {
            debug.exit(8192L, className, "checkKeyEncryptingKey");
        }
    }
}

