/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.hdwrCCA.provider;

import com.ibm.crypto.hdwrCCA.provider.AESKey;
import com.ibm.crypto.hdwrCCA.provider.CCAAlgorithmParameterSpec;
import com.ibm.crypto.hdwrCCA.provider.DESKey;
import com.ibm.crypto.hdwrCCA.provider.DESedeKey;
import com.ibm.crypto.hdwrCCA.provider.Debug;
import com.ibm.crypto.hdwrCCA.provider.HardwareProfile;
import com.ibm.crypto.hdwrCCA.provider.IBMJCECCA;
import com.ibm.crypto.hdwrCCA.provider.PlatformUtilities;
import com.ibm.crypto.hdwrCCA.provider.SymmetricKeyConstants;
import com.ibm.crypto.hdwrCCA.provider.SymmetricKeyUtils;
import com.ibm.crypto.hdwrCCA.provider.SymmetricKeyWrap;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;

public final class AESKeyWrap
extends SymmetricKeyWrap {
    private static final int AES_BLOCK_SIZE_BYTES = 16;
    private static final int MAX_WRAP_OUTPUT_SIZE = 900;
    private static final int MAX_UNWRAP_OUTPUT_SIZE = 725;
    private SymmetricKeyWrap.CipherState state = SymmetricKeyWrap.CipherState.UNINITIALIZED;
    private Key transportKey = null;
    private SymmetricKeyConstants.KeyType unwrapKeyType = DEFAULT_UNWRAP_KEY_TYPE;
    private String unwrapLabel = null;
    private static Debug debug = Debug.getInstance("ibmjcecca");
    private static String className = "com.ibm.crypto.hdwrCCA.provider.AESKeyWrap";

    public AESKeyWrap() {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "AESKeyWrap");
        }
        IBMJCECCA.verifyJceJar();
        if (!IBMJCECCA.verifySelfIntegrity(this.getClass())) {
            SecurityException se = new SecurityException("The IBMJCECCA provider may have been tampered.");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "AESKeyWrap", se);
                debug.exit(Debug.TYPE_FINE, className, "AESKeyWrap");
            }
            throw se;
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "AESKeyWrap");
        }
    }

    @Override
    protected int engineGetBlockSize() {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "engineGetBlockSize");
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineGetBlockSize", 16);
        }
        return 16;
    }

    @Override
    protected int engineGetOutputSize(int inputLen) {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineGetOutputSize", inputLen);
        }
        int outputSize = 900;
        if (this.state == SymmetricKeyWrap.CipherState.UNWRAP) {
            outputSize = 725;
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineGetOutputSize", outputSize);
        }
        return outputSize;
    }

    @Override
    protected int engineGetKeySize(Key key) {
        int keySize;
        block4: {
            if (debug != null) {
                debug.entry(Debug.TYPE_FINE, (Object)className, "engineGetKeySize", key);
            }
            keySize = 128;
            try {
                keySize = Cipher.getMaxAllowedKeyLength("AES");
            }
            catch (NoSuchAlgorithmException e) {
                if (debug == null) break block4;
                debug.exception(Debug.TYPE_PUBLIC, className, "engineGetKeySize", e);
            }
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineGetKeySize", keySize);
        }
        return keySize;
    }

    @Override
    protected void engineInit(int opmode, Key key, SecureRandom random) throws InvalidKeyException {
        if (debug != null) {
            Object[] parms = new Object[]{opmode, key, random};
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineInit", parms);
        }
        try {
            AESKeyWrap.checkEngineInitParameters(opmode, key, null, random);
        }
        catch (InvalidAlgorithmParameterException parms) {
            // empty catch block
        }
        if (!(key instanceof AESKey)) {
            InvalidKeyException ike = new InvalidKeyException("Key must be an instance of com.ibm.crypto.hdwrCCA.provider.AESKey");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineInit", ike);
                debug.exit(Debug.TYPE_FINE, className, "engineInit");
            }
            throw ike;
        }
        this.state = opmode == 3 ? SymmetricKeyWrap.CipherState.WRAP : SymmetricKeyWrap.CipherState.UNWRAP;
        this.transportKey = key;
        this.unwrapKeyType = DEFAULT_UNWRAP_KEY_TYPE;
        this.unwrapLabel = null;
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "engineInit");
        }
    }

    @Override
    protected void engineInit(int opmode, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (debug != null) {
            Object[] parms = new Object[]{opmode, key, params, random};
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineInit", parms);
        }
        AESKeyWrap.checkEngineInitParameters(opmode, key, params, random);
        if (!(key instanceof AESKey)) {
            InvalidKeyException ike = new InvalidKeyException("Key must be an instance of com.ibm.crypto.hdwrCCA.provider.AESKey");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineInit", ike);
                debug.exit(Debug.TYPE_FINE, className, "engineInit");
            }
            throw ike;
        }
        this.state = opmode == 3 ? SymmetricKeyWrap.CipherState.WRAP : SymmetricKeyWrap.CipherState.UNWRAP;
        this.transportKey = key;
        this.unwrapKeyType = DEFAULT_UNWRAP_KEY_TYPE;
        this.unwrapLabel = null;
        CCAAlgorithmParameterSpec spec = (CCAAlgorithmParameterSpec)params;
        if (spec != null) {
            byte hwType = spec.getHwType();
            this.unwrapKeyType = SymmetricKeyConstants.KeyType.valueOfOrDefault(hwType, DEFAULT_UNWRAP_KEY_TYPE);
            this.unwrapLabel = spec.getLabel();
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "engineInit");
        }
    }

    @Override
    protected void engineInit(int opmode, Key key, AlgorithmParameters params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (debug != null) {
            Object[] parms = new Object[]{opmode, key, params, random};
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineInit", parms);
        }
        CCAAlgorithmParameterSpec spec = null;
        if (params != null) {
            try {
                spec = params.getParameterSpec(CCAAlgorithmParameterSpec.class);
            }
            catch (InvalidParameterSpecException ipse) {
                InvalidAlgorithmParameterException iape = new InvalidAlgorithmParameterException("Algorithm parameters not compatible or supported", ipse);
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, "engineInit", iape);
                    debug.exit(Debug.TYPE_FINE, className, "engineInit");
                }
                throw iape;
            }
        }
        AESKeyWrap.checkEngineInitParameters(opmode, key, spec, random);
        if (!(key instanceof AESKey)) {
            InvalidKeyException ike = new InvalidKeyException("Key must be an instance of com.ibm.crypto.hdwrCCA.provider.AESKey");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineInit", ike);
                debug.exit(Debug.TYPE_FINE, className, "engineInit");
            }
            throw ike;
        }
        this.state = opmode == 3 ? SymmetricKeyWrap.CipherState.WRAP : SymmetricKeyWrap.CipherState.UNWRAP;
        this.transportKey = key;
        this.unwrapKeyType = DEFAULT_UNWRAP_KEY_TYPE;
        this.unwrapLabel = null;
        if (spec != null) {
            byte hwType = spec.getHwType();
            this.unwrapKeyType = SymmetricKeyConstants.KeyType.valueOfOrDefault(hwType, DEFAULT_UNWRAP_KEY_TYPE);
            this.unwrapLabel = spec.getLabel();
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "engineInit");
        }
    }

    @Override
    protected byte[] engineWrap(Key key) throws InvalidKeyException {
        byte[] token;
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineWrap", key);
        }
        if (key == null) {
            NullPointerException npe = new NullPointerException("Key is null");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineWrap", npe);
                debug.exit(Debug.TYPE_FINE, className, "engineWrap");
            }
            throw npe;
        }
        if (key.getFormat().equals("RAW")) {
            InvalidKeyException ike = new InvalidKeyException("Key must be a SECURE_INTERNAL_TOKEN or CKDS key");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineWrap", ike);
                debug.exit(Debug.TYPE_FINE, className, "engineWrap");
            }
            throw ike;
        }
        if (this.state != SymmetricKeyWrap.CipherState.WRAP) {
            IllegalStateException ise = new IllegalStateException("Cipher not initialized for wrap operation mode");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineWrap", ise);
                debug.exit(Debug.TYPE_FINE, className, "engineWrap");
            }
            throw ise;
        }
        if (key instanceof AESKey) {
            token = this.wrapAESKey((SecretKey)key);
        } else if (key instanceof DESKey || key instanceof DESedeKey) {
            token = this.wrapDESKey((SecretKey)key);
        } else {
            InvalidKeyException ike = new InvalidKeyException("Key must be instance of com.ibm.crypto.hdwrCCA.provider.AESKey, com.ibm.crypto.hdwrCCA.provider.DESKey, or com.ibm.crypto.hdwrCCA.provider.DESedeKey");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineWrap", ike);
                debug.exit(Debug.TYPE_FINE, className, "engineWrap");
            }
            throw ike;
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineWrap", token);
        }
        return token;
    }

    private final byte[] wrapAESKey(SecretKey key) {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "wrapAESKey", key);
        }
        byte[] internalToken = null;
        if (key.getFormat().equals("CKDSLabel")) {
            try {
                internalToken = SymmetricKeyUtils.readCKDSEntry(key);
            }
            catch (InvalidKeyException ike) {
                if (debug != null) {
                    debug.exception(8192L, className, "wrapAESKey", ike);
                }
            }
        } else {
            internalToken = key.getEncoded();
        }
        if (SymmetricKeyUtils.isAESInternalDataKeyToken(internalToken)) {
            byte[] cipherToken = SymmetricKeyUtils.convertAESDataTokenToAESCipherToken(internalToken);
            Arrays.fill(internalToken, (byte)0);
            internalToken = cipherToken;
        }
        int ruleArrayCount = 2;
        String ruleArray = "AES     AESKW   ";
        byte[] wrappingTokenOrLabel = this.transportKey.getEncoded();
        byte[] externalToken = null;
        if (PlatformUtilities.isLinux() && this.transportKey.getFormat().equals("CKDSLabel")) {
            wrappingTokenOrLabel = PlatformUtilities.convertBytesETOA(wrappingTokenOrLabel);
        }
        externalToken = SymmetricKeyUtils.symmetricKeyExport(ruleArrayCount, ruleArray, internalToken, wrappingTokenOrLabel);
        if (debug != null) {
            debug.exit(8192L, (Object)className, "wrapAESKey", externalToken);
        }
        return externalToken;
    }

    private final byte[] wrapDESKey(SecretKey key) throws InvalidKeyException {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "wrapDESKey", key);
        }
        if (!HardwareProfile.getIsHCR77A1OrLaterPresent()) {
            InvalidKeyException ike = new InvalidKeyException("Wrapping of hardware DES or Triple-DES keys with AES key encrypting keys is only supported on HCR77A1 or later versions");
            if (debug != null) {
                debug.exception(8192L, className, "wrapDESKey", ike);
                debug.exit(8192L, className, "wrapDESKey");
            }
            throw ike;
        }
        int ruleArrayCount = 2;
        String ruleArray = "DES     AESKWCV ";
        byte[] tokenOrLabel = key.getEncoded();
        byte[] wrappingTokenOrLabel = this.transportKey.getEncoded();
        byte[] externalToken = null;
        if (PlatformUtilities.isLinux()) {
            if (key.getFormat().equals("CKDSLabel")) {
                tokenOrLabel = PlatformUtilities.convertBytesETOA(tokenOrLabel);
            }
            if (this.transportKey.getFormat().equals("CKDSLabel")) {
                wrappingTokenOrLabel = PlatformUtilities.convertBytesETOA(wrappingTokenOrLabel);
            }
        }
        externalToken = SymmetricKeyUtils.symmetricKeyExport(ruleArrayCount, ruleArray, tokenOrLabel, wrappingTokenOrLabel);
        if (debug != null) {
            debug.exit(8192L, (Object)className, "wrapDESKey", externalToken);
        }
        return externalToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    protected Key engineUnwrap(byte[] wrappedKey, String wrappedKeyAlgorithm, int wrappedKeyType) throws InvalidKeyException {
        if (AESKeyWrap.debug != null) {
            parms = new Object[]{wrappedKey, wrappedKeyAlgorithm, wrappedKeyType};
            AESKeyWrap.debug.entry(Debug.TYPE_FINE, (Object)AESKeyWrap.className, "engineUnwrap", parms);
        }
        if (wrappedKey == null) {
            npe = new NullPointerException("Wrapped key is null");
            if (AESKeyWrap.debug != null) {
                AESKeyWrap.debug.exception(Debug.TYPE_PUBLIC, AESKeyWrap.className, "engineUnwrap", npe);
                AESKeyWrap.debug.exit(Debug.TYPE_FINE, AESKeyWrap.className, "engineUnwrap");
            }
            throw npe;
        }
        if (wrappedKeyType != 3) {
            ike = new InvalidKeyException("Wrapped key type must be SECRET_KEY");
            if (AESKeyWrap.debug != null) {
                AESKeyWrap.debug.exception(Debug.TYPE_PUBLIC, AESKeyWrap.className, "engineUnwrap", ike);
                AESKeyWrap.debug.exit(Debug.TYPE_FINE, AESKeyWrap.className, "engineUnwrap");
            }
            throw ike;
        }
        if (this.state != SymmetricKeyWrap.CipherState.UNWRAP) {
            ise = new IllegalStateException("Cipher not initialized for unwrap operation mode");
            if (AESKeyWrap.debug != null) {
                AESKeyWrap.debug.exception(Debug.TYPE_PUBLIC, AESKeyWrap.className, "engineUnwrap", ise);
                AESKeyWrap.debug.exit(Debug.TYPE_FINE, AESKeyWrap.className, "engineUnwrap");
            }
            throw ise;
        }
        if ("AES".equalsIgnoreCase(wrappedKeyAlgorithm)) {
            internalToken = this.unwrapAESKey(wrappedKey);
            try {
                key /* !! */  = new AESKey("ICSFToken", internalToken);
                if (this.unwrapKeyType != SymmetricKeyConstants.KeyType.CKDS) ** GOTO lbl60
                actualLabel = SymmetricKeyUtils.storeProtectedKeyInCKDS(key /* !! */ , this.unwrapLabel);
                key /* !! */  = AESKey.newLabelKey(actualLabel);
            }
            finally {
                Arrays.fill(internalToken, (byte)0);
            }
        } else if ("DES".equalsIgnoreCase(wrappedKeyAlgorithm)) {
            internalToken = this.unwrapDESKey(wrappedKey);
            try {
                key /* !! */  = new DESKey("ICSFToken", internalToken);
                if (this.unwrapKeyType != SymmetricKeyConstants.KeyType.CKDS) ** GOTO lbl60
                actualLabel = SymmetricKeyUtils.storeProtectedKeyInCKDS(key /* !! */ , this.unwrapLabel);
                key /* !! */  = DESKey.newLabelKey(actualLabel);
            }
            finally {
                Arrays.fill(internalToken, (byte)0);
            }
        } else if ("DESede".equalsIgnoreCase(wrappedKeyAlgorithm) || "TripleDES".equalsIgnoreCase(wrappedKeyAlgorithm) || "3DES".equalsIgnoreCase(wrappedKeyAlgorithm)) {
            internalToken = this.unwrapDESKey(wrappedKey);
            try {
                key /* !! */  = new DESedeKey("ICSFToken", internalToken);
                if (this.unwrapKeyType != SymmetricKeyConstants.KeyType.CKDS) ** GOTO lbl60
                actualLabel = SymmetricKeyUtils.storeProtectedKeyInCKDS(key /* !! */ , this.unwrapLabel);
                key /* !! */  = DESedeKey.newLabelKey(actualLabel);
            }
            finally {
                Arrays.fill(internalToken, (byte)0);
            }
        } else {
            ike = new InvalidKeyException("Wrapped key algorithm must be DES, DESede, or AES");
            if (AESKeyWrap.debug != null) {
                AESKeyWrap.debug.exception(Debug.TYPE_PUBLIC, AESKeyWrap.className, "engineUnwrap", ike);
                AESKeyWrap.debug.exit(Debug.TYPE_FINE, AESKeyWrap.className, "engineUnwrap");
            }
            throw ike;
        }
lbl60:
        // 6 sources

        if (AESKeyWrap.debug != null) {
            AESKeyWrap.debug.exit(Debug.TYPE_FINE, (Object)AESKeyWrap.className, "engineUnwrap", key /* !! */ );
        }
        return key /* !! */ ;
    }

    private final byte[] unwrapAESKey(byte[] wrappedKey) {
        byte[] internalToken;
        if (debug != null) {
            debug.entry(8192L, (Object)className, "unwrapAESKey", (Object)wrappedKey);
        }
        int ruleArrayCount = 2;
        String ruleArray = "AES     AESKW   ";
        byte[] unwrappingTokenOrLabel = this.transportKey.getEncoded();
        if (PlatformUtilities.isLinux() && this.transportKey.getFormat().equals("CKDSLabel")) {
            unwrappingTokenOrLabel = PlatformUtilities.convertBytesETOA(unwrappingTokenOrLabel);
        }
        if (SymmetricKeyUtils.isAESInternalCipherKeyToken(internalToken = SymmetricKeyUtils.symmetricKeyImport2(ruleArrayCount, ruleArray, wrappedKey, unwrappingTokenOrLabel))) {
            byte[] dataToken = SymmetricKeyUtils.convertAESCipherTokenToAESDataToken(internalToken);
            Arrays.fill(internalToken, (byte)0);
            internalToken = dataToken;
        }
        if (debug != null) {
            debug.exit(8192L, (Object)className, "unwrapAESKey", internalToken);
        }
        return internalToken;
    }

    private final byte[] unwrapDESKey(byte[] wrappedKey) throws InvalidKeyException {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "unwrapDESKey", (Object)wrappedKey);
        }
        if (!HardwareProfile.getIsHCR77A1OrLaterPresent()) {
            InvalidKeyException ike = new InvalidKeyException("Unwrapping of hardware DES or Triple-DES keys with AES key encrypting keys is only supported on HCR77A1 or later versions");
            if (debug != null) {
                debug.exception(8192L, className, "unwrapDESKey", ike);
                debug.exit(8192L, className, "unwrapDESKey");
            }
            throw ike;
        }
        int ruleArrayCount = 2;
        String ruleArray = "DES     AESKWCV ";
        byte[] unwrappingTokenOrLabel = this.transportKey.getEncoded();
        if (PlatformUtilities.isLinux() && this.transportKey.getFormat().equals("CKDSLabel")) {
            unwrappingTokenOrLabel = PlatformUtilities.convertBytesETOA(unwrappingTokenOrLabel);
        }
        byte[] internalToken = SymmetricKeyUtils.symmetricKeyImport2(ruleArrayCount, ruleArray, wrappedKey, unwrappingTokenOrLabel);
        if (debug != null) {
            debug.exit(8192L, (Object)className, "unwrapDESKey", internalToken);
        }
        return internalToken;
    }
}

