/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.hdwrCCA.provider;

import java.security.InvalidKeyException;
import java.security.spec.KeySpec;

public class AESKeySpec
implements KeySpec {
    private byte[] key;
    private String type;

    public AESKeySpec(byte[] key) throws InvalidKeyException {
        this(key, 0, key.length, "RAW");
    }

    public AESKeySpec(byte[] key, String type) throws InvalidKeyException {
        this(key, 0, key.length, type);
    }

    public AESKeySpec(byte[] key, int offset, int len) throws InvalidKeyException {
        this(key, offset, len, "RAW");
    }

    public AESKeySpec(byte[] key, int offset, int len, String type) throws InvalidKeyException {
        if (key == null) {
            throw new InvalidKeyException("Missing key");
        }
        if (key.length == 0) {
            throw new InvalidKeyException("Empty key");
        }
        if (key.length - offset < len) {
            throw new InvalidKeyException("Invalid offset/length combination");
        }
        if (!("RAW".equals(type) || "CKDSLabel".equals(type) || "ICSFToken".equals(type))) {
            throw new InvalidKeyException("Invalid type. Must be one of RAW, CKDSLabel, or ICSFToken.");
        }
        this.type = type;
        if ("RAW".equals(type) && len != 16 && len != 24 && len != 32) {
            throw new InvalidKeyException("Invalid length: use 16, 24, or 32");
        }
        this.key = new byte[len];
        System.arraycopy(key, offset, this.key, 0, len);
    }

    public byte[] getKey() {
        return (byte[])this.key.clone();
    }

    public String getType() {
        return this.type;
    }
}

