/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.hdwrCCA.provider;

import com.ibm.crypto.hdwrCCA.provider.AESKey;
import com.ibm.crypto.hdwrCCA.provider.CCAAlgorithmParameterSpec;
import com.ibm.crypto.hdwrCCA.provider.Debug;
import com.ibm.crypto.hdwrCCA.provider.HIKM;
import com.ibm.crypto.hdwrCCA.provider.HardwareProfile;
import com.ibm.crypto.hdwrCCA.provider.HexDumpEncoder;
import com.ibm.crypto.hdwrCCA.provider.IBMJCECCA;
import com.ibm.crypto.hdwrCCA.provider.JCECCARuntimeException;
import com.ibm.crypto.hdwrCCA.provider.PlatformUtilities;
import com.ibm.crypto.hdwrCCA.provider.SymmetricKeyConstants;
import com.ibm.crypto.hdwrCCA.provider.SymmetricKeyUtils;
import com.ibm.crypto.hdwrCCA.provider.TokenPair;
import com.ibm.crypto.hdwrCCA.provider.hikmNativeInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import javax.crypto.KeyGeneratorSpi;
import javax.crypto.SecretKey;

public final class AESKeyGenerator
extends KeyGeneratorSpi {
    private static final int DEFAULT_AES_KEYSIZE = 128;
    private static final SymmetricKeyConstants.KeyUsage DEFAULT_AES_KEY_USAGE = SymmetricKeyConstants.KeyUsage.OP_DATA;
    private SecureRandom random = null;
    private int keysize = 128;
    private boolean genHWkeyToken = false;
    private boolean generatePairOfKeys = false;
    private SymmetricKeyConstants.KeyUsage keyUsage = null;
    private boolean canBeStored = true;
    private boolean storeKey1InCKDS = false;
    private String key1CKDSLabel = null;
    private SecretKey key2EncryptingKey = null;
    private static Debug debug = Debug.getInstance("ibmjcecca");
    private static String className = "com.ibm.crypto.hdwrCCA.provider.AESKeyGenerator";

    public AESKeyGenerator() {
        if (!IBMJCECCA.verifySelfIntegrity(this.getClass())) {
            throw new SecurityException("The IBMJCECCA provider may have been tampered.");
        }
    }

    @Override
    protected void engineInit(SecureRandom random) {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineInit", random);
        }
        this.random = random;
        this.keysize = 128;
        this.genHWkeyToken = false;
        this.generatePairOfKeys = false;
        this.keyUsage = null;
        this.canBeStored = true;
        this.storeKey1InCKDS = false;
        this.key1CKDSLabel = null;
        this.key2EncryptingKey = null;
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "engineInit");
        }
    }

    @Override
    protected void engineInit(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        SymmetricKeyConstants.KeyUsage specKeyUsage;
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "engineInit", params, random);
        }
        if (!(params instanceof CCAAlgorithmParameterSpec)) {
            InvalidAlgorithmParameterException iape = new InvalidAlgorithmParameterException("AES key generation parameter spec must be a CCAAlgorithmParameterSpec.");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineInit", iape);
                debug.exit(Debug.TYPE_FINE, className, "engineInit");
            }
            throw iape;
        }
        CCAAlgorithmParameterSpec paramSpec = (CCAAlgorithmParameterSpec)params;
        int specKeySize = paramSpec.getKeySize();
        if (specKeySize == 0) {
            specKeySize = 128;
        }
        if ((specKeyUsage = paramSpec.getKeyUsage()) == null) {
            specKeyUsage = DEFAULT_AES_KEY_USAGE;
        }
        byte specKeyType = paramSpec.getHwType();
        byte specWrappingMode = paramSpec.getTokenWrappingMode();
        SecretKey specKey2KEK = paramSpec.getKey2KeyEncryptingKey();
        if (specWrappingMode != 10) {
            RuntimeException e = new RuntimeException("Only the WRAPPING_MODE_DEFAULT wrapping mode can be used within the CCAAlgorithmParameterSpec for the AES key generator.");
            if (null != debug) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineInit", e);
                debug.exit(Debug.TYPE_FINE, className, "engineInit");
            }
            throw e;
        }
        if (paramSpec.isSecureInternalToken()) {
            this.random = null;
            this.keysize = specKeySize;
            this.genHWkeyToken = true;
            this.keyUsage = specKeyUsage;
            this.canBeStored = true;
            this.storeKey1InCKDS = false;
            this.key1CKDSLabel = null;
            switch (this.keyUsage) {
                case OPEX_EXPORTER_IMPORTER: 
                case OPEX_IMPORTER_EXPORTER: {
                    this.generatePairOfKeys = true;
                    this.key2EncryptingKey = AESKeyGenerator.checkKeyEncryptingKey(specKey2KEK);
                    break;
                }
                case OP_DATA: {
                    this.generatePairOfKeys = false;
                    this.key2EncryptingKey = null;
                    break;
                }
                default: {
                    InvalidParameterException ipe = new InvalidParameterException("Not a supported key usage: " + (Object)((Object)specKeyUsage));
                    if (debug != null) {
                        debug.exception(Debug.TYPE_PUBLIC, className, "engineInit", ipe);
                        debug.exit(Debug.TYPE_FINE, className, "engineInit");
                    }
                    throw ipe;
                }
            }
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineInit", "A CCAAlgorithmParameterSpec is specified, keyType is SECURE_INTERNAL_TOKEN. \nThe AES key will be generated as a secret hardware key.");
            }
        } else if (specKeyType == 0) {
            this.random = null;
            this.keysize = specKeySize;
            this.genHWkeyToken = true;
            this.keyUsage = specKeyUsage;
            this.canBeStored = true;
            this.storeKey1InCKDS = true;
            this.key1CKDSLabel = paramSpec.getLabel();
            switch (this.keyUsage) {
                case OPEX_EXPORTER_IMPORTER: 
                case OPEX_IMPORTER_EXPORTER: {
                    this.generatePairOfKeys = true;
                    this.key2EncryptingKey = AESKeyGenerator.checkKeyEncryptingKey(specKey2KEK);
                    break;
                }
                case OP_DATA: {
                    this.generatePairOfKeys = false;
                    this.key2EncryptingKey = null;
                    break;
                }
                default: {
                    InvalidParameterException ipe = new InvalidParameterException("Not a supported key usage: " + (Object)((Object)specKeyUsage));
                    if (debug != null) {
                        debug.exception(Debug.TYPE_PUBLIC, className, "engineInit", ipe);
                        debug.exit(Debug.TYPE_FINE, className, "engineInit");
                    }
                    throw ipe;
                }
            }
            if (debug != null) {
                String labelInfo = "A CKDS label will be generated for the new entry.";
                if (null != this.key1CKDSLabel && !"".equals(this.key1CKDSLabel)) {
                    labelInfo = "The following user-specified CKDS label will be used: " + this.key1CKDSLabel;
                }
                debug.text(Debug.TYPE_PUBLIC, className, "engineInit", "A CCAAlgorithmParameterSpec is specified, keyType is CKDS. \nThe AES key will be generated as a secret hardware key and stored in the CKDS. \n" + labelInfo);
            }
        } else {
            this.random = random;
            this.keysize = specKeySize;
            this.genHWkeyToken = false;
            this.generatePairOfKeys = false;
            this.keyUsage = null;
            this.canBeStored = true;
            this.storeKey1InCKDS = false;
            this.key1CKDSLabel = null;
            this.key2EncryptingKey = null;
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineInit", "A CCAAlgorithmParameterSpec is specified, keyType is CLEAR. \nThe AES key will be generated as a clear key.");
            }
        }
        if (specKeySize != 128 && specKeySize != 192 && specKeySize != 256) {
            InvalidParameterException ipe = new InvalidParameterException("Wrong keysize: must be equal to 128, 192, or 256");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineInit", ipe);
                debug.exit(Debug.TYPE_FINE, className, "engineInit");
            }
            throw ipe;
        }
        if (null != random && this.genHWkeyToken) {
            InvalidAlgorithmParameterException iape = new InvalidAlgorithmParameterException("It is not valid to specify a source of randomness for a secret hardware AES key.");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineInit", iape);
                debug.exit(Debug.TYPE_FINE, className, "engineInit");
            }
            throw iape;
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "engineInit");
        }
    }

    @Override
    protected void engineInit(int keysize, SecureRandom random) {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "engineInit", keysize, random);
        }
        if (keysize != 128 && keysize != 192 && keysize != 256) {
            InvalidParameterException ipe = new InvalidParameterException("Keysize must be equal to 128, 192 or 256");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineInit", ipe);
                debug.exit(Debug.TYPE_FINE, className, "engineInit");
            }
            throw ipe;
        }
        this.engineInit(random);
        this.keysize = keysize;
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "engineInit");
        }
    }

    private static final SecretKey checkKeyEncryptingKey(SecretKey keyEncryptingKey) {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "checkKeyEncryptingKey", keyEncryptingKey);
        }
        if (keyEncryptingKey == null) {
            InvalidParameterException ipe = new InvalidParameterException("A Key Encrypting Key is required");
            if (debug != null) {
                debug.exception(8192L, className, "checkKeyEncryptingKey", ipe);
                debug.exit(8192L, className, "checkKeyEncryptingKey");
            }
            throw ipe;
        }
        if (!(keyEncryptingKey instanceof AESKey)) {
            InvalidParameterException ipe = new InvalidParameterException("The Key Encrypting Key must be an instance of com.ibm.crypto.hdwrCCA.provider.AESKey");
            if (debug != null) {
                debug.exception(8192L, className, "checkKeyEncryptingKey", ipe);
                debug.exit(8192L, className, "checkKeyEncryptingKey");
            }
            throw ipe;
        }
        if (keyEncryptingKey.getFormat().equalsIgnoreCase("RAW")) {
            InvalidParameterException ipe = new InvalidParameterException("The Key Encrypting Key must be a hardware key");
            if (debug != null) {
                debug.exception(8192L, className, "checkKeyEncryptingKey", ipe);
                debug.exit(8192L, className, "checkKeyEncryptingKey");
            }
            throw ipe;
        }
        if (debug != null) {
            debug.exit(8192L, (Object)className, "checkKeyEncryptingKey", keyEncryptingKey);
        }
        return keyEncryptingKey;
    }

    @Override
    protected SecretKey engineGenerateKey() {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "engineGenerateKey");
        }
        AESKey aesKey = null;
        if (this.genHWkeyToken) {
            if (this.generatePairOfKeys) {
                TokenPair pairOfTokens = this.generatePairOfICSFTokens();
                byte[] primaryToken = pairOfTokens.getPrimaryToken();
                byte[] secondaryToken = pairOfTokens.getSecondaryToken();
                try {
                    aesKey = new AESKey("ICSFToken", primaryToken, secondaryToken);
                }
                catch (InvalidKeyException ike) {
                    if (debug != null) {
                        debug.exception(Debug.TYPE_PUBLIC, className, "engineGenerateKey", ike);
                        debug.exit(Debug.TYPE_FINE, className, "engineGenerateKey");
                    }
                    throw new RuntimeException("Key type: ICSFToken. " + ike.getMessage(), ike);
                }
                finally {
                    Arrays.fill(primaryToken, (byte)0);
                    Arrays.fill(secondaryToken, (byte)0);
                }
                if (this.storeKey1InCKDS) {
                    try {
                        String actualLabel = SymmetricKeyUtils.storeProtectedKeyInCKDS(aesKey, this.key1CKDSLabel);
                        aesKey = AESKey.newLabelKeyWithPairedToken(actualLabel, aesKey.getPairedExternalToken());
                    }
                    catch (InvalidKeyException ike) {
                        if (debug != null) {
                            debug.exception(Debug.TYPE_PUBLIC, className, "engineGenerateKey", ike);
                            debug.exit(Debug.TYPE_FINE, className, "engineGenerateKey");
                        }
                        throw new RuntimeException("Key type: CKDSLabel. " + ike.getMessage(), ike);
                    }
                }
            } else {
                byte[] token = this.generateHWKeyToken();
                boolean canStoreInKeyStore = this.canBeStored;
                this.canBeStored = true;
                try {
                    aesKey = new AESKey("ICSFToken", token);
                    aesKey.setCanBeStored(canStoreInKeyStore);
                }
                catch (InvalidKeyException ike) {
                    if (debug != null) {
                        debug.exception(Debug.TYPE_PUBLIC, className, "engineGenerateKey", ike);
                        debug.exit(Debug.TYPE_FINE, className, "engineGenerateKey");
                    }
                    throw new RuntimeException("Key type: ICSFToken    " + ike.getMessage(), ike);
                }
                finally {
                    Arrays.fill(token, (byte)0);
                }
                if (this.storeKey1InCKDS) {
                    try {
                        String actualLabel = SymmetricKeyUtils.storeProtectedKeyInCKDS(aesKey, this.key1CKDSLabel);
                        aesKey = AESKey.newLabelKey(actualLabel);
                    }
                    catch (Exception ex) {
                        if (debug != null) {
                            debug.exception(Debug.TYPE_PUBLIC, className, "engineGenerateKey", ex);
                            debug.exit(Debug.TYPE_FINE, className, "engineGenerateKey");
                        }
                        throw new RuntimeException("Error storing key " + this.key1CKDSLabel + " in the CKDS. " + ex.getMessage(), ex);
                    }
                }
            }
        } else {
            if (this.random == null) {
                try {
                    this.random = SecureRandom.getInstance("IBMSecureRandom", "IBMJCECCA");
                }
                catch (NoSuchAlgorithmException | NoSuchProviderException e) {
                    if (debug != null) {
                        debug.exception(Debug.TYPE_PUBLIC, className, "engineGenerateKey", e);
                    }
                    this.random = new SecureRandom();
                }
            }
            byte[] key = new byte[this.keysize / 8];
            this.random.nextBytes(key);
            try {
                aesKey = new AESKey(key);
            }
            catch (InvalidKeyException ex) {
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, "engineGenerateKey", ex);
                    debug.exit(Debug.TYPE_FINE, className, "engineGenerateKey");
                }
                throw new RuntimeException(ex.getMessage());
            }
            finally {
                Arrays.fill(key, (byte)0);
            }
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineGenerateKey", aesKey);
        }
        return aesKey;
    }

    private byte[] generateHWKeyToken() {
        String kekKeyId2String;
        String kekKeyId1String;
        String exitDataString;
        HexDumpEncoder encoder = null;
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "generateHWKeyToken");
            encoder = new HexDumpEncoder();
        }
        HIKM hikm = new HIKM();
        hikmNativeInteger returnCode = new hikmNativeInteger(0);
        hikmNativeInteger reasonCode = new hikmNativeInteger(0);
        hikmNativeInteger exitDataLength = new hikmNativeInteger(0);
        byte[] exitData = new byte[]{};
        byte[] kekKeyId1 = new byte[64];
        byte[] kekKeyId2 = new byte[64];
        byte[] keyForm = PlatformUtilities.getBytesPlatform("OP  ");
        byte[] keyLength = this.keysize == 256 ? PlatformUtilities.getBytesPlatform("KEYLN32 ") : (this.keysize == 192 ? PlatformUtilities.getBytesPlatform("KEYLN24 ") : PlatformUtilities.getBytesPlatform("KEYLN16 "));
        byte[] keyType1 = PlatformUtilities.getBytesPlatform("AESDATA ");
        byte[] keyType2 = new byte[8];
        byte[] genKeyId1 = new byte[64];
        byte[] genKeyId2 = (byte[])genKeyId1.clone();
        if (null != debug) {
            exitDataString = encoder.encodeBuffer(exitData);
            kekKeyId1String = encoder.encodeBuffer(kekKeyId1);
            kekKeyId2String = encoder.encodeBuffer(kekKeyId2);
            String keyFormString = encoder.encodeBuffer(keyForm);
            String keyLengthString = encoder.encodeBuffer(keyLength);
            String keyType1String = encoder.encodeBuffer(keyType1);
            String keyType2String = encoder.encodeBuffer(keyType2);
            String genKeyId1String = encoder.encodeBuffer(genKeyId1);
            String genKeyId2String = encoder.encodeBuffer(genKeyId2);
            String parmsReport = "\nAESKeyGenerator: CSNBKGN INPUT PARAMETERS \n    exitDataLen: " + exitDataLength.getValue() + "\n    exitData   : " + exitDataString + "\n    kekKeyId1  :\n" + kekKeyId1String + "\n    kekKeyId2  :\n" + kekKeyId2String + "\n    keyForm    : " + keyFormString + "\n    keyLength  : " + keyLengthString + "\n    keyType1   : " + keyType1String + "\n    keyType2   : " + keyType2String + "\n    genKeyId1  :\n" + genKeyId1String + "\n    genKeyId2  :\n" + genKeyId2String + "\n";
            debug.text(Debug.TYPE_FINEST, className, "generateHWKeyToken", parmsReport);
        }
        try {
            hikm.CSNBKGNJ(returnCode, reasonCode, exitDataLength, exitData, keyForm, keyLength, keyType1, keyType2, kekKeyId1, kekKeyId2, genKeyId1, genKeyId2);
        }
        catch (IllegalArgumentException e) {
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "generateHWKeyToken", e);
                debug.exit(Debug.TYPE_FINE, className, "generateHWKeyToken");
            }
            throw new RuntimeException("Hardware error from call CSNBKGN " + e);
        }
        if (debug != null) {
            debug.text(Debug.TYPE_FINE, className, "generateHWKeyToken", "CSNBKGN: return code = " + returnCode.getValue() + " reason code = " + reasonCode.getValue());
        }
        if (debug != null) {
            exitDataString = encoder.encodeBuffer(exitData);
            kekKeyId1String = encoder.encodeBuffer(kekKeyId1);
            kekKeyId2String = encoder.encodeBuffer(kekKeyId2);
            String genKeyId1String = encoder.encodeBuffer(genKeyId1);
            String genKeyId2String = encoder.encodeBuffer(genKeyId2);
            String parmsReport = "\nAESKeyGenerator: CSNBKGN RETURN PARAMETERS: \n    returnCode : " + returnCode.getValue() + "\n    reasonCode : " + reasonCode.getValue() + "\n    exitDataLen: " + exitDataLength.getValue() + "\n    exitData   : " + exitDataString + "\n    kekKeyId1  :\n" + kekKeyId1String + "\n    kekKeyId2  :\n" + kekKeyId2String + "\n    genKeyId1  :\n" + genKeyId1String + "\n    genKeyId2  :\n" + genKeyId2String + "\n";
            debug.text(Debug.TYPE_FINEST, className, "generateHWKeyToken", parmsReport);
        }
        if (returnCode.getValue() != 0) {
            if (returnCode.getValue() == 8 && reasonCode.getValue() == 2093 && !AESKeyGenerator.checkIfAllZero(genKeyId1)) {
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "generateHWKeyToken", "Expected error from ICSF AES key generate call using CSNBKGN returnCode=" + returnCode.getValue() + " reasonCode=" + reasonCode.getValue());
                }
                this.canBeStored = false;
            } else {
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "generateHWKeyToken", "Hardware error from call CSNBKGN returnCode=" + returnCode.getValue() + " reasonCode=" + reasonCode.getValue());
                    debug.exit(Debug.TYPE_FINE, className, "generateHWKeyToken");
                }
                throw new JCECCARuntimeException(1, "CSNBKGN", "Hardware error from call CSNBKGN returnCode " + returnCode.getValue() + " reasonCode " + reasonCode.getValue(), returnCode.getValue(), reasonCode.getValue());
            }
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "generateHWKeyToken", genKeyId1);
        }
        return genKeyId1;
    }

    private final TokenPair generatePairOfICSFTokens() {
        if (debug != null) {
            debug.entry(8192L, className, "generatePairOfICSFTokens");
        }
        if (!HardwareProfile.getIsHCR7790OrLaterPresent()) {
            UnsupportedOperationException uoe = new UnsupportedOperationException("Generating an AES key pair is only supported on HCR7790 or later versions.");
            if (debug != null) {
                debug.exception(8192L, className, "generatePairOfICSFTokens", uoe);
                debug.exit(8192L, className, "generatePairOfICSFTokens");
            }
            throw uoe;
        }
        String keyType1String = null;
        String keyType2String = null;
        switch (this.keyUsage) {
            case OPEX_EXPORTER_IMPORTER: {
                keyType1String = "EXPORTER";
                keyType2String = "IMPORTER";
                break;
            }
            default: {
                keyType1String = "IMPORTER";
                keyType2String = "EXPORTER";
            }
        }
        int ruleArrayCount = 2;
        String ruleArrayString = "AES     OPEX    ";
        int clearKeyBitLength = this.keysize;
        byte[] kekIdentifier1 = null;
        byte[] kekIdentifier2 = this.key2EncryptingKey.getEncoded();
        if (PlatformUtilities.isLinux() && this.key2EncryptingKey.getFormat().equals("CKDSLabel")) {
            kekIdentifier2 = PlatformUtilities.convertBytesETOA(kekIdentifier2);
        }
        TokenPair result = SymmetricKeyUtils.keyGenerate2(ruleArrayCount, ruleArrayString, clearKeyBitLength, keyType1String, keyType2String, kekIdentifier1, kekIdentifier2);
        if (debug != null) {
            debug.exit(8192L, (Object)className, "generatePairOfICSFTokens", result);
        }
        return result;
    }

    private static final boolean checkIfAllZero(byte[] value) {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "checkIfAllZero", (Object)value);
        }
        for (int x = 0; x < value.length; ++x) {
            if (value[x] == 0) continue;
            if (debug != null) {
                debug.exit(Debug.TYPE_FINE, (Object)className, "checkIfAllZero", false);
            }
            return false;
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "checkIfAllZero", true);
        }
        return true;
    }
}

