/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.hdwrCCA.provider;

import com.ibm.crypto.hdwrCCA.provider.Debug;
import com.ibm.crypto.hdwrCCA.provider.LabelUtils;
import com.ibm.crypto.hdwrCCA.provider.PlatformUtilities;
import com.ibm.crypto.hdwrCCA.provider.SymmetricKeyUtils;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.security.InvalidKeyException;
import java.util.Arrays;
import javax.crypto.SecretKey;

public class AESKey
implements SecretKey {
    static final long serialVersionUID = -3809229116514182961L;
    private String keyType;
    private byte[] key;
    private byte[] icsfToken;
    private byte[] ckdsLabel;
    private byte[] pairedExportedICSFToken;
    private boolean canBeStored = true;
    private static Debug debug = Debug.getInstance("ibmjcecca");
    private static String className = "com.ibm.crypto.hdwrCCA.provider.AESKey";

    AESKey(byte[] key) throws InvalidKeyException {
        this("RAW", key, null);
    }

    AESKey(String keyType, byte[] keyOrTokenOrLabel) throws InvalidKeyException {
        this(keyType, keyOrTokenOrLabel, null);
    }

    AESKey(String keyType, byte[] keyOrTokenOrLabel, byte[] pairedExportedICSFToken) throws InvalidKeyException {
        InvalidKeyException ike;
        if (debug != null) {
            Object[] parms = new Object[]{keyType, keyOrTokenOrLabel, pairedExportedICSFToken};
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "AESKey", parms);
        }
        if ("RAW".equals(keyType)) {
            if (pairedExportedICSFToken != null) {
                IllegalArgumentException iae = new IllegalArgumentException("RAW key is not compatible with paired ICSF token");
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, "AESKey", iae);
                    debug.exit(Debug.TYPE_PUBLIC, className, "AESKey");
                }
                throw iae;
            }
            int numKeyBytes = 0;
            if (keyOrTokenOrLabel != null) {
                numKeyBytes = keyOrTokenOrLabel.length;
            }
            if (numKeyBytes != 16 && numKeyBytes != 24 && numKeyBytes != 32) {
                InvalidKeyException ike2 = new InvalidKeyException("Wrong key size");
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, "AESKey", ike2);
                    debug.exit(Debug.TYPE_PUBLIC, className, "AESKey");
                }
                throw ike2;
            }
            this.keyType = "RAW";
            this.key = (byte[])keyOrTokenOrLabel.clone();
            this.icsfToken = null;
            this.ckdsLabel = null;
            this.canBeStored = true;
            this.pairedExportedICSFToken = null;
        } else if ("ICSFToken".equals(keyType)) {
            if (null == keyOrTokenOrLabel || 0 == keyOrTokenOrLabel.length) {
                ike = new InvalidKeyException("Key token must not have zero length.");
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, "AESKey", ike);
                    debug.exit(Debug.TYPE_PUBLIC, className, "AESKey");
                }
                throw ike;
            }
            this.keyType = "ICSFToken";
            this.key = null;
            this.icsfToken = (byte[])keyOrTokenOrLabel.clone();
            this.ckdsLabel = null;
            this.canBeStored = true;
            this.pairedExportedICSFToken = null;
            if (pairedExportedICSFToken != null) {
                this.pairedExportedICSFToken = (byte[])pairedExportedICSFToken.clone();
            }
        } else if ("CKDSLabel".equals(keyType)) {
            if (null == keyOrTokenOrLabel || 0 == keyOrTokenOrLabel.length) {
                ike = new InvalidKeyException("Key label must not have zero length.");
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, "AESKey", ike);
                    debug.exit(Debug.TYPE_PUBLIC, className, "AESKey");
                }
                throw ike;
            }
            this.keyType = "CKDSLabel";
            this.key = null;
            this.icsfToken = null;
            this.ckdsLabel = LabelUtils.padLabel(keyOrTokenOrLabel, PlatformUtilities.CHARSET_IBM_1047);
            this.canBeStored = true;
            this.pairedExportedICSFToken = null;
            if (pairedExportedICSFToken != null) {
                this.pairedExportedICSFToken = (byte[])pairedExportedICSFToken.clone();
            }
        } else {
            ike = new InvalidKeyException("Key type must be RAW, ICSFToken, or CKDSLabel.");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "AESKey", ike);
                debug.exit(Debug.TYPE_PUBLIC, className, "AESKey");
            }
            throw ike;
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "AESKey");
        }
    }

    static AESKey newLabelKey(String label) throws InvalidKeyException {
        return new AESKey("CKDSLabel", label.getBytes(PlatformUtilities.CHARSET_IBM_1047));
    }

    static AESKey newLabelKeyWithPairedToken(String label, byte[] pairedExportedToken) throws InvalidKeyException {
        return new AESKey("CKDSLabel", label.getBytes(PlatformUtilities.CHARSET_IBM_1047), pairedExportedToken);
    }

    @Override
    public byte[] getEncoded() {
        byte[] returnValue = null;
        if ("RAW".equals(this.keyType)) {
            returnValue = (byte[])this.key.clone();
        } else if ("ICSFToken".equals(this.keyType)) {
            try {
                returnValue = this.getToken();
            }
            catch (Exception ex) {
                returnValue = null;
            }
        } else if ("CKDSLabel".equals(this.keyType)) {
            try {
                returnValue = this.getLabel();
            }
            catch (Exception ex) {
                returnValue = null;
            }
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getEncoded", returnValue);
        }
        return returnValue;
    }

    public byte[] getToken() throws InvalidKeyException {
        if (!"ICSFToken".equals(this.keyType)) {
            InvalidKeyException ike = new InvalidKeyException("Only an ICSFToken key has an ICSF token.");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "getToken", ike);
                debug.exit(Debug.TYPE_PUBLIC, className, "getToken");
            }
            throw ike;
        }
        byte[] returnToken = (byte[])this.icsfToken.clone();
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getToken", returnToken);
        }
        return returnToken;
    }

    public byte[] getLabel() throws InvalidKeyException {
        if (!"CKDSLabel".equals(this.keyType)) {
            InvalidKeyException ike = new InvalidKeyException("Only a CKDSLabel key has a CKDS label.");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "getLabel", ike);
                debug.exit(Debug.TYPE_PUBLIC, className, "getLabel");
            }
            throw ike;
        }
        byte[] returnLabel = (byte[])this.ckdsLabel.clone();
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getLabel", returnLabel);
        }
        return returnLabel;
    }

    public String getLabelString() throws InvalidKeyException {
        if (!"CKDSLabel".equals(this.keyType)) {
            InvalidKeyException ike = new InvalidKeyException("Only a CKDSLabel key has a CKDS label.");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "getLabelString", ike);
                debug.exit(Debug.TYPE_PUBLIC, className, "getLabelString");
            }
            throw ike;
        }
        String returnLabel = new String(this.ckdsLabel, PlatformUtilities.CHARSET_IBM_1047);
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getLabelString", returnLabel);
        }
        return returnLabel;
    }

    public byte[] getPairedExternalToken() {
        byte[] pairedExternalToken = null;
        if (this.pairedExportedICSFToken != null) {
            pairedExternalToken = (byte[])this.pairedExportedICSFToken.clone();
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getPairedExternalToken", pairedExternalToken);
        }
        return pairedExternalToken;
    }

    @Override
    public String getAlgorithm() {
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getAlgorithm", "AES");
        }
        return "AES";
    }

    @Override
    public String getFormat() {
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getFormat", this.keyType);
        }
        return this.keyType;
    }

    protected void setCanBeStored(boolean value) {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "setCanBeStored", value);
        }
        this.canBeStored = value;
    }

    protected boolean getCanBeStored() {
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getCanBeStored", this.canBeStored);
        }
        return this.canBeStored;
    }

    public void deleteCKDSEntry() throws InvalidKeyException {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "deleteCKDSEntry");
        }
        SymmetricKeyUtils.deleteCKDSEntry(this);
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "deleteCKDSEntry");
        }
    }

    public int hashCode() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "hashCode");
        }
        int retval = 0;
        byte[] keyData = this.getEncoded();
        for (int i = 1; i < keyData.length; ++i) {
            retval += keyData[i] * i;
        }
        retval ^= "aes".hashCode();
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "hashCode", retval);
        }
        return retval;
    }

    public boolean equals(Object obj) {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "equals", obj);
        }
        if (this == obj) {
            if (debug != null) {
                debug.exit(Debug.TYPE_PUBLIC, (Object)className, "equals1", true);
            }
            return true;
        }
        if (!(obj instanceof AESKey)) {
            if (debug != null) {
                debug.exit(Debug.TYPE_PUBLIC, (Object)className, "equals2", false);
            }
            return false;
        }
        String thatAlg = ((AESKey)obj).getAlgorithm();
        if (!thatAlg.equalsIgnoreCase("AES")) {
            if (debug != null) {
                debug.exit(Debug.TYPE_PUBLIC, (Object)className, "equals3", false);
            }
            return false;
        }
        String thatKeyType = ((AESKey)obj).getFormat();
        if (!thatKeyType.equals(this.keyType)) {
            if (debug != null) {
                debug.exit(Debug.TYPE_PUBLIC, (Object)className, "equals5", false);
            }
            return false;
        }
        byte[] thiskeyData = null;
        byte[] thatkeyData = null;
        try {
            thiskeyData = this.getEncoded();
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "equals6", e);
                debug.exit(Debug.TYPE_PUBLIC, (Object)className, "equals6", false);
            }
            return false;
        }
        try {
            thatkeyData = ((AESKey)obj).getEncoded();
        }
        catch (Exception e) {
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "equals7", e);
                debug.exit(Debug.TYPE_PUBLIC, (Object)className, "equals7", false);
            }
            return false;
        }
        boolean ret = Arrays.equals(thiskeyData, thatkeyData);
        Arrays.fill(thiskeyData, (byte)0);
        Arrays.fill(thatkeyData, (byte)0);
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "equals8", ret);
        }
        return ret;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        if (debug != null) {
            debug.entry(8192L, (Object)className, "readObject", s);
        }
        s.defaultReadObject();
        if ("RAW".equals(this.keyType)) {
            if (this.pairedExportedICSFToken != null) {
                InvalidObjectException ioe = new InvalidObjectException("RAW key is not compatible with paired ICSF token");
                if (debug != null) {
                    debug.exception(8192L, className, "readObject", ioe);
                    debug.exit(8192L, className, "readObject");
                }
                throw ioe;
            }
            this.key = (byte[])this.key.clone();
            this.icsfToken = null;
            this.ckdsLabel = null;
            this.pairedExportedICSFToken = null;
        } else if ("ICSFToken".equals(this.keyType)) {
            this.key = null;
            this.icsfToken = (byte[])this.icsfToken.clone();
            this.ckdsLabel = null;
            if (this.pairedExportedICSFToken != null) {
                this.pairedExportedICSFToken = (byte[])this.pairedExportedICSFToken.clone();
            }
        } else if ("CKDSLabel".equals(this.keyType)) {
            this.key = null;
            this.icsfToken = null;
            this.ckdsLabel = (byte[])this.ckdsLabel.clone();
            if (this.pairedExportedICSFToken != null) {
                this.pairedExportedICSFToken = (byte[])this.pairedExportedICSFToken.clone();
            }
        } else {
            InvalidObjectException ioe = new InvalidObjectException("Key type must be RAW, ICSFToken, or CKDSLabel");
            if (debug != null) {
                debug.exception(8192L, className, "readObject", ioe);
                debug.exit(8192L, className, "readObject");
            }
            throw ioe;
        }
        if (debug != null) {
            debug.exit(8192L, className, "readObject");
        }
    }

    protected void finalize() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "finalize");
        }
        if (this.key != null) {
            Arrays.fill(this.key, (byte)0);
            this.key = null;
        } else if (null != this.icsfToken) {
            Arrays.fill(this.icsfToken, (byte)0);
            this.icsfToken = null;
        } else if (null != this.ckdsLabel) {
            Arrays.fill(this.ckdsLabel, (byte)0);
            this.ckdsLabel = null;
        }
        if (this.pairedExportedICSFToken != null) {
            Arrays.fill(this.pairedExportedICSFToken, (byte)0);
            this.pairedExportedICSFToken = null;
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "finalize");
        }
    }
}

