/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.hdwrCCA.provider;

import com.ibm.crypto.hdwrCCA.provider.Debug;
import com.ibm.crypto.hdwrCCA.provider.SymmetricCipher;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.IllegalBlockSizeException;

class AESCrypt
extends SymmetricCipher {
    private static final int AES_BLOCK_SIZE = 16;
    byte[] rawKey = null;
    private static Debug debug = Debug.getInstance("ibmjcecca");
    private static String className = "com.ibm.crypto.hdwrCCA.provider.AESCrypt";

    AESCrypt() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "AESCrypt");
            debug.exit(Debug.TYPE_PUBLIC, className, "AESCrypt");
        }
    }

    @Override
    void init(Key key) throws InvalidKeyException {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, (Object)className, "init", key);
        }
        if (key == null) {
            throw new InvalidKeyException("Key missing");
        }
        if (!key.getAlgorithm().equalsIgnoreCase("AES")) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "init", "Wrong algorithm: AES required");
            }
            throw new InvalidKeyException("Wrong algorithm: AES required");
        }
        if (!key.getFormat().equalsIgnoreCase("RAW")) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "init", "Wrong format: RAW bytes needed");
            }
            throw new InvalidKeyException("Wrong format: RAW bytes needed");
        }
        byte[] keys = key.getEncoded();
        if (keys == null) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "init", "RAW bytes missing");
            }
            throw new InvalidKeyException("RAW bytes missing");
        }
        if (keys.length != 16 && keys.length != 24 && keys.length != 32) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "init", "Wrong key size. Key size is " + keys.length);
            }
            throw new InvalidKeyException("Wrong key size");
        }
        this.rawKey = keys;
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "init");
        }
    }

    @Override
    void init(Key key, AlgorithmParameterSpec params) throws InvalidKeyException {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "init", key, params);
        }
        this.init(key);
        if (debug != null) {
            debug.exit(Debug.TYPE_PUBLIC, className, "init");
        }
    }

    @Override
    int getBlockSize() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "getBlockSize");
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getBlockSize", 16);
        }
        return 16;
    }

    @Override
    public byte[] getIV() {
        if (debug != null) {
            debug.entry(Debug.TYPE_PUBLIC, className, "getIV");
            debug.exit(Debug.TYPE_PUBLIC, (Object)className, "getIV", null);
        }
        return null;
    }

    @Override
    void encrypt(byte[] plain, int plainOffset, int plainLen, byte[] cipher, int cipherOffset) throws IllegalBlockSizeException {
        throw new IllegalBlockSizeException("IBMJCECCA AES This method is not developed yet: " + plainLen);
    }

    @Override
    void decrypt(byte[] cipher, int cipherOffset, int cipherLen, byte[] plain, int plainOffset) throws IllegalBlockSizeException {
        throw new IllegalBlockSizeException("IBMJCECCA AES This method is not developed yet: " + cipherLen);
    }
}

