/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.hdwrCCA.provider;

import com.ibm.crypto.hdwrCCA.provider.AESCrypt;
import com.ibm.crypto.hdwrCCA.provider.CipherBlockChaining;
import com.ibm.crypto.hdwrCCA.provider.CipherFeedback;
import com.ibm.crypto.hdwrCCA.provider.ConstructKeys;
import com.ibm.crypto.hdwrCCA.provider.Debug;
import com.ibm.crypto.hdwrCCA.provider.ElectronicCodeBook;
import com.ibm.crypto.hdwrCCA.provider.FeedbackCipher;
import com.ibm.crypto.hdwrCCA.provider.FullHardwareCrypt;
import com.ibm.crypto.hdwrCCA.provider.HardwareProfile;
import com.ibm.crypto.hdwrCCA.provider.IBMJCECCA;
import com.ibm.crypto.hdwrCCA.provider.ICVSelection;
import com.ibm.crypto.hdwrCCA.provider.JCECCARuntimeException;
import com.ibm.crypto.hdwrCCA.provider.JCEHdwrUtils;
import com.ibm.crypto.hdwrCCA.provider.OutputFeedback;
import com.ibm.crypto.hdwrCCA.provider.PKCS5Padding;
import com.ibm.crypto.hdwrCCA.provider.Padding;
import com.ibm.crypto.hdwrCCA.provider.SymmetricCipher;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.AEADBadTagException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.IvParameterSpec;

public final class AESCipher
extends CipherSpi {
    private byte[] buffer;
    private int unitBytes;
    private int buffered;
    private int diffBlocksize;
    private Padding padding;
    private Key specifiedKey;
    private SymmetricCipher cipher;
    private SecureRandom initRandom;
    private boolean jitOptimized;
    protected int cipherMode;
    private String cipherModeString;
    private String jitCipherModeString;
    private boolean decrypting;
    protected static final int ECB_MODE = 0;
    protected static final int CBC_MODE = 1;
    protected static final int CFB_MODE = 2;
    protected static final int OFB_MODE = 3;
    protected static final int GCM_MODE = 5;
    private boolean isLabel;
    private boolean isToken;
    public static final int DEFAULT_TAG_LENGTH = 128;
    private int GCM_T_size;
    private byte[] GCM_AAD;
    private byte[] GCM_IV;
    private GCMParameterSpec GCM_parmSpec;
    private byte[] keyToken;
    private JCEHdwrUtils hdwrUtils;
    private static final int AES_BLOCK_SIZE = 16;
    private int lcfbLen;
    private ICVSelection icvMode;
    protected AESCrypt rawAlg;
    private static Debug debug = Debug.getInstance("ibmjcecca");
    private static String className = "com.ibm.crypto.hdwrCCA.provider.AESCipher";

    public AESCipher() {
        block8: {
            this.buffer = null;
            this.unitBytes = 0;
            this.buffered = 0;
            this.diffBlocksize = 16;
            this.padding = null;
            this.specifiedKey = null;
            this.cipher = null;
            this.initRandom = null;
            this.jitOptimized = false;
            this.jitCipherModeString = null;
            this.decrypting = false;
            this.isLabel = false;
            this.isToken = false;
            this.GCM_T_size = -1;
            this.GCM_AAD = new byte[0];
            this.GCM_IV = null;
            this.keyToken = null;
            this.lcfbLen = 0;
            this.icvMode = ICVSelection.ICV_INITIAL;
            if (debug != null) {
                debug.entry(Debug.TYPE_FINE, className, "AESCipher");
            }
            IBMJCECCA.verifyJceJar();
            if (!IBMJCECCA.verifySelfIntegrity(this.getClass())) {
                SecurityException se = new SecurityException("The IBMJCECCA provider may have been tampered.");
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "AESCipher", "The IBMJCECCA provider may have been tampered.");
                    debug.exception(Debug.TYPE_PUBLIC, className, "AESCipher", se);
                    debug.exit(Debug.TYPE_FINE, className, "AESCipher");
                }
                throw se;
            }
            try {
                this.setRawAlg();
                this.unitBytes = 16;
                this.buffer = new byte[32];
                this.engineSetMode("CBC");
                this.engineSetPadding("PKCS5Padding");
            }
            catch (NoSuchAlgorithmException ex) {
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, "AESCipher", ex);
                }
            }
            catch (NoSuchPaddingException ex) {
                if (debug == null) break block8;
                debug.exception(Debug.TYPE_PUBLIC, className, "AESCipher", ex);
            }
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "AESCipher");
        }
    }

    public AESCipher(String mode, String paddingScheme) throws NoSuchAlgorithmException, NoSuchPaddingException {
        this.buffer = null;
        this.unitBytes = 0;
        this.buffered = 0;
        this.diffBlocksize = 16;
        this.padding = null;
        this.specifiedKey = null;
        this.cipher = null;
        this.initRandom = null;
        this.jitOptimized = false;
        this.jitCipherModeString = null;
        this.decrypting = false;
        this.isLabel = false;
        this.isToken = false;
        this.GCM_T_size = -1;
        this.GCM_AAD = new byte[0];
        this.GCM_IV = null;
        this.keyToken = null;
        this.lcfbLen = 0;
        this.icvMode = ICVSelection.ICV_INITIAL;
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "AESCipher", mode, paddingScheme);
        }
        IBMJCECCA.verifyJceJar();
        if (!IBMJCECCA.verifySelfIntegrity(this.getClass())) {
            SecurityException se = new SecurityException("The IBMJCECCA provider may have been tampered.");
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "AESCipher", "The IBMJCECCA provider may have been tampered.");
                debug.exception(Debug.TYPE_PUBLIC, className, "AESCipher", se);
                debug.exit(Debug.TYPE_FINE, className, "AESCipher");
            }
            throw se;
        }
        this.setRawAlg();
        this.unitBytes = 16;
        this.buffer = new byte[32];
        this.engineSetMode(mode);
        this.engineSetPadding(paddingScheme);
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "AESCipher");
        }
    }

    protected void setRawAlg() {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "setRawAlg");
        }
        this.rawAlg = new AESCrypt();
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "setRawAlg");
        }
    }

    @Override
    protected void engineSetMode(String mode) throws NoSuchAlgorithmException {
        String modeUpperCase;
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineSetMode", mode);
        }
        if (mode == null) {
            NoSuchAlgorithmException nsae = new NoSuchAlgorithmException("Cipher mode can not be null.");
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineSetMode", "Cipher mode can not be null.");
                debug.exception(Debug.TYPE_PUBLIC, className, "engineSetMode", nsae);
                debug.exit(Debug.TYPE_FINE, className, "engineSetMode");
            }
            throw nsae;
        }
        this.cipherModeString = modeUpperCase = mode.toUpperCase();
        this.jitCipherModeString = modeUpperCase;
        if (modeUpperCase.equals("ECB")) {
            this.cipherMode = 0;
            ElectronicCodeBook ecb = new ElectronicCodeBook();
            ecb.setEmbeddedCipher(this.rawAlg);
            this.cipher = ecb;
            if (debug != null) {
                debug.exit(Debug.TYPE_FINE, className, "engineSetMode ECB");
            }
        } else if (modeUpperCase.equals("CBC")) {
            this.cipherMode = 1;
            CipherBlockChaining cbc = new CipherBlockChaining();
            cbc.setEmbeddedCipher(this.rawAlg);
            this.cipher = cbc;
            if (debug != null) {
                debug.exit(Debug.TYPE_FINE, className, "engineSetMode CBC");
            }
        } else if (modeUpperCase.equals("GCM")) {
            if (!HardwareProfile.getIsOfbCfbGcmSupported()) {
                NoSuchAlgorithmException nsae = new NoSuchAlgorithmException("Requested cipher mode not supported in this environment.");
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "engineSetMode", "Requested cipher mode not supported in this environment.");
                    debug.exception(Debug.TYPE_PUBLIC, className, "engineSetMode", nsae);
                    debug.exit(Debug.TYPE_FINE, className, "engineSetMode");
                }
                throw nsae;
            }
            this.cipherMode = 5;
            try {
                this.engineSetPadding("NoPadding");
            }
            catch (Exception ex) {
                String rte_msg = "Internal error: unexpected exception thrown: " + ex.getMessage();
                RuntimeException rte = new RuntimeException(rte_msg, ex);
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "engineSetMode", rte_msg);
                    debug.exception(Debug.TYPE_PUBLIC, className, "engineSetMode", rte);
                    debug.exit(Debug.TYPE_FINE, className, "engineSetMode");
                }
                throw rte;
            }
            if (debug != null) {
                debug.exit(Debug.TYPE_FINE, className, "engineSetMode GCM/NoPadding");
            }
        } else if (modeUpperCase.equals("OFB")) {
            if (!HardwareProfile.getIsOfbCfbGcmSupported()) {
                NoSuchAlgorithmException nsae = new NoSuchAlgorithmException("Requested cipher mode not supported in this environment.");
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "engineSetMode", "Requested cipher mode not supported in this environment.");
                    debug.exception(Debug.TYPE_PUBLIC, className, "engineSetMode", nsae);
                    debug.exit(Debug.TYPE_FINE, className, "engineSetMode");
                }
                throw nsae;
            }
            this.cipherMode = 3;
            OutputFeedback ofb = new OutputFeedback();
            ofb.setEmbeddedCipher(this.rawAlg);
            this.cipher = ofb;
            if (debug != null) {
                debug.exit(Debug.TYPE_FINE, className, "engineSetMode OFB");
            }
        } else if (modeUpperCase.startsWith("CFB")) {
            this.cipherMode = 2;
            this.jitCipherModeString = "CFB";
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineSetMode", "Requested cipher mode: " + modeUpperCase + "  jitCipherMode: " + this.jitCipherModeString);
            }
            CipherFeedback cfb = null;
            if (mode.length() > 3) {
                if (!HardwareProfile.getIsOfbCfbGcmSupported()) {
                    NoSuchAlgorithmException nsae = new NoSuchAlgorithmException("Requested cipher mode not supported in this environment.");
                    if (debug != null) {
                        debug.text(Debug.TYPE_PUBLIC, className, "engineSetMode", "Requested cipher mode not supported in this environment.");
                        debug.exception(Debug.TYPE_PUBLIC, className, "engineSetMode", nsae);
                        debug.exit(Debug.TYPE_FINE, className, "engineSetMode");
                    }
                    throw nsae;
                }
                Integer num = null;
                try {
                    num = Integer.valueOf(mode.substring(3));
                }
                catch (NumberFormatException e) {
                    NoSuchAlgorithmException nsae = new NoSuchAlgorithmException("Algorithm mode: " + mode + " not implemented.");
                    if (debug != null) {
                        debug.text(Debug.TYPE_PUBLIC, className, "engineSetMode", "Algorithm mode: " + mode + " not implemented.");
                        debug.exception(Debug.TYPE_PUBLIC, className, "engineSetMode", nsae);
                        debug.exit(Debug.TYPE_FINE, className, "engineSetMode");
                    }
                    throw nsae;
                }
                if (num != null && num % 8 == 0 && num > 0) {
                    int numInt = num / 8;
                    if (numInt <= 16 && numInt > 0) {
                        this.unitBytes = numInt;
                        cfb = new CipherFeedback(this.unitBytes);
                        if (debug != null) {
                            debug.text(Debug.TYPE_PUBLIC, className, "engineSetMode", "Setting unitByte size to: " + this.unitBytes);
                            debug.text(Debug.TYPE_PUBLIC, className, "engineSetMode", "lcfbLen: " + this.lcfbLen);
                        }
                        this.lcfbLen = numInt;
                    }
                } else {
                    NoSuchAlgorithmException nsae = new NoSuchAlgorithmException("Invalid algorithm mode: " + mode);
                    if (debug != null) {
                        debug.text(Debug.TYPE_PUBLIC, className, "engineSetMode", "Invalid algorithm mode: " + mode);
                        debug.exception(Debug.TYPE_PUBLIC, className, "engineSetMode", nsae);
                        debug.exit(Debug.TYPE_FINE, className, "engineSetMode");
                    }
                    throw nsae;
                }
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "engineSetMode", "final lcfbLen: " + this.lcfbLen);
                }
            } else {
                cfb = new CipherFeedback();
            }
            cfb.setEmbeddedCipher(this.rawAlg);
            this.cipher = cfb;
            if (debug != null) {
                debug.exit(Debug.TYPE_FINE, className, "engineSetMode CFB");
            }
        } else {
            NoSuchAlgorithmException nsae = new NoSuchAlgorithmException("Only support ECB, CFB, OFB, or CBC Mode for AES. ");
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineSetMode", "Only support ECB, CFB, OFB, or CBC Mode for AES. ");
                debug.exception(Debug.TYPE_PUBLIC, className, "engineSetMode", nsae);
                debug.exit(Debug.TYPE_FINE, className, "engineSetMode");
            }
            throw nsae;
        }
    }

    @Override
    protected void engineSetPadding(String paddingScheme) throws NoSuchPaddingException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineSetPadding", paddingScheme);
        }
        if (paddingScheme == null) {
            NoSuchPaddingException nspe = new NoSuchPaddingException("null padding");
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineSetPadding", "null padding");
                debug.exception(Debug.TYPE_PUBLIC, className, "engineSetPadding", nspe);
                debug.exit(Debug.TYPE_FINE, className, "engineSetPadding");
            }
            throw nspe;
        }
        if (this.cipherMode == 5 && !paddingScheme.equalsIgnoreCase("NoPadding")) {
            String nspe_msg = "Padding " + paddingScheme + " specified.  Only NoPadding is available for GCM mode.";
            NoSuchPaddingException nspe = new NoSuchPaddingException(nspe_msg);
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineSetPadding", nspe_msg);
                debug.exception(Debug.TYPE_PUBLIC, className, "engineSetPadding", nspe);
                debug.exit(Debug.TYPE_FINE, className, "engineSetPadding");
            }
            throw nspe;
        }
        if (paddingScheme.equalsIgnoreCase("PKCS5Padding")) {
            this.padding = new PKCS5Padding(16);
        } else if (paddingScheme.equalsIgnoreCase("NoPadding")) {
            this.padding = null;
        } else {
            NoSuchPaddingException nspe = new NoSuchPaddingException("Padding: " + paddingScheme + " not implemented");
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineSetPadding", "Padding: " + paddingScheme + " not implemented");
                debug.exception(Debug.TYPE_PUBLIC, className, "engineSetPadding", nspe);
                debug.exit(Debug.TYPE_FINE, className, "engineSetPadding");
            }
            throw nspe;
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineSetPadding2", this.padding);
        }
    }

    @Override
    protected int engineGetBlockSize() {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "engineGetBlockSize");
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineGetBlockSize", 16);
        }
        return 16;
    }

    @Override
    protected int engineGetOutputSize(int inputLen) {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineGetOutputSize", new Integer(inputLen));
        }
        int totalLen = this.buffered + inputLen;
        if (debug != null) {
            debug.text(Debug.TYPE_PUBLIC, className, "engineGetOutputSize", "inputLen = " + inputLen + "  totalLen = " + totalLen);
        }
        if (this.cipherMode == 5 && this.GCM_T_size <= 0) {
            String ise_msg = "Output size for GCM mode cannot be determined before init() is called.";
            IllegalStateException ise = new IllegalStateException(ise_msg);
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineGetOutputSize", ise_msg);
                debug.exception(Debug.TYPE_PUBLIC, className, "engineGetOutputSize", ise);
                debug.exit(Debug.TYPE_FINE, className, "engineGetOutputSize");
            }
            throw ise;
        }
        if (this.padding == null) {
            if (this.cipherMode == 5) {
                if (this.decrypting) {
                    totalLen -= this.GCM_T_size;
                    if (debug != null) {
                        debug.text(Debug.TYPE_PUBLIC, className, "engineGetOutputSize", "padding == null. GCM decryption.  totalLen = " + totalLen);
                    }
                } else {
                    totalLen += this.GCM_T_size;
                    if (debug != null) {
                        debug.text(Debug.TYPE_PUBLIC, className, "engineGetOutputSize", "padding == null. GCM encryption.  totalLen = " + totalLen);
                    }
                }
            }
            if (debug != null) {
                debug.exit(Debug.TYPE_FINE, (Object)className, "engineGetOutputSize1", totalLen);
            }
            return totalLen;
        }
        if (this.decrypting) {
            if (this.cipherMode == 5) {
                totalLen -= this.GCM_T_size;
            }
            if (debug != null) {
                debug.exit(Debug.TYPE_FINE, (Object)className, "engineGetOutputSize2", totalLen);
            }
            return totalLen;
        }
        if (this.unitBytes != 16) {
            if (totalLen < this.diffBlocksize) {
                if (debug != null) {
                    debug.exit(Debug.TYPE_FINE, (Object)className, "engineGetOutputSize3", this.diffBlocksize);
                }
                return this.diffBlocksize;
            }
            if (debug != null) {
                debug.exit(Debug.TYPE_FINE, (Object)className, "engineGetOutputSize4", totalLen + 16 - (totalLen - this.diffBlocksize) % 16);
            }
            return totalLen + 16 - (totalLen - this.diffBlocksize) % 16;
        }
        int returnSize = totalLen + this.padding.padLength(totalLen);
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineGetOutputSize5", returnSize);
        }
        return returnSize;
    }

    @Override
    protected byte[] engineGetIV() {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "engineGetIV");
        }
        if (this.cipherMode == 0) {
            if (debug != null) {
                debug.exit(Debug.TYPE_FINE, (Object)className, "engineGetIV1", null);
            }
            return null;
        }
        if (this.cipherMode == 5) {
            byte[] returnIV = new byte[this.GCM_IV.length];
            System.arraycopy(this.GCM_IV, 0, returnIV, 0, this.GCM_IV.length);
            if (debug != null) {
                debug.exit(Debug.TYPE_FINE, (Object)className, "engineGetIV2", returnIV);
            }
            return returnIV;
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineGetIV3", ((FeedbackCipher)((Object)this.cipher)).getIV());
        }
        return ((FeedbackCipher)((Object)this.cipher)).getIV();
    }

    @Override
    protected void engineInit(int opmode, Key key, SecureRandom random) throws InvalidKeyException {
        InvalidKeyException ike;
        if (debug != null) {
            Object[] parms = new Object[]{new Integer(opmode), key, random};
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineInit(opmode,key,random)", parms);
        }
        if (key == null) {
            ike = new InvalidKeyException("No key given");
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineInit", "No key given");
                debug.exception(Debug.TYPE_PUBLIC, className, "engineInit", ike);
                debug.exit(Debug.TYPE_FINE, className, "engineInit1");
            }
            throw ike;
        }
        this.initRandom = random;
        this.specifiedKey = key;
        this.GCM_T_size = -1;
        this.GCM_AAD = new byte[0];
        this.GCM_IV = null;
        this.GCM_parmSpec = null;
        this.jitOptimized = false;
        if (key.getFormat().equalsIgnoreCase("RAW")) {
            this.jitOptimized = this.jitOptimizationAvailable();
        }
        if (key.getFormat().equalsIgnoreCase("CKDSLabel")) {
            this.isToken = false;
            this.isLabel = true;
        } else if (key.getFormat().equalsIgnoreCase("ICSFToken")) {
            this.isToken = true;
            this.isLabel = false;
        } else {
            this.isToken = false;
            this.isLabel = false;
        }
        if (this.cipherMode != 1 && this.cipherMode != 0 && this.cipherMode != 2 && this.cipherMode != 3 && this.cipherMode != 5 && this.isLabel) {
            ike = new InvalidKeyException("A CKDS label key may only be used with ECB, CFB, OFB, GCM, or CBC mode.");
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineInit", "A CKDS label key may only be used with ECB, CFB, OFB, GCM, or CBC mode.");
                debug.exception(Debug.TYPE_PUBLIC, className, "engineInit", ike);
                debug.exit(Debug.TYPE_FINE, className, "engineInit2");
            }
            throw ike;
        }
        if (this.cipherMode != 1 && this.cipherMode != 0 && this.isToken) {
            ike = new InvalidKeyException("An ICSF token key can only be used with ECB or CBC mode.");
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineInit", "An ICSF token key can only be used with ECB or CBC mode.");
                debug.exception(Debug.TYPE_PUBLIC, className, "engineInit", ike);
                debug.exit(Debug.TYPE_FINE, className, "engineInit3");
            }
            throw ike;
        }
        if (opmode == 2 || opmode == 4) {
            if (this.cipherMode != 0) {
                ike = new InvalidKeyException("Parameters missing");
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "engineInit", "Parameters missing");
                    debug.exception(Debug.TYPE_PUBLIC, className, "engineInit", ike);
                    debug.exit(Debug.TYPE_FINE, className, "engineInit4");
                }
                throw ike;
            }
            this.decrypting = true;
        } else {
            this.decrypting = false;
        }
        this.buffered = 0;
        this.diffBlocksize = 16;
        this.icvMode = ICVSelection.ICV_INITIAL;
        if (this.cipherMode == 5) {
            try {
                this.initGCM(opmode, key, null, random);
            }
            catch (InvalidAlgorithmParameterException e) {
                InvalidKeyException ike2 = new InvalidKeyException(e);
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, "engineInit", ike2);
                    debug.exit(Debug.TYPE_FINE, className, "engineInit9");
                }
                throw ike2;
            }
            return;
        }
        if (this.cipherMode == 0 || random == null) {
            this.cipher.init(key);
            if (!this.isLabel && !this.isToken) {
                this.rawAlg.init(key);
            }
            this.keyToken = null;
            this.hdwrUtils = null;
            this.hdwrUtils = new JCEHdwrUtils();
            this.keyToken = true == this.jitOptimized ? this.hdwrUtils.initHdwr("AES", this.jitCipherModeString, !this.decrypting, key, this.cipher.getIV()) : this.hdwrUtils.initHdwr(key, this.cipher.getIV());
            if (debug != null) {
                debug.exit(Debug.TYPE_FINE, className, "engineInit8");
            }
            return;
        }
        byte[] iv = new byte[16];
        random.nextBytes(iv);
        IvParameterSpec ivSpec = new IvParameterSpec(iv);
        try {
            this.cipher.init(key, ivSpec);
            if (!this.isLabel && !this.isToken) {
                this.rawAlg.init(key);
            }
        }
        catch (InvalidAlgorithmParameterException e) {
            InvalidKeyException ike3 = new InvalidKeyException(e);
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineInit", ike3);
                debug.exit(Debug.TYPE_FINE, className, "engineInit9");
            }
            throw ike3;
        }
        this.keyToken = null;
        this.hdwrUtils = null;
        this.hdwrUtils = new JCEHdwrUtils();
        this.keyToken = this.jitOptimized ? (this.cipherMode == 2 ? this.hdwrUtils.initHdwr("AES", this.jitCipherModeString, !this.decrypting, key, this.cipher.getIV(), this.unitBytes) : this.hdwrUtils.initHdwr("AES", this.jitCipherModeString, !this.decrypting, key, this.cipher.getIV())) : this.hdwrUtils.initHdwr(key, this.cipher.getIV());
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "engineInit10");
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void engineInit(int opmode, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        block30: {
            byte[] iv;
            block29: {
                InvalidKeyException ike;
                if (debug != null) {
                    Object[] parms = new Object[]{new Integer(opmode), key, params, random};
                    debug.entry(Debug.TYPE_FINE, (Object)className, "engineInit(opmode,key,parms,random)", parms);
                }
                if (key == null) {
                    ike = new InvalidKeyException("No key given");
                    if (debug != null) {
                        debug.text(Debug.TYPE_PUBLIC, className, "engineInit", "No key given");
                        debug.exception(Debug.TYPE_PUBLIC, className, "engineInit", ike);
                        debug.exit(Debug.TYPE_FINE, className, "engineInit20");
                    }
                    throw ike;
                }
                this.initRandom = random;
                this.specifiedKey = key;
                this.GCM_T_size = -1;
                this.GCM_AAD = new byte[0];
                this.GCM_IV = null;
                this.GCM_parmSpec = null;
                this.jitOptimized = false;
                if (key.getFormat().equalsIgnoreCase("RAW")) {
                    this.jitOptimized = this.jitOptimizationAvailable();
                }
                if (key.getFormat().equalsIgnoreCase("CKDSLabel")) {
                    this.isLabel = true;
                    this.isToken = false;
                } else if (key.getFormat().equalsIgnoreCase("ICSFToken")) {
                    this.isLabel = false;
                    this.isToken = true;
                } else {
                    this.isLabel = false;
                    this.isToken = false;
                }
                if (this.cipherMode != 1 && this.cipherMode != 0 && this.cipherMode != 2 && this.cipherMode != 3 && this.cipherMode != 5 && this.isLabel) {
                    ike = new InvalidKeyException("A CKDS label key only be used with ECB, CFB, OFB, GCM, or CBC mode.");
                    if (debug != null) {
                        debug.text(Debug.TYPE_PUBLIC, className, "engineInit", "A CKDS label key only be used with ECB, CFB, OFB, GCM, or CBC mode.");
                        debug.exception(Debug.TYPE_PUBLIC, className, "engineInit", ike);
                        debug.exit(Debug.TYPE_FINE, className, "engineInit21");
                    }
                    throw ike;
                }
                if (this.cipherMode != 1 && this.cipherMode != 0 && this.isToken) {
                    ike = new InvalidKeyException("An ICSF token key can only be used with ECB or CBC mode.");
                    if (debug != null) {
                        debug.text(Debug.TYPE_PUBLIC, className, "engineInit", "An ICSF token key can only be used with ECB or CBC mode.");
                        debug.exception(Debug.TYPE_PUBLIC, className, "engineInit", ike);
                        debug.exit(Debug.TYPE_FINE, className, "engineInit22");
                    }
                    throw ike;
                }
                iv = new byte[16];
                if (opmode == 2 || opmode == 4) {
                    if (this.cipherMode != 0 && params == null) {
                        InvalidAlgorithmParameterException iape = new InvalidAlgorithmParameterException("Parameters missing");
                        if (debug != null) {
                            debug.text(Debug.TYPE_PUBLIC, className, "engineInit", "Parameters missing");
                            debug.exception(Debug.TYPE_PUBLIC, className, "engineInit", iape);
                            debug.exit(Debug.TYPE_FINE, className, "engineInit23");
                        }
                        throw iape;
                    }
                    this.decrypting = true;
                } else {
                    this.decrypting = false;
                }
                this.buffered = 0;
                this.diffBlocksize = 16;
                this.icvMode = ICVSelection.ICV_INITIAL;
                if (this.cipherMode == 5) {
                    this.initGCM(opmode, key, params, random);
                    return;
                }
                if (this.cipherMode == 0) {
                    this.cipher.init(key);
                    if (!this.isLabel && !this.isToken) {
                        this.rawAlg.init(key);
                    }
                    this.keyToken = null;
                    this.hdwrUtils = null;
                    this.hdwrUtils = new JCEHdwrUtils();
                    this.keyToken = true == this.jitOptimized ? this.hdwrUtils.initHdwr("AES", this.jitCipherModeString, !this.decrypting, key, this.cipher.getIV()) : this.hdwrUtils.initHdwr(key, this.cipher.getIV());
                    if (debug != null) {
                        debug.exit(Debug.TYPE_FINE, className, "engineInit24");
                    }
                    return;
                }
                if (params == null) break block29;
                if (params instanceof IvParameterSpec) {
                    iv = ((IvParameterSpec)params).getIV();
                    this.cipher.init(key, (IvParameterSpec)params);
                    if (!this.isLabel && !this.isToken) {
                        this.rawAlg.init(key);
                    }
                    break block30;
                } else {
                    InvalidAlgorithmParameterException iape = new InvalidAlgorithmParameterException("Wrong parameter type: IV expected");
                    if (debug != null) {
                        debug.text(Debug.TYPE_PUBLIC, className, "engineInit", "Wrong parameter type: IV expected");
                        debug.exception(Debug.TYPE_PUBLIC, className, "engineInit", iape);
                        debug.exit(Debug.TYPE_FINE, className, "engineInit33");
                    }
                    throw iape;
                }
            }
            if (random == null) {
                this.cipher.init(key);
                if (!this.isLabel && !this.isToken) {
                    this.rawAlg.init(key);
                }
            } else {
                random.nextBytes(iv);
                IvParameterSpec spec = new IvParameterSpec(iv);
                this.cipher.init(key, spec);
                if (!this.isLabel && !this.isToken) {
                    this.rawAlg.init(key);
                }
            }
        }
        this.keyToken = null;
        this.hdwrUtils = null;
        this.hdwrUtils = new JCEHdwrUtils();
        this.keyToken = this.jitOptimized ? (this.cipherMode == 2 ? this.hdwrUtils.initHdwr("AES", this.jitCipherModeString, !this.decrypting, key, this.cipher.getIV(), this.unitBytes) : this.hdwrUtils.initHdwr("AES", this.jitCipherModeString, !this.decrypting, key, this.cipher.getIV())) : this.hdwrUtils.initHdwr(key, this.cipher.getIV());
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "engineInit37");
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void initGCM(int opmode, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        block24: {
            block25: {
                if (debug != null) {
                    Object[] parms = new Object[]{new Integer(opmode), key, params, random};
                    debug.entry(Debug.TYPE_FINE, (Object)className, "initGCM(opmode,key,parms,random)", parms);
                }
                if (params == null) break block25;
                if (params instanceof IvParameterSpec) {
                    this.GCM_IV = ((IvParameterSpec)params).getIV();
                    if (debug != null) {
                        if (null == this.GCM_IV) {
                            debug.text(Debug.TYPE_PUBLIC, className, "initGCM", "IvParameterSpec specified.  IV is NULL");
                        } else {
                            debug.text(Debug.TYPE_PUBLIC, className, "initGCM", "IvParameterSpec specified.  IV length = " + this.GCM_IV.length);
                        }
                    }
                    this.GCM_T_size = 16;
                    if (debug != null) {
                        debug.text(Debug.TYPE_PUBLIC, className, "initGCM", "defaulted TLen = 128 bits => " + this.GCM_T_size + " bytes.");
                    }
                    break block24;
                } else if (params instanceof GCMParameterSpec) {
                    this.GCM_IV = ((GCMParameterSpec)params).getIV();
                    if (debug != null) {
                        if (null == this.GCM_IV) {
                            debug.text(Debug.TYPE_PUBLIC, className, "initGCM", "GCMParameterSpec specified.  IV is NULL");
                        } else {
                            debug.text(Debug.TYPE_PUBLIC, className, "initGCM", "GCMParameterSpec specified.  IV length = " + this.GCM_IV.length);
                        }
                    }
                    int t_size_in_bits = ((GCMParameterSpec)params).getTLen();
                    this.GCM_T_size = t_size_in_bits / 8;
                    if (debug != null) {
                        debug.text(Debug.TYPE_PUBLIC, className, "initGCM", "TLen = " + t_size_in_bits + " bits => " + this.GCM_T_size + " bytes.");
                    }
                    if (t_size_in_bits <= 0) {
                        String iape_msg = "The GCMParameterSpec tLen must be greater than 0.";
                        InvalidAlgorithmParameterException iape = new InvalidAlgorithmParameterException(iape_msg);
                        if (debug != null) {
                            debug.text(Debug.TYPE_PUBLIC, className, "initGCM", iape_msg);
                            debug.exception(Debug.TYPE_PUBLIC, className, "initGCM", iape);
                            debug.exit(Debug.TYPE_FINE, className, "initGCM1");
                        }
                        throw iape;
                    }
                    if (t_size_in_bits % 8 != 0) {
                        String iape_msg = "The GCMParameterSpec tLen must be an even multiple of 8.";
                        InvalidAlgorithmParameterException iape = new InvalidAlgorithmParameterException(iape_msg);
                        if (debug != null) {
                            debug.text(Debug.TYPE_PUBLIC, className, "initGCM", iape_msg);
                            debug.exception(Debug.TYPE_PUBLIC, className, "initGCM", iape);
                            debug.exit(Debug.TYPE_FINE, className, "initGCM2");
                        }
                        throw iape;
                    }
                    break block24;
                } else {
                    InvalidAlgorithmParameterException iape = new InvalidAlgorithmParameterException("Wrong parameter type: IV or GCM expected");
                    if (debug != null) {
                        debug.text(Debug.TYPE_PUBLIC, className, "initGCM", "Wrong parameter type: IV or GCM expected");
                        debug.exception(Debug.TYPE_PUBLIC, className, "initGCM", iape);
                        debug.exit(Debug.TYPE_FINE, className, "initGCM3");
                    }
                    throw iape;
                }
            }
            this.GCM_T_size = 16;
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "initGCM", "defaulted TLen = 128 bits => " + this.GCM_T_size + " bytes.");
            }
        }
        if (null == this.GCM_IV || 0 == this.GCM_IV.length) {
            if (this.decrypting) {
                String iape_msg = "The GCMParameterSpec src buffer must contain IV bytes.";
                InvalidAlgorithmParameterException iape = new InvalidAlgorithmParameterException(iape_msg);
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "initGCM", iape_msg);
                    debug.exception(Debug.TYPE_PUBLIC, className, "initGCM", iape);
                    debug.exit(Debug.TYPE_FINE, className, "initGCM4");
                }
                throw iape;
            }
            this.GCM_IV = new byte[16];
            SecureRandom rnd = random == null ? new SecureRandom() : random;
            rnd.nextBytes(this.GCM_IV);
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "initGCM", "IV generated.  Length = " + this.GCM_IV.length);
            }
        }
        this.GCM_parmSpec = new GCMParameterSpec(this.GCM_T_size * 8, this.GCM_IV);
        this.specifiedKey = key;
        this.hdwrUtils = new JCEHdwrUtils();
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "initGCM7");
        }
    }

    @Override
    protected void engineInit(int opmode, Key key, AlgorithmParameters params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (debug != null) {
            Object[] parms = new Object[]{new Integer(opmode), key, params, random};
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineInit", parms);
        }
        if (key == null) {
            InvalidKeyException ike = new InvalidKeyException("No key given");
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineInit", "No key given");
                debug.exception(Debug.TYPE_PUBLIC, className, "engineInit", ike);
                debug.exit(Debug.TYPE_FINE, className, "engineInit50");
            }
            throw ike;
        }
        this.initRandom = random;
        this.specifiedKey = key;
        IvParameterSpec ivSpec = null;
        GCMParameterSpec gcmSpec = null;
        this.GCM_T_size = -1;
        this.GCM_AAD = new byte[0];
        this.GCM_IV = null;
        this.GCM_parmSpec = null;
        if (key.getFormat().equalsIgnoreCase("CKDSLabel")) {
            this.isLabel = true;
            this.isToken = false;
        } else if (key.getFormat().equalsIgnoreCase("ICSFToken")) {
            this.isLabel = false;
            this.isToken = true;
        } else {
            this.isLabel = false;
            this.isToken = false;
        }
        if (this.cipherMode != 1 && this.cipherMode != 0 && this.cipherMode != 2 && this.cipherMode != 3 && this.cipherMode != 5 && this.isLabel) {
            InvalidKeyException ike = new InvalidKeyException("A CKDS label key may only be used with ECB, CFB, OFB, GCM, or CBC mode.");
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineInit", "A CKDS label key may only be used with ECB, CFB, OFB, GCM, or CBC mode.");
                debug.exception(Debug.TYPE_PUBLIC, className, "engineInit", ike);
                debug.exit(Debug.TYPE_FINE, className, "engineInit51");
            }
            throw ike;
        }
        if (this.cipherMode != 1 && this.cipherMode != 0 && this.isToken) {
            InvalidKeyException ike = new InvalidKeyException("An ICSF token key can only be used with ECB or CBC mode.");
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineInit", "An ICSF token key can only be used with ECB or CBC mode.");
                debug.exception(Debug.TYPE_PUBLIC, className, "engineInit", ike);
                debug.exit(Debug.TYPE_FINE, className, "engineInit52");
            }
            throw ike;
        }
        if (params == null) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineInit", "null AlgorithmParameters specified.");
            }
            this.engineInit(opmode, key, (AlgorithmParameterSpec)null, random);
        } else if (this.cipherMode == 5) {
            try {
                gcmSpec = params.getParameterSpec(GCMParameterSpec.class);
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "engineInit", "GCM AlgorithmParameters specified.");
                }
                this.engineInit(opmode, key, gcmSpec, random);
            }
            catch (InvalidParameterSpecException ipse) {
                try {
                    ivSpec = params.getParameterSpec(IvParameterSpec.class);
                    if (debug != null) {
                        debug.text(Debug.TYPE_PUBLIC, className, "engineInit", "IV AlgorithmParameters specified.");
                    }
                    this.engineInit(opmode, key, ivSpec, random);
                }
                catch (InvalidParameterSpecException ipse2) {
                    InvalidAlgorithmParameterException iape = new InvalidAlgorithmParameterException("Wrong parameter type: IV or GCM expected");
                    if (debug != null) {
                        debug.text(Debug.TYPE_PUBLIC, className, "engineInit", "Wrong parameter type: IV or GCM expected");
                        debug.exception(Debug.TYPE_PUBLIC, className, "engineInit", iape);
                        debug.exit(Debug.TYPE_FINE, className, "engineInit53");
                    }
                    throw iape;
                }
            }
        } else {
            try {
                ivSpec = params.getParameterSpec(IvParameterSpec.class);
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "engineInit", "IV AlgorithmParameters specified.");
                }
            }
            catch (InvalidParameterSpecException ipse) {
                InvalidAlgorithmParameterException iape = new InvalidAlgorithmParameterException("Wrong parameter type: IV expected");
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "engineInit", "Wrong parameter type: IV expected");
                    debug.exception(Debug.TYPE_PUBLIC, className, "engineInit", iape);
                    debug.exit(Debug.TYPE_FINE, className, "engineInit54");
                }
                throw iape;
            }
            this.engineInit(opmode, key, ivSpec, random);
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "engineInit55");
        }
    }

    protected void engineUpdateAAD(byte[] src) throws IllegalArgumentException, IllegalStateException, UnsupportedOperationException {
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineUpdateAAD", (Object)src);
        }
        this.engineUpdateAAD(src, 0, src.length);
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, className, "engineUpdateAAD");
        }
    }

    @Override
    protected void engineUpdateAAD(byte[] src, int offset, int len) throws IllegalArgumentException, IllegalStateException, UnsupportedOperationException {
        if (debug != null) {
            Object[] parms = new Object[]{src, new Integer(offset), new Integer(len)};
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineUpdateAAD", parms);
        }
        if (this.cipherMode != 5) {
            String ise_msg = "This method is only supported in GCM mode.";
            IllegalStateException ise = new IllegalStateException(ise_msg);
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineUpdateAAD", ise_msg);
                debug.exception(Debug.TYPE_PUBLIC, className, "engineUpdateAAD", ise);
                debug.exit(Debug.TYPE_FINE, className, "engineUpdateAAD");
            }
            throw ise;
        }
        if (null == src || 0 == src.length) {
            String iae_msg = "No AAD data was specified.";
            IllegalArgumentException iae = new IllegalArgumentException(iae_msg);
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineUpdateAAD", iae_msg);
                debug.exception(Debug.TYPE_PUBLIC, className, "engineUpdateAAD", iae);
                debug.exit(Debug.TYPE_FINE, className, "engineUpdateAAD");
            }
            throw iae;
        }
        byte[] newBuffer = null;
        int newBufferPos = 0;
        if (null == this.GCM_AAD || 0 == this.GCM_AAD.length) {
            newBuffer = new byte[len];
        } else {
            newBuffer = new byte[this.GCM_AAD.length + len];
            System.arraycopy(this.GCM_AAD, 0, newBuffer, 0, this.GCM_AAD.length);
            newBufferPos = this.GCM_AAD.length;
        }
        if (debug != null) {
            debug.text(Debug.TYPE_PUBLIC, className, "engineUpdateAAD", "On entry, current AAD length is " + newBufferPos);
        }
        System.arraycopy(src, offset, newBuffer, newBufferPos, len);
        this.GCM_AAD = newBuffer;
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineUpdateAAD", "On exit, current AAD length is " + this.GCM_AAD.length);
        }
    }

    @Override
    protected byte[] engineUpdate(byte[] input, int inputOffset, int inputLen) {
        byte[] out;
        block8: {
            byte[] output = null;
            out = null;
            if (debug != null) {
                Object[] parms = new Object[]{input, new Integer(inputOffset), new Integer(inputLen)};
                debug.entry(Debug.TYPE_FINE, (Object)className, "engineUpdate", parms);
            }
            if (this.cipherMode == 5) {
                String ise_msg = "(3) This method is not supported in GCM mode.";
                IllegalStateException ise = new IllegalStateException(ise_msg);
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "engineUpdate", ise_msg);
                    debug.exception(Debug.TYPE_PUBLIC, className, "engineUpdate", ise);
                    debug.exit(Debug.TYPE_FINE, className, "engineUpdate");
                }
                throw ise;
            }
            try {
                output = new byte[this.engineGetOutputSize(inputLen)];
                int len = this.engineUpdate(input, inputOffset, inputLen, output, 0);
                if (len < output.length) {
                    out = new byte[len];
                    System.arraycopy(output, 0, out, 0, len);
                } else {
                    out = output;
                }
            }
            catch (ShortBufferException e) {
                if (debug == null) break block8;
                debug.exception(Debug.TYPE_PUBLIC, className, "engineUpdate", e);
            }
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineUpdate", out);
        }
        return out;
    }

    @Override
    protected int engineUpdate(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws ShortBufferException {
        if (debug != null) {
            Object[] parms = new Object[]{input, new Integer(inputOffset), new Integer(inputLen), output, new Integer(outputOffset)};
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineUpdate", parms);
        }
        if (this.cipherMode == 5) {
            String ise_msg = "(4) This method is not supported in GCM mode.";
            IllegalStateException ise = new IllegalStateException(ise_msg);
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineUpdate", ise_msg);
                debug.exception(Debug.TYPE_PUBLIC, className, "engineUpdate", ise);
                debug.exit(Debug.TYPE_FINE, className, "engineUpdate");
            }
            throw ise;
        }
        int len = this.buffered + inputLen;
        if (this.padding != null && this.decrypting) {
            len -= 16;
        }
        len = len < 0 ? 0 : len;
        len -= len % this.unitBytes;
        if (output == null || output.length - outputOffset < len) {
            ShortBufferException sbe = new ShortBufferException("Output buffer must be (at least) " + len + " bytes long");
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineUpdate", "Output buffer must be (at least) " + len + " bytes long");
                debug.exception(Debug.TYPE_PUBLIC, className, "engineUpdate", sbe);
                debug.exit(Debug.TYPE_FINE, className, "engineUpdate");
            }
            throw sbe;
        }
        if (len > 0) {
            byte[] in = new byte[len];
            int inputConsumed = len - this.buffered;
            int bufferedConsumed = this.buffered;
            if (inputConsumed < 0) {
                inputConsumed = 0;
                bufferedConsumed = len;
            }
            if (this.buffered != 0) {
                System.arraycopy(this.buffer, 0, in, 0, bufferedConsumed);
            }
            if (inputConsumed > 0) {
                System.arraycopy(input, inputOffset, in, bufferedConsumed, inputConsumed);
            }
            if (this.decrypting) {
                this.hdwrUtils.decrypt(in, 0, len, output, outputOffset, this.keyToken, "AES", this.cipherMode, this.lcfbLen, this.icvMode);
            } else {
                this.hdwrUtils.encrypt(in, 0, len, output, outputOffset, this.keyToken, "AES", this.cipherMode, this.lcfbLen, this.icvMode);
            }
            if (this.icvMode.equals((Object)ICVSelection.ICV_INITIAL)) {
                this.icvMode = ICVSelection.ICV_CONTINUE;
            }
            if (this.unitBytes != 16) {
                this.diffBlocksize = len < this.diffBlocksize ? (this.diffBlocksize -= len) : 16 - (len - this.diffBlocksize) % 16;
            }
            inputLen -= inputConsumed;
            inputOffset += inputConsumed;
            outputOffset += len;
            this.buffered -= bufferedConsumed;
            if (this.buffered > 0) {
                System.arraycopy(this.buffer, bufferedConsumed, this.buffer, 0, this.buffered);
            }
        }
        if (inputLen > 0) {
            System.arraycopy(input, inputOffset, this.buffer, this.buffered, inputLen);
        }
        this.buffered += inputLen;
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineUpdate", len < 0 ? 0 : len);
        }
        return len < 0 ? 0 : len;
    }

    @Override
    protected byte[] engineDoFinal(byte[] input, int inputOffset, int inputLen) throws IllegalBlockSizeException, BadPaddingException {
        byte[] out;
        block9: {
            byte[] output = null;
            out = null;
            if (debug != null) {
                Object[] parms = new Object[]{input, new Integer(inputOffset), new Integer(inputLen)};
                debug.entry(Debug.TYPE_FINE, (Object)className, "engineDoFinal", parms);
            }
            if (this.cipherMode == 5 && this.decrypting && this.GCM_T_size > inputLen) {
                String iae_msg = "Decrypting in GCM mode. The input cipherText buffer cannot be shorter than TLen.";
                IllegalArgumentException iae = new IllegalArgumentException(iae_msg);
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "engineDoFinal", iae_msg);
                    debug.exception(Debug.TYPE_PUBLIC, className, "engineDoFinal", iae);
                    debug.exit(Debug.TYPE_FINE, className, "engineDoFinal");
                }
                throw iae;
            }
            try {
                output = new byte[this.engineGetOutputSize(inputLen)];
                int len = this.engineDoFinal(input, inputOffset, inputLen, output, 0);
                if (len < output.length) {
                    out = new byte[len];
                    if (len != 0) {
                        System.arraycopy(output, 0, out, 0, len);
                    }
                } else {
                    out = output;
                }
            }
            catch (ShortBufferException e) {
                if (debug == null) break block9;
                debug.exception(Debug.TYPE_PUBLIC, className, "engineDoFinal", e);
            }
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineDoFinal", out);
        }
        return out;
    }

    @Override
    protected int engineDoFinal(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws IllegalBlockSizeException, ShortBufferException, BadPaddingException {
        int totalLen;
        int paddedLen = totalLen = this.buffered + inputLen;
        int paddingLen = 0;
        if (debug != null) {
            Object[] parms = new Object[]{input, new Integer(inputOffset), new Integer(inputLen), output, new Integer(outputOffset), new Integer(totalLen), new Integer(this.unitBytes)};
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineDoFinal", parms);
        }
        if (this.jitOptimized && this.jitCipherModeString.startsWith("CFB") && this.unitBytes != 16) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineDoFinal", "jitOptimized = " + this.jitOptimized + ", jitCipherModeString = " + this.jitCipherModeString + ", unitBytes = " + this.unitBytes);
            }
            int result = this.doFinalCFBinJIT(input, inputOffset, inputLen, output, outputOffset);
            if (debug != null) {
                debug.exit(Debug.TYPE_FINE, (Object)className, "engineDoFinal1", result);
            }
            return result;
        }
        if (this.cipherMode == 5) {
            String iae_msg;
            if (this.decrypting && this.GCM_T_size > inputLen) {
                iae_msg = "Decrypting in GCM mode. The input cipherText buffer cannot be shorter than TLen.";
                IllegalArgumentException iae = new IllegalArgumentException(iae_msg);
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "engineDoFinal", iae_msg);
                    debug.exception(Debug.TYPE_PUBLIC, className, "engineDoFinal", iae);
                    debug.exit(Debug.TYPE_FINE, className, "engineDoFinal");
                }
                throw iae;
            }
            if (0 == inputLen && 0 == this.GCM_AAD.length) {
                iae_msg = "For AES/GCM, at least one of Additional Authentication Data (AAD) and input text must have non-zero length.";
                IllegalArgumentException iae = new IllegalArgumentException(iae_msg);
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "engineDoFinal", iae_msg);
                    debug.exception(Debug.TYPE_PUBLIC, className, "engineDoFinal", iae);
                    debug.exit(Debug.TYPE_FINE, className, "engineDoFinal");
                }
                throw iae;
            }
            try {
                this.keyToken = this.hdwrUtils.initHdwr(this.specifiedKey, this.GCM_IV, this.GCM_T_size, this.GCM_AAD);
            }
            catch (InvalidKeyException ike) {
                String rte_msg = "InvalidKeyException thrown by initHdwr() for GCM mode cipher: " + ike.getMessage();
                RuntimeException rte = new RuntimeException(rte_msg, ike);
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "engineDoFinal", rte_msg);
                    debug.exception(Debug.TYPE_PUBLIC, className, "engineDoFinal", rte);
                    debug.exit(Debug.TYPE_FINE, className, "engineDoFinal");
                }
                throw rte;
            }
        }
        if (this.unitBytes != 16) {
            this.diffBlocksize = totalLen < this.diffBlocksize ? (this.diffBlocksize -= totalLen) : 16 - (totalLen - this.diffBlocksize) % 16;
            paddingLen = this.diffBlocksize;
        } else if (this.padding != null) {
            paddingLen = this.padding.padLength(totalLen);
        }
        if (debug != null) {
            debug.text(Debug.TYPE_PUBLIC, className, "engineDoFinal", "blockSize checking  " + this.diffBlocksize + " " + paddingLen + " " + this.decrypting);
        }
        if (this.diffBlocksize > 0 && this.diffBlocksize != 16 && this.padding == null && !this.decrypting && this.cipherMode != 2 && this.cipherMode != 3 && this.cipherMode != 5) {
            IllegalBlockSizeException ibse = new IllegalBlockSizeException("Input length must be multiple of 16 when encrypting with Nopadded cipher");
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineDoFinal", "Input length must be multiple of 16 when encrypting with Nopadded cipher");
                debug.exception(Debug.TYPE_PUBLIC, className, "engineDoFinal", ibse);
                debug.exit(Debug.TYPE_FINE, className, "engineDoFinal");
            }
            throw ibse;
        }
        if (!this.decrypting && this.padding != null) {
            paddedLen += paddingLen;
        }
        if (output == null) {
            output = new byte[]{};
        }
        int spaceOutBuff = output.length - outputOffset;
        int spaceOutBuffNeeded = 0;
        int sizeOutBuffNeeded = 0;
        if (this.cipherMode == 5) {
            String sbe_msg;
            String msg;
            if (this.decrypting) {
                spaceOutBuffNeeded = inputLen - this.GCM_T_size;
                sizeOutBuffNeeded = outputOffset + spaceOutBuffNeeded;
                if (debug != null) {
                    msg = "\nGCM mode decryption: inputLen = " + inputLen + "  paddingLen = " + paddingLen + "  GCM_T_size = " + this.GCM_T_size + "\nGCM mode decryption: spaceOutBuffNeeded = " + spaceOutBuffNeeded + "  spaceOutBuff = " + spaceOutBuff;
                    debug.text(Debug.TYPE_PUBLIC, className, "engineDoFinal", msg);
                }
                if (spaceOutBuff < spaceOutBuffNeeded) {
                    sbe_msg = "Output buffer too short for GCM mode decryption. " + output.length + " bytes given, " + sizeOutBuffNeeded + " bytes needed.";
                    ShortBufferException sbe = new ShortBufferException(sbe_msg);
                    if (debug != null) {
                        debug.text(Debug.TYPE_PUBLIC, className, "engineDoFinal", sbe_msg);
                        debug.exception(Debug.TYPE_PUBLIC, className, "engineDoFinal", sbe);
                        debug.exit(Debug.TYPE_FINE, className, "engineDoFinal");
                    }
                    throw sbe;
                }
            } else {
                spaceOutBuffNeeded = inputLen + this.GCM_T_size;
                sizeOutBuffNeeded = outputOffset + spaceOutBuffNeeded;
                if (debug != null) {
                    msg = "\nGCM mode encryption: paddedLen = " + paddedLen + "  GCM_T_size = " + this.GCM_T_size + "\nGCM mode encryption: spaceOutBuffNeeded = " + spaceOutBuffNeeded + "  spaceOutBuff = " + spaceOutBuff;
                    debug.text(Debug.TYPE_PUBLIC, className, "engineDoFinal", msg);
                }
                if (spaceOutBuff < spaceOutBuffNeeded) {
                    sbe_msg = "Output buffer too short for GCM mode encryption because it must accommodate padding characters and the Authentication Tag. " + output.length + " bytes given, " + sizeOutBuffNeeded + " bytes needed.";
                    ShortBufferException sbe = new ShortBufferException(sbe_msg);
                    if (debug != null) {
                        debug.text(Debug.TYPE_PUBLIC, className, "engineDoFinal", sbe_msg);
                        debug.exception(Debug.TYPE_PUBLIC, className, "engineDoFinal", sbe);
                        debug.exit(Debug.TYPE_FINE, className, "engineDoFinal");
                    }
                    throw sbe;
                }
            }
        } else if (!(spaceOutBuff >= paddedLen || this.decrypting && this.padding != null)) {
            ShortBufferException sbe = new ShortBufferException("Output buffer too short: " + spaceOutBuff + " bytes given, " + paddedLen + " bytes needed");
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineDoFinal", "Output buffer too short: " + spaceOutBuff + " bytes given, " + paddedLen + " bytes needed");
                debug.exception(Debug.TYPE_PUBLIC, className, "engineDoFinal", sbe);
                debug.exit(Debug.TYPE_FINE, className, "engineDoFinal");
            }
            throw sbe;
        }
        byte[] outWithPadding = null;
        byte[] finalBuf = null;
        if (this.padding == null || this.decrypting) {
            byte[] out = output;
            int outOffset = outputOffset;
            if (this.padding != null) {
                outWithPadding = new byte[totalLen];
                out = outWithPadding;
                outOffset = 0;
            }
            if (this.buffered == 0 && inputOffset == 0) {
                try {
                    totalLen = this.finalNoPadding(input, inputOffset, out, outOffset, inputLen);
                }
                catch (JCECCARuntimeException jrte) {
                    if (this.decrypting && this.cipherMode == 5 && 8 == jrte.getReturnCode() && 2028 == jrte.getReasonCode()) {
                        String abteMsg = "CSNBSYD returned (8,2028). Decryption failed because the AuthenticationTag does not match the data provided.(1)";
                        AEADBadTagException abte = new AEADBadTagException(abteMsg);
                        if (null != debug) {
                            debug.text(Debug.TYPE_PUBLIC, className, "engineDoFinal", abteMsg);
                            debug.exception(Debug.TYPE_PUBLIC, className, "engineDoFinal", abte);
                            debug.exit(Debug.TYPE_FINE, className, "engineDoFinal");
                        }
                        throw abte;
                    }
                    if (this.cipherMode == 5 && 8 == jrte.getReturnCode() && 11000 == jrte.getReasonCode()) {
                        String apiName = "CSNBSYE";
                        if (this.decrypting) {
                            apiName = "CSNBSYD";
                        }
                        String iae_msg = apiName + " returned (8,11000). Verify that the TLen specified is supported by ICSF.(1)";
                        IllegalArgumentException iae = new IllegalArgumentException(iae_msg);
                        if (debug != null) {
                            debug.text(Debug.TYPE_PUBLIC, className, "engineDoFinal", iae_msg);
                            debug.exception(Debug.TYPE_PUBLIC, className, "engineDoFinal", iae);
                            debug.exit(Debug.TYPE_FINE, className, "engineDoFinal");
                        }
                        throw iae;
                    }
                    throw jrte;
                }
            } else {
                finalBuf = new byte[totalLen];
                System.arraycopy(this.buffer, 0, finalBuf, 0, this.buffered);
                if (inputLen != 0) {
                    System.arraycopy(input, inputOffset, finalBuf, this.buffered, inputLen);
                }
                try {
                    totalLen = this.finalNoPadding(finalBuf, 0, out, outOffset, totalLen);
                }
                catch (JCECCARuntimeException jrte) {
                    if (this.decrypting && this.cipherMode == 5 && 8 == jrte.getReturnCode() && 2028 == jrte.getReasonCode()) {
                        String abteMsg = "CSNBSYD returned (8,2028). Decryption failed because the AuthenticationTag does not match the data provided.(2)";
                        AEADBadTagException abte = new AEADBadTagException(abteMsg);
                        if (null != debug) {
                            debug.text(Debug.TYPE_PUBLIC, className, "engineDoFinal", abteMsg);
                            debug.exception(Debug.TYPE_PUBLIC, className, "engineDoFinal", abte);
                            debug.exit(Debug.TYPE_FINE, className, "engineDoFinal");
                        }
                        throw abte;
                    }
                    if (this.cipherMode == 5 && 8 == jrte.getReturnCode() && 11000 == jrte.getReasonCode()) {
                        String apiName = "CSNBSYE";
                        if (this.decrypting) {
                            apiName = "CSNBSYD";
                        }
                        String iae_msg = apiName + " returned (8,11000). Verify that the TLen specified is supported by ICSF.(2)";
                        IllegalArgumentException iae = new IllegalArgumentException(iae_msg);
                        if (debug != null) {
                            debug.text(Debug.TYPE_PUBLIC, className, "engineDoFinal", iae_msg);
                            debug.exception(Debug.TYPE_PUBLIC, className, "engineDoFinal", iae);
                            debug.exit(Debug.TYPE_FINE, className, "engineDoFinal");
                        }
                        throw iae;
                    }
                    throw jrte;
                }
            }
        } else {
            finalBuf = new byte[paddedLen];
            if (this.buffered != 0) {
                System.arraycopy(this.buffer, 0, finalBuf, 0, this.buffered);
            }
            if (inputLen != 0) {
                System.arraycopy(input, inputOffset, finalBuf, this.buffered, inputLen);
            }
            this.padding.padWithLen(finalBuf, totalLen, paddingLen);
            try {
                totalLen = this.finalNoPadding(finalBuf, 0, output, outputOffset, paddedLen);
            }
            catch (JCECCARuntimeException jrte) {
                if (this.cipherMode == 5 && 8 == jrte.getReturnCode() && 11000 == jrte.getReasonCode()) {
                    String apiName = "CSNBSYE";
                    if (this.decrypting) {
                        apiName = "CSNBSYD";
                    }
                    String iae_msg = apiName + " returned (8,11000). Verify that the TLen specified is supported by ICSF.(3)";
                    IllegalArgumentException iae = new IllegalArgumentException(iae_msg);
                    if (debug != null) {
                        debug.text(Debug.TYPE_PUBLIC, className, "engineDoFinal", iae_msg);
                        debug.exception(Debug.TYPE_PUBLIC, className, "engineDoFinal", iae);
                        debug.exit(Debug.TYPE_FINE, className, "engineDoFinal");
                    }
                    throw iae;
                }
                throw jrte;
            }
        }
        if (this.decrypting && this.padding != null) {
            int padStart = this.padding.unpad(outWithPadding, 0, totalLen);
            if (padStart < 0) {
                BadPaddingException bpe = new BadPaddingException("Given final block not properly padded");
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "engineDoFinal", "Given final block not properly padded");
                    debug.exception(Debug.TYPE_PUBLIC, className, "engineDoFinal", bpe);
                    debug.exit(Debug.TYPE_FINE, className, "engineDoFinal");
                }
                throw bpe;
            }
            totalLen = padStart;
            if (output.length - outputOffset < totalLen) {
                ShortBufferException sbe = new ShortBufferException("Output buffer too short: " + (output.length - outputOffset) + " bytes given, " + paddedLen + " bytes needed");
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "engineDoFinal", "Output buffer too short: " + (output.length - outputOffset) + " bytes given, " + paddedLen + " bytes needed");
                    debug.exception(Debug.TYPE_PUBLIC, className, "engineDoFinal", sbe);
                    debug.exit(Debug.TYPE_FINE, className, "engineDoFinal");
                }
                throw sbe;
            }
            for (int i = 0; i < totalLen; ++i) {
                output[outputOffset + i] = outWithPadding[i];
            }
        }
        this.buffered = 0;
        this.diffBlocksize = 16;
        this.GCM_AAD = new byte[0];
        if (this.cipherMode != 0 && this.cipherMode != 5) {
            FeedbackCipher fc = (FeedbackCipher)((Object)this.cipher);
            fc.reset();
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineDoFinal", totalLen);
        }
        if (this.hdwrUtils != null) {
            this.icvMode = ICVSelection.ICV_INITIAL;
            if (this.cipherMode == 1) {
                try {
                    this.engineInit(this.decrypting ? 2 : 1, this.specifiedKey, new IvParameterSpec(this.cipher.getIV()), this.initRandom);
                }
                catch (Exception ex) {
                    RuntimeException rte = new RuntimeException("Unable to reinitialize keyToken.", ex);
                    if (debug != null) {
                        debug.text(Debug.TYPE_PUBLIC, className, "engineDoFinal", "Unable to reinitialize keyToken.");
                        debug.exception(Debug.TYPE_PUBLIC, className, "engineDoFinal", rte);
                        debug.exit(Debug.TYPE_FINE, className, "engineDoFinal");
                    }
                    throw rte;
                }
            }
        }
        if (this.cipherMode == 5) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineDoFinal", "GCM Mode: returned value changed from " + totalLen + " to " + spaceOutBuffNeeded);
            }
            totalLen = spaceOutBuffNeeded;
        }
        return totalLen;
    }

    private int doFinalCFBinJIT(byte[] input, int inputOffset, int inputLen, byte[] output, int outputOffset) throws IllegalBlockSizeException, ShortBufferException, BadPaddingException {
        int cfbPadding;
        int totalLen;
        int paddedLen = totalLen = this.buffered + inputLen;
        int paddingLen = 0;
        if (debug != null) {
            Object[] parms = new Object[]{input, new Integer(inputOffset), new Integer(inputLen), output, new Integer(outputOffset), new Integer(totalLen), new Integer(this.unitBytes)};
            debug.entry(Debug.TYPE_FINE, (Object)className, "doFinalCFBinJIT", parms);
        }
        int n = cfbPadding = this.padding == null ? totalLen % this.unitBytes : 0;
        if (debug != null) {
            debug.text(Debug.TYPE_FINEST, className, "doFinalCFBinJIT", "buffered = " + this.buffered + ", inputLen = " + inputLen + ", paddedLen = " + paddedLen + ", paddingLen = " + paddingLen + ", cfbPadding = " + cfbPadding);
        }
        if (this.unitBytes != this.engineGetBlockSize()) {
            this.diffBlocksize = totalLen < this.diffBlocksize ? (this.diffBlocksize -= totalLen) : this.engineGetBlockSize() - (totalLen - this.diffBlocksize) % this.engineGetBlockSize();
            paddingLen = this.diffBlocksize;
        } else if (this.padding != null) {
            paddingLen = this.padding.padLength(totalLen);
        }
        if (this.diffBlocksize > 0 && this.diffBlocksize != this.engineGetBlockSize() && this.padding != null && this.decrypting) {
            String errMsg = "Input length must be multiple of " + this.engineGetBlockSize() + " when decrypting with padded cipher";
            IllegalBlockSizeException ibe = new IllegalBlockSizeException(errMsg);
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "doFinalCFBinJIT", errMsg);
                debug.exception(Debug.TYPE_FINE, className, "doFinalCFBinJIT", ibe);
                debug.exit(Debug.TYPE_FINE, className, "doFinalCFBinJIT");
            }
            throw ibe;
        }
        if (!this.decrypting && this.padding != null) {
            paddedLen += paddingLen;
        }
        if (output == null || output.length - outputOffset < paddedLen && (!this.decrypting || this.padding == null)) {
            String errMsg = "Output buffer too short: " + (output.length - outputOffset) + " bytes given, " + paddedLen + " bytes needed";
            ShortBufferException sbe = new ShortBufferException(errMsg);
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "doFinalCFBinJIT", errMsg);
                debug.exception(Debug.TYPE_FINE, className, "doFinalCFBinJIT", sbe);
                debug.exit(Debug.TYPE_FINE, className, "doFinalCFBinJIT");
            }
            throw sbe;
        }
        byte[] outWithPadding = null;
        byte[] finalBuf = null;
        if (cfbPadding != 0) {
            int totalPaddedLength = totalLen - cfbPadding + this.unitBytes;
            outWithPadding = new byte[totalPaddedLength];
            if (this.buffered != 0) {
                System.arraycopy(this.buffer, 0, outWithPadding, 0, this.buffered);
            }
            if (inputLen != 0) {
                System.arraycopy(input, inputOffset, outWithPadding, this.buffered, inputLen);
            }
            this.finalNoPadding(outWithPadding, 0, outWithPadding, 0, totalPaddedLength);
            System.arraycopy(outWithPadding, 0, output, outputOffset, totalLen);
        } else if (this.padding == null || this.decrypting) {
            byte[] out = output;
            int outOffset = outputOffset;
            if (this.padding != null) {
                outWithPadding = new byte[totalLen];
                out = outWithPadding;
                outOffset = 0;
            }
            if (this.buffered == 0) {
                totalLen = this.finalNoPadding(input, inputOffset, out, outOffset, inputLen);
            } else {
                finalBuf = new byte[totalLen];
                System.arraycopy(this.buffer, 0, finalBuf, 0, this.buffered);
                if (inputLen != 0) {
                    System.arraycopy(input, inputOffset, finalBuf, this.buffered, inputLen);
                }
                totalLen = this.finalNoPadding(finalBuf, 0, out, outOffset, totalLen);
            }
        } else {
            finalBuf = new byte[paddedLen];
            if (this.buffered != 0) {
                System.arraycopy(this.buffer, 0, finalBuf, 0, this.buffered);
            }
            if (inputLen != 0) {
                System.arraycopy(input, inputOffset, finalBuf, this.buffered, inputLen);
            }
            this.padding.padWithLen(finalBuf, totalLen, paddingLen);
            totalLen = this.finalNoPadding(finalBuf, 0, output, outputOffset, paddedLen);
        }
        if (this.decrypting && this.padding != null) {
            int padStart = this.padding.unpad(outWithPadding, 0, totalLen);
            if (padStart < 0) {
                String errMsg = "Given final block not properly padded";
                BadPaddingException bpe = new BadPaddingException(errMsg);
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "doFinalCFBinJIT1", errMsg);
                    debug.exception(Debug.TYPE_FINE, className, "doFinalCFBinJIT1", bpe);
                    debug.exit(Debug.TYPE_FINE, className, "doFinalCFBinJIT1");
                }
                throw bpe;
            }
            totalLen = padStart;
            if (output.length - outputOffset < totalLen) {
                String errMsg = "Output buffer too short: " + (output.length - outputOffset) + " bytes given, " + totalLen + " bytes needed";
                ShortBufferException sbe = new ShortBufferException(errMsg);
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "doFinalCFBinJIT1", errMsg);
                    debug.exception(Debug.TYPE_FINE, className, "doFinalCFBinJIT1", sbe);
                    debug.exit(Debug.TYPE_FINE, className, "doFinalCFBinJIT1");
                }
                throw sbe;
            }
            System.arraycopy(outWithPadding, 0, output, outputOffset, totalLen);
        }
        this.buffered = 0;
        this.diffBlocksize = this.engineGetBlockSize();
        if (this.cipherMode != 0) {
            FeedbackCipher fc = (FeedbackCipher)((Object)this.cipher);
            fc.reset();
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "doFinalCFBinJIT", totalLen);
        }
        return totalLen;
    }

    private int finalNoPadding(byte[] in, int inOff, byte[] out, int outOff, int len) throws IllegalBlockSizeException {
        if (debug != null) {
            Object[] parms = new Object[]{in, new Integer(inOff), out, new Integer(outOff), new Integer(len)};
            debug.entry(Debug.TYPE_FINE, (Object)className, "finalNoPadding", parms);
        }
        if ((in == null || len == 0) && this.cipherMode == 5) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "finalNoPadding", "GCM mode with input length 0. Continuing with encrypt/decrypt.");
            }
            if (in == null) {
                in = new byte[]{};
            }
        } else if (in == null || len == 0) {
            if (debug != null) {
                debug.exit(Debug.TYPE_FINE, (Object)className, "finalNoPadding", 0);
            }
            return 0;
        }
        if (this.cipherMode != 2 && this.cipherMode != 3 && this.cipherMode != 5 && len % this.unitBytes != 0) {
            IllegalBlockSizeException ibse;
            if (this.padding != null) {
                ibse = new IllegalBlockSizeException("Input length (with padding) not multiple of " + this.unitBytes + " bytes");
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "finalNoPadding", "Input length (with padding) not multiple of " + this.unitBytes + " bytes");
                    debug.exception(Debug.TYPE_PUBLIC, className, "finalNoPadding", ibse);
                    debug.exit(Debug.TYPE_FINE, className, "finalNoPadding");
                }
                throw ibse;
            }
            ibse = new IllegalBlockSizeException("Input length not multiple of " + this.unitBytes + " bytes");
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "finalNoPadding", "Input length not multiple of " + this.unitBytes + " bytes");
                debug.exception(Debug.TYPE_PUBLIC, className, "finalNoPadding", ibse);
                debug.exit(Debug.TYPE_FINE, className, "finalNoPadding");
            }
            throw ibse;
        }
        if (this.cipherMode == 3 || this.cipherMode == 2) {
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "finalNoPadding", "cipherMode is OFB or CFB: " + this.cipherMode);
                debug.text(Debug.TYPE_PUBLIC, className, "finalNoPadding", "Current icvMode: " + (Object)((Object)this.icvMode));
            }
            if (this.icvMode.equals((Object)ICVSelection.ICV_INITIAL)) {
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "finalNoPadding", "icvMode is INITIAL. Changing the icvMode to ONLY.");
                }
                this.icvMode = ICVSelection.ICV_ONLY;
            } else {
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "finalNoPadding", "icvMode is NOT INITIAL. Changing the icvMode to FINAL.");
                }
                this.icvMode = ICVSelection.ICV_FINAL;
            }
        } else if (this.cipherMode == 5) {
            this.icvMode = ICVSelection.ICV_ONLY;
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "finalNoPadding", "icvMode for GCM set to " + (Object)((Object)this.icvMode));
            }
        }
        if (debug != null) {
            debug.text(Debug.TYPE_PUBLIC, className, "finalNoPadding", "len: " + len + ". inOff: " + inOff + ". outOff: " + outOff + ".");
            debug.text(Debug.TYPE_PUBLIC, className, "finalNoPadding", "lcfbLen: " + this.lcfbLen);
            debug.text(Debug.TYPE_PUBLIC, className, "finalNoPadding", "icvMode: " + (Object)((Object)this.icvMode));
        }
        if (this.decrypting) {
            this.hdwrUtils.decrypt(in, inOff, len, out, outOff, this.keyToken, "AES", this.cipherMode, this.lcfbLen, this.icvMode);
        } else {
            this.hdwrUtils.encrypt(in, inOff, len, out, outOff, this.keyToken, "AES", this.cipherMode, this.lcfbLen, this.icvMode);
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "finalNoPadding", len);
        }
        return len;
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        AlgorithmParameters params = null;
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, className, "engineGetParameters");
        }
        if (this.cipherMode == 0) {
            if (debug != null) {
                debug.exit(Debug.TYPE_FINE, (Object)className, "engineGetParameters", null);
            }
            return null;
        }
        if (this.cipherMode == 5) {
            if (null == this.GCM_parmSpec) {
                if (debug != null) {
                    debug.exit(Debug.TYPE_FINE, (Object)className, "engineGetParameters", null);
                }
                return null;
            }
            try {
                params = AlgorithmParameters.getInstance("AESGCM");
                params.init(this.GCM_parmSpec);
            }
            catch (NoSuchAlgorithmException nsae) {
                RuntimeException rte = new RuntimeException(nsae.getMessage());
                debug.exception(Debug.TYPE_PUBLIC, className, "engineInit", rte);
                debug.exit(Debug.TYPE_FINE, className, "engineInit5");
                throw rte;
            }
            catch (InvalidParameterSpecException ipse) {
                RuntimeException rte = new RuntimeException(ipse.getMessage());
                debug.exception(Debug.TYPE_PUBLIC, className, "engineInit", rte);
                debug.exit(Debug.TYPE_FINE, className, "engineInit6");
                throw rte;
            }
            if (debug != null) {
                debug.exit(Debug.TYPE_FINE, (Object)className, "engineGetParameters", params);
            }
            return params;
        }
        byte[] tiv = this.engineGetIV();
        if (tiv == null) {
            return null;
        }
        IvParameterSpec ivSpec = new IvParameterSpec(tiv);
        String provider = null;
        provider = Security.getProvider("IBMJCECCA") == null ? "IBMJCE4758" : "IBMJCECCA";
        try {
            params = AlgorithmParameters.getInstance("AES", provider);
        }
        catch (NoSuchAlgorithmException nsae) {
            RuntimeException rte = new RuntimeException(provider + " called, but not configured");
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineGetParameters", provider + " called, but not configured");
                debug.exception(Debug.TYPE_PUBLIC, className, "engineGetParameters", nsae);
                debug.exception(Debug.TYPE_PUBLIC, className, "engineGetParameters", rte);
                debug.exit(Debug.TYPE_FINE, className, "engineGetParameters");
            }
            throw rte;
        }
        catch (NoSuchProviderException nspe) {
            RuntimeException rte = new RuntimeException(provider + " called, but not configured");
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineGetParameters", provider + " called, but not configured");
                debug.exception(Debug.TYPE_PUBLIC, className, "engineGetParameters", nspe);
                debug.exception(Debug.TYPE_PUBLIC, className, "engineGetParameters", rte);
                debug.exit(Debug.TYPE_FINE, className, "engineGetParameters");
            }
            throw rte;
        }
        try {
            params.init(ivSpec);
        }
        catch (InvalidParameterSpecException ipse) {
            RuntimeException rte = new RuntimeException("IvParameterSpec not supported");
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineGetParameters", "IvParameterSpec not supported");
                debug.exception(Debug.TYPE_PUBLIC, className, "engineGetParameters", ipse);
                debug.exception(Debug.TYPE_PUBLIC, className, "engineGetParameters", rte);
                debug.exit(Debug.TYPE_FINE, className, "engineGetParameters");
            }
            throw rte;
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineGetParameters", params);
        }
        return params;
    }

    @Override
    protected int engineGetKeySize(Key key) {
        int keySize;
        block4: {
            keySize = 128;
            if (debug != null) {
                debug.entry(Debug.TYPE_FINE, (Object)className, "engineGetKeySize", key);
            }
            try {
                keySize = Cipher.getMaxAllowedKeyLength("AES");
            }
            catch (NoSuchAlgorithmException e) {
                if (debug == null) break block4;
                debug.exception(Debug.TYPE_PUBLIC, className, "engineGetKeySize", e);
            }
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineGetKeySize", keySize);
        }
        return keySize;
    }

    @Override
    protected byte[] engineWrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
        byte[] result;
        block16: {
            result = null;
            if (debug != null) {
                debug.entry(Debug.TYPE_FINE, (Object)className, "engineWrap", key);
            }
            if (this.cipherMode == 5) {
                String ise_msg = "(1) This method is not supported in GCM mode.";
                IllegalStateException ise = new IllegalStateException(ise_msg);
                if (debug != null) {
                    debug.text(Debug.TYPE_PUBLIC, className, "engineWrap", ise_msg);
                    debug.exception(Debug.TYPE_PUBLIC, className, "engineWrap", ise);
                    debug.exit(Debug.TYPE_FINE, className, "engineWrap");
                }
                throw ise;
            }
            if (null == key) {
                InvalidKeyException ike3 = new InvalidKeyException("The key specified to wrap() must not be null.");
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, "engineWrap", ike3);
                }
                throw ike3;
            }
            if (key instanceof PublicKey) {
                InvalidKeyException ike1 = new InvalidKeyException("PublicKey is not a key type supported by wrap() in this cipher.");
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, "engineWrap", ike1);
                }
                throw ike1;
            }
            if (key instanceof PrivateKey) {
                InvalidKeyException ike2 = new InvalidKeyException("PrivateKey is not a key type supported by wrap() in this cipher.");
                if (debug != null) {
                    debug.exception(Debug.TYPE_PUBLIC, className, "engineWrap", ike2);
                }
                throw ike2;
            }
            try {
                String keyType = key.getFormat();
                if (!"RAW".equalsIgnoreCase(keyType)) {
                    String ikeMsg = "This cipher can only wrap RAW keys. Specified key is type " + keyType + ".";
                    InvalidKeyException ike = new InvalidKeyException(ikeMsg);
                    if (debug != null) {
                        debug.text(Debug.TYPE_PUBLIC, className, "engineWrap", ikeMsg);
                        debug.exception(Debug.TYPE_PUBLIC, className, "engineWrap", ike);
                        debug.exit(Debug.TYPE_FINE, className, "engineWrap");
                    }
                    throw ike;
                }
                byte[] encodedKey = key.getEncoded();
                if (encodedKey == null || encodedKey.length == 0) {
                    InvalidKeyException ike = new InvalidKeyException("Cannot get an encoding of the key to be wrapped");
                    if (debug != null) {
                        debug.text(Debug.TYPE_PUBLIC, className, "engineWrap", "Cannot get an encoding of the key to be wrapped");
                        debug.exception(Debug.TYPE_PUBLIC, className, "engineWrap", ike);
                        debug.exit(Debug.TYPE_FINE, className, "engineWrap");
                    }
                    throw ike;
                }
                result = this.engineDoFinal(encodedKey, 0, encodedKey.length);
            }
            catch (BadPaddingException e) {
                if (debug == null) break block16;
                debug.exception(Debug.TYPE_PUBLIC, className, "engineWrap", e);
            }
        }
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineWrap", result);
        }
        return result;
    }

    @Override
    protected Key engineUnwrap(byte[] wrappedKey, String wrappedKeyAlgorithm, int wrappedKeyType) throws InvalidKeyException, NoSuchAlgorithmException {
        byte[] encodedKey;
        if (debug != null) {
            Object[] parms = new Object[]{wrappedKey, wrappedKeyAlgorithm, new Integer(wrappedKeyType)};
            debug.entry(Debug.TYPE_FINE, (Object)className, "engineUnwrap", parms);
        }
        SecretKey result = null;
        if (this.cipherMode == 5) {
            String ise_msg = "(2) This method is not supported in GCM mode.";
            IllegalStateException ise = new IllegalStateException(ise_msg);
            if (debug != null) {
                debug.text(Debug.TYPE_PUBLIC, className, "engineUnwrap", ise_msg);
                debug.exception(Debug.TYPE_PUBLIC, className, "engineUnwrap", ise);
                debug.exit(Debug.TYPE_FINE, className, "engineUnwrap");
            }
            throw ise;
        }
        if (null == wrappedKeyAlgorithm || "".equals(wrappedKeyAlgorithm)) {
            NoSuchAlgorithmException nsae = new NoSuchAlgorithmException("The wrappedKeyAlgorithm name specified to unwrap() must not be null or empty.");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineUnwrap", nsae);
            }
            throw nsae;
        }
        if (null == wrappedKey || 0 == wrappedKey.length) {
            InvalidKeyException ike = new InvalidKeyException("The wrapped key specified to unwrap() must not be null or empty.");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineUnwrap", ike);
            }
            throw ike;
        }
        if (wrappedKeyType == 1) {
            InvalidKeyException ike1 = new InvalidKeyException("PublicKey is not a key type supported by unwrap() in this cipher.");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineUnwrap", ike1);
            }
            throw ike1;
        }
        if (wrappedKeyType == 2) {
            InvalidKeyException ike2 = new InvalidKeyException("PrivateKey is not a key type supported by unwrap() in this cipher.");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineUnwrap", ike2);
            }
            throw ike2;
        }
        if (wrappedKeyType != 3) {
            InvalidKeyException ike3 = new InvalidKeyException("Unrecognized key type specified to unwrap().");
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineUnwrap", ike3);
            }
            throw ike3;
        }
        try {
            encodedKey = this.engineDoFinal(wrappedKey, 0, wrappedKey.length);
        }
        catch (BadPaddingException ePadding) {
            InvalidKeyException ike = new InvalidKeyException(ePadding);
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineUnwrap", ePadding);
                debug.exception(Debug.TYPE_PUBLIC, className, "engineUnwrap", ike);
                debug.exit(Debug.TYPE_FINE, className, "engineUnwrap");
            }
            throw ike;
        }
        catch (IllegalBlockSizeException eBlockSize) {
            InvalidKeyException ike = new InvalidKeyException(eBlockSize);
            if (debug != null) {
                debug.exception(Debug.TYPE_PUBLIC, className, "engineUnwrap", eBlockSize);
                debug.exception(Debug.TYPE_PUBLIC, className, "engineUnwrap", ike);
                debug.exit(Debug.TYPE_FINE, className, "engineUnwrap");
            }
            throw ike;
        }
        result = ConstructKeys.constructSecretKey(encodedKey, wrappedKeyAlgorithm);
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "engineUnwrap", result);
        }
        return result;
    }

    private boolean jitOptimizationAvailable() {
        boolean result = false;
        if (debug != null) {
            debug.entry(Debug.TYPE_FINE, (Object)className, "jitOptimizationAvailable", "algorithm: AES   mode: " + this.cipherModeString);
        }
        result = FullHardwareCrypt.isSupportedByHardware("AES", this.cipherModeString);
        if (debug != null) {
            debug.exit(Debug.TYPE_FINE, (Object)className, "jitOptimizationAvailable", result);
        }
        return result;
    }
}

