/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.pkcs11impl.provider;

import com.ibm.crypto.pkcs11impl.provider.CipherMechanismBuilder;
import com.ibm.crypto.pkcs11impl.provider.KeyMechanismBuilder;
import com.ibm.crypto.pkcs11impl.provider.MechanismBuilder;
import com.ibm.pkcs11.PKCS11Mechanism;
import com.ibm.pkcs11.PKCS11Object;
import java.security.AccessController;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedExceptionAction;
import java.security.spec.AlgorithmParameterSpec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.NoSuchPaddingException;

class MechanismBuilderImpl
implements CipherMechanismBuilder,
KeyMechanismBuilder {
    private static ArrayList<String> streamCipher = new ArrayList();
    private String type;
    private String algorithm;
    private int mechanism = 0;
    private MODES mode;
    private PADDING padding;
    private static Map<String, String> mechanism_AliasesMap = new HashMap<String, String>();
    private static Map<String, String> key_AliasesMap = new HashMap<String, String>();

    private static boolean isStreamCipher(String algo) {
        return streamCipher.indexOf(algo) >= 0;
    }

    public static CipherMechanismBuilder createCipherMechanismBuilder(String alg) {
        return new MechanismBuilderImpl(alg, "Cipher");
    }

    public static CipherMechanismBuilder createCipherMechanismBuilder(String alg, String mode, String padding) {
        return new MechanismBuilderImpl(alg, mode, padding, "Cipher");
    }

    public static KeyMechanismBuilder createKeyMechanismBuilder(String alg) {
        return new MechanismBuilderImpl(alg, "KeyFactory");
    }

    public static MechanismBuilder createMechanismBuilder(String alg, String type) {
        return new MechanismBuilderImpl(alg, type);
    }

    protected MechanismBuilderImpl(String alg, String algType) {
        this.type = algType;
        this.algorithm = alg;
        this.mode = MODES.ECB;
        this.padding = PADDING.NOPADDING;
    }

    protected MechanismBuilderImpl(String alg, String mod, String pad, String algType) {
        this.type = algType;
        this.algorithm = alg;
        this.mode = mod.equalsIgnoreCase("CBC") ? MODES.CBC : (mod.equalsIgnoreCase("GCM") ? MODES.GCM : MODES.ECB);
        this.padding = pad.equalsIgnoreCase("Pad") ? PADDING.PAD : (pad.equalsIgnoreCase("PKCS5Padding") ? PADDING.PKCS5PADDING : PADDING.NOPADDING);
    }

    @Override
    public void setMode(String mode) throws NoSuchAlgorithmException {
        if (MechanismBuilderImpl.isStreamCipher(this.algorithm)) {
            throw new NoSuchAlgorithmException("No mode or padding for stream cipher " + this.algorithm);
        }
        if (mode.equalsIgnoreCase("GCM") && !this.algorithm.equalsIgnoreCase("AES")) {
            throw new NoSuchAlgorithmException(this.algorithm + " does not support mode: " + mode);
        }
        try {
            this.mode = MODES.valueOf(mode.toUpperCase());
            this.mechanism = 0;
        }
        catch (IllegalArgumentException ex) {
            throw new NoSuchAlgorithmException("Invalid Mode value: " + mode);
        }
    }

    @Override
    public String getMode() {
        switch (this.mode) {
            case ECB: {
                return "ECB";
            }
            case CBC: {
                return "CBC";
            }
            case GCM: {
                return "GCM";
            }
        }
        return "";
    }

    @Override
    public void setPadding(String padding) throws NoSuchPaddingException {
        if (MechanismBuilderImpl.isStreamCipher(this.algorithm)) {
            throw new NoSuchPaddingException("No mode or padding for stream cipher " + this.algorithm);
        }
        try {
            this.padding = PADDING.valueOf(padding.toUpperCase());
            this.mechanism = 0;
            if ((this.padding == PADDING.PAD || this.padding == PADDING.PKCS5PADDING) && this.mode == MODES.ECB) {
                throw new NoSuchPaddingException("No padding implemented for ECB mode");
            }
            if (this.mode == MODES.GCM && this.padding != PADDING.NOPADDING) {
                throw new NoSuchPaddingException("Padding: " + padding + " not implemented for " + this.algorithm + " in " + (Object)((Object)this.mode) + " mode.");
            }
        }
        catch (IllegalArgumentException ex) {
            throw new NoSuchPaddingException("Padding: " + padding + " can not be verified for " + this.algorithm + " in " + (Object)((Object)this.mode) + " mode.");
        }
    }

    @Override
    public String getPadding() {
        switch (this.padding) {
            case NOPADDING: {
                return "NoPadding";
            }
            case PAD: {
                return "Pad";
            }
            case PKCS5PADDING: {
                return "PKCS5Padding";
            }
        }
        return "";
    }

    @Override
    public String getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public boolean isCompatibleOperationMode(int opmode, AlgorithmParameterSpec paramSpec) {
        return this.mode != MODES.CBC || opmode != 2 && opmode != 4 || paramSpec != null;
    }

    @Override
    public boolean isIVRequired() {
        return this.mode == MODES.CBC || this.mode == MODES.GCM;
    }

    @Override
    public boolean isPadding() {
        return this.padding == PADDING.PAD || this.padding == PADDING.PKCS5PADDING;
    }

    @Override
    public int getMechanism() {
        if (this.mechanism != 0) {
            return this.mechanism;
        }
        String mechanismAlgName = mechanism_AliasesMap.containsKey(this.algorithm.toUpperCase()) ? mechanism_AliasesMap.get(this.algorithm.toUpperCase()) : this.algorithm.toUpperCase();
        StringBuilder mechanismName = new StringBuilder(mechanismAlgName);
        if (this.type.equalsIgnoreCase("KeyFactory")) {
            mechanismName.append("_KEY_GEN");
        } else if (this.type.equalsIgnoreCase("Cipher") && !mechanismAlgName.equalsIgnoreCase("RC4")) {
            mechanismName.append('_');
            mechanismName.append((Object)this.mode);
            if (this.padding == PADDING.PAD || this.padding == PADDING.PKCS5PADDING) {
                mechanismName.append('_');
                mechanismName.append((Object)PADDING.PAD);
            }
        }
        try {
            final String mn = mechanismName.toString();
            this.mechanism = (Integer)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IllegalAccessException, NoSuchFieldException {
                    int i = PKCS11Mechanism.class.getDeclaredField(mn).getInt(null);
                    return new Integer(i);
                }
            });
        }
        catch (Exception e) {
            return -1;
        }
        return this.mechanism;
    }

    @Override
    public Integer getKeyType() {
        try {
            final String mechanismAlgName = key_AliasesMap.containsKey(this.algorithm.toUpperCase()) ? key_AliasesMap.get(this.algorithm.toUpperCase()) : this.algorithm.toUpperCase();
            return (Integer)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IllegalAccessException, NoSuchFieldException {
                    return PKCS11Object.class.getDeclaredField(mechanismAlgName).get(null);
                }
            });
        }
        catch (Exception e) {
            return new Integer(-1);
        }
    }

    @Override
    public int getDefaultKeySize() {
        switch (this.getMechanism()) {
            case 288: {
                return 64;
            }
            case 305: {
                return 192;
            }
            case 272: 
            case 4224: 
            case 4240: {
                return 128;
            }
        }
        return 0;
    }

    static {
        mechanism_AliasesMap.put("DESEDE", "DES3");
        mechanism_AliasesMap.put("ARCFOUR", "RC4");
        mechanism_AliasesMap.put("HMACMD5", "MD5_HMAC");
        mechanism_AliasesMap.put("HMACSHA1", "SHA_1_HMAC");
        mechanism_AliasesMap.put("HMACSHA224", "SHA224_HMAC");
        mechanism_AliasesMap.put("HMACSHA256", "SHA256_HMAC");
        mechanism_AliasesMap.put("HMACSHA384", "SHA384_HMAC");
        mechanism_AliasesMap.put("HMACSHA512", "SHA512_HMAC");
        mechanism_AliasesMap.put("GENERIC", "GENERIC_SECRET");
        key_AliasesMap.put("DESEDE", "DES3");
        key_AliasesMap.put("ARCFOUR", "RC4");
        key_AliasesMap.put("HMACMD5", "GENERIC_SECRET");
        key_AliasesMap.put("HMACSHA1", "GENERIC_SECRET");
        key_AliasesMap.put("HMACSHA224", "GENERIC_SECRET");
        key_AliasesMap.put("HMACSHA256", "GENERIC_SECRET");
        key_AliasesMap.put("HMACSHA384", "GENERIC_SECRET");
        key_AliasesMap.put("HMACSHA512", "GENERIC_SECRET");
        key_AliasesMap.put("MAC", "GENERIC_SECRET");
        key_AliasesMap.put("TLSRSAPREMASTERSECRET", "GENERIC_SECRET");
        key_AliasesMap.put("GENERIC", "GENERIC_SECRET");
        streamCipher.add("ARCFOUR");
        streamCipher.add("RC4");
    }

    private static enum MODES {
        ECB,
        CBC,
        GCM;

    }

    private static enum PADDING {
        NOPADDING,
        PAD,
        PKCS5PADDING;

    }
}

