/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zertjsse;

import com.ibm.zertjsse.Debug;

class ZERTSignatureInformation {
    private static Debug debug = Debug.getInstance("zertjsse");
    private static final String className = "com.ibm.zertjsse.ZERTSignatureInformation";
    protected short secattriTlsCertSignatureMethod = 0;
    protected short secattriTlsCertEncMethod = 0;
    protected short secattriTlsCertDigestAlg = 0;

    protected ZERTSignatureInformation() {
        String methodName = "ZERTSignatureInformation";
        Debug.traceEntry(debug, className, methodName);
        Debug.traceExit(debug, className, methodName);
    }

    protected ZERTSignatureInformation(String sigAlgName) {
        String methodName = "ZERTSignatureInformation";
        Debug.traceEntry(debug, className, methodName, sigAlgName);
        try {
            String sigAlgNameUpper = sigAlgName.toUpperCase();
            String andString = "AND";
            int andIndex = sigAlgNameUpper.indexOf("AND");
            if (andIndex > 0) {
                sigAlgNameUpper = sigAlgNameUpper.substring(0, andIndex);
                Debug.traceText(debug, className, methodName, "Parsed out the 'AND', sigAlgNameUpper: " + sigAlgNameUpper);
            }
            String withString = "WITH";
            int withIndex = sigAlgNameUpper.indexOf("WITH");
            String mdAlg = sigAlgNameUpper.substring(0, withIndex);
            Debug.traceText(debug, className, methodName, "Parsed out the 'WITH', mdAlg: " + mdAlg);
            String encAlg = sigAlgNameUpper.substring(withIndex + "WITH".length());
            Debug.traceText(debug, className, methodName, "Parsed out the 'WITH', encAlg: " + encAlg);
            switch (mdAlg) {
                case "NONE": {
                    this.secattriTlsCertDigestAlg = 1;
                    break;
                }
                case "MD2": {
                    this.secattriTlsCertDigestAlg = (short)2;
                    break;
                }
                case "MD5": {
                    this.secattriTlsCertDigestAlg = (short)3;
                    break;
                }
                case "SHA": 
                case "SHA1": 
                case "SHA11": {
                    this.secattriTlsCertDigestAlg = (short)4;
                    break;
                }
                case "SHA224": 
                case "SHA-224": {
                    this.secattriTlsCertDigestAlg = (short)5;
                    break;
                }
                case "SHA256": 
                case "SHA-256": {
                    this.secattriTlsCertDigestAlg = (short)6;
                    break;
                }
                case "SHA384": 
                case "SHA-384": {
                    this.secattriTlsCertDigestAlg = (short)7;
                    break;
                }
                case "SHA512": 
                case "SHA-512": {
                    this.secattriTlsCertDigestAlg = (short)8;
                    break;
                }
                default: {
                    Debug.traceText(debug, className, methodName, "Unable to find digest algorithm for zERT, using default unknown value");
                }
            }
            switch (encAlg) {
                case "NONE": {
                    this.secattriTlsCertEncMethod = 1;
                    break;
                }
                case "RSA": {
                    this.secattriTlsCertEncMethod = (short)2;
                    break;
                }
                case "DSA": {
                    this.secattriTlsCertEncMethod = (short)3;
                    break;
                }
                case "ECDSA": {
                    this.secattriTlsCertEncMethod = (short)4;
                    break;
                }
                default: {
                    Debug.traceText(debug, className, methodName, "Unable to find encryption algorithm for zERT, using default unknown value");
                }
            }
            block39 : switch (this.secattriTlsCertEncMethod) {
                case 2: {
                    switch (this.secattriTlsCertDigestAlg) {
                        case 2: {
                            this.secattriTlsCertSignatureMethod = (short)2;
                            break block39;
                        }
                        case 3: {
                            this.secattriTlsCertSignatureMethod = (short)3;
                            break block39;
                        }
                        case 4: {
                            this.secattriTlsCertSignatureMethod = (short)4;
                            break block39;
                        }
                        case 5: {
                            this.secattriTlsCertSignatureMethod = (short)6;
                            break block39;
                        }
                        case 6: {
                            this.secattriTlsCertSignatureMethod = (short)7;
                            break block39;
                        }
                        case 7: {
                            this.secattriTlsCertSignatureMethod = (short)8;
                            break block39;
                        }
                        case 8: {
                            this.secattriTlsCertSignatureMethod = (short)9;
                        }
                    }
                    break;
                }
                case 3: {
                    switch (this.secattriTlsCertDigestAlg) {
                        case 4: {
                            this.secattriTlsCertSignatureMethod = (short)5;
                            break block39;
                        }
                        case 5: {
                            this.secattriTlsCertSignatureMethod = (short)15;
                            break block39;
                        }
                        case 6: {
                            this.secattriTlsCertSignatureMethod = (short)16;
                        }
                    }
                    break;
                }
                case 4: {
                    switch (this.secattriTlsCertDigestAlg) {
                        case 4: {
                            this.secattriTlsCertSignatureMethod = (short)10;
                            break block39;
                        }
                        case 5: {
                            this.secattriTlsCertSignatureMethod = (short)11;
                            break block39;
                        }
                        case 6: {
                            this.secattriTlsCertSignatureMethod = (short)12;
                            break block39;
                        }
                        case 7: {
                            this.secattriTlsCertSignatureMethod = (short)13;
                            break block39;
                        }
                        case 8: {
                            this.secattriTlsCertSignatureMethod = (short)14;
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            Debug.traceText(debug, className, methodName, "There was an issue trying to obtain certificate information for zERT");
            Debug.traceException(debug, className, methodName, e);
        }
        Debug.traceText(debug, className, "ZERTSignatureInformation", "secattriTlsCertSignatureMethod: " + this.secattriTlsCertSignatureMethod + ", secattriTlsCertEncMethod: " + this.secattriTlsCertEncMethod + ", secattriTlsCertDigestAlg: " + this.secattriTlsCertDigestAlg);
        Debug.traceExit(debug, className, methodName);
    }
}

