/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zertjsse;

import com.ibm.zertjsse.Debug;
import com.ibm.zertjsse.ZERTSSLSocketImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;

class ZERTInputStream
extends InputStream {
    private static Debug debug = Debug.getInstance("zertjsse");
    private static final String className = "com.ibm.zertjsse.ZERTInputStream";
    private InputStream iStream;
    private ZERTSSLSocketImpl socket;

    public ZERTInputStream(InputStream iStream, ZERTSSLSocketImpl socket) {
        String methodName = "ZERTInputStream";
        Debug.traceEntry(debug, className, methodName, iStream, socket);
        this.iStream = iStream;
        this.socket = socket;
        Debug.traceExit(debug, className, methodName);
    }

    @Override
    public int read() throws IOException {
        String methodName = "read";
        Debug.traceEntry(debug, className, methodName);
        int read = 0;
        try {
            read = this.iStream.read();
            if (read == -1) {
                this.socket.notifyzERTTermination();
            } else {
                this.socket.notifyzERTHandshakePossible();
            }
        }
        catch (InterruptedIOException e) {
            Debug.traceException(debug, className, methodName, e);
            Debug.traceExit(debug, className, methodName);
            throw e;
        }
        catch (IOException e) {
            Debug.traceException(debug, className, methodName, e);
            this.socket.notifyzERTFailure();
            Debug.traceExit(debug, className, methodName);
            throw e;
        }
        catch (Exception e) {
            Debug.traceException(debug, className, methodName, e);
            Debug.traceExit(debug, className, methodName);
            throw e;
        }
        Debug.traceExit(debug, className, methodName, read);
        return read;
    }

    @Override
    public int read(byte[] b) throws IOException {
        String methodName = "read";
        Debug.traceEntry(debug, className, methodName, (Object)b);
        int read = 0;
        try {
            read = this.iStream.read(b);
            if (read == -1) {
                this.socket.notifyzERTTermination();
            } else {
                this.socket.notifyzERTHandshakePossible();
            }
        }
        catch (InterruptedIOException e) {
            Debug.traceException(debug, className, methodName, e);
            Debug.traceExit(debug, className, methodName);
            throw e;
        }
        catch (IOException e) {
            Debug.traceException(debug, className, methodName, e);
            this.socket.notifyzERTFailure();
            Debug.traceExit(debug, className, methodName);
            throw e;
        }
        catch (Exception e) {
            Debug.traceException(debug, className, methodName, e);
            Debug.traceExit(debug, className, methodName);
            throw e;
        }
        Debug.traceExit(debug, className, methodName, read);
        return read;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        String methodName = "read";
        Debug.traceEntry(debug, className, methodName, "b: " + b + ", off: " + off + ", len: " + len);
        int read = 0;
        try {
            read = this.iStream.read(b, off, len);
            if (read == -1) {
                this.socket.notifyzERTTermination();
            } else {
                this.socket.notifyzERTHandshakePossible();
            }
        }
        catch (InterruptedIOException e) {
            Debug.traceException(debug, className, methodName, e);
            Debug.traceExit(debug, className, methodName);
            throw e;
        }
        catch (IOException e) {
            Debug.traceException(debug, className, methodName, e);
            this.socket.notifyzERTFailure();
            Debug.traceExit(debug, className, methodName);
            throw e;
        }
        catch (Exception e) {
            Debug.traceException(debug, className, methodName, e);
            Debug.traceExit(debug, className, methodName);
            throw e;
        }
        Debug.traceExit(debug, className, methodName, read);
        return read;
    }

    @Override
    public long skip(long n) throws IOException {
        String methodName = "skip";
        Debug.traceEntry(debug, className, methodName, n);
        long skipped = 0L;
        try {
            skipped = this.iStream.skip(n);
        }
        catch (Exception e) {
            Debug.traceException(debug, className, methodName, e);
            Debug.traceExit(debug, className, methodName);
            throw e;
        }
        Debug.traceExit(debug, className, methodName, skipped);
        return skipped;
    }

    @Override
    public int available() throws IOException {
        String methodName = "available";
        Debug.traceEntry(debug, className, methodName);
        int available = 0;
        try {
            available = this.iStream.available();
        }
        catch (Exception e) {
            Debug.traceException(debug, className, methodName, e);
            Debug.traceExit(debug, className, methodName);
            throw e;
        }
        Debug.traceExit(debug, className, methodName, available);
        return available;
    }

    @Override
    public void close() throws IOException {
        String methodName = "close";
        Debug.traceEntry(debug, className, methodName);
        try {
            this.socket.notifyzERTRenegotiation();
            this.iStream.close();
        }
        catch (Exception e) {
            Debug.traceException(debug, className, methodName, e);
            Debug.traceExit(debug, className, methodName);
            throw e;
        }
        finally {
            this.socket.notifyzERTTermination();
        }
        Debug.traceExit(debug, className, methodName);
    }

    @Override
    public void mark(int readlimit) {
        String methodName = "mark";
        Debug.traceEntry(debug, className, methodName, readlimit);
        try {
            this.iStream.mark(readlimit);
        }
        catch (Exception e) {
            Debug.traceException(debug, className, methodName, e);
            Debug.traceExit(debug, className, methodName);
            throw e;
        }
        Debug.traceExit(debug, className, methodName);
    }

    @Override
    public void reset() throws IOException {
        String methodName = "reset";
        Debug.traceEntry(debug, className, methodName);
        try {
            this.iStream.reset();
        }
        catch (Exception e) {
            Debug.traceException(debug, className, methodName, e);
            Debug.traceExit(debug, className, methodName);
            throw e;
        }
        Debug.traceExit(debug, className, methodName);
    }

    @Override
    public boolean markSupported() {
        String methodName = "markSupported";
        Debug.traceEntry(debug, className, methodName);
        boolean markSupported = false;
        try {
            markSupported = this.iStream.markSupported();
        }
        catch (Exception e) {
            Debug.traceException(debug, className, methodName, e);
            Debug.traceExit(debug, className, methodName);
            throw e;
        }
        Debug.traceExit(debug, className, methodName, markSupported);
        return markSupported;
    }
}

