/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zertjsse;

import com.ibm.zertjsse.Debug;
import com.ibm.zertjsse.Role;
import com.ibm.zertjsse.ZERTPublicKeyInformation;
import com.ibm.zertjsse.ZERTSignatureInformation;
import com.ibm.zos.net.SiocSSecattr;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Date;

class ZERTCertificateUtils {
    private static Debug debug = Debug.getInstance("zertjsse");
    private static final String className = "com.ibm.zertjsse.ZERTCertificateUtils";

    ZERTCertificateUtils() {
    }

    protected static void addCertificateInformation(SiocSSecattr ioctl, X509Certificate cert, SiocSSecattr.Status status, Role role) {
        String methodName = "addCertificateInformation";
        Debug.traceEntry(debug, className, methodName, "ioctl: " + ioctl + ", cert: " + cert + ", status: " + status + ", role: " + (Object)((Object)role));
        try {
            ZERTCertificateUtils.addCertSerial(ioctl, cert, role);
            ZERTCertificateUtils.addCertSignatureInformation(ioctl, cert, role);
            ZERTCertificateUtils.addCertTime(ioctl, cert, role);
            ZERTCertificateUtils.addCertPublicKeyInformation(ioctl, cert, role);
            ZERTCertificateUtils.addCertSdn(ioctl, cert, role);
            ZERTCertificateUtils.addCertIdn(ioctl, cert, role);
            if (status.equals((Object)SiocSSecattr.Status.SECATTR_ENABLED_CERT)) {
                Debug.traceText(debug, className, methodName, "zERT is enabled for sending complete certificates");
                ZERTCertificateUtils.addCert(ioctl, cert, role);
            } else {
                Debug.traceText(debug, className, methodName, "zERT is not enabled for sending complete certificates");
            }
        }
        catch (Exception e) {
            Debug.traceText(debug, className, methodName, "Unable to send certificate information to zERT");
            Debug.traceException(debug, className, methodName, e);
        }
        Debug.traceExit(debug, className, methodName);
    }

    private static String getCertSerial(X509Certificate cert) {
        String methodName = "getCertSerial";
        Debug.traceEntry(debug, className, methodName);
        String secattriTlsCertSerial = "";
        try {
            secattriTlsCertSerial = cert.getSerialNumber().toString();
        }
        catch (Exception e) {
            Debug.traceText(debug, className, methodName, "Unable to obtain certificate serial number for zERT");
            Debug.traceException(debug, className, methodName, e);
        }
        Debug.traceExit(debug, className, methodName, secattriTlsCertSerial);
        return secattriTlsCertSerial;
    }

    private static ZERTSignatureInformation getCertSignatureInformation(X509Certificate cert) {
        String methodName = "getCertSignatureInformation";
        Debug.traceEntry(debug, className, methodName);
        ZERTSignatureInformation signatureInfo = new ZERTSignatureInformation();
        try {
            String sigAlgName = cert.getSigAlgName();
            signatureInfo = new ZERTSignatureInformation(sigAlgName);
        }
        catch (Exception e) {
            Debug.traceText(debug, className, methodName, "Unable to obtain certificate signature information for zERT");
            Debug.traceException(debug, className, methodName, e);
        }
        Debug.traceExit(debug, className, methodName, signatureInfo);
        return signatureInfo;
    }

    private static Date getCertTime(X509Certificate cert) {
        String methodName = "getCertTime";
        Debug.traceEntry(debug, className, methodName);
        Date secattriTlsCertTime = null;
        try {
            secattriTlsCertTime = cert.getNotAfter();
        }
        catch (Exception e) {
            Debug.traceText(debug, className, methodName, "Unable to obtain certificate not after date for zERT");
            Debug.traceException(debug, className, methodName, e);
        }
        Debug.traceExit(debug, className, methodName, secattriTlsCertTime);
        return secattriTlsCertTime;
    }

    private static ZERTPublicKeyInformation getCertPublicKeyInformation(X509Certificate cert) {
        String methodName = "getCertPublicKeyInformation";
        Debug.traceEntry(debug, className, methodName);
        ZERTPublicKeyInformation publicKeyInfo = new ZERTPublicKeyInformation();
        try {
            PublicKey publicKey = cert.getPublicKey();
            publicKeyInfo = new ZERTPublicKeyInformation(publicKey);
        }
        catch (Exception e) {
            Debug.traceText(debug, className, methodName, "Unable to obtain certificate public key information for zERT");
            Debug.traceException(debug, className, methodName, e);
        }
        Debug.traceExit(debug, className, methodName, publicKeyInfo);
        return publicKeyInfo;
    }

    private static String getCertSdn(X509Certificate cert) {
        String methodName = "getCertSdn";
        Debug.traceEntry(debug, className, methodName);
        String secattriTlsCertSdn = "";
        try {
            secattriTlsCertSdn = cert.getSubjectDN().getName();
        }
        catch (Exception e) {
            Debug.traceText(debug, className, methodName, "Unable to obtain subject distinguished name of certificate for zERT");
            Debug.traceException(debug, className, methodName, e);
        }
        Debug.traceExit(debug, className, methodName, secattriTlsCertSdn);
        return secattriTlsCertSdn;
    }

    private static String getCertIdn(X509Certificate cert) {
        String methodName = "getCertIdn";
        Debug.traceEntry(debug, className, methodName);
        String secattriTlsCertIdn = "";
        try {
            secattriTlsCertIdn = cert.getIssuerDN().getName();
        }
        catch (Exception e) {
            Debug.traceText(debug, className, methodName, "Unable to obtain issuer distinguished name of certificate for zERT");
            Debug.traceException(debug, className, methodName, e);
        }
        Debug.traceExit(debug, className, methodName, secattriTlsCertIdn);
        return secattriTlsCertIdn;
    }

    private static byte[] getCert(X509Certificate cert) {
        String methodName = "getCert";
        Debug.traceEntry(debug, className, methodName);
        byte[] secattriTlsCert = null;
        try {
            secattriTlsCert = cert.getEncoded();
        }
        catch (Exception e) {
            Debug.traceText(debug, className, methodName, "Unable to obtain full certificate for zERT");
            Debug.traceException(debug, className, methodName, e);
        }
        Debug.traceExit(debug, className, methodName, secattriTlsCert);
        return secattriTlsCert;
    }

    private static void addCertSerial(SiocSSecattr ioctl, X509Certificate cert, Role role) {
        String methodName = "addCertSerial";
        Debug.traceEntry(debug, className, methodName, ioctl, (Object)role);
        try {
            String secattriTlsCertSerial = ZERTCertificateUtils.getCertSerial(cert);
            Debug.traceText(debug, className, methodName, "Calling setSecattriTlsXCertSerial with secattriTlsCertSerial: " + secattriTlsCertSerial);
            if (role.equals((Object)Role.CLIENT)) {
                ioctl.setSecattriTlsCCertSerial(secattriTlsCertSerial);
            } else if (role.equals((Object)Role.SERVER)) {
                ioctl.setSecattriTlsSCertSerial(secattriTlsCertSerial);
            }
            Debug.traceText(debug, className, methodName, "Called setSecattriTlsXCertSerial successfully, ioctl: " + ioctl);
        }
        catch (Exception e) {
            Debug.traceText(debug, className, methodName, "Unable to send certificate serial to zERT");
            Debug.traceException(debug, className, methodName, e);
        }
        Debug.traceExit(debug, className, methodName);
    }

    private static void addCertSignatureInformation(SiocSSecattr ioctl, X509Certificate cert, Role role) {
        String methodName = "addCertSignatureInformation";
        Debug.traceEntry(debug, className, methodName, ioctl, (Object)role);
        try {
            ZERTSignatureInformation signatureInfo = ZERTCertificateUtils.getCertSignatureInformation(cert);
            ZERTCertificateUtils.addCertSignatureMethod(ioctl, signatureInfo.secattriTlsCertSignatureMethod, role);
            ZERTCertificateUtils.addCertEncMethod(ioctl, signatureInfo.secattriTlsCertEncMethod, role);
            ZERTCertificateUtils.addCertDigestAlg(ioctl, signatureInfo.secattriTlsCertDigestAlg, role);
        }
        catch (Exception e) {
            Debug.traceText(debug, className, methodName, "Unable to send certificate signature information to zERT");
            Debug.traceException(debug, className, methodName, e);
        }
        Debug.traceExit(debug, className, methodName);
    }

    private static void addCertSignatureMethod(SiocSSecattr ioctl, short secattriTlsCertSignatureMethod, Role role) {
        String methodName = "addCertSignatureMethod";
        Debug.traceEntry(debug, className, methodName, "ioctl: " + ioctl + ", secattriTlsCertSignatureMethod: " + secattriTlsCertSignatureMethod + ", role: " + (Object)((Object)role));
        try {
            Debug.traceText(debug, className, methodName, "Calling setSecattriTlsXCertSignatureMethod with secattriTlsCertSignatureMethod: " + secattriTlsCertSignatureMethod);
            if (role.equals((Object)Role.CLIENT)) {
                ioctl.setSecattriTlsCCertSignatureMethod(Short.valueOf(secattriTlsCertSignatureMethod));
            } else if (role.equals((Object)Role.SERVER)) {
                ioctl.setSecattriTlsSCertSignatureMethod(Short.valueOf(secattriTlsCertSignatureMethod));
            }
            Debug.traceText(debug, className, methodName, "Called setSecattriTlsXCertSignatureMethod successfully, ioctl: " + ioctl);
        }
        catch (Exception e) {
            Debug.traceText(debug, className, methodName, "Unable to send certificate signature method to zERT");
            Debug.traceException(debug, className, methodName, e);
        }
        Debug.traceExit(debug, className, methodName);
    }

    private static void addCertEncMethod(SiocSSecattr ioctl, short secattriTlsCertEncMethod, Role role) {
        String methodName = "addCertEncMethod";
        Debug.traceEntry(debug, className, methodName, "ioctl: " + ioctl + ", secattriTlsCertEncMethod: " + secattriTlsCertEncMethod + ", role: " + (Object)((Object)role));
        try {
            Debug.traceText(debug, className, methodName, "Calling setSecattriTlsXCertEncMethod with secattriTlsCertEncMethod: " + secattriTlsCertEncMethod);
            if (role.equals((Object)Role.CLIENT)) {
                ioctl.setSecattriTlsCCertEncMethod(Short.valueOf(secattriTlsCertEncMethod));
            } else if (role.equals((Object)Role.SERVER)) {
                ioctl.setSecattriTlsSCertEncMethod(Short.valueOf(secattriTlsCertEncMethod));
            }
            Debug.traceText(debug, className, methodName, "Called setSecattriTlsXCertEncMethod successfully, ioctl: " + ioctl);
        }
        catch (Exception e) {
            Debug.traceText(debug, className, methodName, "Unable to send certificate encryption method to zERT");
            Debug.traceException(debug, className, methodName, e);
        }
        Debug.traceExit(debug, className, methodName);
    }

    private static void addCertDigestAlg(SiocSSecattr ioctl, short secattriTlsCertDigestAlg, Role role) {
        String methodName = "addCertDigestAlg";
        Debug.traceEntry(debug, className, methodName, "ioctl: " + ioctl + ", secattriTlsCertDigestAlg: " + secattriTlsCertDigestAlg + ", role: " + (Object)((Object)role));
        try {
            Debug.traceText(debug, className, methodName, "Calling setSecattriTlsXCertDigestAlg with secattriTlsCertDigestAlg: " + secattriTlsCertDigestAlg);
            if (role.equals((Object)Role.CLIENT)) {
                ioctl.setSecattriTlsCCertDigestAlg(Short.valueOf(secattriTlsCertDigestAlg));
            } else if (role.equals((Object)Role.SERVER)) {
                ioctl.setSecattriTlsSCertDigestAlg(Short.valueOf(secattriTlsCertDigestAlg));
            }
            Debug.traceText(debug, className, methodName, "Called setSecattriTlsXCertDigestAlg successfully, ioctl: " + ioctl);
        }
        catch (Exception e) {
            Debug.traceText(debug, className, methodName, "Unable to send certificate digest algorithm to zERT");
            Debug.traceException(debug, className, methodName, e);
        }
        Debug.traceExit(debug, className, methodName);
    }

    private static void addCertTime(SiocSSecattr ioctl, X509Certificate cert, Role role) {
        String methodName = "addCertTime";
        Debug.traceEntry(debug, className, methodName, ioctl, (Object)role);
        try {
            Date secattriTlsCertTime = ZERTCertificateUtils.getCertTime(cert);
            Debug.traceText(debug, className, methodName, "Calling setSecattriTlsXCertTime with secattriTlsCertTime: " + secattriTlsCertTime);
            if (role.equals((Object)Role.CLIENT)) {
                ioctl.setSecattriTlsCCertTime(secattriTlsCertTime);
            } else if (role.equals((Object)Role.SERVER)) {
                ioctl.setSecattriTlsSCertTime(secattriTlsCertTime);
            }
            Debug.traceText(debug, className, methodName, "Called setSecattriTlsXCertTime successfully, ioctl: " + ioctl);
        }
        catch (Exception e) {
            Debug.traceText(debug, className, methodName, "Unable to send certificate not after date to zERT");
            Debug.traceException(debug, className, methodName, e);
        }
        Debug.traceExit(debug, className, methodName);
    }

    private static void addCertKeyType(SiocSSecattr ioctl, short secattriTlsCertKeyType, Role role) {
        String methodName = "addCertKeyType";
        Debug.traceEntry(debug, className, methodName, "ioctl: " + ioctl + ", secattriTlsCertKeyType: " + secattriTlsCertKeyType + ", role: " + (Object)((Object)role));
        try {
            Debug.traceText(debug, className, methodName, "Calling setSecattriTlsXCertKeyType with secattriTlsCertKeyType: " + secattriTlsCertKeyType);
            if (role.equals((Object)Role.CLIENT)) {
                ioctl.setSecattriTlsCCertKeyType(Short.valueOf(secattriTlsCertKeyType));
            } else if (role.equals((Object)Role.SERVER)) {
                ioctl.setSecattriTlsSCertKeyType(Short.valueOf(secattriTlsCertKeyType));
            }
            Debug.traceText(debug, className, methodName, "Called setSecattriTlsXCertKeyType successfully, ioctl: " + ioctl);
        }
        catch (Exception e) {
            Debug.traceText(debug, className, methodName, "Unable to send certificate key type to zERT");
            Debug.traceException(debug, className, methodName, e);
        }
        Debug.traceExit(debug, className, methodName);
    }

    private static void addCertKeyLen(SiocSSecattr ioctl, short secattriTlsCertKeyLen, Role role) {
        String methodName = "addCertKeyLen";
        Debug.traceEntry(debug, className, methodName, "ioctl: " + ioctl + ", secattriTlsCertKeyLen: " + secattriTlsCertKeyLen + ", role: " + (Object)((Object)role));
        try {
            Debug.traceText(debug, className, methodName, "Calling setSecattriTlsXCertKeyLen with secattriTlsCertKeyLen: " + secattriTlsCertKeyLen);
            if (role.equals((Object)Role.CLIENT)) {
                ioctl.setSecattriTlsCCertKeyLen(Short.valueOf(secattriTlsCertKeyLen));
            } else if (role.equals((Object)Role.SERVER)) {
                ioctl.setSecattriTlsSCertKeyLen(Short.valueOf(secattriTlsCertKeyLen));
            }
            Debug.traceText(debug, className, methodName, "Called setSecattriTlsXCertKeyLen successfully, ioctl: " + ioctl);
        }
        catch (Exception e) {
            Debug.traceText(debug, className, methodName, "Unable to send certificate key length to zERT");
            Debug.traceException(debug, className, methodName, e);
        }
        Debug.traceExit(debug, className, methodName);
    }

    private static void addCertPublicKeyInformation(SiocSSecattr ioctl, X509Certificate cert, Role role) {
        String methodName = "addCertPublicKeyInformation";
        Debug.traceEntry(debug, className, methodName, ioctl, (Object)role);
        try {
            ZERTPublicKeyInformation publicKeyInfo = ZERTCertificateUtils.getCertPublicKeyInformation(cert);
            ZERTCertificateUtils.addCertKeyType(ioctl, publicKeyInfo.secattriTlsCertKeyType, role);
            ZERTCertificateUtils.addCertKeyLen(ioctl, publicKeyInfo.secattriTlsCertKeyLen, role);
        }
        catch (Exception e) {
            Debug.traceText(debug, className, methodName, "Unable to send certificate public key information to zERT");
            Debug.traceException(debug, className, methodName, e);
        }
        Debug.traceExit(debug, className, methodName);
    }

    private static void addCertSdn(SiocSSecattr ioctl, X509Certificate cert, Role role) {
        String methodName = "addCertSdn";
        Debug.traceEntry(debug, className, methodName, ioctl, (Object)role);
        try {
            String secattriTlsCertSdn = ZERTCertificateUtils.getCertSdn(cert);
            Debug.traceText(debug, className, methodName, "Calling setSecattriTlsXCertSdn with secattriTlsCertSdn: " + secattriTlsCertSdn);
            if (role.equals((Object)Role.CLIENT)) {
                ioctl.setSecattriTlsCCertSdn(secattriTlsCertSdn);
            } else if (role.equals((Object)Role.SERVER)) {
                ioctl.setSecattriTlsSCertSdn(secattriTlsCertSdn);
            }
            Debug.traceText(debug, className, methodName, "Called setSecattriTlsXCertSdn successfully, ioctl: " + ioctl);
        }
        catch (Exception e) {
            Debug.traceText(debug, className, methodName, "Unable to send subject distinguished name of certificate to zERT");
            Debug.traceException(debug, className, methodName, e);
        }
        Debug.traceExit(debug, className, methodName);
    }

    private static void addCertIdn(SiocSSecattr ioctl, X509Certificate cert, Role role) {
        String methodName = "addCertIdn";
        Debug.traceEntry(debug, className, methodName, ioctl, (Object)role);
        try {
            String secattriTlsCertIdn = ZERTCertificateUtils.getCertIdn(cert);
            Debug.traceText(debug, className, methodName, "Calling setSecattriTlsXCertIdn with secattriTlsCertIdn: " + secattriTlsCertIdn);
            if (role.equals((Object)Role.CLIENT)) {
                ioctl.setSecattriTlsCCertIdn(secattriTlsCertIdn);
            } else if (role.equals((Object)Role.SERVER)) {
                ioctl.setSecattriTlsSCertIdn(secattriTlsCertIdn);
            }
            Debug.traceText(debug, className, methodName, "Called setSecattriTlsXCertIdn successfully, ioctl: " + ioctl);
        }
        catch (Exception e) {
            Debug.traceText(debug, className, methodName, "Unable to send issuer distinguished name of certificate to zERT");
            Debug.traceException(debug, className, methodName, e);
        }
        Debug.traceExit(debug, className, methodName);
    }

    private static void addCert(SiocSSecattr ioctl, X509Certificate cert, Role role) {
        String methodName = "addCert";
        Debug.traceEntry(debug, className, methodName, ioctl, (Object)role);
        try {
            byte[] secattriTlsCert = ZERTCertificateUtils.getCert(cert);
            Debug.traceText(debug, className, methodName, "Calling setSecattriTlsXCert with secattriTlsCert: " + secattriTlsCert);
            if (role.equals((Object)Role.CLIENT)) {
                ioctl.setSecattriTlsCCert(secattriTlsCert);
            } else if (role.equals((Object)Role.SERVER)) {
                ioctl.setSecattriTlsSCert(secattriTlsCert);
            }
            Debug.traceText(debug, className, methodName, "Called setSecattriTlsXCert successfully, ioctl: " + ioctl);
        }
        catch (Exception e) {
            Debug.traceText(debug, className, methodName, "Unable to send full certificate to zERT");
            Debug.traceException(debug, className, methodName, e);
        }
        Debug.traceExit(debug, className, methodName);
    }

    protected static void addNULLCertificateInformation(SiocSSecattr ioctl, Role role) {
        String methodName = "addCertificateInformation";
        Debug.traceEntry(debug, className, methodName, ioctl, (Object)role);
        try {
            ZERTCertificateUtils.addNULLSignatureInformation(ioctl, role);
            ZERTCertificateUtils.addNULLKeyType(ioctl, role);
        }
        catch (Exception e) {
            Debug.traceText(debug, className, methodName, "Unable to send certificate information to zERT");
            Debug.traceException(debug, className, methodName, e);
        }
        Debug.traceExit(debug, className, methodName);
    }

    private static void addNULLSignatureInformation(SiocSSecattr ioctl, Role role) {
        String methodName = "addNULLSignatureInformation";
        Debug.traceEntry(debug, className, methodName, ioctl, (Object)role);
        short secattriTlsCertSignatureMethod = 1;
        short secattriTlsCertEncMethod = 1;
        short secattriTlsCertDigestAlg = 1;
        try {
            ZERTCertificateUtils.addNULLSignatureMethod(ioctl, secattriTlsCertSignatureMethod, role);
            ZERTCertificateUtils.addNULLEncMethod(ioctl, secattriTlsCertEncMethod, role);
            ZERTCertificateUtils.addNULLDigestAlg(ioctl, secattriTlsCertDigestAlg, role);
        }
        catch (Exception e) {
            Debug.traceText(debug, className, methodName, "Unable to send certificate signature information to zERT");
            Debug.traceException(debug, className, methodName, e);
        }
        Debug.traceExit(debug, className, methodName);
    }

    private static void addNULLSignatureMethod(SiocSSecattr ioctl, short secattriTlsCertSignatureMethod, Role role) {
        String methodName = "addNULLSignatureMethod";
        Debug.traceEntry(debug, className, methodName, "ioctl: " + ioctl + ", secattriTlsCertSignatureMethod: " + secattriTlsCertSignatureMethod + ", role: " + (Object)((Object)role));
        try {
            Debug.traceText(debug, className, methodName, "Calling setSecattriTlsXCertSignatureMethod with secattriTlsCertSignatureMethod: " + secattriTlsCertSignatureMethod);
            if (role.equals((Object)Role.CLIENT)) {
                ioctl.setSecattriTlsCCertSignatureMethod(Short.valueOf(secattriTlsCertSignatureMethod));
            } else if (role.equals((Object)Role.SERVER)) {
                ioctl.setSecattriTlsSCertSignatureMethod(Short.valueOf(secattriTlsCertSignatureMethod));
            }
            Debug.traceText(debug, className, methodName, "Called setSecattriTlsXCertSignatureMethod successfully, ioctl: " + ioctl);
        }
        catch (Exception e) {
            Debug.traceText(debug, className, methodName, "Unable to send certificate signature method to zERT");
            Debug.traceException(debug, className, methodName, e);
        }
        Debug.traceExit(debug, className, methodName);
    }

    private static void addNULLEncMethod(SiocSSecattr ioctl, short secattriTlsCertEncMethod, Role role) {
        String methodName = "addNULLEncMethod";
        Debug.traceEntry(debug, className, methodName, "ioctl: " + ioctl + ", secattriTlsCertEncMethod: " + secattriTlsCertEncMethod + ", role: " + (Object)((Object)role));
        try {
            Debug.traceText(debug, className, methodName, "Calling setSecattriTlsXCertEncMethod with secattriTlsCertEncMethod: " + secattriTlsCertEncMethod);
            if (role.equals((Object)Role.CLIENT)) {
                ioctl.setSecattriTlsCCertEncMethod(Short.valueOf(secattriTlsCertEncMethod));
            } else if (role.equals((Object)Role.SERVER)) {
                ioctl.setSecattriTlsSCertEncMethod(Short.valueOf(secattriTlsCertEncMethod));
            }
            Debug.traceText(debug, className, methodName, "Called setSecattriTlsXCertEncMethod successfully, ioctl: " + ioctl);
        }
        catch (Exception e) {
            Debug.traceText(debug, className, methodName, "Unable to send certificate encryption method to zERT");
            Debug.traceException(debug, className, methodName, e);
        }
        Debug.traceExit(debug, className, methodName);
    }

    private static void addNULLDigestAlg(SiocSSecattr ioctl, short secattriTlsCertDigestAlg, Role role) {
        String methodName = "addNULLDigestAlg";
        Debug.traceEntry(debug, className, methodName, "ioctl: " + ioctl + ", secattriTlsCertDigestAlg: " + secattriTlsCertDigestAlg + ", role: " + (Object)((Object)role));
        try {
            Debug.traceText(debug, className, methodName, "Calling setSecattriTlsXCertDigestAlg with secattriTlsCertDigestAlg: " + secattriTlsCertDigestAlg);
            if (role.equals((Object)Role.CLIENT)) {
                ioctl.setSecattriTlsCCertDigestAlg(Short.valueOf(secattriTlsCertDigestAlg));
            } else if (role.equals((Object)Role.SERVER)) {
                ioctl.setSecattriTlsSCertDigestAlg(Short.valueOf(secattriTlsCertDigestAlg));
            }
            Debug.traceText(debug, className, methodName, "Called setSecattriTlsXCertDigestAlg successfully, ioctl: " + ioctl);
        }
        catch (Exception e) {
            Debug.traceText(debug, className, methodName, "Unable to send certificate digest algorithm to zERT");
            Debug.traceException(debug, className, methodName, e);
        }
        Debug.traceExit(debug, className, methodName);
    }

    private static void addNULLKeyType(SiocSSecattr ioctl, Role role) {
        String methodName = "addNULLKeyType";
        Debug.traceEntry(debug, className, methodName, ioctl, (Object)role);
        short secattriTlsCertKeyType = 1;
        try {
            Debug.traceText(debug, className, methodName, "Calling setSecattriTlsXCertKeyType with secattriTlsCertKeyType: " + secattriTlsCertKeyType);
            if (role.equals((Object)Role.CLIENT)) {
                ioctl.setSecattriTlsCCertKeyType(Short.valueOf(secattriTlsCertKeyType));
            } else if (role.equals((Object)Role.SERVER)) {
                ioctl.setSecattriTlsSCertKeyType(Short.valueOf(secattriTlsCertKeyType));
            }
            Debug.traceText(debug, className, methodName, "Called setSecattriTlsXCertKeyType successfully, ioctl: " + ioctl);
        }
        catch (Exception e) {
            Debug.traceText(debug, className, methodName, "Unable to send certificate key type to zERT");
            Debug.traceException(debug, className, methodName, e);
        }
        Debug.traceExit(debug, className, methodName);
    }
}

