/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.javacore.builder.javacore;

import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.image.ImageSection;
import com.ibm.dtfj.image.javacore.JCImage;
import com.ibm.dtfj.image.javacore.JCImageAddressSpace;
import com.ibm.dtfj.image.javacore.JCImageSection;
import com.ibm.dtfj.java.javacore.JCInvalidArgumentsException;
import com.ibm.dtfj.javacore.builder.BuilderFailureException;
import com.ibm.dtfj.javacore.builder.IImageAddressSpaceBuilder;
import com.ibm.dtfj.javacore.builder.IImageProcessBuilder;
import com.ibm.dtfj.javacore.builder.javacore.AbstractBuilderComponent;
import com.ibm.dtfj.javacore.builder.javacore.BuilderContainer;
import com.ibm.dtfj.javacore.builder.javacore.ImageProcessBuilder;

public class ImageAddressSpaceBuilder
extends AbstractBuilderComponent
implements IImageAddressSpaceBuilder {
    private JCImageAddressSpace fImageAddressSpace;
    private BuilderContainer fBuilderContainer;

    public ImageAddressSpaceBuilder(JCImage image, String id) throws JCInvalidArgumentsException {
        super(id);
        if (image == null) {
            throw new JCInvalidArgumentsException("An image address space builder must have a valid image");
        }
        this.fImageAddressSpace = new JCImageAddressSpace(image);
        this.fBuilderContainer = this.getBuilderContainer();
    }

    @Override
    public IImageProcessBuilder getCurrentImageProcessBuilder() {
        return (IImageProcessBuilder)((Object)this.fBuilderContainer.getLastAdded());
    }

    @Override
    public IImageProcessBuilder generateImageProcessBuilder(String id) throws BuilderFailureException {
        ImageProcessBuilder imageProcessBuilder = null;
        if (this.getImageProcessBuilder(id) == null) {
            try {
                imageProcessBuilder = new ImageProcessBuilder(this.fImageAddressSpace, id);
                if (!(imageProcessBuilder instanceof AbstractBuilderComponent)) {
                    throw new BuilderFailureException(imageProcessBuilder.toString() + " must also be an " + AbstractBuilderComponent.class);
                }
                this.fBuilderContainer.add(imageProcessBuilder);
            }
            catch (JCInvalidArgumentsException e) {
                throw new BuilderFailureException(e);
            }
        }
        return imageProcessBuilder;
    }

    @Override
    public IImageProcessBuilder getImageProcessBuilder(String builderID) {
        return (IImageProcessBuilder)((Object)this.fBuilderContainer.findComponent(builderID));
    }

    @Override
    public ImageSection addImageSection(String name, long base, long size) {
        ImagePointer basePointer = this.fImageAddressSpace.getPointer(base);
        JCImageSection section = new JCImageSection(name, basePointer, size);
        this.fImageAddressSpace.addImageSection(section);
        return section;
    }
}

