/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.dtfj.java.j9;

import com.ibm.dtfj.image.CorruptDataException;
import com.ibm.dtfj.image.DataUnavailable;
import com.ibm.dtfj.image.ImagePointer;
import com.ibm.dtfj.image.ImageThread;
import com.ibm.dtfj.image.j9.CorruptData;
import com.ibm.dtfj.image.j9.ImageAddressSpace;
import com.ibm.dtfj.image.j9.ImageProcess;
import com.ibm.dtfj.java.JavaVMInitArgs;
import com.ibm.dtfj.java.j9.JavaAbstractClass;
import com.ibm.dtfj.java.j9.JavaArrayClass;
import com.ibm.dtfj.java.j9.JavaClass;
import com.ibm.dtfj.java.j9.JavaClassLoader;
import com.ibm.dtfj.java.j9.JavaHeap;
import com.ibm.dtfj.java.j9.JavaHeapRegion;
import com.ibm.dtfj.java.j9.JavaMethod;
import com.ibm.dtfj.java.j9.JavaMonitor;
import com.ibm.dtfj.java.j9.JavaObject;
import com.ibm.dtfj.java.j9.JavaReference;
import com.ibm.dtfj.java.j9.JavaThread;
import com.ibm.dtfj.java.j9.TraceBuffer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;

public class JavaRuntime
implements com.ibm.dtfj.java.JavaRuntime {
    private ImageProcess _containingProc;
    private ImagePointer _address;
    private LinkedHashMap _classLoaders = new LinkedHashMap();
    private Vector _vmThreads = new Vector();
    private LinkedHashMap _classes = new LinkedHashMap();
    private Set _arrayClasses = new HashSet();
    private Map _arrayClassesMap = new HashMap();
    private Vector _monitors = new Vector();
    private Vector _heaps = new Vector();
    private Vector _heapRoots = new Vector();
    private HashMap _traceBuffers = new HashMap();
    private Properties _systemProperties = new Properties();
    private com.ibm.dtfj.java.j9.JavaVMInitArgs _javaVMInitArgs;
    private boolean _objectsShouldInferHash = false;
    private HashMap _methodsByID = new HashMap();
    private Vector deferMonitors = new Vector();
    private HashMap _specialObjects = new HashMap();
    JavaClass _weakReferenceClass = null;
    JavaClass _softReferenceClass = null;
    JavaClass _phantomReferenceClass = null;
    JavaClass _javaLangObjectClass = null;
    private static final String WEAKREF_CLASS_NAME = "java/lang/ref/WeakReference";
    private static final String SOFTREF_CLASS_NAME = "java/lang/ref/SoftReference";
    private static final String PHANTOMREF_CLASS_NAME = "java/lang/ref/PhantomReference";
    private static final String OBJECT_CLASS_NAME = "java/lang/Object";
    private static final int DEFAULT_OBJECT_ALIGNMENT = 8;

    public JavaRuntime(ImageProcess containingProc, ImagePointer baseAddress, String runtimeVersion) {
        if (null == baseAddress) {
            throw new IllegalArgumentException("A Java Runtime cannot have a null base address");
        }
        this._containingProc = containingProc;
        this._address = baseAddress;
        this._objectsShouldInferHash = "2.2".equals(runtimeVersion) || "2.3".equals(runtimeVersion) || "2.4".equals(runtimeVersion);
    }

    @Override
    public ImagePointer getJavaVM() throws CorruptDataException {
        return this._address;
    }

    @Override
    public Iterator getJavaClassLoaders() {
        return this._classLoaders.values().iterator();
    }

    @Override
    public Iterator getThreads() {
        return this._vmThreads.iterator();
    }

    @Override
    public Iterator getCompiledMethods() {
        Iterator classes = this._classes.values().iterator();
        Vector<JavaMethod> compiledMethods = new Vector<JavaMethod>();
        while (classes.hasNext()) {
            JavaAbstractClass oneClass = (JavaAbstractClass)classes.next();
            Iterator methods = oneClass.getDeclaredMethods();
            while (methods.hasNext()) {
                JavaMethod method = (JavaMethod)methods.next();
                if (!method.getCompiledSections().hasNext()) continue;
                compiledMethods.add(method);
            }
        }
        return compiledMethods.iterator();
    }

    @Override
    public Iterator getMonitors() {
        this.checkDeferredMonitors();
        return this._monitors.iterator();
    }

    @Override
    public Iterator getHeaps() {
        return this._heaps.iterator();
    }

    @Override
    public Object getTraceBuffer(String bufferName, boolean formatted) throws CorruptDataException {
        return this._traceBuffers.get(bufferName);
    }

    @Override
    public String getFullVersion() throws CorruptDataException {
        return this.getVersion();
    }

    @Override
    public String getVersion() throws CorruptDataException {
        String javaFullVersion = this.getRequiredSystemProperty("java.fullversion");
        String javaRuntimeVersion = this.getRequiredSystemProperty("java.runtime.version");
        String javaRuntimeName = this.getRequiredSystemProperty("java.runtime.name");
        String javaVMName = this.getRequiredSystemProperty("java.vm.name");
        String version = javaRuntimeName + "(build " + javaRuntimeVersion + ")\n";
        version = version + javaVMName + "(" + javaFullVersion + ")";
        return version;
    }

    public void addClass(JavaAbstractClass theClass) {
        if (null == theClass) {
            return;
        }
        long id = theClass.getID().getAddress();
        this._classes.put(id, theClass);
        try {
            if (theClass.isArray()) {
                this._arrayClasses.add(theClass);
            }
        }
        catch (CorruptDataException corruptDataException) {
            // empty catch block
        }
        if (theClass instanceof JavaClass) {
            try {
                if (WEAKREF_CLASS_NAME.equals(theClass.getName())) {
                    this._weakReferenceClass = (JavaClass)theClass;
                } else if (SOFTREF_CLASS_NAME.equals(theClass.getName())) {
                    this._softReferenceClass = (JavaClass)theClass;
                } else if (PHANTOMREF_CLASS_NAME.equals(theClass.getName())) {
                    this._phantomReferenceClass = (JavaClass)theClass;
                } else if (OBJECT_CLASS_NAME.equals(theClass.getName())) {
                    this._javaLangObjectClass = (JavaClass)theClass;
                }
            }
            catch (CorruptDataException corruptDataException) {
                // empty catch block
            }
        }
    }

    public void addClassLoader(JavaClassLoader loader) {
        long id = loader.getID();
        this._classLoaders.put(id, loader);
    }

    public com.ibm.dtfj.java.JavaClass getClassForID(long classID) {
        return (com.ibm.dtfj.java.JavaClass)this._classes.get(classID);
    }

    com.ibm.dtfj.java.JavaClass getComponentTypeForClass(com.ibm.dtfj.java.JavaClass theClass) throws CorruptDataException {
        Object obj;
        if (this._arrayClasses != null && this._arrayClassesMap.isEmpty()) {
            for (JavaArrayClass currentClass : this._arrayClasses) {
                String className = currentClass.getName();
                String classLoaderID = "";
                com.ibm.dtfj.java.JavaClassLoader currentClassLoader = currentClass.getClassLoader();
                if (currentClassLoader != null) {
                    classLoaderID = currentClassLoader.toString();
                }
                this._arrayClassesMap.put(className + classLoaderID, currentClass);
            }
            this._arrayClasses.clear();
            this._arrayClasses = null;
        }
        com.ibm.dtfj.java.JavaClass componentType = null;
        String componentClassName = theClass.getName().substring(1);
        String classLoaderID = "";
        com.ibm.dtfj.java.JavaClassLoader theClassLoader = theClass.getClassLoader();
        if (theClassLoader != null) {
            classLoaderID = theClassLoader.toString();
        }
        if ((obj = this._arrayClassesMap.get(componentClassName + classLoaderID)) instanceof com.ibm.dtfj.java.JavaClass) {
            componentType = (com.ibm.dtfj.java.JavaClass)obj;
        }
        return componentType;
    }

    public com.ibm.dtfj.java.JavaClassLoader getClassLoaderForID(long loaderID) {
        return (com.ibm.dtfj.java.JavaClassLoader)this._classLoaders.get(loaderID);
    }

    public void addMonitor(JavaMonitor monitor) {
        this._monitors.add(monitor);
        for (int i = 0; i < this.deferMonitors.size(); ++i) {
            DeferMonitor mon = (DeferMonitor)this.deferMonitors.get(i);
            if (monitor.getID().getAddress() != mon.id) continue;
            if (mon.blocked) {
                monitor.addBlockedThread(mon.thread);
            } else {
                monitor.addWaitingThread(mon.thread);
            }
            mon.id = 0L;
        }
    }

    public void addHeap(JavaHeap heap) {
        this._heaps.add(heap);
    }

    public void addHeapRoot(JavaReference heapRoot) {
        this._heapRoots.add(heapRoot);
    }

    private void checkDeferredMonitors() {
        int errs = 0;
        for (int i = 0; i < this.deferMonitors.size(); ++i) {
            DeferMonitor mon = (DeferMonitor)this.deferMonitors.get(i);
            if (mon.id == 0L) continue;
            ImagePointer ptr = this.pointerInAddressSpace(mon.id);
            JavaMonitor autoMon = new JavaMonitor(this, ptr, "Auto-generated monitor #" + mon.id, null, 0L);
            this.addMonitor(autoMon);
            ++errs;
        }
        this.deferMonitors.clear();
    }

    public void addThread(JavaThread thread, long blockedOnMonitor, long waitingOnMonitor) {
        JavaMonitor monitor;
        boolean found;
        Iterator iter;
        this._vmThreads.add(thread);
        if (0L != blockedOnMonitor) {
            assert (0L == waitingOnMonitor) : "Thread cannot be blocked and waiting at the same time";
            iter = this._monitors.iterator();
            found = false;
            while (iter.hasNext()) {
                monitor = (JavaMonitor)iter.next();
                if (monitor.getID().getAddress() != blockedOnMonitor) continue;
                monitor.addBlockedThread(thread);
                found = true;
                break;
            }
            if (!found) {
                this.deferMonitors.add(new DeferMonitor(blockedOnMonitor, true, thread));
            }
        }
        if (0L != waitingOnMonitor) {
            assert (0L == blockedOnMonitor) : "Thread cannot be blocked and waiting at the same time";
            iter = this._monitors.iterator();
            found = false;
            while (iter.hasNext()) {
                monitor = (JavaMonitor)iter.next();
                if (monitor.getID().getAddress() != waitingOnMonitor) continue;
                monitor.addWaitingThread(thread);
                found = true;
                break;
            }
            if (!found) {
                this.deferMonitors.add(new DeferMonitor(waitingOnMonitor, false, thread));
            }
        }
    }

    public void setTraceBufferForName(TraceBuffer buffer, String key) {
        this._traceBuffers.put(key, buffer);
    }

    @Override
    public String getSystemProperty(String key) {
        return this._systemProperties.getProperty(key);
    }

    public String getSystemProperty(String key, String defaultValue) {
        return this._systemProperties.getProperty(key, defaultValue);
    }

    String getRequiredSystemProperty(String key) throws CorruptDataException {
        String value = this.getSystemProperty(key);
        if (value == null) {
            throw new CorruptDataException(new CorruptData("Required system property " + key + " not found in JExtract output", null));
        }
        return value;
    }

    public void setSystemProperty(String key, String value) {
        this._systemProperties.setProperty(key, value);
    }

    @Override
    public boolean equals(Object obj) {
        boolean isEqual = false;
        if (obj instanceof JavaRuntime) {
            isEqual = this._address.equals(((JavaRuntime)obj)._address);
        }
        return isEqual;
    }

    @Override
    public int hashCode() {
        return this._address.hashCode();
    }

    @Override
    public JavaVMInitArgs getJavaVMInitArgs() throws DataUnavailable, CorruptDataException {
        if (this._javaVMInitArgs == null) {
            throw new DataUnavailable("JavaVMInitArgs");
        }
        return this._javaVMInitArgs;
    }

    boolean objectShouldInferHash() {
        return this._objectsShouldInferHash;
    }

    public ImagePointer pointerInAddressSpace(long id) {
        return this._address.getAddressSpace().getPointer(id);
    }

    public ImageThread nativeThreadForID(long nativeID) {
        ImageThread thread = null;
        try {
            if (null != this._containingProc) {
                Iterator iter = this._containingProc.getThreads();
                while (iter.hasNext()) {
                    ImageThread t = (ImageThread)iter.next();
                    if (Long.decode(t.getID()) != nativeID) continue;
                    thread = t;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return thread;
    }

    public JavaMethod methodForID(long method) {
        return (JavaMethod)this._methodsByID.get(method);
    }

    public void addMethodForID(JavaMethod method, long id) {
        this._methodsByID.put(id, method);
    }

    public com.ibm.dtfj.java.j9.JavaVMInitArgs createJavaVMInitArgs(int version, boolean ignoreUnrecognized) {
        if (null != this._javaVMInitArgs) {
            throw new IllegalStateException("JavaVMInitArgs being created more than once");
        }
        this._javaVMInitArgs = new com.ibm.dtfj.java.j9.JavaVMInitArgs(this._address.getAddressSpace(), version, ignoreUnrecognized);
        return this._javaVMInitArgs;
    }

    public int bytesPerPointer() {
        int s = this._containingProc.getPointerSize();
        int s2 = ((ImageAddressSpace)this._address.getAddressSpace()).bytesPerPointer();
        if (s == 64 || s == 32 || s == 31) {
            return (s + 7) / 8;
        }
        return s2;
    }

    protected Iterator getClasses() {
        return this._classes.values().iterator();
    }

    @Override
    public Iterator getHeapRoots() {
        return this._heapRoots.iterator();
    }

    @Override
    public com.ibm.dtfj.java.JavaObject getObjectAtAddress(ImagePointer address) throws CorruptDataException, IllegalArgumentException {
        if (null == address) {
            throw new NullPointerException("The ImagePointer was null");
        }
        long ptr = address.getAddress();
        if (0L == ptr) {
            throw new IllegalArgumentException("The object address " + ptr + " is not in any heap");
        }
        Iterator heaps = this.getHeaps();
        JavaHeapRegion region = null;
        JavaHeap heap = null;
        while (null == region && heaps.hasNext()) {
            heap = (JavaHeap)heaps.next();
            region = heap.regionForPointer(address);
        }
        if (null == region) {
            if ((address.getAddress() & 7L) != 0L) {
                throw new IllegalArgumentException("Invalid alignment for JavaObject. Address = " + address.toString());
            }
            return new JavaObject(this, address, heap, 0L, 0L, false, 8);
        }
        return region.getObjectAtAddress(address);
    }

    public void addSpecialObject(com.ibm.dtfj.java.JavaObject obj) {
        this._specialObjects.put(obj.getID(), obj);
    }

    public com.ibm.dtfj.java.JavaObject getSpecialObject(ImagePointer address) {
        return (com.ibm.dtfj.java.JavaObject)this._specialObjects.get(address);
    }

    @Override
    public Iterator getMemoryCategories() throws DataUnavailable {
        throw new DataUnavailable("This implementation of DTFJ does not support getMemoryCategories");
    }

    @Override
    public Iterator getMemorySections(boolean includeFreed) throws DataUnavailable {
        throw new DataUnavailable("This implementation of DTFJ does not support getMemorySections");
    }

    @Override
    public boolean isJITEnabled() throws DataUnavailable, CorruptDataException {
        throw new DataUnavailable("This implementation of DTFJ does not support isJITEnabled");
    }

    @Override
    public Properties getJITProperties() throws DataUnavailable, CorruptDataException {
        throw new DataUnavailable("This implementation of DTFJ does not support getJITProperies");
    }

    @Override
    public long getStartTime() throws DataUnavailable, CorruptDataException {
        throw new DataUnavailable("Dump start time is not available");
    }

    @Override
    public long getStartTimeNanos() throws DataUnavailable, CorruptDataException {
        throw new DataUnavailable("Dump start time is not available");
    }

    private static class DeferMonitor {
        long id;
        boolean blocked;
        JavaThread thread;

        DeferMonitor(long id, boolean blocked, JavaThread thread) {
            this.id = id;
            this.blocked = blocked;
            this.thread = thread;
        }

        public String toString() {
            return "Defer monitor " + this.id;
        }
    }
}

