/*
 * Decompiled with CFR 0.152.
 */
package java.lang.management;

import com.ibm.java.lang.management.internal.ManagementUtils;
import com.ibm.oti.util.Msg;
import javax.management.openmbean.CompositeData;

public class MemoryUsage {
    private long init;
    private long used;
    private long committed;
    private long max;
    private String TOSTRING_VALUE;

    public MemoryUsage(long init, long used, long committed, long max) {
        if (init < -1L) {
            throw new IllegalArgumentException(Msg.getString("K0608"));
        }
        if (max < -1L) {
            throw new IllegalArgumentException(Msg.getString("K0609"));
        }
        if (used < 0L) {
            throw new IllegalArgumentException(Msg.getString("K060A"));
        }
        if (committed < 0L) {
            throw new IllegalArgumentException(Msg.getString("K060B"));
        }
        if (used > committed) {
            throw new IllegalArgumentException(Msg.getString("K060C"));
        }
        if (max != -1L && committed > max) {
            throw new IllegalArgumentException(Msg.getString("K060D"));
        }
        this.init = init;
        this.used = used;
        this.committed = committed;
        this.max = max;
    }

    public long getCommitted() {
        return this.committed;
    }

    public long getInit() {
        return this.init;
    }

    public long getMax() {
        return this.max;
    }

    public long getUsed() {
        return this.used;
    }

    public String toString() {
        if (this.TOSTRING_VALUE == null) {
            StringBuilder buff = new StringBuilder();
            buff.append("init = ");
            buff.append(this.init);
            MemoryUsage.appendSizeInKBytes(buff, this.init);
            buff.append("used = ");
            buff.append(this.used);
            MemoryUsage.appendSizeInKBytes(buff, this.used);
            buff.append("committed = ");
            buff.append(this.committed);
            MemoryUsage.appendSizeInKBytes(buff, this.committed);
            buff.append("max = ");
            buff.append(this.max);
            MemoryUsage.appendSizeInKBytes(buff, this.max);
            this.TOSTRING_VALUE = buff.toString().trim();
        }
        return this.TOSTRING_VALUE;
    }

    private static void appendSizeInKBytes(StringBuilder buff, long value) {
        if (value == -1L) {
            buff.append("(-1K) ");
        } else {
            buff.append("(").append(value / 1024L).append("K) ");
        }
    }

    public static MemoryUsage from(CompositeData cd) {
        MemoryUsage result = null;
        if (cd != null) {
            ManagementUtils.verifyFieldNumber(cd, 4);
            String[] attributeNames = new String[]{"init", "used", "committed", "max"};
            ManagementUtils.verifyFieldNames(cd, attributeNames);
            String[] attributeTypes = new String[]{"java.lang.Long", "java.lang.Long", "java.lang.Long", "java.lang.Long"};
            ManagementUtils.verifyFieldTypes(cd, attributeNames, attributeTypes);
            Object[] attributeVals = cd.getAll(attributeNames);
            long initVal = (Long)attributeVals[0];
            long usedVal = (Long)attributeVals[1];
            long committedVal = (Long)attributeVals[2];
            long maxVal = (Long)attributeVals[3];
            result = new MemoryUsage(initVal, usedVal, committedVal, maxVal);
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MemoryUsage)) {
            return false;
        }
        MemoryUsage mu = (MemoryUsage)obj;
        if (mu.getInit() != this.getInit()) {
            return false;
        }
        if (mu.getCommitted() != this.getCommitted()) {
            return false;
        }
        if (mu.getUsed() != this.getUsed()) {
            return false;
        }
        return mu.getMax() == this.getMax();
    }

    public int hashCode() {
        return (Long.toString(this.getCommitted()) + this.getInit() + this.getMax() + this.getUsed()).hashCode();
    }
}

