/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oti.vm;

import com.ibm.oti.util.Util;
import com.ibm.oti.vm.VM;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLStreamHandler;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import sun.net.www.protocol.file.Handler;

public abstract class AbstractClassLoader
extends ClassLoader {
    private static ClassLoader systemClassLoader;
    String[] parsedPath;
    int[] types;
    Object[] cache;
    static Object cacheLock;
    FilePermission[] permissions;
    volatile SoftReference<ConcurrentHashMap<String, Vector>> resourceCacheRef;
    private static URLStreamHandler urlJarStreamHandler;
    private static URLStreamHandler urlFileStreamHandler;

    void fillCache(int i) {
        this.setTypeElement(i, VM.getClassPathEntryType(this, i));
        switch (this.types[i]) {
            case 0: {
                this.setCacheElement(i, this.cache);
                return;
            }
            case 1: 
            case 2: {
                String path;
                if (this.parsedPath[i] == null) {
                    this.setParsedPathElement(i, Util.toString(VM.getPathFromClassPath(i)));
                }
                File f = new File(this.parsedPath[i]);
                try {
                    path = f.getCanonicalPath();
                }
                catch (IOException e) {
                    path = f.getAbsolutePath();
                }
                if (this.types[i] == 1) {
                    if (path.charAt(path.length() - 1) != File.separatorChar) {
                        StringBuilder buffer = new StringBuilder(path.length() + 1);
                        path = buffer.append(path).append(File.separatorChar).toString();
                    }
                    this.setParsedPathElement(i, path);
                    this.setCacheElement(i, this.cache);
                } else {
                    this.setParsedPathElement(i, path);
                    try {
                        JarFile zf = new JarFile(this.parsedPath[i]);
                        this.setCacheElement(i, zf);
                        return;
                    }
                    catch (IOException iOException) {
                        this.setTypeElement(i, 5);
                        this.setCacheElement(i, this.cache);
                    }
                }
                return;
            }
            case 3: 
            case 5: {
                this.setCacheElement(i, this.cache);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCacheElement(int i, Object value) {
        Object object = cacheLock;
        synchronized (object) {
            this.cache[i] = value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setTypeElement(int i, int value) {
        Object object = cacheLock;
        synchronized (object) {
            this.types[i] = value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setParsedPathElement(int i, String value) {
        Object object = cacheLock;
        synchronized (object) {
            this.parsedPath[i] = value;
        }
    }

    static String toURLString(String filename, int cpType) {
        String name = filename;
        if (File.separatorChar != '/') {
            name = name.replace(File.separatorChar, '/');
        }
        name = Util.urlEncode(name);
        int length = name.length() + 6;
        if (cpType == 2) {
            length += 4;
        }
        StringBuilder buf = new StringBuilder(length);
        if (cpType == 2) {
            buf.append("jar:file:");
        } else if (cpType == 1) {
            buf.append("file:");
        } else if (cpType == 3) {
            buf.append("jrt:");
        }
        if (!name.startsWith("/")) {
            buf.append('/');
        }
        name = buf.append(name).toString();
        return name;
    }

    public static void setBootstrapClassLoader(ClassLoader bootstrapClassLoader) {
        if (systemClassLoader != null) {
            throw new IllegalArgumentException();
        }
        systemClassLoader = bootstrapClassLoader;
        urlJarStreamHandler = new sun.net.www.protocol.jar.Handler();
        urlFileStreamHandler = new Handler();
    }

    static String getPackageName(Class<?> theClass) {
        String name = VM.getClassNameImpl(theClass, false);
        int index = name.lastIndexOf(46);
        if (index == -1) {
            return null;
        }
        return name.substring(0, index);
    }

    @Override
    protected URL findResource(final String res) {
        SecurityManager sm;
        URL result = (URL)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                for (int i = 0; i < AbstractClassLoader.this.cache.length; ++i) {
                    URL result = AbstractClassLoader.this.findResourceImpl(i, res);
                    if (result == null) continue;
                    return result;
                }
                return null;
            }
        });
        if (result != null && (sm = System.getSecurityManager()) != null) {
            try {
                sm.checkPermission(result.openConnection().getPermission());
            }
            catch (IOException e) {
                return null;
            }
            catch (SecurityException e) {
                return null;
            }
        }
        return result;
    }

    private URL findResourceImpl(int i, String res) {
        if (res.length() > 0 && res.charAt(0) == '/') {
            return null;
        }
        if (this.cache[i] == null) {
            this.fillCache(i);
        }
        try {
            switch (this.types[i]) {
                case 2: {
                    ZipFile zf = (ZipFile)this.cache[i];
                    if (zf.getEntry(res) != null) {
                        return new URL(null, AbstractClassLoader.toURLString(this.parsedPath[i] + "!/" + res, this.types[i]), urlJarStreamHandler);
                    }
                    return null;
                }
                case 1: {
                    StringBuilder buffer = new StringBuilder(this.parsedPath[i].length() + res.length());
                    String resourcePath = buffer.append(this.parsedPath[i]).append(res).toString();
                    File f = new File(resourcePath);
                    if (f.exists()) {
                        return new URL(null, AbstractClassLoader.toURLString(resourcePath, this.types[i]), urlFileStreamHandler);
                    }
                    return null;
                }
                case 3: {
                    return null;
                }
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Enumeration findResources(final String res) throws IOException {
        ConcurrentHashMap<String, Vector<Object>> resourceCache;
        SecurityManager sm;
        Vector result;
        ConcurrentHashMap<String, Vector> resourceCache2;
        if (this.resourceCacheRef != null && (resourceCache2 = this.resourceCacheRef.get()) != null && (result = resourceCache2.get(res)) != null) {
            return result.elements();
        }
        Vector<URL> result2 = (Vector<URL>)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Vector<URL> resources = new Vector<URL>();
                for (int i = 0; i < AbstractClassLoader.this.cache.length; ++i) {
                    URL resource = AbstractClassLoader.this.findResourceImpl(i, res);
                    if (resource == null) continue;
                    resources.addElement(resource);
                }
                return resources;
            }
        });
        int length = result2.size();
        if (length > 0 && (sm = System.getSecurityManager()) != null) {
            Vector<URL> reduced = new Vector<URL>(length);
            for (int i = 0; i < length; ++i) {
                URL url = (URL)result2.elementAt(i);
                try {
                    sm.checkPermission(url.openConnection().getPermission());
                    reduced.addElement(url);
                    continue;
                }
                catch (IOException | SecurityException exception) {
                    // empty catch block
                }
            }
            result2 = reduced;
        }
        if (this.resourceCacheRef == null || (resourceCache = this.resourceCacheRef.get()) == null) {
            Object object = cacheLock;
            synchronized (object) {
                if (this.resourceCacheRef == null || (resourceCache = this.resourceCacheRef.get()) == null) {
                    resourceCache = new ConcurrentHashMap(64);
                    this.resourceCacheRef = new SoftReference<ConcurrentHashMap<String, Vector>>(resourceCache);
                }
            }
        }
        resourceCache.put(res, result2);
        return result2.elements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getResourceAsStream(String resName) {
        int length;
        InputStream answer;
        if (resName == null || resName.length() < 1 || resName.charAt(0) == '/') {
            return null;
        }
        if (this != systemClassLoader && (answer = this.getParent() == null ? systemClassLoader.getResourceAsStream(resName) : this.getParent().getResourceAsStream(resName)) != null) {
            return answer;
        }
        Object object = cacheLock;
        synchronized (object) {
            length = this.cache.length;
        }
        for (int i = 0; i < length; ++i) {
            try {
                if (this.cache[i] == null) {
                    this.fillCache(i);
                }
                switch (this.types[i]) {
                    case 2: {
                        ZipFile zf = (ZipFile)this.cache[i];
                        ZipEntry entry = zf.getEntry(resName);
                        if (entry == null) break;
                        SecurityManager security = System.getSecurityManager();
                        if (security != null) {
                            this.initalizePermissions();
                            if (this.permissions[i] == null) {
                                this.setPermissionElement(i, new FilePermission(this.parsedPath[i], "read"));
                            }
                            security.checkPermission(this.permissions[i]);
                        }
                        try {
                            return zf.getInputStream(entry);
                        }
                        catch (IOException iOException) {
                            break;
                        }
                    }
                    case 1: {
                        StringBuilder buffer = new StringBuilder(this.parsedPath[i].length() + resName.length());
                        String resourcePath = buffer.append(this.parsedPath[i]).append(resName).toString();
                        InputStream result = AbstractClassLoader.openFile(resourcePath);
                        if (result == null) break;
                        return result;
                    }
                }
                continue;
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initalizePermissions() {
        Object object = cacheLock;
        synchronized (object) {
            if (this.permissions == null) {
                this.permissions = new FilePermission[this.cache.length];
            }
        }
    }

    private static InputStream openFile(String resourcePath) {
        File f = new File(resourcePath);
        if (f.exists()) {
            try {
                return new BufferedInputStream(new FileInputStream(f));
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setPermissionElement(int i, FilePermission value) {
        Object object = cacheLock;
        synchronized (object) {
            this.permissions[i] = value;
        }
    }

    static {
        cacheLock = new CacheLock();
    }

    private static final class CacheLock {
        private CacheLock() {
        }
    }
}

