/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jtc.orb.map;

import com.ibm.amino.map.ConcurrentWeakHashMap;
import com.ibm.jtc.orb.map.ConcurrentMapFactory;
import com.ibm.jtc.orb.map.MapFactory;
import com.ibm.jtc.orb.map.ObjectWrapper;
import java.lang.ref.WeakReference;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class MapFactories {
    public static final MapFactory WEAK = Weak.INSTANCE;
    public static final MapFactory IDEN = Identity.INSTANCE;
    public static final ConcurrentMapFactory CONCURRENT_WEAK = ConcurrentWeak.INSTANCE;
    public static final ConcurrentMapFactory CONCURRENT_HASH = Concurrent.INSTANCE;

    private MapFactories() {
    }

    private static final class ConcurrentWeak
    implements ConcurrentMapFactory {
        public static final ConcurrentWeak INSTANCE = new ConcurrentWeak();

        private ConcurrentWeak() {
        }

        @Override
        public ConcurrentMap create() {
            return new ConcurrentWeakHashMap();
        }

        @Override
        public ConcurrentMap create(int n) {
            return new ConcurrentWeakHashMap(n);
        }

        @Override
        public ConcurrentMap create(int n, float f, int n2) {
            return new ConcurrentWeakHashMap(n, f, n2);
        }

        @Override
        public ObjectWrapper getKeyWrapper() {
            return WeakWrapper.INSTANCE;
        }
    }

    private static final class Concurrent
    implements ConcurrentMapFactory {
        public static final Concurrent INSTANCE = new Concurrent();

        private Concurrent() {
        }

        @Override
        public ConcurrentMap create() {
            return new ConcurrentHashMap();
        }

        @Override
        public ConcurrentMap create(int n) {
            return new ConcurrentHashMap(n);
        }

        @Override
        public ConcurrentMap create(int n, float f, int n2) {
            return new ConcurrentHashMap(n, f, n2);
        }

        @Override
        public ObjectWrapper getKeyWrapper() {
            return NoopWrapper.INSTANCE;
        }
    }

    private static final class WeakWrapper
    implements ObjectWrapper {
        public static final WeakWrapper INSTANCE = new WeakWrapper();

        private WeakWrapper() {
        }

        @Override
        public final Object wrap(Object object) {
            return null == object ? null : new WeakReference<Object>(object);
        }

        @Override
        public final Object unwrap(Object object) {
            return null == object ? null : ((WeakReference)object).get();
        }
    }

    private static final class NoopWrapper
    implements ObjectWrapper {
        public static final NoopWrapper INSTANCE = new NoopWrapper();

        private NoopWrapper() {
        }

        @Override
        public final Object wrap(Object object) {
            return object;
        }

        @Override
        public final Object unwrap(Object object) {
            return object;
        }
    }

    private static final class Identity
    implements MapFactory {
        public static final Identity INSTANCE = new Identity();

        private Identity() {
        }

        @Override
        public Map create() {
            return new IdentityHashMap();
        }

        @Override
        public ObjectWrapper getKeyWrapper() {
            return NoopWrapper.INSTANCE;
        }
    }

    private static final class Weak
    implements MapFactory {
        public static final Weak INSTANCE = new Weak();

        private Weak() {
        }

        @Override
        public Map create() {
            return new WeakHashMap();
        }

        @Override
        public ObjectWrapper getKeyWrapper() {
            return WeakWrapper.INSTANCE;
        }
    }
}

