/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.security.x509;

import com.ibm.misc.Debug;
import com.ibm.security.util.DerInputStream;
import com.ibm.security.util.DerOutputStream;
import com.ibm.security.util.DerValue;
import com.ibm.security.util.ObjectIdentifier;
import com.ibm.security.x509.AVA;
import com.ibm.security.x509.GeneralNameInterface;
import com.ibm.security.x509.RDN;
import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import javax.security.auth.x500.X500Principal;

public final class X500Name
implements GeneralNameInterface,
Principal {
    private String dn;
    private String rfc1779Dn;
    private String rfc2253Dn;
    private String canonicalDn;
    private RDN[] names;
    private X500Principal x500Principal;
    private byte[] encoded;
    private volatile List<RDN> rdnList;
    private volatile List<AVA> allAvaList;
    private static Debug debug = Debug.getInstance("ibmpkcs");
    private static final int[] emailAddress_data = new int[]{1, 2, 840, 113549, 1, 9, 1};
    private static final int[] postalCode_data = new int[]{2, 5, 4, 17};
    private static final int[] commonName_data = new int[]{2, 5, 4, 3};
    private static final int[] surName_data = new int[]{2, 5, 4, 4};
    private static final int[] serialNumber_data = new int[]{2, 5, 4, 5};
    private static final int[] countryName_data = new int[]{2, 5, 4, 6};
    private static final int[] localityName_data = new int[]{2, 5, 4, 7};
    private static final int[] stateName_data = new int[]{2, 5, 4, 8};
    private static final int[] streetAddress_data = new int[]{2, 5, 4, 9};
    private static final int[] orgName_data = new int[]{2, 5, 4, 10};
    private static final int[] orgUnitName_data = new int[]{2, 5, 4, 11};
    private static final int[] title_data = new int[]{2, 5, 4, 12};
    private static final int[] givenName_data = new int[]{2, 5, 4, 42};
    private static final int[] initials_data = new int[]{2, 5, 4, 43};
    private static final int[] pseudonym_data = new int[]{2, 5, 4, 65};
    private static final int[] generationQualifier_data = new int[]{2, 5, 4, 44};
    private static final int[] dnQualifier_data = new int[]{2, 5, 4, 46};
    private static final int[] ipAddress_data = new int[]{1, 3, 6, 1, 4, 1, 42, 2, 11, 2, 1};
    private static final int[] domainComponent_data = new int[]{0, 9, 2342, 19200300, 100, 1, 25};
    private static final int[] userid_data = new int[]{0, 9, 2342, 19200300, 100, 1, 1};
    public static final ObjectIdentifier emailAddress_oid = ObjectIdentifier.newInternal(emailAddress_data);
    public static final ObjectIdentifier postalCode_oid = ObjectIdentifier.newInternal(postalCode_data);
    public static final ObjectIdentifier commonName_oid = ObjectIdentifier.newInternal(commonName_data);
    public static final ObjectIdentifier countryName_oid = ObjectIdentifier.newInternal(countryName_data);
    public static final ObjectIdentifier localityName_oid = ObjectIdentifier.newInternal(localityName_data);
    public static final ObjectIdentifier orgName_oid = ObjectIdentifier.newInternal(orgName_data);
    public static final ObjectIdentifier orgUnitName_oid = ObjectIdentifier.newInternal(orgUnitName_data);
    public static final ObjectIdentifier stateName_oid = ObjectIdentifier.newInternal(stateName_data);
    public static final ObjectIdentifier streetAddress_oid = ObjectIdentifier.newInternal(streetAddress_data);
    public static final ObjectIdentifier title_oid = ObjectIdentifier.newInternal(title_data);
    public static final ObjectIdentifier dnQualifier_oid = ObjectIdentifier.newInternal(dnQualifier_data);
    public static final ObjectIdentifier surName_oid = ObjectIdentifier.newInternal(surName_data);
    public static final ObjectIdentifier givenName_oid = ObjectIdentifier.newInternal(givenName_data);
    public static final ObjectIdentifier initials_oid = ObjectIdentifier.newInternal(initials_data);
    public static final ObjectIdentifier pseudonym_oid = ObjectIdentifier.newInternal(pseudonym_data);
    public static final ObjectIdentifier generationQualifier_oid = ObjectIdentifier.newInternal(generationQualifier_data);
    public static final ObjectIdentifier ipAddress_oid = ObjectIdentifier.newInternal(ipAddress_data);
    public static final ObjectIdentifier domainComponent_oid = ObjectIdentifier.newInternal(domainComponent_data);
    public static final ObjectIdentifier userid_oid = ObjectIdentifier.newInternal(userid_data);
    public static final ObjectIdentifier serialNumber_oid = ObjectIdentifier.newInternal(serialNumber_data);

    public X500Name(String dname) throws IOException {
        this(dname, Collections.emptyMap());
    }

    public X500Name(String dname, Map<String, String> keywordMap) throws IOException {
        this.parseDN(dname, keywordMap);
    }

    public X500Name(String dname, String format) throws IOException {
        if (dname == null) {
            throw new NullPointerException("Name must not be null");
        }
        if (format.equalsIgnoreCase("RFC2253")) {
            this.parseRFC2253DN(dname);
        } else if (format.equalsIgnoreCase("DEFAULT")) {
            this.parseDN(dname, Collections.emptyMap());
        } else {
            throw new IOException("Unsupported format " + format);
        }
    }

    public X500Name(String commonName, String organizationUnit, String organizationName, String country) throws IOException {
        this.names = new RDN[4];
        this.names[3] = new RDN(1);
        this.names[3].assertion[0] = new AVA(commonName_oid, new DerValue(commonName));
        this.names[2] = new RDN(1);
        this.names[2].assertion[0] = new AVA(orgUnitName_oid, new DerValue(organizationUnit));
        this.names[1] = new RDN(1);
        this.names[1].assertion[0] = new AVA(orgName_oid, new DerValue(organizationName));
        this.names[0] = new RDN(1);
        this.names[0].assertion[0] = new AVA(countryName_oid, new DerValue(country));
    }

    public X500Name(String commonName, String organizationUnit, String organizationName, String country, String emailAddress) throws IOException {
        this.names = new RDN[5];
        this.names[4] = new RDN(1);
        this.names[4].assertion[0] = new AVA(commonName_oid, new DerValue(commonName));
        this.names[3] = new RDN(1);
        this.names[3].assertion[0] = new AVA(orgUnitName_oid, new DerValue(organizationUnit));
        this.names[2] = new RDN(1);
        this.names[2].assertion[0] = new AVA(orgName_oid, new DerValue(organizationName));
        this.names[1] = new RDN(1);
        this.names[1].assertion[0] = new AVA(countryName_oid, new DerValue(country));
        this.names[0] = new RDN(1);
        this.names[0].assertion[0] = new AVA(emailAddress_oid, new DerValue(22, emailAddress));
    }

    public X500Name(String commonName, String organizationUnit, String organizationName, String localityName, String stateName, String country) throws IOException {
        this.names = new RDN[6];
        this.names[5] = new RDN(1);
        this.names[5].assertion[0] = new AVA(commonName_oid, new DerValue(commonName));
        this.names[4] = new RDN(1);
        this.names[4].assertion[0] = new AVA(orgUnitName_oid, new DerValue(organizationUnit));
        this.names[3] = new RDN(1);
        this.names[3].assertion[0] = new AVA(orgName_oid, new DerValue(organizationName));
        this.names[2] = new RDN(1);
        this.names[2].assertion[0] = new AVA(localityName_oid, new DerValue(localityName));
        this.names[1] = new RDN(1);
        this.names[1].assertion[0] = new AVA(stateName_oid, new DerValue(stateName));
        this.names[0] = new RDN(1);
        this.names[0].assertion[0] = new AVA(countryName_oid, new DerValue(country));
    }

    public X500Name(String commonName, String organizationUnit, String organizationName, String localityName, String stateName, String postalCode, String country) throws IOException {
        this.names = new RDN[7];
        this.names[6] = new RDN(1);
        this.names[6].assertion[0] = new AVA(commonName_oid, new DerValue(commonName));
        this.names[5] = new RDN(1);
        this.names[5].assertion[0] = new AVA(orgUnitName_oid, new DerValue(organizationUnit));
        this.names[4] = new RDN(1);
        this.names[4].assertion[0] = new AVA(orgName_oid, new DerValue(organizationName));
        this.names[3] = new RDN(1);
        this.names[3].assertion[0] = new AVA(localityName_oid, new DerValue(localityName));
        this.names[2] = new RDN(1);
        this.names[2].assertion[0] = new AVA(stateName_oid, new DerValue(stateName));
        this.names[1] = new RDN(1);
        this.names[1].assertion[0] = new AVA(postalCode_oid, new DerValue(postalCode));
        this.names[0] = new RDN(1);
        this.names[0].assertion[0] = new AVA(countryName_oid, new DerValue(country));
    }

    public X500Name(RDN[] rdnArray) throws IOException {
        if (rdnArray == null) {
            this.names = new RDN[0];
        } else {
            this.names = (RDN[])rdnArray.clone();
            for (int i = 0; i < this.names.length; ++i) {
                if (this.names[i] != null) continue;
                throw new IOException("Cannot create an X500Name");
            }
        }
    }

    public X500Name(DerValue value) throws IOException {
        this(value.toDerInputStream());
    }

    public X500Name(DerInputStream in) throws IOException {
        this.parseDER(in);
    }

    public X500Name(byte[] name) throws IOException {
        DerInputStream in = new DerInputStream(name);
        this.parseDER(in);
    }

    public List<RDN> rdns() {
        List<RDN> list = this.rdnList;
        if (list == null) {
            this.rdnList = list = Collections.unmodifiableList(Arrays.asList(this.names));
        }
        return list;
    }

    public int size() {
        return this.names.length;
    }

    public RDN getRDN(int index) {
        return this.names[index];
    }

    public X500Name getParentDn() throws IOException {
        RDN[] result = new RDN[this.names.length - 1];
        System.arraycopy(this.names, 0, result, 0, this.names.length - 1);
        return new X500Name(result);
    }

    public List<AVA> allAvas() {
        List<AVA> list = this.allAvaList;
        if (list == null) {
            list = new ArrayList<AVA>();
            for (int i = 0; i < this.names.length; ++i) {
                list.addAll(this.names[i].avas());
            }
            this.allAvaList = list = Collections.unmodifiableList(list);
        }
        return list;
    }

    public int avaSize() {
        return this.allAvas().size();
    }

    public boolean isEmpty() {
        int n = this.names.length;
        for (int i = 0; i < n; ++i) {
            if (this.names[i].assertion.length == 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        return this.getRFC2253CanonicalName().hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof X500Name)) {
            return false;
        }
        X500Name other = (X500Name)obj;
        if (this.canonicalDn != null && other.canonicalDn != null) {
            return this.canonicalDn.equals(other.canonicalDn);
        }
        int n = this.names.length;
        if (n != other.names.length) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            RDN r1 = this.names[i];
            RDN r2 = other.names[i];
            if (r1.assertion.length == r2.assertion.length) continue;
            return false;
        }
        String thisCanonical = this.getRFC2253CanonicalName();
        String otherCanonical = other.getRFC2253CanonicalName();
        return thisCanonical.equals(otherCanonical);
    }

    public boolean equals(X500Name other) {
        if (this.canonicalDn != null && other.canonicalDn != null) {
            return this.canonicalDn.equals(other.canonicalDn);
        }
        int n = this.names.length;
        if (n != other.names.length) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            RDN r1 = this.names[i];
            RDN r2 = other.names[i];
            if (r1.assertion.length == r2.assertion.length) continue;
            return false;
        }
        String thisCanonical = this.getRFC2253CanonicalName();
        String otherCanonical = other.getRFC2253CanonicalName();
        return thisCanonical.equals(otherCanonical);
    }

    private String getString(DerValue attribute) throws IOException {
        if (attribute == null) {
            return null;
        }
        String value = attribute.getAsString();
        if (value == null) {
            throw new IOException("not a DER string encoding, " + attribute.tag);
        }
        return value;
    }

    @Override
    public int getType() {
        return 4;
    }

    public String getEmail() throws IOException {
        DerValue attr = this.findAttribute(emailAddress_oid);
        return this.getString(attr);
    }

    public String getPostalCode() throws IOException {
        DerValue attr = this.findAttribute(postalCode_oid);
        return this.getString(attr);
    }

    public String getCountry() throws IOException {
        DerValue attr = this.findAttribute(countryName_oid);
        return this.getString(attr);
    }

    public String getOrganization() throws IOException {
        DerValue attr = this.findAttribute(orgName_oid);
        return this.getString(attr);
    }

    public String getOrganizationalUnit() throws IOException {
        DerValue attr = this.findAttribute(orgUnitName_oid);
        return this.getString(attr);
    }

    public String getCommonName() throws IOException {
        DerValue attr = this.findAttribute(commonName_oid);
        return this.getString(attr);
    }

    public String getLocality() throws IOException {
        DerValue attr = this.findAttribute(localityName_oid);
        return this.getString(attr);
    }

    public String getState() throws IOException {
        DerValue attr = this.findAttribute(stateName_oid);
        return this.getString(attr);
    }

    public String getDomain() throws IOException {
        DerValue attr = this.findAttribute(domainComponent_oid);
        return this.getString(attr);
    }

    public String getDNQualifier() throws IOException {
        DerValue attr = this.findAttribute(dnQualifier_oid);
        return this.getString(attr);
    }

    public String getSurname() throws IOException {
        DerValue attr = this.findAttribute(surName_oid);
        return this.getString(attr);
    }

    public String getGivenName() throws IOException {
        DerValue attr = this.findAttribute(givenName_oid);
        return this.getString(attr);
    }

    public String getInitials() throws IOException {
        DerValue attr = this.findAttribute(initials_oid);
        return this.getString(attr);
    }

    public String getGeneration() throws IOException {
        DerValue attr = this.findAttribute(generationQualifier_oid);
        return this.getString(attr);
    }

    public String getIP() throws IOException {
        DerValue attr = this.findAttribute(ipAddress_oid);
        return this.getString(attr);
    }

    @Override
    public String toString() {
        if (this.dn == null) {
            this.generateDN();
        }
        return this.dn;
    }

    public String getRFC1779Name() {
        return this.getRFC1779Name(Collections.emptyMap());
    }

    public String getRFC1779Name(Map<String, String> oidMap) throws IllegalArgumentException {
        if (oidMap.isEmpty()) {
            if (this.rfc1779Dn != null) {
                return this.rfc1779Dn;
            }
            this.rfc1779Dn = this.generateRFC1779DN(oidMap);
            return this.rfc1779Dn;
        }
        return this.generateRFC1779DN(oidMap);
    }

    public String getRFC2253Name() {
        return this.getRFC2253Name(Collections.emptyMap());
    }

    public String getRFC2253Name(Map<String, String> oidMap) {
        if (oidMap.isEmpty()) {
            if (this.rfc2253Dn != null) {
                return this.rfc2253Dn;
            }
            this.rfc2253Dn = this.generateRFC2253DN(oidMap);
            return this.rfc2253Dn;
        }
        return this.generateRFC2253DN(oidMap);
    }

    private String generateRFC2253DN(Map<String, String> oidMap) {
        if (this.names.length == 0) {
            return "";
        }
        StringJoiner sj = new StringJoiner(",");
        for (int i = this.names.length - 1; i >= 0; --i) {
            sj.add(this.names[i].toRFC2253String(oidMap));
        }
        return sj.toString();
    }

    public String getRFC2253CanonicalName() {
        if (this.canonicalDn != null) {
            return this.canonicalDn;
        }
        if (this.names.length == 0) {
            this.canonicalDn = "";
            return this.canonicalDn;
        }
        StringJoiner sj = new StringJoiner(",");
        for (int i = this.names.length - 1; i >= 0; --i) {
            sj.add(this.names[i].toRFC2253String(true));
        }
        this.canonicalDn = sj.toString();
        return this.canonicalDn;
    }

    @Override
    public String getName() {
        return this.toString();
    }

    private DerValue findAttribute(ObjectIdentifier attribute) {
        if (this.names != null) {
            for (int i = 0; i < this.names.length; ++i) {
                DerValue value = this.names[i].findAttribute(attribute);
                if (value == null) continue;
                return value;
            }
        }
        return null;
    }

    public DerValue findMostSpecificAttribute(ObjectIdentifier attribute) {
        if (this.names != null) {
            for (int i = this.names.length - 1; i >= 0; --i) {
                DerValue value = this.names[i].findAttribute(attribute);
                if (value == null) continue;
                return value;
            }
        }
        return null;
    }

    private void parseDER(DerInputStream in) throws IOException {
        DerValue[] nameseq = null;
        byte[] derBytes = in.toByteArray();
        try {
            nameseq = in.getSequence(5);
        }
        catch (IOException ioe) {
            if (derBytes == null) {
                nameseq = null;
            }
            DerValue derVal = new DerValue(48, derBytes);
            derBytes = derVal.toByteArray();
            nameseq = new DerInputStream(derBytes).getSequence(5);
        }
        if (nameseq == null) {
            this.names = new RDN[0];
        } else {
            this.names = new RDN[nameseq.length];
            for (int i = 0; i < nameseq.length; ++i) {
                this.names[i] = new RDN(nameseq[i]);
            }
        }
    }

    @Deprecated
    public void emit(DerOutputStream out) throws IOException {
        this.encode(out);
    }

    @Override
    public void encode(DerOutputStream out) throws IOException {
        DerOutputStream tmp = new DerOutputStream();
        for (int i = 0; i < this.names.length; ++i) {
            this.names[i].encode(tmp);
        }
        out.write((byte)48, tmp);
    }

    byte[] getEncodedInternal() throws IOException {
        if (this.encoded == null) {
            DerOutputStream out = new DerOutputStream();
            DerOutputStream tmp = new DerOutputStream();
            for (int i = 0; i < this.names.length; ++i) {
                this.names[i].encode(tmp);
            }
            out.write((byte)48, tmp);
            this.encoded = out.toByteArray();
        }
        return this.encoded;
    }

    public byte[] getEncoded() throws IOException {
        return (byte[])this.getEncodedInternal().clone();
    }

    private void parseDN(String input, Map<String, String> keywordMap) throws IOException {
        RDN rdn;
        String rdnString;
        if (input == null || input.length() == 0) {
            this.names = new RDN[0];
            return;
        }
        ArrayList<RDN> dnVector = new ArrayList<RDN>();
        int dnOffset = 0;
        int quoteCount = 0;
        String dnString = input;
        int searchOffset = 0;
        int nextComma = dnString.indexOf(44);
        int nextSemiColon = dnString.indexOf(59);
        while (nextComma >= 0 || nextSemiColon >= 0) {
            int rdnEnd = nextSemiColon < 0 ? nextComma : (nextComma < 0 ? nextSemiColon : Math.min(nextComma, nextSemiColon));
            if (rdnEnd >= 0 && (quoteCount += X500Name.countQuotes(dnString, searchOffset, rdnEnd)) != 1 && !X500Name.escaped(rdnEnd, searchOffset, dnString)) {
                rdnString = dnString.substring(dnOffset, rdnEnd);
                rdn = new RDN(rdnString, keywordMap);
                dnVector.add(rdn);
                dnOffset = rdnEnd + 1;
                quoteCount = 0;
            }
            searchOffset = rdnEnd + 1;
            nextComma = dnString.indexOf(44, searchOffset);
            nextSemiColon = dnString.indexOf(59, searchOffset);
        }
        rdnString = dnString.substring(dnOffset);
        rdn = new RDN(rdnString, keywordMap);
        dnVector.add(rdn);
        Collections.reverse(dnVector);
        this.names = dnVector.toArray(new RDN[dnVector.size()]);
    }

    private void parseRFC2253DN(String dnString) throws IOException {
        RDN rdn;
        String rdnString;
        if (dnString.length() == 0) {
            this.names = new RDN[0];
            return;
        }
        ArrayList<RDN> dnVector = new ArrayList<RDN>();
        int dnOffset = 0;
        int searchOffset = 0;
        int rdnEnd = dnString.indexOf(44);
        while (rdnEnd >= 0) {
            if (rdnEnd > 0 && !X500Name.escaped(rdnEnd, searchOffset, dnString)) {
                rdnString = dnString.substring(dnOffset, rdnEnd);
                rdn = new RDN(rdnString, "RFC2253");
                dnVector.add(rdn);
                dnOffset = rdnEnd + 1;
            }
            searchOffset = rdnEnd + 1;
            rdnEnd = dnString.indexOf(44, searchOffset);
        }
        rdnString = dnString.substring(dnOffset);
        rdn = new RDN(rdnString, "RFC2253");
        dnVector.add(rdn);
        Collections.reverse(dnVector);
        this.names = dnVector.toArray(new RDN[dnVector.size()]);
    }

    static int countQuotes(String string, int from, int to) {
        int count = 0;
        for (int i = from; i < to; ++i) {
            if ((string.charAt(i) != '\"' || i != from) && (string.charAt(i) != '\"' || string.charAt(i - 1) == '\\')) continue;
            ++count;
        }
        return count;
    }

    private static boolean escaped(int rdnEnd, int searchOffset, String dnString) {
        if (rdnEnd == 1 && dnString.charAt(rdnEnd - 1) == '\\') {
            return true;
        }
        if (rdnEnd > 1 && dnString.charAt(rdnEnd - 1) == '\\' && dnString.charAt(rdnEnd - 2) != '\\') {
            return true;
        }
        if (rdnEnd > 1 && dnString.charAt(rdnEnd - 1) == '\\' && dnString.charAt(rdnEnd - 2) == '\\') {
            int count = 0;
            --rdnEnd;
            while (rdnEnd >= searchOffset) {
                if (dnString.charAt(rdnEnd) == '\\') {
                    ++count;
                }
                --rdnEnd;
            }
            return count % 2 != 0;
        }
        return false;
    }

    private void generateDN() {
        if (this.names.length == 1) {
            this.dn = this.names[0].toString();
            return;
        }
        if (this.names == null) {
            this.dn = "";
            return;
        }
        StringJoiner sj = new StringJoiner(", ");
        for (int i = this.names.length - 1; i >= 0; --i) {
            sj.add(this.names[i].toString());
        }
        this.dn = sj.toString();
    }

    private String generateRFC1779DN(Map<String, String> oidMap) {
        if (this.names.length == 1) {
            return this.names[0].toRFC1779String(oidMap);
        }
        if (this.names == null) {
            return "";
        }
        StringJoiner sj = new StringJoiner(", ");
        for (int i = this.names.length - 1; i >= 0; --i) {
            sj.add(this.names[i].toRFC1779String(oidMap));
        }
        return sj.toString();
    }

    public boolean isAbove(X500Name other) throws IOException {
        while (this.size() < other.size()) {
            other = other.getParentDn();
        }
        return this.equals(other);
    }

    @Override
    public int constrains(GeneralNameInterface inputName) throws UnsupportedOperationException {
        X500Name inputX500;
        int constraintType = inputName == null ? -1 : (inputName.getType() != 4 ? -1 : ((inputX500 = (X500Name)inputName).equals(this) ? 0 : (inputX500.names.length == 0 ? 2 : (this.names.length == 0 ? 1 : (inputX500.isWithinSubtree(this) ? 1 : (this.isWithinSubtree(inputX500) ? 2 : 3))))));
        return constraintType;
    }

    private boolean isWithinSubtree(X500Name other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (other.names.length == 0) {
            return true;
        }
        if (this.names.length == 0) {
            return false;
        }
        if (this.names.length < other.names.length) {
            return false;
        }
        for (int i = 0; i < other.names.length; ++i) {
            if (this.names[i].equals(other.names[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public int subtreeDepth() throws UnsupportedOperationException {
        return this.names.length;
    }

    public X500Name commonAncestor(X500Name other) {
        int i;
        if (other == null) {
            return null;
        }
        int otherLen = other.names.length;
        int thisLen = this.names.length;
        if (thisLen == 0 || otherLen == 0) {
            return null;
        }
        int minLen = thisLen < otherLen ? thisLen : otherLen;
        for (i = 0; i < minLen; ++i) {
            if (this.names[i].equals(other.names[i])) continue;
            if (i != 0) break;
            return null;
        }
        RDN[] ancestor = new RDN[i];
        for (int j = 0; j < i; ++j) {
            ancestor[j] = this.names[j];
        }
        X500Name commonAncestor = null;
        try {
            commonAncestor = new X500Name(ancestor);
        }
        catch (IOException ioe) {
            return null;
        }
        return commonAncestor;
    }
}

