/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.crypto.enc.spec;

import javax.xml.crypto.dsig.DigestMethod;
import javax.xml.crypto.enc.spec.EncryptionMethodParameterSpec;

public final class RSAOAEPParameterSpec
implements EncryptionMethodParameterSpec {
    private DigestMethod digestMethod;
    private byte[] oaepParams;

    public RSAOAEPParameterSpec(DigestMethod digestMethod) {
        if (digestMethod == null) {
            throw new NullPointerException("digest method is null");
        }
        this.digestMethod = digestMethod;
    }

    public RSAOAEPParameterSpec(DigestMethod digestMethod, byte[] oaepParams) {
        if (digestMethod == null) {
            throw new NullPointerException("digest method is null");
        }
        if (oaepParams == null) {
            throw new NullPointerException("oaepParams is null");
        }
        this.digestMethod = digestMethod;
        this.oaepParams = (byte[])oaepParams.clone();
    }

    public DigestMethod getDigestMethod() {
        return this.digestMethod;
    }

    public byte[] getOAEPParams() {
        return this.oaepParams == null ? null : (byte[])this.oaepParams.clone();
    }
}

