/*
 * Decompiled with CFR 0.152.
 */
package java.lang.invoke;

import java.lang.invoke.Comparator;
import java.lang.invoke.MethodType;
import java.lang.invoke.MethodTypeHelper;
import java.lang.invoke.PrimitiveHandle;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;

abstract class FieldHandle
extends PrimitiveHandle {
    final Class<?> fieldClass;
    final boolean isVolatile;

    FieldHandle(MethodType type, Class<?> referenceClass, String fieldName, Class<?> fieldClass, byte kind, Class<?> accessClass) throws IllegalAccessException, NoSuchFieldException {
        super(type, referenceClass, fieldName, kind, null);
        this.fieldClass = fieldClass;
        this.defc = this.finishFieldInitialization(accessClass);
        this.isVolatile = Modifier.isVolatile(this.rawModifiers);
        assert (this.isVMSlotCorrectlyTagged());
    }

    FieldHandle(MethodType type, Field field, byte kind, boolean isStatic) throws IllegalAccessException {
        super(type, field.getDeclaringClass(), field.getName(), kind, field.getModifiers(), null);
        this.fieldClass = field.getType();
        assert (isStatic == Modifier.isStatic(field.getModifiers()));
        boolean succeed = FieldHandle.setVMSlotAndRawModifiersFromField(this, field);
        if (!succeed) {
            throw new IllegalAccessException();
        }
        this.isVolatile = Modifier.isVolatile(this.rawModifiers);
        assert (this.isVMSlotCorrectlyTagged());
    }

    FieldHandle(FieldHandle originalHandle, MethodType newType) {
        super(originalHandle, newType);
        this.fieldClass = originalHandle.fieldClass;
        this.isVolatile = originalHandle.isVolatile;
        assert (this.isVMSlotCorrectlyTagged());
    }

    final Class<?> finishFieldInitialization(Class<?> accessClass) throws IllegalAccessException, NoSuchFieldException {
        String signature = MethodTypeHelper.getBytecodeStringName(this.fieldClass);
        try {
            boolean isStaticLookup = 2 == this.kind || 4 == this.kind;
            return this.lookupField(this.referenceClass, this.name, signature, isStaticLookup, accessClass);
        }
        catch (NoSuchFieldError e) {
            throw new NoSuchFieldException(e.getMessage());
        }
        catch (LinkageError e) {
            throw (IllegalAccessException)new IllegalAccessException(e.getMessage()).initCause(e);
        }
    }

    boolean isVMSlotCorrectlyTagged() {
        if (4 == this.kind || 2 == this.kind) {
            return (this.vmSlot & 1L) == 1L;
        }
        return (this.vmSlot & 1L) == 0L;
    }

    @Override
    boolean canRevealDirect() {
        return true;
    }

    final void compareWithField(FieldHandle left, Comparator c) {
        c.compareStructuralParameter(left.referenceClass, this.referenceClass);
        c.compareStructuralParameter(left.vmSlot, this.vmSlot);
    }
}

