/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.gpu;

import com.ibm.cuda.Cuda;
import com.ibm.cuda.CudaDevice;
import com.ibm.gpu.CUDADevice;
import com.ibm.gpu.GPUConfigurationException;
import com.ibm.gpu.GPUPermission;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import sun.misc.Unsafe;

public final class CUDAManager {
    private static final Lock lock = new Lock();
    private final BitSet busyDevices = new BitSet();
    private int defaultDeviceId = 0;
    private final int defaultDoubleThreshold;
    private final int defaultFloatThreshold;
    private final int defaultIntThreshold;
    private final int defaultLongThreshold;
    private CUDADevice[] devices = null;
    private final long devicesOffset;
    private final Unsafe unsafe;
    private boolean doSortOnGPU = false;
    private boolean enforceGPUSort = false;
    private boolean verboseOutput = CUDAManager.getProperty("com.ibm.gpu.verbose") != null;

    @Deprecated
    public static CUDAManager getInstance() throws GPUConfigurationException, SecurityException {
        return CUDAManager.instance();
    }

    public static CUDAManager instance() throws SecurityException {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkPermission(GPUPermission.Access);
        }
        return CUDAManager.instanceInternal();
    }

    static CUDAManager instanceInternal() {
        return Singleton.INSTANCE;
    }

    public static String getOutputHeader() {
        return "[IBM GPU]:";
    }

    static String getProperty(String name) {
        PrivilegedAction<String> action = () -> System.getProperty(name);
        return AccessController.doPrivileged(action);
    }

    public static String getVersion() {
        return "0.95";
    }

    @Deprecated
    public static void tearDown() {
    }

    CUDAManager() {
        try {
            this.unsafe = Unsafe.getUnsafe();
            this.devicesOffset = this.unsafe.objectFieldOffset(CUDAManager.class.getDeclaredField("devices"));
        }
        catch (NoSuchFieldException e) {
            InternalError error = new InternalError(e.toString());
            error.initCause(e);
            throw error;
        }
        Configuration configuration = new Configuration(this);
        this.defaultDoubleThreshold = configuration.getDoubleThreshold();
        this.defaultFloatThreshold = configuration.getFloatThreshold();
        this.defaultIntThreshold = configuration.getIntThreshold();
        this.defaultLongThreshold = configuration.getLongThreshold();
        if (configuration.checkSortProperty("com.ibm.gpu.enforce")) {
            this.doSortOnGPU = true;
            this.enforceGPUSort = true;
        } else if (configuration.checkSortProperty("com.ibm.gpu.enable")) {
            this.doSortOnGPU = true;
        }
        if (configuration.checkSortProperty("com.ibm.gpu.disable")) {
            this.doSortOnGPU = false;
            this.enforceGPUSort = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int acquireFreeDevice() {
        Lock lock = CUDAManager.lock;
        synchronized (lock) {
            int deviceId = this.busyDevices.nextClearBit(0);
            if (deviceId < this.getDeviceCount()) {
                this.outputIfVerbose("Acquired device: " + deviceId);
                this.busyDevices.set(deviceId);
            } else {
                this.outputIfVerbose("No available devices found");
                deviceId = -1;
            }
            return deviceId;
        }
    }

    private CUDADevice[] findDevices() {
        int deviceCount = 0;
        try {
            deviceCount = Cuda.getDeviceCount();
        }
        catch (Exception e) {
            this.outputIfVerbose("Couldn't count devices due to: " + e.getLocalizedMessage());
        }
        catch (NoClassDefFoundError e) {
            this.outputIfVerbose("Unsupported platform detected");
        }
        CUDADevice[] allDevices = new CUDADevice[deviceCount];
        if (deviceCount != 0) {
            Configuration configuration = new Configuration(this);
            for (int deviceId = 0; deviceId < deviceCount; ++deviceId) {
                String modelName = "";
                try {
                    modelName = new CudaDevice(deviceId).getName();
                }
                catch (Exception e) {
                    this.outputIfVerbose("Warning: couldn't get the GPU model name for device " + deviceId);
                }
                allDevices[deviceId] = new CUDADevice(deviceId, modelName, configuration.getDoubleThreshold(modelName), configuration.getFloatThreshold(modelName), configuration.getIntThreshold(modelName), configuration.getLongThreshold(modelName));
            }
            this.outputIfVerbose("Discovered " + deviceCount + " device(s)");
        }
        return allDevices;
    }

    public ArrayList<CUDADevice> getCUDADevices() {
        return new ArrayList<CUDADevice>(Arrays.asList(this.getDevices()));
    }

    public int getDefaultDevice() {
        return this.defaultDeviceId;
    }

    public CUDADevice getDevice(int deviceId) throws GPUConfigurationException {
        CUDADevice[] allDevices = this.getDevices();
        if (0 <= deviceId && deviceId < allDevices.length) {
            return allDevices[deviceId];
        }
        throw this.newGPUConfigurationException("Invalid device");
    }

    public int getDeviceCount() {
        return this.getDevices().length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CUDADevice[] getDevices() {
        CUDADevice[] allDevices = this.devices;
        if (allDevices == null) {
            Lock lock = CUDAManager.lock;
            synchronized (lock) {
                allDevices = this.devices;
                if (allDevices == null) {
                    allDevices = this.findDevices();
                    this.unsafe.putOrderedObject(this, this.devicesOffset, allDevices);
                }
            }
        }
        return allDevices;
    }

    public CUDADevice getDeviceWithMostAvailableMemory() throws GPUConfigurationException {
        CUDADevice[] allDevices = this.getDevices();
        CUDADevice bestDevice = null;
        int deviceCount = allDevices.length;
        long mostFreeMem = 0L;
        for (int deviceId = 0; deviceId < deviceCount; ++deviceId) {
            try {
                long freeMem = new CudaDevice(deviceId).getFreeMemory();
                if (mostFreeMem >= freeMem && deviceId != 0) continue;
                bestDevice = allDevices[deviceId];
                mostFreeMem = freeMem;
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return bestDevice;
    }

    public int getDoubleThreshold() {
        return this.defaultDoubleThreshold;
    }

    public CUDADevice[] getEnabledCUDADevices() {
        return (CUDADevice[])this.getDevices().clone();
    }

    public int getFloatThreshold() {
        return this.defaultFloatThreshold;
    }

    public long getFreeMemoryForDevice(int deviceId) throws GPUConfigurationException {
        if (0 <= deviceId && deviceId < this.getDeviceCount()) {
            try {
                CudaDevice device = new CudaDevice(deviceId);
                return device.getFreeMemory();
            }
            catch (Exception e) {
                throw new GPUConfigurationException(e.getLocalizedMessage(), e);
            }
        }
        throw this.newGPUConfigurationException("Invalid device");
    }

    public int getIntThreshold() {
        return this.defaultIntThreshold;
    }

    public int getLongThreshold() {
        return this.defaultLongThreshold;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNextAvailableDevice() {
        Lock lock = CUDAManager.lock;
        synchronized (lock) {
            int deviceId = this.busyDevices.nextClearBit(0);
            if (deviceId < this.getDeviceCount()) {
                this.outputIfVerbose("Device " + deviceId + " was free");
            } else {
                this.outputIfVerbose("No free devices!");
                deviceId = -1;
            }
            return deviceId;
        }
    }

    public boolean getVerboseGPUOutput() {
        return this.verboseOutput;
    }

    public boolean hasCUDASupport() {
        return this.getDeviceCount() != 0;
    }

    public boolean isSortEnabledOnGPU() {
        return this.doSortOnGPU;
    }

    public boolean isSortEnforcedOnGPU() {
        return this.enforceGPUSort;
    }

    private GPUConfigurationException newGPUConfigurationException(String message) {
        this.outputIfVerbose(message);
        return new GPUConfigurationException(CUDAManager.getOutputHeader() + ' ' + message);
    }

    void outputIfVerbose(String message) {
        if (this.verboseOutput) {
            System.out.printf("%s [time.ms=%d]: %s\n", CUDAManager.getOutputHeader(), System.currentTimeMillis(), message);
        }
    }

    public void printAllDeviceInfo() {
        CUDADevice[] allDevices = this.getDevices();
        System.out.println("Number of devices: " + allDevices.length);
        for (CUDADevice device : allDevices) {
            System.out.println(device);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseDevice(int deviceId) {
        Lock lock = CUDAManager.lock;
        synchronized (lock) {
            if (0 <= deviceId && deviceId < this.getDeviceCount()) {
                this.busyDevices.clear(deviceId);
                this.outputIfVerbose("Released device: " + deviceId);
            }
        }
    }

    public void setDefaultDevice(int deviceId) {
        this.defaultDeviceId = deviceId;
    }

    public void setDevice(int deviceId) throws GPUConfigurationException {
        if (0 > deviceId || deviceId >= this.getDeviceCount()) {
            throw this.newGPUConfigurationException("Invalid device");
        }
        this.setDefaultDevice(deviceId);
    }

    public void setVerboseGPU(boolean condition) {
        this.verboseOutput = condition;
    }

    private static enum Type {
        DOUBLE,
        FLOAT,
        INT,
        LONG;

        final String propertyPrefix = "com.ibm.gpu." + this.name() + "sortThreshold.";
    }

    private static final class Singleton {
        static final CUDAManager INSTANCE = new CUDAManager();

        private Singleton() {
        }
    }

    private static final class Lock {
        Lock() {
        }
    }

    private static final class Configuration {
        private static final String DEFAULT_MODEL_NAME = "DEFAULT";
        private static final int DEFAULT_THRESHOLD = 30000;
        private final CUDAManager manager;
        private final Map<String, Map<Type, Integer>> thresholds;

        private static void loadProperties(Properties properties, String resourceName) throws IOException {
            PrivilegedAction<InputStream> action = () -> CUDAManager.class.getResourceAsStream(resourceName);
            try (InputStream input = AccessController.doPrivileged(action);){
                if (input != null) {
                    properties.load(input);
                }
            }
        }

        private static boolean startsWithIgnoreCase(String string, String prefix) {
            int prefixLength = prefix.length();
            if (string.length() >= prefixLength) {
                return string.regionMatches(true, 0, prefix, 0, prefixLength);
            }
            return true;
        }

        Configuration(CUDAManager manager) {
            this.manager = manager;
            this.thresholds = new TreeMap<String, Map<Type, Integer>>(String.CASE_INSENSITIVE_ORDER);
            this.readThresholds();
        }

        boolean checkSortProperty(String name) {
            String value = CUDAManager.getProperty(name);
            if (value != null) {
                if (value.isEmpty() || value.equalsIgnoreCase("all") || value.equalsIgnoreCase("sort")) {
                    return true;
                }
                this.manager.outputIfVerbose(String.format("Invalid value \"%s\" given on system property %s", value, name));
            }
            return false;
        }

        private int getDefaultThreshold(Type type) {
            Integer threshold;
            Map<Type, Integer> modelMap = this.thresholds.get(DEFAULT_MODEL_NAME);
            if (modelMap != null && (threshold = modelMap.get((Object)type)) != null) {
                return threshold;
            }
            return 30000;
        }

        int getDoubleThreshold() {
            return this.getDefaultThreshold(Type.DOUBLE);
        }

        int getDoubleThreshold(String modelName) {
            return this.getThreshold(modelName, Type.DOUBLE);
        }

        int getFloatThreshold() {
            return this.getDefaultThreshold(Type.FLOAT);
        }

        int getFloatThreshold(String modelName) {
            return this.getThreshold(modelName, Type.FLOAT);
        }

        int getIntThreshold() {
            return this.getDefaultThreshold(Type.INT);
        }

        int getIntThreshold(String modelName) {
            return this.getThreshold(modelName, Type.INT);
        }

        int getLongThreshold() {
            return this.getDefaultThreshold(Type.LONG);
        }

        int getLongThreshold(String modelName) {
            return this.getThreshold(modelName, Type.LONG);
        }

        private int getThreshold(String modelName, Type type) {
            Integer threshold;
            Map<Type, Integer> modelMap = this.thresholds.get(modelName);
            if (modelMap != null && (threshold = modelMap.get((Object)type)) != null) {
                return threshold;
            }
            return this.getDefaultThreshold(type);
        }

        private void readThresholds() {
            Properties properties = new Properties();
            try {
                Configuration.loadProperties(properties, "ibm_gpu_thresholds.properties");
            }
            catch (IOException e) {
                this.manager.outputIfVerbose("Warning: couldn't load threshold properties file: " + e.getLocalizedMessage());
            }
            block4: for (Map.Entry<Object, Object> property : properties.entrySet()) {
                String propertyName = String.valueOf(property.getKey());
                for (Type type : Type.values()) {
                    String prefix = type.propertyPrefix;
                    if (!Configuration.startsWithIgnoreCase(propertyName, prefix)) continue;
                    String propertyValue = String.valueOf(property.getValue());
                    try {
                        int value = Integer.parseInt(propertyValue);
                        if (0 >= value || value >= Integer.MAX_VALUE) continue block4;
                        String model = propertyName.substring(prefix.length()).replace('_', ' ');
                        Map<Type, Integer> modelMap = this.thresholds.get(model);
                        if (modelMap == null) {
                            modelMap = new HashMap<Type, Integer>();
                            this.thresholds.put(model, modelMap);
                        }
                        modelMap.put(type, value);
                    }
                    catch (NumberFormatException e) {
                        this.manager.outputIfVerbose(String.format("Warning: ignoring non-numeric threshold: %s = %s", propertyName, propertyValue));
                    }
                    continue block4;
                }
            }
        }
    }
}

