/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.java.diagnostics.healthcenter.threads.postprocessor;

import com.ibm.java.diagnostics.common.datamodel.data.Data;
import com.ibm.java.diagnostics.common.datamodel.data.DataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.DataPointBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.StructuredStringDataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.SubsystemDataBuilder;
import com.ibm.java.diagnostics.common.datamodel.data.TwoDimensionalDataBuilder;
import com.ibm.java.diagnostics.common.datamodel.impl.data.StructuredStringDataImpl;
import com.ibm.java.diagnostics.common.datamodel.properties.OutputProperties;
import com.ibm.java.diagnostics.common.extensions.postprocessing.PostProcessor;
import com.ibm.java.diagnostics.common.util.logging.LogFactory;
import com.ibm.java.diagnostics.healthcenter.JVMLabels;
import com.ibm.java.diagnostics.healthcenter.environment.EnvironmentData;
import com.ibm.java.diagnostics.healthcenter.environment.labels.EnvironmentLabels;
import com.ibm.java.diagnostics.healthcenter.postprocessor.PostProcessorBase;
import com.ibm.java.diagnostics.healthcenter.postprocessor.VMLevelChecker;
import com.ibm.java.diagnostics.healthcenter.threads.Messages;
import com.ibm.java.diagnostics.healthcenter.threads.ThreadDataPointImpl;
import com.ibm.java.diagnostics.healthcenter.threads.ThreadLabels;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ThreadAnalyserPostProcessor
extends PostProcessorBase
implements PostProcessor {
    private static final Logger TRACE = LogFactory.getTrace(ThreadAnalyserPostProcessor.class);
    private static final String CLASS_NAME = ThreadAnalyserPostProcessor.class.getName();
    private static final String BLOCKED = "BLOCKED";
    private static final Pattern AGENT_VERSION_REGEX = Pattern.compile("(\\d+)\\.(\\d+).(\\d+).(\\d+)");
    private ArrayList<ThreadDataPointImpl> blockedThreadsList = new ArrayList();
    private ArrayList<ThreadDataPointImpl> completeThreadsList = new ArrayList();

    @Override
    public void postprocess(DataBuilder dataBuilder, OutputProperties outputProperties) {
        TRACE.entering(CLASS_NAME, "postprocess");
        SubsystemDataBuilder subsystemDataBuilder = (SubsystemDataBuilder)dataBuilder.getTopLevelData(JVMLabels.THREADS);
        if (subsystemDataBuilder != null) {
            subsystemDataBuilder.clearValue();
            subsystemDataBuilder.removeData(ThreadLabels.RECOMMENDATION_LABEL);
            StructuredStringDataImpl structuredStringDataImpl = new StructuredStringDataImpl(ThreadLabels.RECOMMENDATION_LABEL);
            this.addThreadTotal(subsystemDataBuilder, structuredStringDataImpl);
            this.showLatestThreadTime(subsystemDataBuilder, structuredStringDataImpl);
            this.checkForBlockedThreads(subsystemDataBuilder, structuredStringDataImpl);
            this.checkForVMLevelOwnedMonitors(dataBuilder, structuredStringDataImpl);
            if (!this.blockedThreadsList.isEmpty()) {
                this.findOwnersOfAllMonitors();
                this.checkForDeadlocks(structuredStringDataImpl);
            }
            this.setHighLevelMessage(subsystemDataBuilder, structuredStringDataImpl);
            this.isAppropriateAgentLevel(dataBuilder, structuredStringDataImpl);
            subsystemDataBuilder.addData(structuredStringDataImpl);
        }
        TRACE.exiting(CLASS_NAME, "postprocess");
    }

    private void addThreadTotal(SubsystemDataBuilder subsystemDataBuilder, StructuredStringDataBuilder structuredStringDataBuilder) {
        DataPointBuilder dataPointBuilder;
        Data data = subsystemDataBuilder.getData(ThreadLabels.THREAD_NUMBER);
        if (data != null && (dataPointBuilder = ((TwoDimensionalDataBuilder)data).getLastDataPoint()) != null) {
            int n = (int)dataPointBuilder.getY();
            structuredStringDataBuilder.addGoodThing(MessageFormat.format(Messages.getString("ThreadAnalyserPostProcessor.thread.total"), n));
        }
    }

    private void showLatestThreadTime(SubsystemDataBuilder subsystemDataBuilder, StructuredStringDataBuilder structuredStringDataBuilder) {
        DataPointBuilder dataPointBuilder;
        Data data = subsystemDataBuilder.getData(ThreadLabels.THREAD_NUMBER);
        if (data != null && (dataPointBuilder = ((TwoDimensionalDataBuilder)data).getLastDataPoint()) != null) {
            structuredStringDataBuilder.addInformation(MessageFormat.format(Messages.getString("Thread.time.of.thread"), dataPointBuilder.formatXWithUnits()));
        }
    }

    private void checkForBlockedThreads(SubsystemDataBuilder subsystemDataBuilder, StructuredStringDataBuilder structuredStringDataBuilder) {
        this.blockedThreadsList.clear();
        this.completeThreadsList.clear();
        Data data = subsystemDataBuilder.getData(ThreadLabels.THREADS);
        Data data2 = subsystemDataBuilder.getData(ThreadLabels.THREAD_NUMBER);
        TwoDimensionalDataBuilder twoDimensionalDataBuilder = (TwoDimensionalDataBuilder)data;
        TwoDimensionalDataBuilder twoDimensionalDataBuilder2 = (TwoDimensionalDataBuilder)data2;
        if (twoDimensionalDataBuilder != null && !twoDimensionalDataBuilder.isEmpty() && twoDimensionalDataBuilder2 != null && !twoDimensionalDataBuilder2.isEmpty()) {
            DataPointBuilder[] dataPointBuilderArray;
            double d = twoDimensionalDataBuilder2.getMaxX().getRawX();
            int n = 0;
            for (DataPointBuilder dataPointBuilder : dataPointBuilderArray = twoDimensionalDataBuilder.getDataPoints()) {
                if (dataPointBuilder.getRawX() != d) continue;
                ThreadDataPointImpl threadDataPointImpl = (ThreadDataPointImpl)dataPointBuilder;
                if (BLOCKED.equalsIgnoreCase(threadDataPointImpl.getState())) {
                    ++n;
                    this.blockedThreadsList.add(threadDataPointImpl);
                }
                this.completeThreadsList.add(threadDataPointImpl);
            }
            if (n > 0) {
                structuredStringDataBuilder.addInformation(MessageFormat.format(Messages.getString("ThreadAnalyserPostProcessor.threads.blocked"), n));
            }
        }
    }

    private void checkForDeadlocks(StructuredStringDataBuilder structuredStringDataBuilder) {
        Iterator<ThreadDataPointImpl> iterator = this.blockedThreadsList.iterator();
        ArrayList<ThreadDataPointImpl> arrayList = new ArrayList<ThreadDataPointImpl>();
        while (iterator.hasNext()) {
            ArrayList<ThreadDataPointImpl> arrayList2;
            boolean bl;
            ThreadDataPointImpl threadDataPointImpl = iterator.next();
            if (arrayList.contains(threadDataPointImpl) || !(bl = this.walkThreadTree(arrayList2 = new ArrayList<ThreadDataPointImpl>(), threadDataPointImpl))) continue;
            for (ThreadDataPointImpl threadDataPointImpl2 : arrayList2) {
                arrayList.add(threadDataPointImpl2);
                structuredStringDataBuilder.addProblem(MessageFormat.format(Messages.getString("ThreadAnalyserPostProcessor.deadlock.detected"), threadDataPointImpl2.getComment(), threadDataPointImpl2.getContendedMonitor(), threadDataPointImpl2.getContendedMonitorOwner()));
            }
        }
    }

    private boolean walkThreadTree(ArrayList<ThreadDataPointImpl> arrayList, ThreadDataPointImpl threadDataPointImpl) {
        ThreadDataPointImpl threadDataPointImpl2 = this.findMonitorOwner(threadDataPointImpl, this.blockedThreadsList);
        if (threadDataPointImpl2 != null) {
            if (threadDataPointImpl.getComment().equals(threadDataPointImpl2.getComment())) {
                return false;
            }
            if (arrayList.contains(threadDataPointImpl2)) {
                return true;
            }
            threadDataPointImpl.setContendedMonitorOwner(threadDataPointImpl2.getComment());
            arrayList.add(threadDataPointImpl2);
            return this.walkThreadTree(arrayList, threadDataPointImpl2);
        }
        return false;
    }

    private void findOwnersOfAllMonitors() {
        for (ThreadDataPointImpl threadDataPointImpl : this.completeThreadsList) {
            ThreadDataPointImpl threadDataPointImpl2;
            if (threadDataPointImpl.getContendedMonitor() == null || (threadDataPointImpl2 = this.findMonitorOwner(threadDataPointImpl, this.completeThreadsList)) == null) continue;
            threadDataPointImpl.setContendedMonitorOwner(threadDataPointImpl2.getComment());
        }
    }

    private ThreadDataPointImpl findMonitorOwner(ThreadDataPointImpl threadDataPointImpl, ArrayList<ThreadDataPointImpl> arrayList) {
        for (ThreadDataPointImpl threadDataPointImpl2 : arrayList) {
            DataPointBuilder[] dataPointBuilderArray;
            TwoDimensionalDataBuilder twoDimensionalDataBuilder = threadDataPointImpl2.getMonitors();
            if (twoDimensionalDataBuilder == null) continue;
            for (DataPointBuilder dataPointBuilder : dataPointBuilderArray = twoDimensionalDataBuilder.getDataPoints()) {
                if (!dataPointBuilder.getComment().equals(threadDataPointImpl.getContendedMonitor())) continue;
                return threadDataPointImpl2;
            }
        }
        return null;
    }

    private void checkForVMLevelOwnedMonitors(DataBuilder dataBuilder, StructuredStringDataBuilder structuredStringDataBuilder) {
        EnvironmentData environmentData;
        VMLevelChecker vMLevelChecker;
        DataBuilder dataBuilder2 = dataBuilder.getTopLevelData(EnvironmentLabels.ENVIRONMENT_LABEL);
        if (dataBuilder2 instanceof EnvironmentData && (vMLevelChecker = (environmentData = (EnvironmentData)((Object)dataBuilder2)).getVMLevelChecker()) != null && vMLevelChecker.isJava5()) {
            structuredStringDataBuilder.addWarning(Messages.getString("ThreadAnalyserPostProcessor.ownedMonitors.unavailable"));
        }
    }

    private void isAppropriateAgentLevel(DataBuilder dataBuilder, StructuredStringDataBuilder structuredStringDataBuilder) {
        String string;
        Matcher matcher;
        DataBuilder dataBuilder2 = dataBuilder.getTopLevelData(EnvironmentLabels.ENVIRONMENT_LABEL);
        if (!(dataBuilder2 instanceof EnvironmentData)) {
            return;
        }
        EnvironmentData environmentData = (EnvironmentData)((Object)dataBuilder2);
        if (environmentData != null && (matcher = AGENT_VERSION_REGEX.matcher(string = environmentData.getAgentVersion())).matches() && matcher.groupCount() == 4) {
            int n = -1;
            int n2 = -1;
            try {
                n = Integer.valueOf(matcher.group(1));
                n2 = Integer.valueOf(matcher.group(2));
            }
            catch (NumberFormatException numberFormatException) {
                TRACE.log(Level.WARNING, numberFormatException.getLocalizedMessage(), numberFormatException);
            }
            if (n < 2 || n == 2 && n2 < 2) {
                structuredStringDataBuilder.addInformation(Messages.getString("ThreadAnalyserPostProcessor.old.agent"));
            }
        }
    }
}

