/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.ibmjcehybrid.provider.safkeyring;

import com.ibm.crypto.ibmjcehybrid.provider.HybridRACFInputStream;
import com.ibm.crypto.ibmjcehybrid.provider.HybridRACFOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;

class SAFKeyRingURLConnection
extends URLConnection {
    String userid = null;
    String ringid = null;

    public SAFKeyRingURLConnection(URL u) {
        super(u);
        this.userid = u.getHost();
        this.ringid = u.getFile().substring(1);
    }

    @Override
    public void connect() throws IOException {
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this.userid == null) {
            throw new IOException("RACF userid was not specified");
        }
        if (this.ringid == null) {
            throw new IOException("RACF ringid was not specified");
        }
        return new HybridRACFInputStream(this.userid, this.ringid, null);
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        if (this.userid == null) {
            throw new IOException("RACF userid was not specified");
        }
        if (this.ringid == null) {
            throw new IOException("RACF ringid was not specified");
        }
        return new HybridRACFOutputStream(this.userid, this.ringid, null);
    }
}

