/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.ibmjcehybrid.provider;

import com.ibm.crypto.ibmjcehybrid.provider.AlgorithmTable;
import com.ibm.crypto.ibmjcehybrid.provider.HybridRACFPrivateKey;
import com.ibm.crypto.ibmjcehybrid.provider.IBMJCEHybridException;
import com.ibm.crypto.ibmjcehybrid.provider.TableObject;
import com.ibm.misc.Debug;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.SignatureSpi;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Vector;

abstract class HybridSignature
extends SignatureSpi {
    private Signature theSignature = null;
    private static final String serviceType = "Signature";
    private String algorithm;
    private String theProvider = null;
    private PrivateKey privateKey = null;
    private PublicKey publicKey = null;
    private String mostRecentInitCalled = "None";
    private final String init_sign = "initSign";
    private final String init_verify = "initVerify";
    private int blockSize = -2;
    private boolean blocking_active = false;
    private boolean blocking_limited = true;
    private int data_bytes_saved = 0;
    private Vector dataSegList;
    private boolean tableObjectReset = false;
    private boolean failoverPossible = true;
    private Vector<Exception> ExceptionHistory = new Vector();
    static Debug debug = Debug.getInstance((String)"ibmjcehybrid");
    private static final String hybridClassName = "com.ibm.crypto.ibmjcehybrid.provider.HybridSignature";

    public HybridSignature(String algorithm, int block_size) {
        if (debug != null) {
            debug.entry(16384L, (Object)hybridClassName, "HybridSignature", (Object)algorithm, (Object)block_size);
        }
        this.algorithm = algorithm;
        this.blockSize = block_size;
        if (-2 >= this.blockSize) {
            this.blockSize = 0;
        }
        if (0 == this.blockSize) {
            this.blocking_active = false;
        } else {
            this.blocking_active = true;
            this.blocking_limited = -1 != this.blockSize;
            this.dataSegList = new Vector();
            this.turn_on_data_blocking();
        }
        this.tableObjectReset = false;
        AlgorithmTable algTbl = new AlgorithmTable();
        if (null == algTbl) {
            String rteMessage = new String("Internal error in AlgorithmTable class.");
            RuntimeException rte = new RuntimeException(rteMessage);
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "HybridSignature", rteMessage);
                debug.exception(16384L, (Object)hybridClassName, "HybridSignature", (Throwable)rte);
                debug.exit(16384L, (Object)hybridClassName, "HybridSignature");
            }
            throw new RuntimeException(rte);
        }
        try {
            this.getSignature();
        }
        catch (Exception ex) {
            IBMJCEHybridException ijhe;
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "HybridSignature", ex.getMessage());
                debug.exception(16384L, (Object)hybridClassName, "HybridSignature", (Throwable)ex);
            }
            if (ex instanceof IBMJCEHybridException) {
                ijhe = (IBMJCEHybridException)ex;
            } else {
                this.ExceptionHistory.addElement(ex);
                ijhe = new IBMJCEHybridException(null, this.ExceptionHistory);
            }
            String rteMessage = new String("No provider found for Signature " + this.algorithm);
            RuntimeException rte = new RuntimeException(rteMessage, ijhe);
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "HybridSignature", rteMessage);
                debug.exception(16384L, (Object)hybridClassName, "HybridSignature", (Throwable)rte);
                debug.exit(16384L, (Object)hybridClassName, "HybridSignature");
            }
            throw new RuntimeException(rte);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "HybridSignature");
        }
    }

    @Override
    @Deprecated
    protected void engineSetParameter(String key, Object param) throws UnsupportedOperationException {
        if (debug != null) {
            Object[] parms = new Object[]{key, param};
            debug.entry(16384L, (Object)hybridClassName, "engineSetParameter", parms);
        }
        this.setParameter(key, param, true);
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "engineSetParameter");
        }
    }

    private void setParameter(String key, Object param, boolean isExternalCall) throws UnsupportedOperationException {
        if (debug != null) {
            Object[] parms = new Object[]{key, param, new Boolean(isExternalCall)};
            debug.entry(16384L, (Object)hybridClassName, "setParameter", parms);
        }
        if (isExternalCall) {
            this.tableObjectReset = false;
            this.ExceptionHistory = new Vector();
        }
        try {
            this.theSignature.setParameter(key, param);
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "setParameter", "Successful call to setParameter(key,param) in provider: " + this.theProvider);
            }
            this.ExceptionHistory = new Vector();
            if (this.blocking_active) {
                this.turn_off_data_blocking();
            }
            this.failoverPossible = false;
        }
        catch (IBMJCEHybridException ijhe) {
            throw ijhe;
        }
        catch (Exception ex) {
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "setParameter", ex.getMessage());
                debug.exception(16384L, (Object)hybridClassName, "setParameter", (Throwable)ex);
            }
            this.ExceptionHistory.addElement(ex);
            if (this.failoverPossible) {
                if (debug != null) {
                    debug.text(16384L, (Object)hybridClassName, "setParameter", "Attempting failover to another provider for " + this.algorithm);
                }
                this.getSignature();
                this.setParameter(key, param, false);
            }
            String ijheMsg = "Object state does not permit failover.";
            IBMJCEHybridException ijhe = new IBMJCEHybridException(ijheMsg, this.ExceptionHistory);
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "setParameter", ijheMsg);
                debug.exception(16384L, (Object)hybridClassName, "setParameter", (Throwable)ijhe);
                debug.exit(16384L, (Object)hybridClassName, "setParameter");
            }
            throw ijhe;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "setParameter");
        }
    }

    @Override
    protected void engineSetParameter(AlgorithmParameterSpec parmSpec) throws InvalidAlgorithmParameterException {
        if (debug != null) {
            Object[] parms = new Object[]{parmSpec};
            debug.entry(16384L, (Object)hybridClassName, "engineSetParameter", parms);
        }
        this.setParameter(parmSpec, true);
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "engineSetParameter");
        }
    }

    private void setParameter(AlgorithmParameterSpec parmSpec, boolean isExternalCall) throws InvalidAlgorithmParameterException {
        if (debug != null) {
            Object[] parms = new Object[]{parmSpec, new Boolean(isExternalCall)};
            debug.entry(16384L, (Object)hybridClassName, "setParameter", parms);
        }
        if (isExternalCall) {
            this.tableObjectReset = false;
            this.ExceptionHistory = new Vector();
        }
        try {
            this.theSignature.setParameter(parmSpec);
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "setParameter", "Successful call to setParameter(key,param) in provider: " + this.theProvider);
            }
            this.ExceptionHistory = new Vector();
            if (this.blocking_active) {
                this.turn_off_data_blocking();
            }
            this.failoverPossible = false;
        }
        catch (IBMJCEHybridException ijhe) {
            throw ijhe;
        }
        catch (Exception ex) {
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "setParameter", ex.getMessage());
                debug.exception(16384L, (Object)hybridClassName, "setParameter", (Throwable)ex);
            }
            this.ExceptionHistory.addElement(ex);
            if (this.failoverPossible) {
                if (debug != null) {
                    debug.text(16384L, (Object)hybridClassName, "setParameter", "Attempting failover to another provider for " + this.algorithm);
                }
                this.getSignature();
                this.setParameter(parmSpec, false);
            }
            String ijheMsg = "Object state does not permit failover.";
            IBMJCEHybridException ijhe = new IBMJCEHybridException(ijheMsg, this.ExceptionHistory);
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "setParameter", ijheMsg);
                debug.exception(16384L, (Object)hybridClassName, "setParameter", (Throwable)ijhe);
                debug.exit(16384L, (Object)hybridClassName, "setParameter");
            }
            throw ijhe;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "setParameter");
        }
    }

    @Override
    @Deprecated
    protected Object engineGetParameter(String key) throws UnsupportedOperationException {
        Object result = null;
        if (debug != null) {
            debug.entry(16384L, (Object)hybridClassName, "engineGetParameter", (Object)key);
        }
        result = this.getParameter(key, true);
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "engineGetParameter");
        }
        return result;
    }

    private Object getParameter(String key, boolean isExternalCall) throws UnsupportedOperationException {
        Object result = null;
        if (debug != null) {
            debug.entry(16384L, (Object)hybridClassName, "getParameter", (Object)key, (Object)new Boolean(isExternalCall));
        }
        if (isExternalCall) {
            this.tableObjectReset = false;
            this.ExceptionHistory = new Vector();
        }
        try {
            result = this.theSignature.getParameter(key);
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "getParameter", "Successful call to getParameter(key) in provider: " + this.theProvider);
            }
            this.ExceptionHistory = new Vector();
        }
        catch (IBMJCEHybridException ijhe) {
            throw ijhe;
        }
        catch (Exception ex) {
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "getParameter", ex.getMessage());
                debug.exception(16384L, (Object)hybridClassName, "getParameter", (Throwable)ex);
            }
            this.ExceptionHistory.addElement(ex);
            if (this.failoverPossible) {
                if (debug != null) {
                    debug.text(16384L, (Object)hybridClassName, "getParameter", "Attempting failover to another provider for " + this.algorithm);
                }
                this.getSignature();
                this.getParameter(key, false);
            }
            String ijheMsg = "Object state does not permit failover.";
            IBMJCEHybridException ijhe = new IBMJCEHybridException(ijheMsg, this.ExceptionHistory);
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "getParameter", ijheMsg);
                debug.exception(16384L, (Object)hybridClassName, "getParameter", (Throwable)ijhe);
                debug.exit(16384L, (Object)hybridClassName, "getParameter");
            }
            throw ijhe;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "getParameter");
        }
        return result;
    }

    @Override
    protected AlgorithmParameters engineGetParameters() throws UnsupportedOperationException {
        AlgorithmParameters result = null;
        if (debug != null) {
            debug.entry(16384L, (Object)hybridClassName, "engineGetParameters");
        }
        result = this.getParameters(true);
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "engineGetParameters");
        }
        return result;
    }

    private AlgorithmParameters getParameters(boolean isExternalCall) throws UnsupportedOperationException {
        AlgorithmParameters result = null;
        if (debug != null) {
            debug.entry(16384L, (Object)hybridClassName, "getParameters", (Object)new Boolean(isExternalCall));
        }
        if (isExternalCall) {
            this.tableObjectReset = false;
            this.ExceptionHistory = new Vector();
        }
        try {
            result = this.theSignature.getParameters();
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "getParameters", "Successful call to getParameters() in provider: " + this.theProvider);
            }
            this.ExceptionHistory = new Vector();
        }
        catch (IBMJCEHybridException ijhe) {
            throw ijhe;
        }
        catch (Exception ex) {
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "getParameters", ex.getMessage());
                debug.exception(16384L, (Object)hybridClassName, "getParameters", (Throwable)ex);
            }
            this.ExceptionHistory.addElement(ex);
            if (this.failoverPossible) {
                if (debug != null) {
                    debug.text(16384L, (Object)hybridClassName, "getParameters", "Attempting failover to another provider for " + this.algorithm);
                }
                this.getSignature();
                this.getParameters(false);
            }
            String ijheMsg = "Object state does not permit failover.";
            IBMJCEHybridException ijhe = new IBMJCEHybridException(ijheMsg, this.ExceptionHistory);
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "getParameters", ijheMsg);
                debug.exception(16384L, (Object)hybridClassName, "getParameters", (Throwable)ijhe);
                debug.exit(16384L, (Object)hybridClassName, "getParameters");
            }
            throw ijhe;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "getParameters");
        }
        return result;
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        if (debug != null) {
            debug.entry(16384L, (Object)hybridClassName, "engineInitSign", (Object)privateKey);
        }
        this.initSign(privateKey, true);
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "engineInitSign");
        }
    }

    private void initSign(PrivateKey privKey, boolean isExternalCall) throws InvalidKeyException {
        if (debug != null) {
            debug.entry(16384L, (Object)hybridClassName, "initSign", (Object)privKey, (Object)new Boolean(isExternalCall));
        }
        if (isExternalCall) {
            this.tableObjectReset = false;
            this.ExceptionHistory = new Vector();
            if (0 != this.blockSize) {
                this.turn_on_data_blocking();
            }
        }
        this.privateKey = privKey;
        this.mostRecentInitCalled = "initSign";
        try {
            if (privKey instanceof HybridRACFPrivateKey) {
                PrivateKey unwraveledKey;
                if (debug != null) {
                    debug.text(16384L, (Object)hybridClassName, "initSign", "HybridRACFPrivateKey found. Need to unwravel the key for use with underlying provider.");
                }
                privKey = unwraveledKey = this.unwravelKey((HybridRACFPrivateKey)privKey);
            }
            this.theSignature.initSign(privKey);
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "initSign", "Successful call to initSign(privateKey) in provider: " + this.theProvider);
            }
            this.ExceptionHistory = new Vector();
            this.failoverPossible = true;
        }
        catch (IBMJCEHybridException ijhe) {
            throw ijhe;
        }
        catch (Exception ex) {
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "initSign", ex.getMessage());
                debug.exception(16384L, (Object)hybridClassName, "initSign", (Throwable)ex);
            }
            this.ExceptionHistory.addElement(ex);
            if (this.failoverPossible) {
                if (debug != null) {
                    debug.text(16384L, (Object)hybridClassName, "initSign", "Attempting failover to another provider for " + this.algorithm);
                }
                this.getSignature();
                this.initSign(this.privateKey, false);
            }
            String ijheMsg = "Object state does not permit failover.";
            IBMJCEHybridException ijhe = new IBMJCEHybridException(ijheMsg, this.ExceptionHistory);
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "initSign", ijheMsg);
                debug.exception(16384L, (Object)hybridClassName, "initSign", (Throwable)ijhe);
                debug.exit(16384L, (Object)hybridClassName, "initSign");
            }
            throw ijhe;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "initSign");
        }
    }

    @Override
    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        if (debug != null) {
            debug.entry(16384L, (Object)hybridClassName, "engineInitVerify", (Object)publicKey);
        }
        this.initVerify(publicKey, true);
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "engineInitVerify");
        }
    }

    private void initVerify(PublicKey publicKey, boolean isExternalCall) throws InvalidKeyException {
        if (debug != null) {
            debug.entry(16384L, (Object)hybridClassName, "initVerify", (Object)publicKey, (Object)new Boolean(isExternalCall));
        }
        if (isExternalCall) {
            this.tableObjectReset = false;
            this.ExceptionHistory = new Vector();
            if (0 != this.blockSize) {
                this.turn_on_data_blocking();
            }
        }
        this.publicKey = publicKey;
        this.mostRecentInitCalled = "initVerify";
        try {
            this.theSignature.initVerify(publicKey);
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "initVerify", "Successful call to initVerify(publicKey) in provider: " + this.theProvider);
            }
            this.ExceptionHistory = new Vector();
            this.failoverPossible = true;
        }
        catch (IBMJCEHybridException ijhe) {
            throw ijhe;
        }
        catch (Exception ex) {
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "initVerify", ex.getMessage());
                debug.exception(16384L, (Object)hybridClassName, "initVerify", (Throwable)ex);
            }
            this.ExceptionHistory.addElement(ex);
            if (this.failoverPossible) {
                if (debug != null) {
                    debug.text(16384L, (Object)hybridClassName, "initVerify", "Attempting failover to another provider for " + this.algorithm);
                }
                this.getSignature();
                this.initVerify(publicKey, false);
            }
            String ijheMsg = "Object state does not permit failover.";
            IBMJCEHybridException ijhe = new IBMJCEHybridException(ijheMsg, this.ExceptionHistory);
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "initVerify", ijheMsg);
                debug.exception(16384L, (Object)hybridClassName, "initVerify", (Throwable)ijhe);
                debug.exit(16384L, (Object)hybridClassName, "initVerify");
            }
            throw ijhe;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "initVerify");
        }
    }

    @Override
    protected void engineUpdate(byte b) {
        if (debug != null) {
            debug.entry(16384L, (Object)hybridClassName, "engineUpdate", (Object)new Byte(b));
        }
        byte[] input = new byte[]{b};
        this.engineUpdate(input, 0, 1);
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "engineUpdate");
        }
    }

    protected void engineUpdate(byte[] data) {
        if (debug != null) {
            Object[] parms = new Object[]{data};
            debug.entry(16384L, (Object)hybridClassName, "engineUpdate", parms);
        }
        this.engineUpdate(data, 0, data.length);
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "engineUpdate");
        }
    }

    @Override
    protected void engineUpdate(byte[] data, int off, int len) {
        if (debug != null) {
            Object[] parms = new Object[]{data, new Integer(off), new Integer(len)};
            debug.entry(16384L, (Object)hybridClassName, "engineUpdate", parms);
        }
        this.update(data, off, len, true);
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "engineUpdate");
        }
    }

    private void update(byte[] data, int off, int len, boolean isExternalCall) {
        if (debug != null) {
            Object[] parms = new Object[]{data, new Integer(off), new Integer(len), new Boolean(isExternalCall)};
            debug.entry(16384L, (Object)hybridClassName, "update", parms);
        }
        if (isExternalCall) {
            this.tableObjectReset = false;
            this.ExceptionHistory = new Vector();
            if (this.blocking_active) {
                byte[] data_seg = new byte[len];
                System.arraycopy(data, off, data_seg, 0, len);
                this.dataSegList.addElement(data_seg);
                this.data_bytes_saved += len;
            }
        }
        try {
            this.theSignature.update(data, off, len);
            if (debug != null) {
                String msg = null;
                msg = this.blocking_active ? (this.blocking_limited ? new String("Successful call to update(bytes,offset,len) in provider: " + this.theProvider + "\n\tBlocking is active.  Data caching is limited.  blocksize = " + this.blockSize + ".  Bytes passed since last reset = " + this.data_bytes_saved) : new String("Successful call to update(bytes,offset,len) in provider: " + this.theProvider + "\n\tBlocking is active.  Data caching is not limited.  blocksize = " + this.blockSize + ".  Bytes passed since last reset = " + this.data_bytes_saved)) : new String("Successful call to update(bytes,offset,len) in provider: " + this.theProvider + "\n\tBlocking is not active.");
                debug.text(16384L, (Object)hybridClassName, "update", msg);
            }
            this.ExceptionHistory = new Vector();
            if (this.blocking_active) {
                if (this.blocking_limited && this.blockSize <= this.data_bytes_saved && isExternalCall) {
                    if (debug != null) {
                        debug.text(16384L, (Object)hybridClassName, "update", "Beginning replay of " + this.blocking_limited + " blocking_limited & " + this.blockSize + " blockSize.");
                    }
                    this.turn_off_data_blocking();
                    this.failoverPossible = false;
                }
            } else {
                if (debug != null) {
                    debug.text(16384L, (Object)hybridClassName, "update", "This " + this.blockSize + " has failed and the fail-over is not possible. ");
                }
                this.failoverPossible = false;
            }
        }
        catch (IBMJCEHybridException ijhe) {
            throw ijhe;
        }
        catch (Exception ex) {
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "update", ex.getMessage());
                debug.exception(16384L, (Object)hybridClassName, "update", (Throwable)ex);
            }
            this.ExceptionHistory.addElement(ex);
            if (this.failoverPossible) {
                if (debug != null) {
                    debug.text(16384L, (Object)hybridClassName, "update", "Attempting failover to another provider for " + this.algorithm);
                }
                this.getSignature();
                try {
                    if (this.mostRecentInitCalled.equals("initVerify")) {
                        if (null != this.privateKey) {
                            this.initSign(this.privateKey, false);
                        }
                        if (null != this.publicKey) {
                            this.initVerify(this.publicKey, false);
                        }
                    } else {
                        if (null != this.publicKey) {
                            this.initVerify(this.publicKey, false);
                        }
                        if (null != this.privateKey) {
                            this.initSign(this.privateKey, false);
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.blocking_active) {
                    int data_seg_count = this.dataSegList.size();
                    if (debug != null) {
                        debug.text(16384L, (Object)hybridClassName, "update", "Beginning replay of " + data_seg_count + " data[] segments.");
                    }
                    byte[] seg = null;
                    for (int idx = 0; idx < data_seg_count; ++idx) {
                        seg = (byte[])this.dataSegList.get(idx);
                        this.update(seg, 0, seg.length, false);
                    }
                    if (debug != null) {
                        debug.text(16384L, (Object)hybridClassName, "update", "Completed replay of " + data_seg_count + " data[] segments.");
                    }
                } else {
                    this.update(data, off, len, false);
                }
            }
            String ijheMsg = "Object state does not permit failover.";
            IBMJCEHybridException ijhe = new IBMJCEHybridException(ijheMsg, this.ExceptionHistory);
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "update", ijheMsg);
                debug.exception(16384L, (Object)hybridClassName, "update", (Throwable)ijhe);
                debug.exit(16384L, (Object)hybridClassName, "update");
            }
            throw ijhe;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "update");
        }
    }

    @Override
    protected byte[] engineSign() throws SignatureException {
        if (debug != null) {
            debug.entry(16384L, (Object)hybridClassName, "engineSign");
        }
        byte[] result = this.sign(true);
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "engineSign", (Object)result);
        }
        return result;
    }

    private byte[] sign(boolean isExternalCall) throws SignatureException {
        byte[] result;
        if (debug != null) {
            debug.entry(16384L, (Object)hybridClassName, "sign");
        }
        if (isExternalCall) {
            this.tableObjectReset = false;
            this.ExceptionHistory = new Vector();
        }
        try {
            result = this.theSignature.sign();
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "sign", "Successful call to sign() in provider: " + this.theProvider);
            }
            this.ExceptionHistory = new Vector();
            if (0 != this.blockSize) {
                this.turn_on_data_blocking();
            }
            this.failoverPossible = true;
        }
        catch (IBMJCEHybridException ijhe) {
            throw ijhe;
        }
        catch (Exception ex) {
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "sign", ex.getMessage());
                debug.exception(16384L, (Object)hybridClassName, "sign", (Throwable)ex);
            }
            this.ExceptionHistory.addElement(ex);
            if (this.failoverPossible) {
                if (debug != null) {
                    debug.text(16384L, (Object)hybridClassName, "sign", "Attempting failover to another provider for " + this.algorithm);
                }
                this.getSignature();
                try {
                    if (null != this.publicKey) {
                        this.initVerify(this.publicKey, false);
                    }
                    if (null != this.privateKey) {
                        this.initSign(this.privateKey, false);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.blocking_active && 0 < this.data_bytes_saved) {
                    int data_seg_count = this.dataSegList.size();
                    if (debug != null) {
                        debug.text(16384L, (Object)hybridClassName, "sign", "Beginning replay of " + data_seg_count + " data[] segments.");
                    }
                    byte[] seg = null;
                    for (int idx = 0; idx < data_seg_count; ++idx) {
                        seg = (byte[])this.dataSegList.get(idx);
                        this.update(seg, 0, seg.length, false);
                    }
                    if (debug != null) {
                        debug.text(16384L, (Object)hybridClassName, "sign", "Completed replay of " + data_seg_count + " data[] segments.");
                    }
                }
                return this.sign(false);
            }
            String ijheMsg = "Object state does not permit failover.";
            IBMJCEHybridException ijhe = new IBMJCEHybridException(ijheMsg, this.ExceptionHistory);
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "sign", ijheMsg);
                debug.exception(16384L, (Object)hybridClassName, "sign", (Throwable)ijhe);
                debug.exit(16384L, (Object)hybridClassName, "sign");
            }
            throw ijhe;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "sign", (Object)result);
        }
        return result;
    }

    @Override
    protected boolean engineVerify(byte[] signature) throws SignatureException {
        boolean result = false;
        if (debug != null) {
            debug.entry(16384L, (Object)hybridClassName, "engineVerify", (Object)signature);
        }
        result = this.verify(signature, 0, signature.length, true);
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "engineVerify", (Object)new Boolean(result));
        }
        return result;
    }

    @Override
    protected boolean engineVerify(byte[] signature, int off, int len) throws SignatureException {
        boolean result = false;
        if (debug != null) {
            debug.entry(16384L, (Object)hybridClassName, "engineVerify", (Object)signature);
        }
        result = this.verify(signature, off, len, true);
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "engineVerify", (Object)new Boolean(result));
        }
        return result;
    }

    private boolean verify(byte[] signature, int off, int len, boolean isExternalCall) throws SignatureException {
        boolean result = false;
        if (debug != null) {
            debug.entry(16384L, (Object)hybridClassName, "verify", (Object)signature);
        }
        if (isExternalCall) {
            this.tableObjectReset = false;
            this.ExceptionHistory = new Vector();
        }
        try {
            result = this.theSignature.verify(signature, off, len);
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "verify", "Successful call to verify() in provider: " + this.theProvider);
            }
            this.ExceptionHistory = new Vector();
            if (0 != this.blockSize) {
                this.turn_on_data_blocking();
            }
            this.failoverPossible = true;
        }
        catch (IBMJCEHybridException ijhe) {
            throw ijhe;
        }
        catch (Exception ex) {
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "verify", ex.getMessage());
                debug.exception(16384L, (Object)hybridClassName, "verify", (Throwable)ex);
            }
            this.ExceptionHistory.addElement(ex);
            if (this.failoverPossible) {
                if (debug != null) {
                    debug.text(16384L, (Object)hybridClassName, "verify", "Attempting failover to another provider for " + this.algorithm);
                }
                this.getSignature();
                try {
                    if (null != this.privateKey) {
                        this.initSign(this.privateKey, false);
                    }
                    if (null != this.publicKey) {
                        this.initVerify(this.publicKey, false);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (this.blocking_active) {
                    int data_seg_count = this.dataSegList.size();
                    if (debug != null) {
                        debug.text(16384L, (Object)hybridClassName, "verify", "Beginning replay of " + data_seg_count + " data[] segments.");
                    }
                    byte[] seg = null;
                    for (int idx = 0; idx < data_seg_count; ++idx) {
                        seg = (byte[])this.dataSegList.get(idx);
                        this.update(seg, 0, seg.length, false);
                    }
                    if (debug != null) {
                        debug.text(16384L, (Object)hybridClassName, "verify", "Completed replay of " + data_seg_count + " data[] segments.");
                    }
                }
                return this.verify(signature, off, len, false);
            }
            String ijheMsg = "Object state does not permit failover.";
            IBMJCEHybridException ijhe = new IBMJCEHybridException(ijheMsg, this.ExceptionHistory);
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "verify", ijheMsg);
                debug.exception(16384L, (Object)hybridClassName, "verify", (Throwable)ijhe);
                debug.exit(16384L, (Object)hybridClassName, "verify");
            }
            throw ijhe;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "verify", (Object)new Boolean(result));
        }
        return result;
    }

    private void turn_on_data_blocking() {
        this.blocking_active = true;
        this.blocking_limited = -1 != this.blockSize;
        int data_seg_count = this.dataSegList.size();
        byte[] seg = null;
        for (int idx = data_seg_count - 1; idx >= 0; --idx) {
            seg = (byte[])this.dataSegList.get(idx);
            this.dataSegList.remove(idx);
            seg = null;
        }
        this.data_bytes_saved = 0;
        this.dataSegList.clear();
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "turn_on_data_blocking", (Object)("blockSize = " + this.blockSize + "  blocking_limited = " + this.blocking_limited));
        }
    }

    private void turn_off_data_blocking() {
        this.blocking_active = false;
        int data_seg_count = this.dataSegList.size();
        byte[] seg = null;
        for (int idx = data_seg_count - 1; idx >= 0; --idx) {
            seg = (byte[])this.dataSegList.get(idx);
            this.dataSegList.remove(idx);
            seg = null;
        }
        this.data_bytes_saved = 0;
        this.dataSegList.clear();
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "turn_off_data_blocking", (Object)("blockSize = " + this.blockSize + "  blocking_limited = " + this.blocking_limited));
        }
    }

    protected void getSignature() {
        if (debug != null) {
            debug.entry(16384L, (Object)hybridClassName, "getSignature");
        }
        if (null != this.theSignature) {
            TableObject tblObj = AlgorithmTable.getStateData(serviceType, this.algorithm);
            tblObj.invalidateProvider(this.theSignature.getProvider().getName());
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "getSignature", "Calling tblObj.invalidateProvider( " + this.theProvider + " ) for " + serviceType + " " + this.algorithm);
            }
        }
        try {
            this.theSignature = this.getBestInstance();
        }
        catch (IBMJCEHybridException ijhe) {
            throw ijhe;
        }
        catch (Exception ex) {
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "getSignature", ex.getMessage());
                debug.exception(16384L, (Object)hybridClassName, "getSignature", (Throwable)ex);
            }
            this.ExceptionHistory.addElement(ex);
            String ijheMsg = "Failover exhausted, all registered providers attempted and failed.";
            IBMJCEHybridException ijhe = new IBMJCEHybridException(ijheMsg, this.ExceptionHistory);
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "getSignature", ijheMsg);
                debug.exception(16384L, (Object)hybridClassName, "getSignature", (Throwable)ijhe);
                debug.exit(16384L, (Object)hybridClassName, "getSignature");
            }
            throw ijhe;
        }
        if (null != this.privateKey) {
            try {
                this.initSign(this.privateKey, false);
            }
            catch (IBMJCEHybridException ijhe) {
                throw ijhe;
            }
            catch (Exception ex) {
                this.ExceptionHistory.addElement(ex);
                String ijheMsg = "Failover exhausted, all registered providers attempted and failed.";
                IBMJCEHybridException ijhe = new IBMJCEHybridException(ijheMsg, this.ExceptionHistory);
                if (debug != null) {
                    debug.exception(16384L, (Object)hybridClassName, "getSignature", (Throwable)ijhe);
                    debug.text(16384L, (Object)hybridClassName, "getSignature", ijheMsg);
                    debug.exit(16384L, (Object)hybridClassName, "getSignature");
                }
                throw ijhe;
            }
        }
        if (null != this.publicKey) {
            try {
                this.initVerify(this.publicKey, false);
            }
            catch (IBMJCEHybridException ijhe) {
                throw ijhe;
            }
            catch (Exception ex) {
                this.ExceptionHistory.addElement(ex);
                String ijheMsg = "Failover exhausted, all registered providers attempted and failed.";
                IBMJCEHybridException ijhe = new IBMJCEHybridException(ijheMsg, this.ExceptionHistory);
                if (debug != null) {
                    debug.exception(16384L, (Object)hybridClassName, "getSignature", (Throwable)ijhe);
                    debug.text(16384L, (Object)hybridClassName, "getSignature", ijheMsg);
                    debug.exit(16384L, (Object)hybridClassName, "getSignature");
                }
                throw ijhe;
            }
        }
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "getSignature");
        }
    }

    private Signature getBestInstance() {
        TableObject tblObj = null;
        if (debug != null) {
            debug.entry(16384L, (Object)hybridClassName, "getBestInstance", (Object)this.algorithm);
        }
        if (null == (tblObj = AlgorithmTable.getStateData(serviceType, this.algorithm))) {
            String ijheMessage = new String("Signature." + this.algorithm + " not found as a registered algorithm");
            IBMJCEHybridException ijhe = new IBMJCEHybridException(ijheMessage, this.ExceptionHistory);
            if (debug != null) {
                debug.exception(16384L, (Object)hybridClassName, "getBestInstance", (Throwable)ijhe);
                debug.text(16384L, (Object)hybridClassName, "getBestInstance", ijheMessage);
                debug.exit(16384L, (Object)hybridClassName, "getBestInstance");
            }
            throw ijhe;
        }
        this.theProvider = tblObj.getBestProvider();
        this.theSignature = null;
        boolean notDone = true;
        while (notDone) {
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "getBestInstance", "Top of loop 1");
            }
            while (null == this.theSignature && null != this.theProvider) {
                if (debug != null) {
                    debug.text(16384L, (Object)hybridClassName, "getBestInstance", "Top of loop 2");
                }
                try {
                    this.theSignature = Signature.getInstance(this.algorithm, this.theProvider);
                    notDone = false;
                }
                catch (Exception ex) {
                    if (debug != null) {
                        debug.text(16384L, (Object)hybridClassName, "getBestInstance", ex.getMessage());
                        debug.exception(16384L, (Object)hybridClassName, "getBestInstance", (Throwable)ex);
                    }
                    this.ExceptionHistory.addElement(ex);
                    if (debug != null) {
                        debug.text(16384L, (Object)hybridClassName, "getBestInstance", "Exception thrown on Signature.getInstance(" + this.algorithm + ", " + this.theProvider + ") \n\t" + ex.getMessage());
                        debug.text(16384L, (Object)hybridClassName, "getBestInstance", "Calling tblObj.invalidateProvider() then tblObj.getBestProvider() for Signature " + this.algorithm);
                    }
                    if (null != this.theProvider) {
                        tblObj.invalidateProvider(this.theProvider);
                    }
                    this.theProvider = tblObj.getBestProvider();
                }
            }
            if (null != this.theSignature) continue;
            if (this.tableObjectReset) {
                notDone = false;
                continue;
            }
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "getBestInstance", "Calling tblObj.doReset() for Signature," + this.algorithm + "provider list reset.");
            }
            tblObj.doReset();
            this.tableObjectReset = true;
            this.ExceptionHistory = new Vector();
            this.theProvider = tblObj.getBestProvider();
        }
        if (null != this.theSignature) {
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "getBestInstance", "Signature " + this.algorithm + " obtained from provider: " + this.theProvider);
            }
        } else {
            String ijheMsg = "Failover exhausted, all registered providers attempted and failed.";
            IBMJCEHybridException ijhe = new IBMJCEHybridException(ijheMsg, this.ExceptionHistory);
            if (debug != null) {
                debug.exception(16384L, (Object)hybridClassName, "getBestInstance", (Throwable)ijhe);
                debug.text(16384L, (Object)hybridClassName, "getBestInstance", ijheMsg);
                debug.exit(16384L, (Object)hybridClassName, "getBestInstance");
            }
            throw ijhe;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "getBestInstance");
        }
        return this.theSignature;
    }

    private PrivateKey unwravelKey(HybridRACFPrivateKey key) {
        if (debug != null) {
            debug.entry(16384L, (Object)hybridClassName, "unwravelKey", (Object)key);
            debug.text(16384L, (Object)hybridClassName, "unwravelKey", "Provider is: " + this.theProvider);
        }
        if (this.theProvider.equalsIgnoreCase("IBMJCECCA")) {
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "unwravelKey", "Unwraveled to a hardware key.");
                debug.exit(16384L, (Object)hybridClassName, "unwravelKey");
            }
            return key.getIBMJCECCAPrivateKey();
        }
        if (debug != null) {
            debug.text(16384L, (Object)hybridClassName, "unwravelKey", "Unwraveled to a software key.");
            debug.exit(16384L, (Object)hybridClassName, "unwravelKey");
        }
        return key.getIBMJCEPrivateKey();
    }
}

