/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.ibmjcehybrid.provider;

import com.ibm.crypto.ibmjcehybrid.provider.AlgorithmTable;
import com.ibm.crypto.ibmjcehybrid.provider.IBMJCEHybridException;
import com.ibm.crypto.ibmjcehybrid.provider.TableObject;
import com.ibm.misc.Debug;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.util.Vector;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.SecretKeyFactorySpi;

abstract class HybridSecretKeyFactory
extends SecretKeyFactorySpi {
    private SecretKeyFactory theFactory;
    private static final String serviceType = "SecretKeyFactory";
    private String algorithm;
    private String theProvider = null;
    private boolean tableObjectReset = false;
    private Vector<Exception> ExceptionHistory = new Vector();
    static Debug debug = Debug.getInstance((String)"ibmjcehybrid");
    private static final String hybridClassName = "com.ibm.crypto.ibmjcehybrid.provider.HybridSecretKeyFactory";

    public HybridSecretKeyFactory(String algorithm) {
        if (debug != null) {
            debug.entry(16384L, (Object)hybridClassName, "HybridSecretKeyFactory", (Object)algorithm);
        }
        this.algorithm = algorithm;
        this.tableObjectReset = false;
        AlgorithmTable algTbl = new AlgorithmTable();
        if (null == algTbl) {
            String rteMessage = new String("Internal error in AlgorithmTable class.");
            RuntimeException rte = new RuntimeException(rteMessage);
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "HybridSecretKeyFactory", rteMessage);
                debug.exception(16384L, (Object)hybridClassName, "HybridSecretKeyFactory", (Throwable)rte);
                debug.exit(16384L, (Object)hybridClassName, "HybridSecretKeyFactory");
            }
            throw new RuntimeException(rte);
        }
        try {
            this.getFactory();
        }
        catch (Exception ex) {
            IBMJCEHybridException ijhe;
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "HybridSecretKeyFactory", ex.getMessage());
                debug.exception(16384L, (Object)hybridClassName, "HybridSecretKeyFactory", (Throwable)ex);
            }
            if (ex instanceof IBMJCEHybridException) {
                ijhe = (IBMJCEHybridException)ex;
            } else {
                this.ExceptionHistory.addElement(ex);
                ijhe = new IBMJCEHybridException(null, this.ExceptionHistory);
            }
            String rteMessage = new String("No provider found for SecretKeyFactory " + this.algorithm);
            RuntimeException rte = new RuntimeException(rteMessage, ijhe);
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "HybridSecretKeyFactory", rteMessage);
                debug.exception(16384L, (Object)hybridClassName, "HybridSecretKeyFactory", (Throwable)rte);
                debug.exit(16384L, (Object)hybridClassName, "HybridSecretKeyFactory");
            }
            throw new RuntimeException(rte);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "HybridSecretKeyFactory");
        }
    }

    @Override
    protected SecretKey engineGenerateSecret(KeySpec keySpec) throws InvalidKeySpecException {
        SecretKey result = null;
        if (debug != null) {
            debug.entry(16384L, (Object)hybridClassName, "engineGenerateSecret", (Object)keySpec);
        }
        result = this.generateSecret(keySpec, true);
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "engineGenerateSecret", (Object)result);
        }
        return result;
    }

    private SecretKey generateSecret(KeySpec keySpec, boolean isExternalCall) throws InvalidKeySpecException {
        SecretKey result = null;
        if (debug != null) {
            debug.entry(16384L, (Object)hybridClassName, "generateSecret", (Object)keySpec, (Object)new Boolean(isExternalCall));
        }
        if (isExternalCall) {
            this.tableObjectReset = false;
            this.ExceptionHistory = new Vector();
        }
        try {
            result = this.theFactory.generateSecret(keySpec);
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "generateSecret", "Successful call to generateSecret(keySpec) in provider: " + this.theProvider);
            }
            this.ExceptionHistory = new Vector();
        }
        catch (IBMJCEHybridException ijhe) {
            throw ijhe;
        }
        catch (Exception ex) {
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "generateSecret", ex.getMessage());
                debug.exception(16384L, (Object)hybridClassName, "generateSecret", (Throwable)ex);
            }
            this.ExceptionHistory.addElement(ex);
            this.getFactory();
            result = this.generateSecret(keySpec, false);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "generateSecret", (Object)result);
        }
        return result;
    }

    protected KeySpec engineGetKeySpec(SecretKey key, Class keySpecClass) throws InvalidKeySpecException {
        KeySpec result = null;
        if (debug != null) {
            debug.entry(16384L, (Object)hybridClassName, "engineGetKeySpec", (Object)key, (Object)keySpecClass);
        }
        result = this.getKeySpec(key, keySpecClass, true);
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "engineGetKeySpec", (Object)result);
        }
        return result;
    }

    private KeySpec getKeySpec(SecretKey key, Class keySpecClass, boolean isExternalCall) throws InvalidKeySpecException {
        KeySpec result = null;
        if (debug != null) {
            debug.entry(16384L, (Object)hybridClassName, "getKeySpec", (Object)new String("key=" + key + "  keySpecClass=" + keySpecClass + "  isExternalCall=" + isExternalCall));
        }
        if (isExternalCall) {
            this.tableObjectReset = false;
            this.ExceptionHistory = new Vector();
        }
        try {
            result = this.theFactory.getKeySpec(key, keySpecClass);
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "getKeySpec", "Successful call to getKeySpec(key,keySpecClass) in provider: " + this.theProvider);
            }
            this.ExceptionHistory = new Vector();
        }
        catch (IBMJCEHybridException ijhe) {
            throw ijhe;
        }
        catch (Exception ex) {
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "getKeySpec", ex.getMessage());
                debug.exception(16384L, (Object)hybridClassName, "getKeySpec", (Throwable)ex);
            }
            this.ExceptionHistory.addElement(ex);
            this.getFactory();
            result = this.getKeySpec(key, keySpecClass, false);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "getKeySpec", (Object)result);
        }
        return result;
    }

    @Override
    protected SecretKey engineTranslateKey(SecretKey key) throws InvalidKeyException {
        SecretKey result = null;
        if (debug != null) {
            debug.entry(16384L, (Object)hybridClassName, "engineTranslateKey", (Object)key);
        }
        result = this.translateKey(key, true);
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "engineTranslateKey", (Object)result);
        }
        return result;
    }

    private SecretKey translateKey(SecretKey key, boolean isExternalCall) throws InvalidKeyException {
        SecretKey result = null;
        if (debug != null) {
            debug.entry(16384L, (Object)hybridClassName, "translateKey", (Object)key, (Object)new Boolean(isExternalCall));
        }
        if (isExternalCall) {
            this.tableObjectReset = false;
            this.ExceptionHistory = new Vector();
        }
        try {
            result = this.theFactory.translateKey(key);
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "translateKey", "Successful call to translateKey(key) in provider: " + this.theProvider);
            }
            this.ExceptionHistory = new Vector();
        }
        catch (IBMJCEHybridException ijhe) {
            throw ijhe;
        }
        catch (Exception ex) {
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "translateKey", ex.getMessage());
                debug.exception(16384L, (Object)hybridClassName, "translateKey", (Throwable)ex);
            }
            this.ExceptionHistory.addElement(ex);
            this.getFactory();
            result = this.translateKey(key, false);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "translateKey", (Object)result);
        }
        return result;
    }

    private void getFactory() {
        if (debug != null) {
            debug.entry(16384L, (Object)hybridClassName, "getFactory", (Object)this.algorithm);
        }
        if (null != this.theFactory) {
            TableObject tblObj = AlgorithmTable.getStateData(serviceType, this.algorithm);
            tblObj.invalidateProvider(this.theFactory.getProvider().getName());
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "getFactory", "Calling tblObj.invalidateProvider( " + this.theProvider + " ) for " + serviceType + " " + this.algorithm);
            }
        }
        try {
            this.theFactory = this.getBestInstance();
        }
        catch (IBMJCEHybridException ijhe) {
            throw ijhe;
        }
        catch (Exception e) {
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "getFactory", e.getMessage());
                debug.exception(16384L, (Object)hybridClassName, "getFactory", (Throwable)e);
            }
            this.ExceptionHistory.addElement(e);
            String ijheMsg = "Failover exhausted, all registered providers attempted and failed.";
            IBMJCEHybridException ijhe = new IBMJCEHybridException(ijheMsg, this.ExceptionHistory);
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "getFactory", ijheMsg);
                debug.exception(16384L, (Object)hybridClassName, "getFactory", (Throwable)ijhe);
                debug.exit(16384L, (Object)hybridClassName, "getFactory");
            }
            throw ijhe;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "getFactory");
        }
    }

    private SecretKeyFactory getBestInstance() throws NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException {
        TableObject tblObj = null;
        if (debug != null) {
            debug.entry(16384L, (Object)hybridClassName, "getBestInstance", (Object)this.algorithm);
        }
        if (null == (tblObj = AlgorithmTable.getStateData(serviceType, this.algorithm))) {
            String ijheMessage = new String("SecretKeyFactory." + this.algorithm + " not found as a registered algorithm");
            IBMJCEHybridException ijhe = new IBMJCEHybridException(ijheMessage, this.ExceptionHistory);
            if (debug != null) {
                debug.exception(16384L, (Object)hybridClassName, "getBestInstance", (Throwable)ijhe);
                debug.text(16384L, (Object)hybridClassName, "getBestInstance", ijheMessage);
                debug.exit(16384L, (Object)hybridClassName, "getBestInstance");
            }
            throw ijhe;
        }
        this.theProvider = tblObj.getBestProvider();
        this.theFactory = null;
        boolean notDone = true;
        while (notDone) {
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "getBestInstance", "Top of loop 1");
            }
            while (null == this.theFactory && null != this.theProvider) {
                if (debug != null) {
                    debug.text(16384L, (Object)hybridClassName, "getBestInstance", "Top of loop 2");
                }
                try {
                    this.theFactory = SecretKeyFactory.getInstance(this.algorithm, this.theProvider);
                    notDone = false;
                }
                catch (Exception ex) {
                    if (debug != null) {
                        debug.text(16384L, (Object)hybridClassName, "getBestInstance", ex.getMessage());
                        debug.exception(16384L, (Object)hybridClassName, "getBestInstance", (Throwable)ex);
                    }
                    this.ExceptionHistory.addElement(ex);
                    if (debug != null) {
                        debug.text(16384L, (Object)hybridClassName, "getBestInstance", "Exception thrown on SecretKeyFactory.getInstance(" + this.algorithm + ", " + this.theProvider + ") \n\t" + ex.getMessage());
                        debug.text(16384L, (Object)hybridClassName, "getBestInstance", "Calling tblObj.invalidateProvider() then tblObj.getBestProvider() for SecretKeyFactory " + this.algorithm);
                    }
                    if (null != this.theProvider) {
                        tblObj.invalidateProvider(this.theProvider);
                    }
                    this.theProvider = tblObj.getBestProvider();
                }
            }
            if (null != this.theFactory) continue;
            if (this.tableObjectReset) {
                notDone = false;
                continue;
            }
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "getBestInstance", "Calling tblObj.doReset() for SecretKeyFactory," + this.algorithm + "provider list reset.");
            }
            tblObj.doReset();
            this.tableObjectReset = true;
            this.ExceptionHistory = new Vector();
            this.theProvider = tblObj.getBestProvider();
        }
        if (null != this.theFactory) {
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "getBestInstance", "SecretKeyFactory " + this.algorithm + " obtained from provider: " + this.theProvider);
            }
        } else {
            String ijheMsg = "Failover exhausted, all registered providers attempted and failed.";
            IBMJCEHybridException ijhe = new IBMJCEHybridException(ijheMsg, this.ExceptionHistory);
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "getBestInstance", ijheMsg);
                debug.exception(16384L, (Object)hybridClassName, "getBestInstance", (Throwable)ijhe);
                debug.exit(16384L, (Object)hybridClassName, "getBestInstance");
            }
            throw ijhe;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "getBestInstance");
        }
        return this.theFactory;
    }
}

