/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.ibmjcehybrid.provider;

import com.ibm.crypto.hdwrCCA.provider.ECPrivateHWKey;
import com.ibm.crypto.hdwrCCA.provider.RSAPrivateHWKey;
import com.ibm.misc.Debug;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.InvalidParameterException;
import java.security.PrivateKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPrivateKey;

public class HybridRACFPrivateKey
implements RSAPrivateCrtKey,
Serializable {
    private PrivateKey hybridIBMJCECCAPrivateKey = null;
    private PrivateKey hybridIBMJCEPrivateKey = null;
    private static Debug debug = Debug.getInstance((String)"ibmjcehybrid");
    private final String hybridClassName = "com.ibm.crypto.ibmjcehybrid.provider.HybridRACFPrivateKey";

    public HybridRACFPrivateKey(PrivateKey IBMJCECCAPrivateKey, PrivateKey IBMJCEPrivateKey) {
        if (debug != null) {
            debug.entry(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFPrivateKey", "HybridRACFPrivateKey", (Object)IBMJCECCAPrivateKey, (Object)IBMJCEPrivateKey);
        }
        this.setIBMJCEPrivateKey(IBMJCEPrivateKey);
        this.setIBMJCECCAPrivateKey(IBMJCECCAPrivateKey);
        if (debug != null) {
            debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFPrivateKey", "HybridRACFPrivateKey");
        }
    }

    @Override
    public BigInteger getPublicExponent() {
        if (debug != null) {
            debug.entry(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFPrivateKey", "getPublicExponent");
        }
        if (this.hybridIBMJCECCAPrivateKey == null && this.hybridIBMJCEPrivateKey == null) {
            UnsupportedOperationException e = new UnsupportedOperationException("Both IBMJCECCA and IBMJCE underlying keys are null.");
            if (debug != null) {
                debug.exception(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFPrivateKey", "getPublicExponent", (Throwable)e);
            }
            throw e;
        }
        BigInteger value = null;
        if (this.hybridIBMJCEPrivateKey != null) {
            if (debug != null) {
                debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFPrivateKey", "getPrivateExponent", "Making getPublicExponent() call to IBMJCE derived key.");
            }
            value = ((RSAPrivateCrtKey)this.hybridIBMJCEPrivateKey).getPublicExponent();
        } else if (this.hybridIBMJCECCAPrivateKey != null) {
            if (debug != null) {
                debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFPrivateKey", "getPublicExponent", "Making getPublicExponent() call to IBMJCECCA derived key.");
            }
            value = ((RSAPrivateCrtKey)this.hybridIBMJCECCAPrivateKey).getPublicExponent();
        } else {
            UnsupportedOperationException e = new UnsupportedOperationException("Value not available.");
            if (debug != null) {
                debug.exception(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFPrivateKey", "getPublicExponent", (Throwable)e);
            }
            throw e;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFPrivateKey", "getPublicExponent", (Object)value);
        }
        return value;
    }

    @Override
    public BigInteger getPrimeExponentQ() {
        if (debug != null) {
            debug.entry(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFPrivateKey", "getPrimeExponentQ");
        }
        if (this.hybridIBMJCECCAPrivateKey == null && this.hybridIBMJCEPrivateKey == null) {
            UnsupportedOperationException e = new UnsupportedOperationException("Both IBMJCECCA and IBMJCE underlying keys are null.");
            if (debug != null) {
                debug.exception(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFPrivateKey", "getPrimeExponentQ", (Throwable)e);
            }
            throw e;
        }
        BigInteger value = null;
        if (this.hybridIBMJCEPrivateKey != null) {
            if (debug != null) {
                debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFPrivateKey", "getPrivateExponent", "Making getPrimeExponentQ() call to IBMJCE derived key.");
            }
            value = ((RSAPrivateCrtKey)this.hybridIBMJCEPrivateKey).getPrimeExponentQ();
        } else if (this.hybridIBMJCECCAPrivateKey != null) {
            if (debug != null) {
                debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFPrivateKey", "getPrimeExponentQ", "Making getPrimeExponentQ() call to IBMJCECCA derived key.");
            }
            value = ((RSAPrivateCrtKey)this.hybridIBMJCECCAPrivateKey).getPrimeExponentQ();
        } else {
            UnsupportedOperationException e = new UnsupportedOperationException("Value not available.");
            if (debug != null) {
                debug.exception(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFPrivateKey", "getPrimeExponentQ", (Throwable)e);
            }
            throw e;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFPrivateKey", "getPrimeExponentQ", (Object)value);
        }
        return value;
    }

    @Override
    public BigInteger getPrimeExponentP() {
        if (debug != null) {
            debug.entry(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFPrivateKey", "getPrimeExponentP");
        }
        if (this.hybridIBMJCECCAPrivateKey == null && this.hybridIBMJCEPrivateKey == null) {
            UnsupportedOperationException e = new UnsupportedOperationException("Both IBMJCECCA and IBMJCE underlying keys are null.");
            if (debug != null) {
                debug.exception(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFPrivateKey", "getPrimeExponentP", (Throwable)e);
            }
            throw e;
        }
        BigInteger value = null;
        if (this.hybridIBMJCEPrivateKey != null) {
            if (debug != null) {
                debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFPrivateKey", "getPrivateExponent", "Making getPrimeExponentP() call to IBMJCE derived key.");
            }
            value = ((RSAPrivateCrtKey)this.hybridIBMJCEPrivateKey).getPrimeExponentP();
        } else if (this.hybridIBMJCECCAPrivateKey != null) {
            if (debug != null) {
                debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFPrivateKey", "getPrimeExponentP", "Making getPrimeExponentP() call to IBMJCECCA derived key.");
            }
            value = ((RSAPrivateCrtKey)this.hybridIBMJCECCAPrivateKey).getPrimeExponentP();
        } else {
            UnsupportedOperationException e = new UnsupportedOperationException("Value not available.");
            if (debug != null) {
                debug.exception(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFPrivateKey", "getPrimeExponentP", (Throwable)e);
            }
            throw e;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFPrivateKey", "getPrimeExponentP", (Object)value);
        }
        return value;
    }

    @Override
    public BigInteger getPrimeQ() {
        if (debug != null) {
            debug.entry(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFPrivateKey", "getPrimeQ");
        }
        if (this.hybridIBMJCECCAPrivateKey == null && this.hybridIBMJCEPrivateKey == null) {
            UnsupportedOperationException e = new UnsupportedOperationException("Both IBMJCECCA and IBMJCE underlying keys are null.");
            if (debug != null) {
                debug.exception(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFPrivateKey", "getPrimeQ", (Throwable)e);
            }
            throw e;
        }
        BigInteger value = null;
        if (this.hybridIBMJCEPrivateKey != null) {
            if (debug != null) {
                debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFPrivateKey", "getPrivateExponent", "Making getPrimeQ() call to IBMJCE derived key.");
            }
            value = ((RSAPrivateCrtKey)this.hybridIBMJCEPrivateKey).getPrimeQ();
        } else if (this.hybridIBMJCECCAPrivateKey != null) {
            if (debug != null) {
                debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFPrivateKey", "getPrimeQ", "Making getPrimeQ() call to IBMJCECCA derived key.");
            }
            value = ((RSAPrivateCrtKey)this.hybridIBMJCECCAPrivateKey).getPrimeQ();
        } else {
            UnsupportedOperationException e = new UnsupportedOperationException("Value not available.");
            if (debug != null) {
                debug.exception(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFPrivateKey", "getPrimeQ", (Throwable)e);
            }
            throw e;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFPrivateKey", "getPrimeQ", (Object)value);
        }
        return value;
    }

    @Override
    public BigInteger getPrimeP() {
        if (debug != null) {
            debug.entry(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFPrivateKey", "getPrimeP");
        }
        if (this.hybridIBMJCECCAPrivateKey == null && this.hybridIBMJCEPrivateKey == null) {
            UnsupportedOperationException e = new UnsupportedOperationException("Both IBMJCECCA and IBMJCE underlying keys are null.");
            if (debug != null) {
                debug.exception(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFPrivateKey", "getPrimeP", (Throwable)e);
            }
            throw e;
        }
        BigInteger value = null;
        if (this.hybridIBMJCEPrivateKey != null) {
            if (debug != null) {
                debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFPrivateKey", "getPrivateExponent", "Making getPrimeP() call to IBMJCE derived key.");
            }
            value = ((RSAPrivateCrtKey)this.hybridIBMJCEPrivateKey).getPrimeP();
        } else if (this.hybridIBMJCECCAPrivateKey != null) {
            if (debug != null) {
                debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFPrivateKey", "getPrimeP", "Making getPrimeP() call to IBMJCECCA derived key.");
            }
            value = ((RSAPrivateCrtKey)this.hybridIBMJCECCAPrivateKey).getPrimeP();
        } else {
            UnsupportedOperationException e = new UnsupportedOperationException("Value not available.");
            if (debug != null) {
                debug.exception(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFPrivateKey", "getPrimeP", (Throwable)e);
            }
            throw e;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFPrivateKey", "getPrimeP", (Object)value);
        }
        return value;
    }

    @Override
    public BigInteger getCrtCoefficient() {
        if (debug != null) {
            debug.entry(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFPrivateKey", "getCrtCoefficient");
        }
        if (this.hybridIBMJCECCAPrivateKey == null && this.hybridIBMJCEPrivateKey == null) {
            UnsupportedOperationException e = new UnsupportedOperationException("Both IBMJCECCA and IBMJCE underlying keys are null.");
            if (debug != null) {
                debug.exception(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFPrivateKey", "getCrtCoefficient", (Throwable)e);
            }
            throw e;
        }
        BigInteger value = null;
        if (this.hybridIBMJCEPrivateKey != null) {
            if (debug != null) {
                debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFPrivateKey", "getPrivateExponent", "Making getCrtCoefficient() call to IBMJCE derived key.");
            }
            value = ((RSAPrivateCrtKey)this.hybridIBMJCEPrivateKey).getCrtCoefficient();
        } else if (this.hybridIBMJCECCAPrivateKey != null) {
            if (debug != null) {
                debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFPrivateKey", "getCrtCoefficient", "Making getCrtCoefficient() call to IBMJCECCA derived key.");
            }
            value = ((RSAPrivateCrtKey)this.hybridIBMJCECCAPrivateKey).getCrtCoefficient();
        } else {
            UnsupportedOperationException e = new UnsupportedOperationException("Value not available.");
            if (debug != null) {
                debug.exception(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFPrivateKey", "getCrtCoefficient", (Throwable)e);
            }
            throw e;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFPrivateKey", "getCrtCoefficient", (Object)value);
        }
        return value;
    }

    @Override
    public BigInteger getPrivateExponent() {
        if (debug != null) {
            debug.entry(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFPrivateKey", "getPrivateExponent");
        }
        if (this.hybridIBMJCECCAPrivateKey == null && this.hybridIBMJCEPrivateKey == null) {
            UnsupportedOperationException e = new UnsupportedOperationException("Both IBMJCECCA and IBMJCE underlying keys are null.");
            if (debug != null) {
                debug.exception(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFPrivateKey", "getPrivateExponent", (Throwable)e);
            }
            throw e;
        }
        BigInteger value = null;
        if (this.hybridIBMJCEPrivateKey != null) {
            if (debug != null) {
                debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFPrivateKey", "getPrivateExponent", "Making getPrivateExponent() call to IBMJCE derived key.");
            }
            value = ((RSAPrivateKey)this.hybridIBMJCEPrivateKey).getPrivateExponent();
        } else if (this.hybridIBMJCECCAPrivateKey != null) {
            if (debug != null) {
                debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFPrivateKey", "getPrivateExponent", "Making getPrivateExponent() call to IBMJCECCA derived key.");
            }
            value = ((RSAPrivateCrtKey)this.hybridIBMJCECCAPrivateKey).getPrivateExponent();
        }
        if (debug != null) {
            debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFPrivateKey", "getPrivateExponent", (Object)value);
        }
        return value;
    }

    @Override
    public BigInteger getModulus() throws UnsupportedOperationException {
        if (debug != null) {
            debug.entry(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFPrivateKey", "getModulus");
        }
        if (this.hybridIBMJCECCAPrivateKey == null && this.hybridIBMJCEPrivateKey == null) {
            UnsupportedOperationException e = new UnsupportedOperationException("Both IBMJCECCA and IBMJCE underlying keys are null.");
            if (debug != null) {
                debug.exception(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFPrivateKey", "getModulus", (Throwable)e);
            }
            throw e;
        }
        BigInteger value = null;
        if (this.hybridIBMJCEPrivateKey != null) {
            if (debug != null) {
                debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFPrivateKey", "getModulus", "Making getModulus() call to IBMJCE derived key.");
            }
            value = ((RSAPrivateKey)this.hybridIBMJCEPrivateKey).getModulus();
        } else if (this.hybridIBMJCECCAPrivateKey != null) {
            if (debug != null) {
                debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFPrivateKey", "getModulus", "Making getModulus() call to IBMJCECCA derived key.");
            }
            value = ((RSAPrivateCrtKey)this.hybridIBMJCECCAPrivateKey).getModulus();
        }
        if (debug != null) {
            debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFPrivateKey", "getModulus", (Object)value);
        }
        return value;
    }

    @Override
    public byte[] getEncoded() {
        if (debug != null) {
            debug.entry(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFPrivateKey", "getEncoded");
        }
        if (this.hybridIBMJCECCAPrivateKey == null && this.hybridIBMJCEPrivateKey == null) {
            UnsupportedOperationException e = new UnsupportedOperationException("Both IBMJCECCA and IBMJCE underlying keys are null.");
            if (debug != null) {
                debug.exception(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFPrivateKey", "getEncoded", (Throwable)e);
            }
            throw e;
        }
        byte[] value = null;
        if (this.hybridIBMJCEPrivateKey != null) {
            if (debug != null) {
                debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFPrivateKey", "getEncoded", "Making getEncoded() call to IBMJCE derived key.");
            }
            value = ((RSAPrivateKey)this.hybridIBMJCEPrivateKey).getEncoded();
        } else if (this.hybridIBMJCECCAPrivateKey != null) {
            if (debug != null) {
                debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFPrivateKey", "getEncoded", "Making getEncoded() call to IBMJCECCA derived key.");
            }
            value = ((RSAPrivateCrtKey)this.hybridIBMJCECCAPrivateKey).getEncoded();
        }
        if (debug != null) {
            debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFPrivateKey", "getEncoded", (Object)value);
        }
        return value;
    }

    @Override
    public String getFormat() {
        if (debug != null) {
            debug.entry(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFPrivateKey", "getFormat");
        }
        if (this.hybridIBMJCECCAPrivateKey == null && this.hybridIBMJCEPrivateKey == null) {
            UnsupportedOperationException e = new UnsupportedOperationException("Both IBMJCECCA and IBMJCE underlying keys are null.");
            if (debug != null) {
                debug.exception(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFPrivateKey", "getFormat", (Throwable)e);
            }
            throw e;
        }
        String value = null;
        if (this.hybridIBMJCEPrivateKey != null) {
            if (debug != null) {
                debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFPrivateKey", "getFormat", "Making getFormat() call to IBMJCE derived key.");
            }
            value = ((RSAPrivateKey)this.hybridIBMJCEPrivateKey).getFormat();
        } else if (this.hybridIBMJCECCAPrivateKey != null) {
            if (debug != null) {
                debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFPrivateKey", "getFormat", "Making getFormat() call to IBMJCECCA derived key.");
            }
            value = ((RSAPrivateCrtKey)this.hybridIBMJCECCAPrivateKey).getFormat();
        }
        if (debug != null) {
            debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFPrivateKey", "getFormat", (Object)value);
        }
        return value;
    }

    @Override
    public String getAlgorithm() {
        if (debug != null) {
            debug.entry(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFPrivateKey", "getAlgorithm");
        }
        if (this.hybridIBMJCECCAPrivateKey == null && this.hybridIBMJCEPrivateKey == null) {
            UnsupportedOperationException e = new UnsupportedOperationException("Both IBMJCECCA and IBMJCE underlying keys are null.");
            if (debug != null) {
                debug.exception(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFPrivateKey", "getAlgorithm", (Throwable)e);
            }
            throw e;
        }
        String value = null;
        if (this.hybridIBMJCEPrivateKey != null) {
            if (debug != null) {
                debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFPrivateKey", "getAlgorithm", "Making getAlgorithm() call to IBMJCE derived key.");
            }
            value = ((RSAPrivateKey)this.hybridIBMJCEPrivateKey).getAlgorithm();
        } else if (this.hybridIBMJCECCAPrivateKey != null) {
            if (debug != null) {
                debug.text(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFPrivateKey", "getAlgorithm", "Making getAlgorithm() call to IBMJCECCA derived key.");
            }
            value = ((RSAPrivateCrtKey)this.hybridIBMJCECCAPrivateKey).getAlgorithm();
        }
        if (debug != null) {
            debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFPrivateKey", "getAlgorithm", (Object)value);
        }
        return value;
    }

    public void setIBMJCEPrivateKey(PrivateKey IBMJCEPrivateKey) throws InvalidParameterException {
        if (debug != null) {
            debug.entry(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFPrivateKey", "setIBMJCEPrivateKey", (Object)IBMJCEPrivateKey);
        }
        if (IBMJCEPrivateKey == null) {
            this.hybridIBMJCEPrivateKey = null;
        } else if (IBMJCEPrivateKey instanceof RSAPrivateKey || IBMJCEPrivateKey instanceof ECPrivateKey) {
            this.hybridIBMJCEPrivateKey = IBMJCEPrivateKey;
        } else {
            InvalidParameterException e = new InvalidParameterException("Key is not an instance of the ECPrivateKey or RSAPrivateKey class.");
            if (debug != null) {
                debug.exception(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFPrivateKey", "setIBMJCEPrivateKey", (Throwable)e);
                debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFPrivateKey", "setIBMJCEPrivateKey");
            }
            throw e;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFPrivateKey", "setIBMJCEPrivateKey");
        }
    }

    public PrivateKey getIBMJCEPrivateKey() {
        if (debug != null) {
            debug.entry(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFPrivateKey", "getIBMJCEPrivateKey");
            debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFPrivateKey", "getIBMJCEPrivateKey", (Object)this.hybridIBMJCEPrivateKey);
        }
        return this.hybridIBMJCEPrivateKey;
    }

    public void setIBMJCECCAPrivateKey(PrivateKey IBMJCECCAPrivateKey) throws InvalidParameterException {
        if (debug != null) {
            debug.entry(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFPrivateKey", "setIBMJCECCAPrivateKey", (Object)IBMJCECCAPrivateKey);
        }
        if (IBMJCECCAPrivateKey == null) {
            this.hybridIBMJCECCAPrivateKey = null;
        } else if (IBMJCECCAPrivateKey instanceof RSAPrivateHWKey || IBMJCECCAPrivateKey instanceof ECPrivateHWKey) {
            this.hybridIBMJCECCAPrivateKey = IBMJCECCAPrivateKey;
        } else {
            InvalidParameterException e = new InvalidParameterException("Key is not an instance of the com.ibm.crypto.hdwrCCA.provider.ECPrivateHWKey or com.ibm.crypto.hdwrCCA.provider.RSAPrivateHWKey class.");
            if (debug != null) {
                debug.exception(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFPrivateKey", "setIBMJCECCAPrivateKey", (Throwable)e);
                debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFPrivateKey", "setIBMJCECCAPrivateKey");
            }
            throw e;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFPrivateKey", "setIBMJCECCAPrivateKey");
        }
    }

    public PrivateKey getIBMJCECCAPrivateKey() {
        if (debug != null) {
            debug.entry(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFPrivateKey", "getIBMJCECCAPrivateKey");
            debug.exit(16384L, (Object)"com.ibm.crypto.ibmjcehybrid.provider.HybridRACFPrivateKey", "getIBMJCECCAPrivateKey", (Object)this.hybridIBMJCECCAPrivateKey);
        }
        return this.hybridIBMJCECCAPrivateKey;
    }

    public String toString() {
        String str = "\nHybridRACFPrivateKey\nIBMJCECCA Private Key Portion:\n\n" + this.hybridIBMJCECCAPrivateKey + "\nIBMJCE Private Key Portion:\n" + this.hybridIBMJCEPrivateKey + "\n";
        return str;
    }
}

