/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.ibmjcehybrid.provider;

import com.ibm.crypto.ibmjcehybrid.provider.AlgorithmTable;
import com.ibm.crypto.ibmjcehybrid.provider.IBMJCEHybridException;
import com.ibm.crypto.ibmjcehybrid.provider.TableObject;
import com.ibm.misc.Debug;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Vector;

abstract class HybridKeyPairGenerator
extends KeyPairGenerator {
    private KeyPairGenerator theGenerator;
    private static final String serviceType = "KeyPairGenerator";
    private String algorithm;
    private String theProvider = null;
    private int keysize = 0;
    private AlgorithmParameterSpec params = null;
    private SecureRandom random = null;
    private boolean tableObjectReset = false;
    private Vector<Exception> ExceptionHistory = new Vector();
    protected static Debug debug = Debug.getInstance((String)"ibmjcehybrid");
    private static final String hybridClassName = "com.ibm.crypto.ibmjcehybrid.provider.HybridKeyPairGenerator";

    public HybridKeyPairGenerator(String algorithm) {
        super(algorithm);
        if (debug != null) {
            debug.entry(16384L, (Object)hybridClassName, "HybridKeyPairGenerator", (Object)algorithm);
        }
        this.algorithm = algorithm;
        this.tableObjectReset = false;
        AlgorithmTable algTbl = new AlgorithmTable();
        if (null == algTbl) {
            String rteMessage = new String("Internal error in AlgorithmTable class.");
            RuntimeException rte = new RuntimeException(rteMessage);
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "HybridKeyPairGenerator", rteMessage);
                debug.exception(16384L, (Object)hybridClassName, "HybridKeyPairGenerator", (Throwable)rte);
                debug.exit(16384L, (Object)hybridClassName, "HybridKeyPairGenerator");
            }
            throw new RuntimeException(rte);
        }
        try {
            this.getGenerator();
        }
        catch (Exception ex) {
            IBMJCEHybridException ijhe;
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "HybridKeyPairGenerator", ex.getMessage());
                debug.exception(16384L, (Object)hybridClassName, "HybridKeyPairGenerator", (Throwable)ex);
            }
            if (ex instanceof IBMJCEHybridException) {
                ijhe = (IBMJCEHybridException)ex;
            } else {
                this.ExceptionHistory.addElement(ex);
                ijhe = new IBMJCEHybridException(null, this.ExceptionHistory);
            }
            String rteMessage = new String("No provider found for KeyPairGenerator " + this.algorithm);
            RuntimeException rte = new RuntimeException(rteMessage, ijhe);
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "HybridKeyPairGenerator", rteMessage);
                debug.exception(16384L, (Object)hybridClassName, "HybridKeyPairGenerator", (Throwable)rte);
                debug.exit(16384L, (Object)hybridClassName, "HybridKeyPairGenerator");
            }
            throw new RuntimeException(rte);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "HybridKeyPairGenerator");
        }
    }

    @Override
    public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException, InvalidParameterException {
        if (debug != null) {
            debug.entry(16384L, (Object)hybridClassName, "initialize", (Object)params, (Object)random);
        }
        this.params = params;
        this.random = random;
        this._initialize(this.params, this.random, true);
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "initialize");
        }
    }

    private void _initialize(AlgorithmParameterSpec params, SecureRandom random, boolean isExternalCall) throws InvalidAlgorithmParameterException, InvalidParameterException {
        if (debug != null) {
            debug.entry(16384L, (Object)hybridClassName, "_initialize", (Object)new String("params = " + params + "  random = " + random + "  isExternalCall = " + isExternalCall));
        }
        if (isExternalCall) {
            this.tableObjectReset = false;
            this.ExceptionHistory = new Vector();
        }
        this.params = params;
        this.random = random;
        try {
            this.theGenerator.initialize(this.params, this.random);
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "_initialize", "Successful call to _initialize(paramSpec,random) in provider: " + this.theProvider);
            }
            this.ExceptionHistory = new Vector();
        }
        catch (IBMJCEHybridException ijhe) {
            throw ijhe;
        }
        catch (Exception ex) {
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "_initialize", ex.getMessage());
                debug.exception(16384L, (Object)hybridClassName, "_initialize", (Throwable)ex);
            }
            this.ExceptionHistory.addElement(ex);
            this.getGenerator();
            this._initialize(this.params, this.random, false);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "initialize");
        }
    }

    @Override
    public void initialize(int strength, SecureRandom random) throws InvalidParameterException {
        if (debug != null) {
            debug.entry(16384L, (Object)hybridClassName, "initialize", (Object)new Integer(strength), (Object)random);
        }
        this.keysize = strength;
        this.random = random;
        this._initialize(this.keysize, this.random, true);
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "initialize");
        }
    }

    private void _initialize(int strength, SecureRandom random, boolean isExternalCall) throws InvalidParameterException {
        if (debug != null) {
            debug.entry(16384L, (Object)hybridClassName, "_initialize", (Object)new String("strength = " + strength + "  random = " + random + "  isExternalCall = " + isExternalCall));
        }
        if (isExternalCall) {
            this.tableObjectReset = false;
            this.ExceptionHistory = new Vector();
        }
        this.keysize = strength;
        this.random = random;
        try {
            this.theGenerator.initialize(this.keysize, this.random);
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "_initialize", "Successful call to _initialize(keySize,random) in provider: " + this.theProvider);
            }
            this.ExceptionHistory = new Vector();
        }
        catch (IBMJCEHybridException ijhe) {
            throw ijhe;
        }
        catch (Exception ex) {
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "_initialize", ex.getMessage());
                debug.exception(16384L, (Object)hybridClassName, "_initialize", (Throwable)ex);
            }
            this.ExceptionHistory.addElement(ex);
            this.getGenerator();
            this._initialize(this.keysize, this.random, false);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "_initialize");
        }
    }

    @Override
    public KeyPair generateKeyPair() {
        KeyPair result = null;
        if (debug != null) {
            debug.entry(16384L, (Object)hybridClassName, "generateKeyPair");
        }
        result = this._generateKeyPair(true);
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "generateKeyPair");
        }
        return result;
    }

    private KeyPair _generateKeyPair(boolean isExternalCall) {
        KeyPair result = null;
        if (debug != null) {
            debug.entry(16384L, (Object)hybridClassName, "_generateKeyPair", (Object)new Boolean(isExternalCall));
        }
        if (isExternalCall) {
            this.tableObjectReset = false;
            this.ExceptionHistory = new Vector();
        }
        try {
            result = this.theGenerator.generateKeyPair();
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "_generateKeyPair", "Successful call to _generateKeyPair() in provider: " + this.theProvider);
            }
            this.ExceptionHistory = new Vector();
        }
        catch (IBMJCEHybridException ijhe) {
            throw ijhe;
        }
        catch (Exception ex) {
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "_generateKeyPair", ex.getMessage());
                debug.exception(16384L, (Object)hybridClassName, "_generateKeyPair", (Throwable)ex);
            }
            this.ExceptionHistory.addElement(ex);
            this.getGenerator();
            result = this._generateKeyPair(false);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "_generateKeyPair");
        }
        return result;
    }

    protected void getGenerator() {
        if (debug != null) {
            debug.entry(16384L, (Object)hybridClassName, "getGenerator", (Object)new String(" " + this.algorithm + ", " + this.keysize + " "));
        }
        if (null != this.theGenerator) {
            TableObject tblObj = AlgorithmTable.getStateData(serviceType, this.algorithm);
            tblObj.invalidateProvider(this.theGenerator.getProvider().getName());
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "getGenerator", "Calling tblObj.invalidateProvider( " + this.theProvider + " ) for " + serviceType + " " + this.algorithm);
            }
        }
        try {
            this.theGenerator = this.getBestInstance();
        }
        catch (IBMJCEHybridException ijhe) {
            throw ijhe;
        }
        catch (Exception e) {
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "getGenerator", e.getMessage());
                debug.exception(16384L, (Object)hybridClassName, "getGenerator", (Throwable)e);
            }
            this.ExceptionHistory.addElement(e);
            String ijheMsg = "Failover exhausted, all registered providers attempted and failed.";
            IBMJCEHybridException ijhe = new IBMJCEHybridException(ijheMsg, this.ExceptionHistory);
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "getGenerator", ijheMsg);
                debug.exception(16384L, (Object)hybridClassName, "getGenerator", (Throwable)ijhe);
                debug.exit(16384L, (Object)hybridClassName, "getGenerator");
            }
            throw ijhe;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "getGenerator");
        }
    }

    private KeyPairGenerator getBestInstance() {
        TableObject tblObj = null;
        if (debug != null) {
            debug.entry(16384L, (Object)hybridClassName, "getBestInstance", (Object)this.algorithm);
        }
        if (null == (tblObj = AlgorithmTable.getStateData(serviceType, this.algorithm))) {
            String ijheMessage = new String("KeyPairGenerator." + this.algorithm + " not found as a registered algorithm");
            IBMJCEHybridException ijhe = new IBMJCEHybridException(ijheMessage, this.ExceptionHistory);
            if (debug != null) {
                debug.exception(16384L, (Object)hybridClassName, "getBestInstance", (Throwable)ijhe);
                debug.text(16384L, (Object)hybridClassName, "getBestInstance", ijheMessage);
                debug.exit(16384L, (Object)hybridClassName, "getBestInstance");
            }
            throw ijhe;
        }
        this.theProvider = tblObj.getBestProvider();
        this.theGenerator = null;
        boolean notDone = true;
        while (notDone) {
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "getBestInstance", "Top of loop 1");
            }
            while (null == this.theGenerator && null != this.theProvider) {
                if (debug != null) {
                    debug.text(16384L, (Object)hybridClassName, "getBestInstance", "Top of loop 2");
                }
                try {
                    this.theGenerator = KeyPairGenerator.getInstance(this.algorithm, this.theProvider);
                    notDone = false;
                }
                catch (Exception ex) {
                    if (debug != null) {
                        debug.text(16384L, (Object)hybridClassName, "getBestInstance", ex.getMessage());
                        debug.exception(16384L, (Object)hybridClassName, "getBestInstance", (Throwable)ex);
                    }
                    this.ExceptionHistory.addElement(ex);
                    if (debug != null) {
                        debug.text(16384L, (Object)hybridClassName, "getBestInstance", "Exception thrown on KeyPairGenerator.getInstance(" + this.algorithm + ", " + this.theProvider + ") \n\t" + ex.getMessage());
                        debug.text(16384L, (Object)hybridClassName, "getBestInstance", "Calling tblObj.invalidateProvider() then tblObj.getBestProvider() for KeyPairGenerator " + this.algorithm);
                    }
                    if (null != this.theProvider) {
                        tblObj.invalidateProvider(this.theProvider);
                    }
                    this.theProvider = tblObj.getBestProvider();
                }
            }
            if (null != this.theGenerator) continue;
            if (this.tableObjectReset) {
                notDone = false;
                continue;
            }
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "getBestInstance", "Calling tblObj.doReset() for KeyPairGenerator," + this.algorithm + "provider list reset.");
            }
            tblObj.doReset();
            this.tableObjectReset = true;
            this.ExceptionHistory = new Vector();
            this.theProvider = tblObj.getBestProvider();
        }
        if (null != this.theGenerator) {
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "getBestInstance", "KeyPairGenerator " + this.algorithm + " obtained from provider: " + this.theProvider);
            }
        } else {
            String ijheMsg = "Failover exhausted, all registered providers attempted and failed.";
            IBMJCEHybridException ijhe = new IBMJCEHybridException(ijheMsg, this.ExceptionHistory);
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "getBestInstance", ijheMsg);
                debug.exception(16384L, (Object)hybridClassName, "getBestInstance", (Throwable)ijhe);
                debug.exit(16384L, (Object)hybridClassName, "getBestInstance");
            }
            throw ijhe;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "getBestInstance");
        }
        return this.theGenerator;
    }
}

