/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.ibmjcehybrid.provider;

import com.ibm.crypto.ibmjcehybrid.provider.AlgorithmTable;
import com.ibm.crypto.ibmjcehybrid.provider.IBMJCEHybridException;
import com.ibm.crypto.ibmjcehybrid.provider.TableObject;
import com.ibm.misc.Debug;
import java.security.InvalidAlgorithmParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Vector;
import javax.crypto.KeyGenerator;
import javax.crypto.KeyGeneratorSpi;
import javax.crypto.SecretKey;

abstract class HybridKeyGenerator
extends KeyGeneratorSpi {
    private KeyGenerator theGenerator;
    private static final String serviceType = "KeyGenerator";
    private String algorithm;
    private String theProvider = null;
    private int keysize;
    private boolean key_to_constructor = false;
    private AlgorithmParameterSpec params = null;
    private SecureRandom random = null;
    private boolean tableObjectReset = false;
    private Vector<Exception> ExceptionHistory = new Vector();
    static Debug debug = Debug.getInstance((String)"ibmjcehybrid");
    private static final String hybridClassName = "com.ibm.crypto.ibmjcehybrid.provider.HybridKeyGenerator";

    public HybridKeyGenerator(String algorithm) {
        if (debug != null) {
            debug.entry(16384L, (Object)hybridClassName, "HybridKeyGenerator", (Object)algorithm);
        }
        this.algorithm = algorithm;
        this.keysize = -1;
        this.key_to_constructor = false;
        this.tableObjectReset = false;
        AlgorithmTable algTbl = new AlgorithmTable();
        if (null == algTbl) {
            String rteMessage = new String("Internal error in AlgorithmTable class.");
            RuntimeException rte = new RuntimeException(rteMessage);
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "HybridAlgorithmParameterGenerator", rteMessage);
                debug.exception(16384L, (Object)hybridClassName, "HybridAlgorithmParameterGenerator", (Throwable)rte);
                debug.exit(16384L, (Object)hybridClassName, "HybridAlgorithmParameterGenerator");
            }
            throw new RuntimeException(rte);
        }
        try {
            this.getGenerator();
        }
        catch (Exception ex) {
            IBMJCEHybridException ijhe;
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "HybridKeyGenerator", ex.getMessage());
                debug.exception(16384L, (Object)hybridClassName, "HybridKeyGenerator", (Throwable)ex);
            }
            if (ex instanceof IBMJCEHybridException) {
                ijhe = (IBMJCEHybridException)ex;
            } else {
                this.ExceptionHistory.addElement(ex);
                ijhe = new IBMJCEHybridException(null, this.ExceptionHistory);
            }
            String rteMessage = new String("No provider found for KeyGenerator " + this.algorithm);
            RuntimeException rte = new RuntimeException(rteMessage, ijhe);
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "HybridKeyGenerator", rteMessage);
                debug.exception(16384L, (Object)hybridClassName, "HybridKeyGenerator", (Throwable)rte);
                debug.exit(16384L, (Object)hybridClassName, "HybridKeyGenerator");
            }
            throw new RuntimeException(rte);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "HybridKeyGenerator");
        }
    }

    public HybridKeyGenerator(String algorithm, int keysize) {
        if (debug != null) {
            debug.entry(16384L, (Object)hybridClassName, "HybridKeyGenerator", (Object)algorithm, (Object)keysize);
        }
        this.algorithm = algorithm;
        this.keysize = keysize;
        this.key_to_constructor = true;
        this.tableObjectReset = false;
        AlgorithmTable algTbl = new AlgorithmTable();
        if (null == algTbl) {
            String rteMessage = new String("Internal error in AlgorithmTable class.");
            RuntimeException rte = new RuntimeException(rteMessage);
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "HybridKeyGenerator", rteMessage);
                debug.exception(16384L, (Object)hybridClassName, "HybridKeyGenerator", (Throwable)rte);
                debug.exit(16384L, (Object)hybridClassName, "HybridKeyGenerator");
            }
            throw new RuntimeException(rte);
        }
        try {
            this.getGenerator();
        }
        catch (Exception ex) {
            IBMJCEHybridException ijhe;
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "HybridKeyGenerator", ex.getMessage());
                debug.exception(16384L, (Object)hybridClassName, "HybridKeyGenerator", (Throwable)ex);
            }
            if (ex instanceof IBMJCEHybridException) {
                ijhe = (IBMJCEHybridException)ex;
            } else {
                this.ExceptionHistory.addElement(ex);
                ijhe = new IBMJCEHybridException(null, this.ExceptionHistory);
            }
            String rteMessage = new String("No provider found for KeyGenerator " + this.algorithm);
            RuntimeException rte = new RuntimeException(rteMessage, ijhe);
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "HybridKeyGenerator", rteMessage);
                debug.exception(16384L, (Object)hybridClassName, "HybridKeyGenerator", (Throwable)rte);
                debug.exit(16384L, (Object)hybridClassName, "HybridKeyGenerator");
            }
            throw new RuntimeException(rte);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "HybridKeyGenerator");
        }
    }

    @Override
    protected void engineInit(SecureRandom random) {
        if (debug != null) {
            debug.entry(16384L, (Object)hybridClassName, "engineInit", (Object)random);
        }
        if (!this.key_to_constructor) {
            this.keysize = -1;
        }
        this.random = random;
        this.params = null;
        this.init(this.random, true);
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "engineInit");
        }
    }

    private void init(SecureRandom random, boolean isExternalCall) {
        if (debug != null) {
            debug.entry(16384L, (Object)hybridClassName, "init", (Object)new String("random = " + random + "  isExternalCall = " + isExternalCall));
        }
        if (isExternalCall) {
            this.tableObjectReset = false;
            this.ExceptionHistory = new Vector();
        }
        this.random = random;
        try {
            this.theGenerator.init(this.random);
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "init", "Successful call to init(random) in provider: " + this.theProvider);
            }
            this.ExceptionHistory = new Vector();
        }
        catch (IBMJCEHybridException ijhe) {
            throw ijhe;
        }
        catch (Exception ex) {
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "init", ex.getMessage());
                debug.exception(16384L, (Object)hybridClassName, "init", (Throwable)ex);
            }
            this.ExceptionHistory.addElement(ex);
            this.getGenerator();
            this.init(this.random, false);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "init");
        }
    }

    @Override
    protected void engineInit(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        if (debug != null) {
            debug.entry(16384L, (Object)hybridClassName, "engineInit", (Object)params, (Object)random);
        }
        if (!this.key_to_constructor) {
            this.keysize = -1;
        }
        this.params = params;
        this.random = random;
        this.init(this.params, this.random, true);
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "engineInit");
        }
    }

    private void init(AlgorithmParameterSpec params, SecureRandom random, boolean isExternalCall) throws InvalidAlgorithmParameterException {
        if (debug != null) {
            debug.entry(16384L, (Object)hybridClassName, "init", (Object)new String("params = " + params + "  random = " + random + "  isExternalCall = " + isExternalCall));
        }
        if (isExternalCall) {
            this.tableObjectReset = false;
            this.ExceptionHistory = new Vector();
        }
        this.params = params;
        this.random = random;
        try {
            this.theGenerator.init(this.params, this.random);
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "init", "Successful call to init(paramSpec,random) in provider: " + this.theProvider);
            }
            this.ExceptionHistory = new Vector();
        }
        catch (IBMJCEHybridException ijhe) {
            throw ijhe;
        }
        catch (Exception ex) {
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "init", ex.getMessage());
                debug.exception(16384L, (Object)hybridClassName, "init", (Throwable)ex);
            }
            this.ExceptionHistory.addElement(ex);
            this.getGenerator();
            this.init(this.params, this.random, false);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "init");
        }
    }

    @Override
    protected void engineInit(int keysize, SecureRandom random) {
        if (debug != null) {
            debug.entry(16384L, (Object)hybridClassName, "engineInit", (Object)new Integer(keysize), (Object)random);
        }
        this.key_to_constructor = false;
        this.keysize = keysize;
        this.random = random;
        this.init(this.keysize, this.random, true);
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "engineInit");
        }
    }

    private void init(int keysize, SecureRandom random, boolean isExternalCall) {
        if (debug != null) {
            debug.entry(16384L, (Object)hybridClassName, "init", (Object)new String("keysize = " + keysize + "  random = " + random + "  isExternalCall = " + isExternalCall));
        }
        if (isExternalCall) {
            this.tableObjectReset = false;
            this.ExceptionHistory = new Vector();
        }
        this.keysize = keysize;
        this.random = random;
        try {
            this.theGenerator.init(this.keysize, this.random);
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "init", "Successful call to init(keysize,random) in provider: " + this.theProvider);
            }
            this.ExceptionHistory = new Vector();
        }
        catch (IBMJCEHybridException ijhe) {
            throw ijhe;
        }
        catch (Exception ex) {
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "init", ex.getMessage());
                debug.exception(16384L, (Object)hybridClassName, "init", (Throwable)ex);
            }
            this.ExceptionHistory.addElement(ex);
            this.getGenerator();
            this.init(this.keysize, this.random, false);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "init");
        }
    }

    @Override
    protected SecretKey engineGenerateKey() {
        SecretKey theKey = null;
        if (debug != null) {
            debug.entry(16384L, (Object)hybridClassName, "engineGenerateKey", (Object)this.algorithm);
        }
        theKey = this.generateKey(true);
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "engineGenerateKey");
        }
        return theKey;
    }

    protected SecretKey generateKey(boolean isExternalCall) {
        SecretKey theKey = null;
        if (debug != null) {
            debug.entry(16384L, (Object)hybridClassName, "generateKey", (Object)new String("isExternalCall = " + isExternalCall));
        }
        if (isExternalCall) {
            this.tableObjectReset = false;
            this.ExceptionHistory = new Vector();
        }
        try {
            theKey = this.theGenerator.generateKey();
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "generateKey", "Successful call to generateKey() in provider: " + this.theProvider);
            }
            this.ExceptionHistory = new Vector();
        }
        catch (IBMJCEHybridException ijhe) {
            throw ijhe;
        }
        catch (Exception ex) {
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "generateKey", ex.getMessage());
                debug.exception(16384L, (Object)hybridClassName, "generateKey", (Throwable)ex);
            }
            this.ExceptionHistory.addElement(ex);
            this.getGenerator();
            try {
                if (null != this.params) {
                    this.init(this.params, this.random, false);
                } else if (-1 < this.keysize) {
                    this.init(this.keysize, this.random, false);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            theKey = this.generateKey(false);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "generateKey");
        }
        return theKey;
    }

    protected void getGenerator() {
        if (debug != null) {
            debug.entry(16384L, (Object)hybridClassName, "getGenerator", (Object)new String(" " + this.algorithm + ", " + this.keysize + " "));
        }
        if (null != this.theGenerator) {
            TableObject tblObj = AlgorithmTable.getStateData(serviceType, this.algorithm);
            tblObj.invalidateProvider(this.theGenerator.getProvider().getName());
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "getGenerator", "Calling tblObj.invalidateProvider( " + this.theProvider + " ) for " + serviceType + " " + this.algorithm);
            }
        }
        try {
            this.theGenerator = this.getBestInstance(this.algorithm);
        }
        catch (IBMJCEHybridException ijhe) {
            throw ijhe;
        }
        catch (Exception e) {
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "getGenerator", e.getMessage());
                debug.exception(16384L, (Object)hybridClassName, "getGenerator", (Throwable)e);
            }
            this.ExceptionHistory.addElement(e);
            String ijheMsg = "Failover exhausted, all registered providers attempted and failed.";
            IBMJCEHybridException ijhe = new IBMJCEHybridException(ijheMsg, this.ExceptionHistory);
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "getGenerator", ijheMsg);
                debug.exception(16384L, (Object)hybridClassName, "getGenerator", (Throwable)ijhe);
                debug.exit(16384L, (Object)hybridClassName, "getGenerator");
            }
            throw ijhe;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "getGenerator");
        }
    }

    public KeyGenerator getBestInstance(String algorithm) {
        TableObject tblObj = null;
        if (debug != null) {
            debug.entry(16384L, (Object)hybridClassName, "getBestInstance", (Object)algorithm);
        }
        if (null == (tblObj = AlgorithmTable.getStateData(serviceType, this.algorithm))) {
            String ijheMessage = new String("KeyGenerator." + this.algorithm + " not found as a registered algorithm");
            IBMJCEHybridException ijhe = new IBMJCEHybridException(ijheMessage, this.ExceptionHistory);
            if (debug != null) {
                debug.exception(16384L, (Object)hybridClassName, "getBestInstance", (Throwable)ijhe);
                debug.text(16384L, (Object)hybridClassName, "getBestInstance", ijheMessage);
                debug.exit(16384L, (Object)hybridClassName, "getBestInstance");
            }
            throw ijhe;
        }
        this.theProvider = tblObj.getBestProvider();
        this.theGenerator = null;
        boolean notDone = true;
        while (notDone) {
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "getBestInstance", "Top of loop 1");
            }
            while (null == this.theGenerator && null != this.theProvider) {
                if (debug != null) {
                    debug.text(16384L, (Object)hybridClassName, "getBestInstance", "Top of loop 2");
                }
                try {
                    this.theGenerator = KeyGenerator.getInstance(this.algorithm, this.theProvider);
                    notDone = false;
                }
                catch (Exception ex) {
                    if (debug != null) {
                        debug.text(16384L, (Object)hybridClassName, "getBestInstance", ex.getMessage());
                        debug.exception(16384L, (Object)hybridClassName, "getBestInstance", (Throwable)ex);
                    }
                    this.ExceptionHistory.addElement(ex);
                    if (debug != null) {
                        debug.text(16384L, (Object)hybridClassName, "getBestInstance", "Exception thrown on KeyGenerator.getInstance(" + this.algorithm + ", " + this.theProvider + ") \n\t" + ex.getMessage());
                        debug.text(16384L, (Object)hybridClassName, "getBestInstance", "Calling tblObj.invalidateProvider() then tblObj.getBestProvider() for KeyGenerator " + this.algorithm);
                    }
                    if (null != this.theProvider) {
                        tblObj.invalidateProvider(this.theProvider);
                    }
                    this.theProvider = tblObj.getBestProvider();
                }
            }
            if (null != this.theGenerator) continue;
            if (this.tableObjectReset) {
                notDone = false;
                continue;
            }
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "getBestInstance", "Calling tblObj.doReset() for KeyGenerator," + this.algorithm + "provider list reset.");
            }
            tblObj.doReset();
            this.tableObjectReset = true;
            this.ExceptionHistory = new Vector();
            this.theProvider = tblObj.getBestProvider();
        }
        if (null != this.theGenerator) {
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "getBestInstance", "KeyGenerator " + this.algorithm + " obtained from provider: " + this.theProvider);
            }
        } else {
            String ijheMsg = "Failover exhausted, all registered providers attempted and failed.";
            IBMJCEHybridException ijhe = new IBMJCEHybridException(ijheMsg, this.ExceptionHistory);
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "getBestInstance", ijheMsg);
                debug.exception(16384L, (Object)hybridClassName, "getBestInstance", (Throwable)ijhe);
                debug.exit(16384L, (Object)hybridClassName, "getBestInstance");
            }
            throw ijhe;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "getBestInstance");
        }
        return this.theGenerator;
    }
}

