/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.crypto.ibmjcehybrid.provider;

import com.ibm.crypto.ibmjcehybrid.provider.AlgorithmTable;
import com.ibm.crypto.ibmjcehybrid.provider.IBMJCEHybridException;
import com.ibm.crypto.ibmjcehybrid.provider.TableObject;
import com.ibm.misc.Debug;
import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.AlgorithmParametersSpi;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import java.util.Vector;
import javax.crypto.NoSuchPaddingException;
import sun.security.util.ECKeySizeParameterSpec;

abstract class HybridAlgorithmParameters
extends AlgorithmParametersSpi {
    private AlgorithmParameters theParams = null;
    private static final String serviceType = "AlgorithmParameters";
    private String algorithm = null;
    private String theProvider = null;
    private AlgorithmParameterSpec paramSpec = null;
    private byte[] encoded = null;
    private String decodingMethod = null;
    private boolean tableObjectReset = false;
    private Vector<Exception> ExceptionHistory = new Vector();
    static Debug debug = Debug.getInstance((String)"ibmjcehybrid");
    private static final String hybridClassName = "com.ibm.crypto.ibmjcehybrid.provider.HybridAlgorithmParameters";

    public HybridAlgorithmParameters(String algorithm) {
        if (debug != null) {
            debug.entry(16384L, (Object)hybridClassName, "HybridAlgorithmParameters", (Object)algorithm);
        }
        this.algorithm = algorithm;
        this.tableObjectReset = false;
        AlgorithmTable algTbl = new AlgorithmTable();
        if (null == algTbl) {
            String rteMessage = new String("Internal error in AlgorithmTable class.");
            RuntimeException rte = new RuntimeException(rteMessage);
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "HybridAlgorithmParameters", rteMessage);
                debug.exception(16384L, (Object)hybridClassName, "HybridAlgorithmParameters", (Throwable)rte);
                debug.exit(16384L, (Object)hybridClassName, "HybridAlgorithmParameters");
            }
            throw new RuntimeException(rte);
        }
        try {
            this.getParams();
        }
        catch (Exception ex) {
            IBMJCEHybridException ijhe;
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "HybridAlgorithmParameters", ex.getMessage());
                debug.exception(16384L, (Object)hybridClassName, "HybridAlgorithmParameters", (Throwable)ex);
            }
            if (ex instanceof IBMJCEHybridException) {
                ijhe = (IBMJCEHybridException)ex;
            } else {
                this.ExceptionHistory.addElement(ex);
                ijhe = new IBMJCEHybridException(null, this.ExceptionHistory);
            }
            String rteMessage = new String("No provider found for AlgorithmParameters " + this.algorithm);
            RuntimeException rte = new RuntimeException(rteMessage, ijhe);
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "HybridAlgorithmParameters", rteMessage);
                debug.exception(16384L, (Object)hybridClassName, "HybridAlgorithmParameters", (Throwable)rte);
                debug.exit(16384L, (Object)hybridClassName, "HybridAlgorithmParameters");
            }
            throw new RuntimeException(rte);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "HybridAlgorithmParameters");
        }
    }

    @Override
    protected void engineInit(AlgorithmParameterSpec paramSpec) throws InvalidParameterSpecException {
        if (debug != null) {
            debug.entry(16384L, (Object)hybridClassName, "engineInit", (Object)paramSpec);
        }
        this.init(paramSpec, true);
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "engineInit");
        }
    }

    private void init(AlgorithmParameterSpec paramSpec, boolean isExternalCall) throws InvalidParameterSpecException {
        if (debug != null) {
            debug.entry(16384L, (Object)hybridClassName, "init", (Object)paramSpec, (Object)new Boolean(isExternalCall));
        }
        this.paramSpec = paramSpec;
        this.encoded = null;
        this.decodingMethod = null;
        if (isExternalCall) {
            this.tableObjectReset = false;
            this.ExceptionHistory = new Vector();
        }
        try {
            this.theParams.init(this.paramSpec);
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "init", "Successful call to init(paramSpec) in provider: " + this.theProvider);
            }
            this.ExceptionHistory = new Vector();
        }
        catch (IBMJCEHybridException ijhe) {
            throw ijhe;
        }
        catch (Exception ex) {
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "init", ex.getMessage());
                debug.exception(16384L, (Object)hybridClassName, "init", (Throwable)ex);
            }
            this.ExceptionHistory.addElement(ex);
            this.getParams();
            this.init(this.paramSpec, false);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "init");
        }
    }

    @Override
    protected void engineInit(byte[] encoded) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)hybridClassName, "engineInit");
        }
        this.init(encoded, true);
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "engineInit");
        }
    }

    private void init(byte[] encoded, boolean isExternalCall) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)hybridClassName, "init", (Object)new Boolean(isExternalCall));
        }
        this.paramSpec = null;
        this.encoded = (byte[])encoded.clone();
        this.decodingMethod = null;
        if (isExternalCall) {
            this.tableObjectReset = false;
            this.ExceptionHistory = new Vector();
        }
        try {
            this.theParams.init(this.encoded);
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "init", "Successful call to init(encoded) in provider: " + this.theProvider);
            }
            this.ExceptionHistory = new Vector();
        }
        catch (IBMJCEHybridException ijhe) {
            throw ijhe;
        }
        catch (Exception ex) {
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "init", ex.getMessage());
                debug.exception(16384L, (Object)hybridClassName, "init", (Throwable)ex);
            }
            this.ExceptionHistory.addElement(ex);
            this.getParams();
            this.init(this.encoded, false);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "init");
        }
    }

    @Override
    protected void engineInit(byte[] encoded, String decodingMethod) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)hybridClassName, "engineInit", (Object)decodingMethod);
        }
        this.init(encoded, decodingMethod, true);
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "engineInit");
        }
    }

    private void init(byte[] encoded, String decodingMethod, boolean isExternalCall) throws IOException {
        if (debug != null) {
            debug.entry(16384L, (Object)hybridClassName, "init", (Object)decodingMethod, (Object)new Boolean(isExternalCall));
        }
        this.paramSpec = null;
        this.encoded = (byte[])encoded.clone();
        this.decodingMethod = decodingMethod;
        if (isExternalCall) {
            this.tableObjectReset = false;
            this.ExceptionHistory = new Vector();
        }
        try {
            this.theParams.init(this.encoded, this.decodingMethod);
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "init", "Successful call to init(encoded,decodingMethod) in provider: " + this.theProvider);
            }
            this.ExceptionHistory = new Vector();
        }
        catch (IBMJCEHybridException ijhe) {
            throw ijhe;
        }
        catch (Exception ex) {
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "init", ex.getMessage());
                debug.exception(16384L, (Object)hybridClassName, "init", (Throwable)ex);
            }
            this.ExceptionHistory.addElement(ex);
            this.getParams();
            this.init(this.encoded, this.decodingMethod, false);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "init");
        }
    }

    protected AlgorithmParameterSpec engineGetParameterSpec(Class paramSpecClass) throws InvalidParameterSpecException {
        AlgorithmParameterSpec result = null;
        if (debug != null) {
            debug.entry(16384L, (Object)hybridClassName, "engineGetParameterSpec", (Object)paramSpecClass.getName());
        }
        if (ECKeySizeParameterSpec.class.isAssignableFrom(paramSpecClass)) {
            throw new InvalidParameterSpecException("ECKeySizeParameterSpec is not supported");
        }
        result = this.getParameterSpec(paramSpecClass, true);
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "engineGetParameterSpec");
        }
        return result;
    }

    private AlgorithmParameterSpec getParameterSpec(Class<AlgorithmParameterSpec> paramSpecClass, boolean isExternalCall) throws InvalidParameterSpecException {
        AlgorithmParameterSpec result = null;
        if (debug != null) {
            debug.entry(16384L, (Object)hybridClassName, "getParameterSpec", (Object)paramSpecClass.getName(), (Object)new Boolean(isExternalCall));
        }
        if (isExternalCall) {
            this.tableObjectReset = false;
            this.ExceptionHistory = new Vector();
        }
        try {
            result = this.theParams.getParameterSpec(paramSpecClass);
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "getParameterSpec", "Successful call to getParameterSpec(paramSpecClass) in provider: " + this.theProvider);
            }
            this.ExceptionHistory = new Vector();
        }
        catch (IBMJCEHybridException ijhe) {
            throw ijhe;
        }
        catch (Exception ex) {
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "getParameterSpec", ex.getMessage());
                debug.exception(16384L, (Object)hybridClassName, "getParameterSpec", (Throwable)ex);
            }
            this.ExceptionHistory.addElement(ex);
            this.getParams();
            this.initializeParameterSpec();
            result = this.getParameterSpec(paramSpecClass, false);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "getParameterSpec");
        }
        return result;
    }

    @Override
    protected byte[] engineGetEncoded() throws IOException {
        byte[] result = null;
        if (debug != null) {
            debug.entry(16384L, (Object)hybridClassName, "engineGetEncoded");
        }
        result = this.getEncoded(true);
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "engineGetEncoded");
        }
        return result;
    }

    private byte[] getEncoded(boolean isExternalCall) throws IOException {
        byte[] result = null;
        if (debug != null) {
            debug.entry(16384L, (Object)hybridClassName, "getEncoded", (Object)new Boolean(isExternalCall));
        }
        if (isExternalCall) {
            this.tableObjectReset = false;
            this.ExceptionHistory = new Vector();
        }
        try {
            result = this.theParams.getEncoded();
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "getEncoded", "Successful call to getEncoded() in provider: " + this.theProvider);
            }
            this.ExceptionHistory = new Vector();
        }
        catch (IBMJCEHybridException ijhe) {
            throw ijhe;
        }
        catch (Exception ex) {
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "getEncoded", ex.getMessage());
                debug.exception(16384L, (Object)hybridClassName, "getEncoded", (Throwable)ex);
            }
            this.ExceptionHistory.addElement(ex);
            this.getParams();
            result = this.getEncoded(false);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "getEncoded");
        }
        return result;
    }

    @Override
    protected byte[] engineGetEncoded(String encodingMethod) throws IOException {
        byte[] result = null;
        if (debug != null) {
            debug.entry(16384L, (Object)hybridClassName, "engineGetEncoded", (Object)encodingMethod);
        }
        result = this.getEncoded(encodingMethod, true);
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "engineGetEncoded");
        }
        return result;
    }

    private byte[] getEncoded(String encodingMethod, boolean isExternalCall) throws IOException {
        byte[] result = null;
        if (debug != null) {
            debug.entry(16384L, (Object)hybridClassName, "getEncoded", (Object)encodingMethod, (Object)new Boolean(isExternalCall));
        }
        if (isExternalCall) {
            this.tableObjectReset = false;
            this.ExceptionHistory = new Vector();
        }
        try {
            result = this.theParams.getEncoded(encodingMethod);
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "getEncoded", "Successful call to getEncoded(encodingMethod) in provider: " + this.theProvider);
            }
            this.ExceptionHistory = new Vector();
        }
        catch (IBMJCEHybridException ijhe) {
            throw ijhe;
        }
        catch (Exception ex) {
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "getEncoded", ex.getMessage());
                debug.exception(16384L, (Object)hybridClassName, "getEncoded", (Throwable)ex);
            }
            this.ExceptionHistory.addElement(ex);
            this.getParams();
            result = this.getEncoded(encodingMethod, false);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "getEncoded");
        }
        return result;
    }

    @Override
    protected String engineToString() {
        String result = null;
        if (debug != null) {
            debug.entry(16384L, (Object)hybridClassName, "engineToString");
        }
        result = this.toString(true);
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "engineToString");
        }
        return result;
    }

    protected String toString(boolean isExternalCall) {
        String result = null;
        if (debug != null) {
            debug.entry(16384L, (Object)hybridClassName, "toString", (Object)new Boolean(isExternalCall));
        }
        if (isExternalCall) {
            this.tableObjectReset = false;
            this.ExceptionHistory = new Vector();
        }
        try {
            result = this.theParams.toString();
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "toString", "Successful call to toString() in provider: " + this.theProvider);
            }
            this.ExceptionHistory = new Vector();
        }
        catch (IBMJCEHybridException ijhe) {
            throw ijhe;
        }
        catch (Exception ex) {
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "toString", ex.getMessage());
                debug.exception(16384L, (Object)hybridClassName, "toString", (Throwable)ex);
            }
            this.ExceptionHistory.addElement(ex);
            this.getParams();
            result = this.toString(false);
        }
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "toString");
        }
        return result;
    }

    private void getParams() {
        if (debug != null) {
            debug.entry(16384L, (Object)hybridClassName, "getParams", (Object)this.algorithm);
        }
        if (null != this.theParams) {
            TableObject tblObj = AlgorithmTable.getStateData(serviceType, this.algorithm);
            tblObj.invalidateProvider(this.theParams.getProvider().getName());
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "getParams", "Calling tblObj.invalidateProvider( " + this.theProvider + " ) for " + serviceType + " " + this.algorithm);
            }
        }
        try {
            this.theParams = this.getBestInstance();
        }
        catch (IBMJCEHybridException ijhe) {
            throw ijhe;
        }
        catch (Exception e) {
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "getParams", e.getMessage());
                debug.exception(16384L, (Object)hybridClassName, "getParams", (Throwable)e);
            }
            this.ExceptionHistory.addElement(e);
            String ijheMsg = "Failover exhausted, all registered providers attempted and failed.";
            IBMJCEHybridException ijhe = new IBMJCEHybridException(ijheMsg, this.ExceptionHistory);
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "getParams", ijheMsg);
                debug.exception(16384L, (Object)hybridClassName, "getParams", (Throwable)ijhe);
                debug.exit(16384L, (Object)hybridClassName, "getParams");
            }
            throw ijhe;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "getParams");
        }
    }

    private AlgorithmParameters getBestInstance() throws NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException {
        TableObject tblObj = null;
        if (debug != null) {
            debug.entry(16384L, (Object)hybridClassName, "getBestInstance", (Object)this.algorithm);
        }
        if (null == (tblObj = AlgorithmTable.getStateData(serviceType, this.algorithm))) {
            String ijheMessage = new String("AlgorithmParameters." + this.algorithm + " not found as a registered algorithm");
            IBMJCEHybridException ijhe = new IBMJCEHybridException(ijheMessage, this.ExceptionHistory);
            if (debug != null) {
                debug.exception(16384L, (Object)hybridClassName, "getBestInstance", (Throwable)ijhe);
                debug.text(16384L, (Object)hybridClassName, "getBestInstance", ijheMessage);
                debug.exit(16384L, (Object)hybridClassName, "getBestInstance");
            }
            throw ijhe;
        }
        this.theProvider = tblObj.getBestProvider();
        this.theParams = null;
        boolean notDone = true;
        while (notDone) {
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "getBestInstance", "Top of loop 1");
            }
            while (null == this.theParams && null != this.theProvider) {
                if (debug != null) {
                    debug.text(16384L, (Object)hybridClassName, "getBestInstance", "Top of loop 2");
                }
                try {
                    this.theParams = AlgorithmParameters.getInstance(this.algorithm, this.theProvider);
                    notDone = false;
                }
                catch (Exception ex) {
                    if (debug != null) {
                        debug.text(16384L, (Object)hybridClassName, "getBestInstance", ex.getMessage());
                        debug.exception(16384L, (Object)hybridClassName, "getBestInstance", (Throwable)ex);
                    }
                    this.ExceptionHistory.addElement(ex);
                    if (debug != null) {
                        debug.text(16384L, (Object)hybridClassName, "getBestInstance", "Exception thrown on AlgorithmParameters.getInstance(" + this.algorithm + ", " + this.theProvider + ") \n\t" + ex.getMessage());
                        debug.text(16384L, (Object)hybridClassName, "getBestInstance", "Calling tblObj.invalidateProvider() then tblObj.getBestProvider() for AlgorithmParameters " + this.algorithm);
                    }
                    if (null != this.theProvider) {
                        tblObj.invalidateProvider(this.theProvider);
                    }
                    this.theProvider = tblObj.getBestProvider();
                }
            }
            if (null != this.theParams) continue;
            if (this.tableObjectReset) {
                notDone = false;
                continue;
            }
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "getBestInstance", "Calling tblObj.doReset() for AlgorithmParameters," + this.algorithm + "provider list reset.");
            }
            tblObj.doReset();
            this.tableObjectReset = true;
            this.ExceptionHistory = new Vector();
            this.theProvider = tblObj.getBestProvider();
        }
        if (null != this.theParams) {
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "getBestInstance", "AlgorithmParameters for " + this.algorithm + " obtained from provider: " + this.theProvider);
            }
        } else {
            String ijheMsg = "Failover exhausted, all registered providers attempted and failed.";
            IBMJCEHybridException ijhe = new IBMJCEHybridException(ijheMsg, this.ExceptionHistory);
            if (debug != null) {
                debug.text(16384L, (Object)hybridClassName, "getBestInstance", ijheMsg);
                debug.exception(16384L, (Object)hybridClassName, "getBestInstance", (Throwable)ijhe);
                debug.exit(16384L, (Object)hybridClassName, "getBestInstance");
            }
            throw ijhe;
        }
        if (debug != null) {
            debug.exit(16384L, (Object)hybridClassName, "getBestInstance");
        }
        return this.theParams;
    }

    private void initializeParameterSpec() throws InvalidParameterSpecException {
        if (this.theParams != null && this.theParams.getAlgorithm().equals("EC") && this.paramSpec != null) {
            this.theParams.init(this.paramSpec);
        }
    }
}

