/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zertjsse;

import com.ibm.zertjsse.Debug;
import com.ibm.zertjsse.Role;
import com.ibm.zertjsse.ZERTCertificateUtils;
import com.ibm.zertjsse.ZERTCipherInformation;
import com.ibm.zertjsse.ZERTHandshakeCompletedListener;
import com.ibm.zertjsse.ZERTInputStream;
import com.ibm.zertjsse.ZERTOutputStream;
import com.ibm.zos.net.SiocSSecattr;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.SocketChannel;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;

class ZERTSSLSocketImpl
extends SSLSocket {
    private static Debug debug = Debug.getInstance("zertjsse");
    private static final String className = "com.ibm.zertjsse.ZERTSSLSocketImpl";
    private SSLSocket sslSocket = null;
    private Socket socket = null;
    private Field sslSessionField = null;
    private boolean initialHandshakeCompleted = false;
    private SiocSSecattr.Status zERTStatus = SiocSSecattr.Status.SECATTR_DISABLED;

    public ZERTSSLSocketImpl(SSLSocket sslSocket) {
        this(sslSocket, null);
    }

    public ZERTSSLSocketImpl(SSLSocket sslSocket, Socket socket) {
        String methodName = "ZERTSSLSocketImpl";
        Debug.traceEntry(debug, className, methodName, sslSocket, socket);
        if (debug != null) {
            SiocSSecattr.getLogger().setLevel(Level.INFO);
        } else {
            SiocSSecattr.getLogger().setLevel(Level.OFF);
        }
        this.sslSocket = sslSocket;
        this.socket = socket;
        this.queryzERT();
        try {
            this.addHandshakeCompletedListener(new ZERTHandshakeCompletedListener(this));
        }
        catch (Exception e) {
            Debug.traceText(debug, className, methodName, "Unable to add ZERTHandshakeCompletedListener, zERT will not be notified of handshake completion events");
            Debug.traceException(debug, className, methodName, e);
        }
        this.initSSLSessionField();
        Debug.traceExit(debug, className, methodName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initSSLSessionField() {
        String methodName = "initSSLSessionField";
        Debug.traceEntry(debug, className, methodName);
        ArrayList<Exception> exceptions = new ArrayList<Exception>();
        Field[] fields = this.sslSocket.getClass().getDeclaredFields();
        for (Field field : fields) {
            boolean needsReset = false;
            try {
                if (Modifier.isPrivate(field.getModifiers())) {
                    field.setAccessible(true);
                    needsReset = true;
                }
                if (!(field.get(this.sslSocket) instanceof SSLSession)) continue;
                this.setSSLSessionField(field);
                break;
            }
            catch (Exception e) {
                exceptions.add(e);
            }
            finally {
                try {
                    if (needsReset) {
                        field.setAccessible(false);
                    }
                }
                catch (Exception exception) {}
            }
        }
        if (this.getSSLSessionField() == null) {
            Debug.traceText(debug, className, methodName, "We were unable to instantiate the sslSessionField. Here are the exceptions that we encountered:");
            for (Exception e : exceptions) {
                Debug.traceException(debug, className, methodName, e);
            }
        }
        Debug.traceExit(debug, className, methodName);
    }

    private Field getSSLSessionField() {
        String methodName = "getSSLSessionField";
        Debug.traceEntry(debug, className, methodName);
        Debug.traceExit(debug, className, methodName, this.sslSessionField);
        return this.sslSessionField;
    }

    private void setSSLSessionField(Field field) {
        String methodName = "setSSLSessionField";
        Debug.traceEntry(debug, className, methodName, field);
        this.sslSessionField = field;
        Debug.traceExit(debug, className, methodName);
    }

    protected boolean getInitialHandshakeCompleted() {
        String methodName = "getInitialHandshakeCompleted";
        Debug.traceEntry(debug, className, methodName);
        Debug.traceExit(debug, className, methodName, this.initialHandshakeCompleted);
        return this.initialHandshakeCompleted;
    }

    protected void setInitialHandshakeCompleted(boolean completed) {
        String methodName = "setInitialHandshakeCompleted";
        Debug.traceEntry(debug, className, methodName, completed);
        this.initialHandshakeCompleted = completed;
        Debug.traceExit(debug, className, methodName);
    }

    protected SiocSSecattr.Status getzERTStatus() {
        String methodName = "getzERTStatus";
        Debug.traceEntry(debug, className, methodName);
        Debug.traceExit(debug, className, methodName, this.zERTStatus);
        return this.zERTStatus;
    }

    protected void setzERTStatus(SiocSSecattr.Status status) {
        String methodName = "setzERTStatus";
        Debug.traceEntry(debug, className, methodName, status);
        this.zERTStatus = status;
        Debug.traceExit(debug, className, methodName);
    }

    @Override
    public void addHandshakeCompletedListener(HandshakeCompletedListener listener) {
        String methodName = "addHandshakeCompletedListener";
        Debug.traceEntry(debug, className, methodName, listener);
        try {
            this.sslSocket.addHandshakeCompletedListener(listener);
        }
        catch (Exception e) {
            Debug.traceException(debug, className, methodName, e);
            Debug.traceExit(debug, className, methodName);
            throw e;
        }
        Debug.traceExit(debug, className, methodName);
    }

    @Override
    public String[] getEnabledCipherSuites() {
        String methodName = "getEnabledCipherSuites";
        Debug.traceEntry(debug, className, methodName);
        String[] suites = null;
        try {
            suites = this.sslSocket.getEnabledCipherSuites();
        }
        catch (Exception e) {
            Debug.traceException(debug, className, methodName, e);
            Debug.traceExit(debug, className, methodName);
            throw e;
        }
        Debug.traceExit(debug, className, methodName, suites);
        return suites;
    }

    @Override
    public String[] getEnabledProtocols() {
        String methodName = "getEnabledProtocols";
        Debug.traceEntry(debug, className, methodName);
        String[] protocols = null;
        try {
            protocols = this.sslSocket.getEnabledProtocols();
        }
        catch (Exception e) {
            Debug.traceException(debug, className, methodName, e);
            Debug.traceExit(debug, className, methodName);
            throw e;
        }
        Debug.traceExit(debug, className, methodName, protocols);
        return protocols;
    }

    @Override
    public boolean getEnableSessionCreation() {
        String methodName = "getEnableSessionCreation";
        Debug.traceEntry(debug, className, methodName);
        boolean enableSessionsCreation = false;
        try {
            enableSessionsCreation = this.sslSocket.getEnableSessionCreation();
        }
        catch (Exception e) {
            Debug.traceException(debug, className, methodName, e);
            Debug.traceExit(debug, className, methodName);
            throw e;
        }
        Debug.traceExit(debug, className, methodName, enableSessionsCreation);
        return enableSessionsCreation;
    }

    @Override
    public SSLSession getHandshakeSession() {
        String methodName = "getHandshakeSession";
        Debug.traceEntry(debug, className, methodName);
        SSLSession session = null;
        try {
            session = this.sslSocket.getHandshakeSession();
        }
        catch (Exception e) {
            Debug.traceException(debug, className, methodName, e);
            Debug.traceExit(debug, className, methodName);
            throw e;
        }
        Debug.traceExit(debug, className, methodName, session);
        return session;
    }

    @Override
    public boolean getNeedClientAuth() {
        String methodName = "getNeedClientAuth";
        Debug.traceEntry(debug, className, methodName);
        boolean needClientAuth = false;
        try {
            needClientAuth = this.sslSocket.getNeedClientAuth();
        }
        catch (Exception e) {
            Debug.traceException(debug, className, methodName, e);
            Debug.traceExit(debug, className, methodName);
            throw e;
        }
        Debug.traceExit(debug, className, methodName, needClientAuth);
        return needClientAuth;
    }

    @Override
    public SSLSession getSession() {
        String methodName = "getSession";
        Debug.traceEntry(debug, className, methodName);
        SSLSession session = null;
        try {
            session = this.sslSocket.getSession();
            if (session.equals("SSL_NULL_WITH_NULL_NULL")) {
                this.notifyzERTInitialHandshakeFailure();
            }
        }
        catch (Exception e) {
            Debug.traceException(debug, className, methodName, e);
            Debug.traceExit(debug, className, methodName);
            throw e;
        }
        this.notifyzERTHandshakePossible();
        Debug.traceExit(debug, className, methodName, session);
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SSLSession getSessionZERT() {
        String methodName = "getSessionZERT";
        Debug.traceEntry(debug, className, methodName);
        SSLSession session = null;
        boolean needsReset = false;
        Field field = this.getSSLSessionField();
        if (field == null) {
            Debug.traceText(debug, className, methodName, "We were unable to get an SSLSession because the sslSessionField was not initialized. This is most likely a security issue.");
            Debug.traceExit(debug, className, methodName, session);
            return session;
        }
        try {
            if (Modifier.isPrivate(field.getModifiers())) {
                field.setAccessible(true);
                needsReset = true;
            }
            field.setAccessible(true);
            session = (SSLSession)field.get(this.sslSocket);
        }
        catch (Exception e) {
            Debug.traceText(debug, className, methodName, "We were unable to get an SSLSession via reflection. This is most likely a security issue.");
            Debug.traceException(debug, className, methodName, e);
        }
        finally {
            if (needsReset) {
                try {
                    field.setAccessible(false);
                }
                catch (Exception exception) {}
            }
        }
        Debug.traceExit(debug, className, methodName, session);
        return session;
    }

    @Override
    public String[] getSupportedCipherSuites() {
        String methodName = "getSupportedCipherSuites";
        Debug.traceEntry(debug, className, methodName);
        String[] suites = null;
        try {
            suites = this.sslSocket.getSupportedCipherSuites();
        }
        catch (Exception e) {
            Debug.traceException(debug, className, methodName, e);
            Debug.traceExit(debug, className, methodName);
            throw e;
        }
        Debug.traceExit(debug, className, methodName, suites);
        return suites;
    }

    @Override
    public String[] getSupportedProtocols() {
        String methodName = "getSupportedProtocols";
        Debug.traceEntry(debug, className, methodName);
        String[] protocols = null;
        try {
            protocols = this.sslSocket.getSupportedProtocols();
        }
        catch (Exception e) {
            Debug.traceException(debug, className, methodName, e);
            Debug.traceExit(debug, className, methodName);
            throw e;
        }
        Debug.traceExit(debug, className, methodName, protocols);
        return protocols;
    }

    @Override
    public boolean getUseClientMode() {
        String methodName = "getUseClientMode";
        Debug.traceEntry(debug, className, methodName);
        boolean useClientMode = false;
        try {
            useClientMode = this.sslSocket.getUseClientMode();
        }
        catch (Exception e) {
            Debug.traceException(debug, className, methodName, e);
            Debug.traceExit(debug, className, methodName);
            throw e;
        }
        Debug.traceExit(debug, className, methodName, useClientMode);
        return useClientMode;
    }

    @Override
    public boolean getWantClientAuth() {
        String methodName = "getWantClientAuth";
        Debug.traceEntry(debug, className, methodName);
        boolean wantClientAuth = false;
        try {
            wantClientAuth = this.sslSocket.getWantClientAuth();
        }
        catch (Exception e) {
            Debug.traceException(debug, className, methodName, e);
            Debug.traceExit(debug, className, methodName);
            throw e;
        }
        Debug.traceExit(debug, className, methodName, wantClientAuth);
        return wantClientAuth;
    }

    @Override
    public void removeHandshakeCompletedListener(HandshakeCompletedListener listener) {
        String methodName = "removeHandshakeCompletedListener";
        Debug.traceEntry(debug, className, methodName, listener);
        try {
            this.sslSocket.removeHandshakeCompletedListener(listener);
        }
        catch (Exception e) {
            Debug.traceException(debug, className, methodName, e);
            Debug.traceExit(debug, className, methodName);
            throw e;
        }
        Debug.traceExit(debug, className, methodName);
    }

    @Override
    public void setEnabledCipherSuites(String[] suites) {
        String methodName = "setEnabledCipherSuites";
        Debug.traceEntry(debug, className, methodName, suites);
        try {
            this.sslSocket.setEnabledCipherSuites(suites);
        }
        catch (Exception e) {
            Debug.traceException(debug, className, methodName, e);
            Debug.traceExit(debug, className, methodName);
            throw e;
        }
        Debug.traceExit(debug, className, methodName);
    }

    @Override
    public void setEnabledProtocols(String[] protocols) {
        String methodName = "setEnabledProtocols";
        Debug.traceEntry(debug, className, methodName, protocols);
        try {
            this.sslSocket.setEnabledProtocols(protocols);
        }
        catch (Exception e) {
            Debug.traceException(debug, className, methodName, e);
            Debug.traceExit(debug, className, methodName);
            throw e;
        }
        Debug.traceExit(debug, className, methodName);
    }

    @Override
    public void setEnableSessionCreation(boolean flag) {
        String methodName = "setEnableSessionCreation";
        Debug.traceEntry(debug, className, methodName, flag);
        try {
            this.sslSocket.setEnableSessionCreation(flag);
        }
        catch (Exception e) {
            Debug.traceException(debug, className, methodName, e);
            Debug.traceExit(debug, className, methodName);
            throw e;
        }
        Debug.traceExit(debug, className, methodName);
    }

    @Override
    public void setNeedClientAuth(boolean need) {
        String methodName = "setNeedClientAuth";
        Debug.traceEntry(debug, className, methodName, need);
        try {
            this.sslSocket.setNeedClientAuth(need);
        }
        catch (Exception e) {
            Debug.traceException(debug, className, methodName, e);
            Debug.traceExit(debug, className, methodName);
            throw e;
        }
        Debug.traceExit(debug, className, methodName);
    }

    @Override
    public void setUseClientMode(boolean mode) {
        String methodName = "setUseClientMode";
        Debug.traceEntry(debug, className, methodName, mode);
        try {
            this.sslSocket.setUseClientMode(mode);
        }
        catch (Exception e) {
            Debug.traceException(debug, className, methodName, e);
            Debug.traceExit(debug, className, methodName);
            throw e;
        }
        Debug.traceExit(debug, className, methodName);
    }

    @Override
    public void setWantClientAuth(boolean want) {
        String methodName = "setWantClientAuth";
        Debug.traceEntry(debug, className, methodName, want);
        try {
            this.sslSocket.setWantClientAuth(want);
        }
        catch (Exception e) {
            Debug.traceException(debug, className, methodName, e);
            Debug.traceExit(debug, className, methodName);
            throw e;
        }
        Debug.traceExit(debug, className, methodName);
    }

    @Override
    public void startHandshake() throws IOException {
        String methodName = "startHandshake";
        Debug.traceEntry(debug, className, methodName);
        try {
            this.sslSocket.startHandshake();
        }
        catch (InterruptedIOException e) {
            Debug.traceException(debug, className, methodName, e);
            Debug.traceExit(debug, className, methodName);
            throw e;
        }
        catch (IOException e) {
            Debug.traceException(debug, className, methodName, e);
            this.notifyzERTFailure();
            Debug.traceExit(debug, className, methodName);
            throw e;
        }
        catch (Exception e) {
            Debug.traceException(debug, className, methodName, e);
            Debug.traceExit(debug, className, methodName);
            throw e;
        }
        this.notifyzERTHandshakePossible();
        Debug.traceExit(debug, className, methodName);
    }

    @Override
    public SSLParameters getSSLParameters() {
        String methodName = "getSSLParameters";
        Debug.traceEntry(debug, className, methodName);
        SSLParameters params = null;
        try {
            params = this.sslSocket.getSSLParameters();
        }
        catch (Exception e) {
            Debug.traceException(debug, className, methodName, e);
            Debug.traceExit(debug, className, methodName);
            throw e;
        }
        Debug.traceExit(debug, className, methodName, params);
        return params;
    }

    @Override
    public void setSSLParameters(SSLParameters params) throws IllegalArgumentException {
        String methodName = "setSSLParameters";
        Debug.traceEntry(debug, className, methodName, params);
        try {
            this.sslSocket.setSSLParameters(params);
        }
        catch (Exception e) {
            Debug.traceException(debug, className, methodName, e);
            Debug.traceExit(debug, className, methodName);
            throw e;
        }
        Debug.traceExit(debug, className, methodName);
    }

    @Override
    public void bind(SocketAddress bindpoint) throws IOException {
        String methodName = "bind";
        Debug.traceEntry(debug, className, methodName, bindpoint);
        try {
            this.sslSocket.bind(bindpoint);
        }
        catch (Exception e) {
            Debug.traceException(debug, className, methodName, e);
            Debug.traceExit(debug, className, methodName);
            throw e;
        }
        Debug.traceExit(debug, className, methodName);
    }

    @Override
    public void close() throws IOException {
        String methodName = "close";
        Debug.traceEntry(debug, className, methodName);
        try {
            this.notifyzERTRenegotiation();
            this.sslSocket.close();
        }
        catch (Exception e) {
            Debug.traceException(debug, className, methodName, e);
            Debug.traceExit(debug, className, methodName);
            throw e;
        }
        finally {
            this.notifyzERTTermination();
        }
        Debug.traceExit(debug, className, methodName);
    }

    @Override
    public void connect(SocketAddress endpoint) throws IOException {
        String methodName = "connect";
        Debug.traceEntry(debug, className, methodName, endpoint);
        try {
            this.sslSocket.connect(endpoint);
        }
        catch (Exception e) {
            Debug.traceException(debug, className, methodName, e);
            Debug.traceExit(debug, className, methodName);
            throw e;
        }
        Debug.traceExit(debug, className, methodName);
    }

    @Override
    public void connect(SocketAddress endpoint, int timeout) throws IOException {
        String methodName = "connect";
        Debug.traceEntry(debug, className, methodName, endpoint, timeout);
        try {
            this.sslSocket.connect(endpoint, timeout);
        }
        catch (Exception e) {
            Debug.traceException(debug, className, methodName, e);
            Debug.traceExit(debug, className, methodName);
            throw e;
        }
        Debug.traceExit(debug, className, methodName);
    }

    @Override
    public SocketChannel getChannel() {
        String methodName = "getChannel";
        Debug.traceEntry(debug, className, methodName);
        SocketChannel channel = null;
        try {
            channel = this.sslSocket.getChannel();
        }
        catch (Exception e) {
            Debug.traceException(debug, className, methodName, e);
            Debug.traceExit(debug, className, methodName);
            throw e;
        }
        Debug.traceExit(debug, className, methodName, channel);
        return channel;
    }

    @Override
    public InetAddress getInetAddress() {
        String methodName = "getInetAddress";
        Debug.traceEntry(debug, className, methodName);
        InetAddress address = null;
        try {
            address = this.sslSocket.getInetAddress();
        }
        catch (Exception e) {
            Debug.traceException(debug, className, methodName, e);
            Debug.traceExit(debug, className, methodName);
            throw e;
        }
        Debug.traceExit(debug, className, methodName, address);
        return address;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        String methodName = "getInputStream";
        Debug.traceEntry(debug, className, methodName);
        ZERTInputStream iStream = null;
        try {
            iStream = new ZERTInputStream(this.sslSocket.getInputStream(), this);
        }
        catch (Exception e) {
            Debug.traceException(debug, className, methodName, e);
            Debug.traceExit(debug, className, methodName);
            throw e;
        }
        Debug.traceExit(debug, className, methodName, iStream);
        return iStream;
    }

    @Override
    public boolean getKeepAlive() throws SocketException {
        String methodName = "getKeepAlive";
        Debug.traceEntry(debug, className, methodName);
        boolean keepAlive = false;
        try {
            keepAlive = this.sslSocket.getKeepAlive();
        }
        catch (Exception e) {
            Debug.traceException(debug, className, methodName, e);
            Debug.traceExit(debug, className, methodName);
            throw e;
        }
        Debug.traceExit(debug, className, methodName, keepAlive);
        return keepAlive;
    }

    @Override
    public InetAddress getLocalAddress() {
        String methodName = "getLocalAddress";
        Debug.traceEntry(debug, className, methodName);
        InetAddress address = null;
        try {
            address = this.sslSocket.getLocalAddress();
        }
        catch (Exception e) {
            Debug.traceException(debug, className, methodName, e);
            Debug.traceExit(debug, className, methodName);
            throw e;
        }
        Debug.traceExit(debug, className, methodName, address);
        return address;
    }

    @Override
    public int getLocalPort() {
        String methodName = "getLocalPort";
        Debug.traceEntry(debug, className, methodName);
        int port = 0;
        try {
            port = this.sslSocket.getLocalPort();
        }
        catch (Exception e) {
            Debug.traceException(debug, className, methodName, e);
            Debug.traceExit(debug, className, methodName);
            throw e;
        }
        Debug.traceExit(debug, className, methodName, port);
        return port;
    }

    @Override
    public SocketAddress getLocalSocketAddress() {
        String methodName = "getLocalSocketAddress";
        Debug.traceEntry(debug, className, methodName);
        SocketAddress address = null;
        try {
            address = this.sslSocket.getLocalSocketAddress();
        }
        catch (Exception e) {
            Debug.traceException(debug, className, methodName, e);
            Debug.traceExit(debug, className, methodName);
            throw e;
        }
        Debug.traceExit(debug, className, methodName, address);
        return address;
    }

    @Override
    public boolean getOOBInline() throws SocketException {
        String methodName = "getOOBInline";
        Debug.traceEntry(debug, className, methodName);
        boolean on = false;
        try {
            on = this.sslSocket.getOOBInline();
        }
        catch (Exception e) {
            Debug.traceException(debug, className, methodName, e);
            Debug.traceExit(debug, className, methodName);
            throw e;
        }
        Debug.traceExit(debug, className, methodName, on);
        return on;
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        String methodName = "getOutputStream";
        Debug.traceEntry(debug, className, methodName);
        ZERTOutputStream oStream = null;
        try {
            oStream = new ZERTOutputStream(this.sslSocket.getOutputStream(), this);
        }
        catch (Exception e) {
            Debug.traceException(debug, className, methodName, e);
            Debug.traceExit(debug, className, methodName);
            throw e;
        }
        Debug.traceExit(debug, className, methodName, oStream);
        return oStream;
    }

    @Override
    public int getPort() {
        String methodName = "getPort";
        Debug.traceEntry(debug, className, methodName);
        int port = 0;
        try {
            port = this.sslSocket.getPort();
        }
        catch (Exception e) {
            Debug.traceException(debug, className, methodName, e);
            Debug.traceExit(debug, className, methodName);
            throw e;
        }
        Debug.traceExit(debug, className, methodName, port);
        return port;
    }

    @Override
    public int getReceiveBufferSize() throws SocketException {
        String methodName = "getReceiveBufferSize";
        Debug.traceEntry(debug, className, methodName);
        int size = 0;
        try {
            size = this.sslSocket.getReceiveBufferSize();
        }
        catch (Exception e) {
            Debug.traceException(debug, className, methodName, e);
            Debug.traceExit(debug, className, methodName);
            throw e;
        }
        Debug.traceExit(debug, className, methodName, size);
        return size;
    }

    @Override
    public SocketAddress getRemoteSocketAddress() {
        String methodName = "getRemoteSocketAddress";
        Debug.traceEntry(debug, className, methodName);
        SocketAddress address = null;
        try {
            address = this.sslSocket.getRemoteSocketAddress();
        }
        catch (Exception e) {
            Debug.traceException(debug, className, methodName, e);
            Debug.traceExit(debug, className, methodName);
            throw e;
        }
        Debug.traceExit(debug, className, methodName, address);
        return address;
    }

    @Override
    public boolean getReuseAddress() throws SocketException {
        String methodName = "getReuseAddress";
        Debug.traceEntry(debug, className, methodName);
        boolean reUseAddress = false;
        try {
            reUseAddress = this.sslSocket.getReuseAddress();
        }
        catch (Exception e) {
            Debug.traceException(debug, className, methodName, e);
            Debug.traceExit(debug, className, methodName);
            throw e;
        }
        Debug.traceExit(debug, className, methodName, reUseAddress);
        return reUseAddress;
    }

    @Override
    public int getSendBufferSize() throws SocketException {
        String methodName = "getSendBufferSize";
        Debug.traceEntry(debug, className, methodName);
        int size = 0;
        try {
            size = this.sslSocket.getSendBufferSize();
        }
        catch (Exception e) {
            Debug.traceException(debug, className, methodName, e);
            Debug.traceExit(debug, className, methodName);
            throw e;
        }
        Debug.traceExit(debug, className, methodName, size);
        return size;
    }

    @Override
    public int getSoLinger() throws SocketException {
        String methodName = "getSoLinger";
        Debug.traceEntry(debug, className, methodName);
        int linger = 0;
        try {
            linger = this.sslSocket.getSoLinger();
        }
        catch (Exception e) {
            Debug.traceException(debug, className, methodName, e);
            Debug.traceExit(debug, className, methodName);
            throw e;
        }
        Debug.traceExit(debug, className, methodName, linger);
        return linger;
    }

    @Override
    public int getSoTimeout() throws SocketException {
        String methodName = "getSoTimeout";
        Debug.traceEntry(debug, className, methodName);
        int timeout = 0;
        try {
            timeout = this.sslSocket.getSoTimeout();
        }
        catch (Exception e) {
            Debug.traceException(debug, className, methodName, e);
            Debug.traceExit(debug, className, methodName);
            throw e;
        }
        Debug.traceExit(debug, className, methodName, timeout);
        return timeout;
    }

    @Override
    public boolean getTcpNoDelay() throws SocketException {
        String methodName = "getTcpNoDelay";
        Debug.traceEntry(debug, className, methodName);
        boolean on = false;
        try {
            on = this.sslSocket.getTcpNoDelay();
        }
        catch (Exception e) {
            Debug.traceException(debug, className, methodName, e);
            Debug.traceExit(debug, className, methodName);
            throw e;
        }
        Debug.traceExit(debug, className, methodName, on);
        return on;
    }

    @Override
    public int getTrafficClass() throws SocketException {
        String methodName = "getTrafficClass";
        Debug.traceEntry(debug, className, methodName);
        int tc = 0;
        try {
            tc = this.sslSocket.getTrafficClass();
        }
        catch (Exception e) {
            Debug.traceException(debug, className, methodName, e);
            Debug.traceExit(debug, className, methodName);
            throw e;
        }
        Debug.traceExit(debug, className, methodName, tc);
        return tc;
    }

    @Override
    public boolean isBound() {
        String methodName = "isBound";
        Debug.traceEntry(debug, className, methodName);
        boolean isBound = false;
        try {
            isBound = this.sslSocket.isBound();
        }
        catch (Exception e) {
            Debug.traceException(debug, className, methodName, e);
            Debug.traceExit(debug, className, methodName);
            throw e;
        }
        Debug.traceExit(debug, className, methodName, isBound);
        return isBound;
    }

    @Override
    public boolean isClosed() {
        String methodName = "isClosed";
        Debug.traceEntry(debug, className, methodName);
        boolean isClosed = false;
        try {
            isClosed = this.sslSocket.isClosed();
        }
        catch (Exception e) {
            Debug.traceException(debug, className, methodName, e);
            Debug.traceExit(debug, className, methodName);
            throw e;
        }
        Debug.traceExit(debug, className, methodName, isClosed);
        return isClosed;
    }

    @Override
    public boolean isConnected() {
        String methodName = "isConnected";
        Debug.traceEntry(debug, className, methodName);
        boolean isConnected = false;
        try {
            isConnected = this.sslSocket.isConnected();
        }
        catch (Exception e) {
            Debug.traceException(debug, className, methodName, e);
            Debug.traceExit(debug, className, methodName);
            throw e;
        }
        Debug.traceExit(debug, className, methodName, isConnected);
        return isConnected;
    }

    @Override
    public boolean isInputShutdown() {
        String methodName = "isInputShutdown";
        Debug.traceEntry(debug, className, methodName);
        boolean isInputShutdown = false;
        try {
            isInputShutdown = this.sslSocket.isInputShutdown();
        }
        catch (Exception e) {
            Debug.traceException(debug, className, methodName, e);
            Debug.traceExit(debug, className, methodName);
            throw e;
        }
        Debug.traceExit(debug, className, methodName, isInputShutdown);
        return isInputShutdown;
    }

    @Override
    public boolean isOutputShutdown() {
        String methodName = "isOutputShutdown";
        Debug.traceEntry(debug, className, methodName);
        boolean isOutputShutdown = false;
        try {
            isOutputShutdown = this.sslSocket.isOutputShutdown();
        }
        catch (Exception e) {
            Debug.traceException(debug, className, methodName, e);
            Debug.traceExit(debug, className, methodName);
            throw e;
        }
        Debug.traceExit(debug, className, methodName, isOutputShutdown);
        return isOutputShutdown;
    }

    @Override
    public void sendUrgentData(int data) throws IOException {
        String methodName = "sendUrgentData";
        Debug.traceEntry(debug, className, methodName, data);
        try {
            this.sslSocket.sendUrgentData(data);
        }
        catch (Exception e) {
            Debug.traceException(debug, className, methodName, e);
            Debug.traceExit(debug, className, methodName);
            throw e;
        }
        Debug.traceExit(debug, className, methodName);
    }

    @Override
    public void setKeepAlive(boolean on) throws SocketException {
        String methodName = "setKeepAlive";
        Debug.traceEntry(debug, className, methodName, on);
        try {
            this.sslSocket.setKeepAlive(on);
        }
        catch (Exception e) {
            Debug.traceException(debug, className, methodName, e);
            Debug.traceExit(debug, className, methodName);
            throw e;
        }
        Debug.traceExit(debug, className, methodName);
    }

    @Override
    public void setOOBInline(boolean on) throws SocketException {
        String methodName = "setOOBInline";
        Debug.traceEntry(debug, className, methodName, on);
        try {
            this.sslSocket.setOOBInline(on);
        }
        catch (Exception e) {
            Debug.traceException(debug, className, methodName, e);
            Debug.traceExit(debug, className, methodName);
            throw e;
        }
        Debug.traceExit(debug, className, methodName);
    }

    @Override
    public void setPerformancePreferences(int connectionTime, int latency, int bandwidth) {
        String methodName = "setPerformancePreferences";
        Debug.traceEntry(debug, className, methodName + bandwidth);
        try {
            this.sslSocket.setPerformancePreferences(connectionTime, latency, bandwidth);
        }
        catch (Exception e) {
            Debug.traceException(debug, className, methodName, e);
            Debug.traceExit(debug, className, methodName);
            throw e;
        }
        Debug.traceExit(debug, className, methodName);
    }

    @Override
    public void setReceiveBufferSize(int size) throws SocketException {
        String methodName = "setReceiveBufferSize";
        Debug.traceEntry(debug, className, methodName, size);
        try {
            this.sslSocket.setReceiveBufferSize(size);
        }
        catch (Exception e) {
            Debug.traceException(debug, className, methodName, e);
            Debug.traceExit(debug, className, methodName);
            throw e;
        }
        Debug.traceExit(debug, className, methodName);
    }

    @Override
    public void setReuseAddress(boolean on) throws SocketException {
        String methodName = "setReuseAddress";
        Debug.traceEntry(debug, className, methodName, on);
        try {
            this.sslSocket.setReuseAddress(on);
        }
        catch (Exception e) {
            Debug.traceException(debug, className, methodName, e);
            Debug.traceExit(debug, className, methodName);
            throw e;
        }
        Debug.traceExit(debug, className, methodName);
    }

    @Override
    public void setSendBufferSize(int size) throws SocketException {
        String methodName = "setSendBufferSize";
        Debug.traceEntry(debug, className, methodName, size);
        try {
            this.sslSocket.setSendBufferSize(size);
        }
        catch (Exception e) {
            Debug.traceException(debug, className, methodName, e);
            Debug.traceExit(debug, className, methodName);
            throw e;
        }
        Debug.traceExit(debug, className, methodName);
    }

    @Override
    public void setSoLinger(boolean on, int linger) throws SocketException {
        String methodName = "setSoLinger";
        Debug.traceEntry(debug, className, methodName, on, linger);
        try {
            this.sslSocket.setSoLinger(on, linger);
        }
        catch (Exception e) {
            Debug.traceException(debug, className, methodName, e);
            Debug.traceExit(debug, className, methodName);
            throw e;
        }
        Debug.traceExit(debug, className, methodName);
    }

    @Override
    public void setSoTimeout(int timeout) throws SocketException {
        String methodName = "setSoTimeout";
        Debug.traceEntry(debug, className, methodName, timeout);
        try {
            this.sslSocket.setSoTimeout(timeout);
        }
        catch (Exception e) {
            Debug.traceException(debug, className, methodName, e);
            Debug.traceExit(debug, className, methodName);
            throw e;
        }
        Debug.traceExit(debug, className, methodName);
    }

    @Override
    public void setTcpNoDelay(boolean on) throws SocketException {
        String methodName = "setTcpNoDelay";
        Debug.traceEntry(debug, className, methodName, on);
        try {
            this.sslSocket.setTcpNoDelay(on);
        }
        catch (Exception e) {
            Debug.traceException(debug, className, methodName, e);
            Debug.traceExit(debug, className, methodName);
            throw e;
        }
        Debug.traceExit(debug, className, methodName);
    }

    @Override
    public void setTrafficClass(int tc) throws SocketException {
        String methodName = "setTrafficClass";
        Debug.traceEntry(debug, className, methodName, tc);
        try {
            this.sslSocket.setTrafficClass(tc);
        }
        catch (Exception e) {
            Debug.traceException(debug, className, methodName, e);
            Debug.traceExit(debug, className, methodName);
            throw e;
        }
        Debug.traceExit(debug, className, methodName);
    }

    @Override
    public void shutdownInput() throws IOException {
        String methodName = "shutdownInput";
        Debug.traceEntry(debug, className, methodName);
        try {
            this.sslSocket.shutdownInput();
        }
        catch (Exception e) {
            Debug.traceException(debug, className, methodName, e);
            Debug.traceExit(debug, className, methodName);
            throw e;
        }
        Debug.traceExit(debug, className, methodName);
    }

    @Override
    public void shutdownOutput() throws IOException {
        String methodName = "shutdownOutput";
        Debug.traceEntry(debug, className, methodName);
        try {
            this.sslSocket.shutdownOutput();
        }
        catch (Exception e) {
            Debug.traceException(debug, className, methodName, e);
            Debug.traceExit(debug, className, methodName);
            throw e;
        }
        Debug.traceExit(debug, className, methodName);
    }

    private int sendzERT(SiocSSecattr ioctl) {
        String methodName = "sendzERT";
        Debug.traceEntry(debug, className, methodName, ioctl);
        int rc = -1;
        if (this.socket != null) {
            Debug.traceText(debug, className, methodName, "Underlying Socket is not null.  We must have a layered SSLSocket, so we will send the underlying Socket to zERT");
            rc = ioctl.send(this.socket);
        } else {
            Debug.traceText(debug, className, methodName, "Underlying Socket is null.  We must have a non-layered SSLSocket, so we will send the underlying SSLSocket to zERT");
            rc = ioctl.send((Socket)this.sslSocket);
        }
        if (rc != 0) {
            Debug.traceText(debug, className, methodName, "SiocSSecattr.send(SSLSocket) was unsuccessful, rc: " + rc);
        } else {
            Debug.traceText(debug, className, methodName, "Notified zERT successfully");
        }
        Debug.traceExit(debug, className, methodName, rc);
        return rc;
    }

    protected void queryzERT() {
        String methodName = "queryzERT";
        Debug.traceEntry(debug, className, methodName);
        try {
            Debug.traceText(debug, className, methodName, "Querying zERT");
            SiocSSecattr ioctl = new SiocSSecattr(SiocSSecattr.EventType.SECATTR_QUERY);
            int rc = this.sendzERT(ioctl);
            if (rc == 0) {
                SiocSSecattr.Status status = ioctl.getSecattriStatus();
                Debug.traceText(debug, className, methodName, "Queried zERT successfully: " + status);
                this.setzERTStatus(status);
            }
        }
        catch (Exception e) {
            Debug.traceText(debug, className, methodName, "Unable to query zERT, zERT will remain disabled");
            Debug.traceException(debug, className, methodName, e);
        }
        Debug.traceText(debug, className, methodName, "zERTEnabled: " + this.getzERTStatus());
        Debug.traceExit(debug, className, methodName);
    }

    protected void notifyzERTHandshakePossible() {
        String methodName = "notifyzERTHandshakePossible";
        Debug.traceEntry(debug, className, methodName);
        boolean completed = this.getInitialHandshakeCompleted();
        if (!completed) {
            this.setInitialHandshakeCompleted(true);
            this.notifyzERTInitialHandshake();
        }
        Debug.traceExit(debug, className, methodName);
    }

    protected void notifyzERTInitialHandshake() {
        String methodName = "notifyzERTInitialHandshake";
        Debug.traceEntry(debug, className, methodName);
        try {
            SiocSSecattr.Status status = this.getzERTStatus();
            if (status.equals((Object)SiocSSecattr.Status.SECATTR_DISABLED)) {
                Debug.traceText(debug, className, methodName, "zERT is disabled, skipping the notification");
                Debug.traceExit(debug, className, methodName);
                return;
            }
            SSLSession session = this.getSessionZERT();
            if (session == null) {
                Debug.traceText(debug, className, methodName, "Unable to obtain SSLSession, skipping the notification");
                Debug.traceExit(debug, className, methodName);
                return;
            }
            SiocSSecattr ioctl = new SiocSSecattr(SiocSSecattr.EventType.SECATTR_INITIALIZATION);
            this.addZERTInformation(ioctl, session);
            Debug.traceText(debug, className, methodName, "Notifying zERT");
            this.sendzERT(ioctl);
        }
        catch (Exception e) {
            Debug.traceText(debug, className, methodName, "Unable to notify zERT");
            Debug.traceException(debug, className, methodName, e);
        }
        Debug.traceExit(debug, className, methodName);
    }

    protected void notifyzERTRenegotiation() {
        String methodName = "notifyzERTRenegotiation";
        Debug.traceEntry(debug, className, methodName);
        try {
            SiocSSecattr.Status status = this.getzERTStatus();
            if (status.equals((Object)SiocSSecattr.Status.SECATTR_DISABLED)) {
                Debug.traceText(debug, className, methodName, "zERT is disabled, skipping the notification");
                Debug.traceExit(debug, className, methodName);
                return;
            }
            SSLSession session = this.getSessionZERT();
            if (session == null) {
                Debug.traceText(debug, className, methodName, "Unable to obtain SSLSession, skipping the notification");
                Debug.traceExit(debug, className, methodName);
                return;
            }
            SiocSSecattr ioctl = new SiocSSecattr(SiocSSecattr.EventType.SECATTR_RENEGOTIATION);
            this.addZERTInformation(ioctl, session);
            Debug.traceText(debug, className, methodName, "Notifying zERT");
            this.sendzERT(ioctl);
        }
        catch (Exception e) {
            Debug.traceText(debug, className, methodName, "Unable to notify zERT");
            Debug.traceException(debug, className, methodName, e);
        }
        Debug.traceExit(debug, className, methodName);
    }

    protected void notifyzERTFailure() {
        String methodName = "notifyzERTFailure";
        Debug.traceEntry(debug, className, methodName);
        boolean completed = this.getInitialHandshakeCompleted();
        if (completed) {
            this.notifyzERTTermination();
        } else {
            this.notifyzERTInitialHandshakeFailure();
        }
        Debug.traceExit(debug, className, methodName);
    }

    protected void notifyzERTTermination() {
        String methodName = "notifyzERTTermination";
        Debug.traceEntry(debug, className, methodName);
        try {
            SiocSSecattr.Status status = this.getzERTStatus();
            if (status.equals((Object)SiocSSecattr.Status.SECATTR_DISABLED)) {
                Debug.traceText(debug, className, methodName, "zERT is disabled, skipping the notification");
                Debug.traceExit(debug, className, methodName);
                return;
            }
            SiocSSecattr ioctl = new SiocSSecattr(SiocSSecattr.EventType.SECATTR_TERMINATION);
            Debug.traceText(debug, className, methodName, "Notifying zERT");
            this.sendzERT(ioctl);
        }
        catch (Exception e) {
            Debug.traceText(debug, className, methodName, "Unable to notify zERT");
            Debug.traceException(debug, className, methodName, e);
        }
        this.setInitialHandshakeCompleted(false);
        Debug.traceExit(debug, className, methodName);
    }

    protected void notifyzERTInitialHandshakeFailure() {
        String methodName = "notifyzERTInitialHandshakeFailure";
        Debug.traceEntry(debug, className, methodName);
        try {
            SiocSSecattr.Status status = this.getzERTStatus();
            if (status.equals((Object)SiocSSecattr.Status.SECATTR_DISABLED)) {
                Debug.traceText(debug, className, methodName, "zERT is disabled, skipping the notification");
                Debug.traceExit(debug, className, methodName);
                return;
            }
            SiocSSecattr ioctl = new SiocSSecattr(SiocSSecattr.EventType.SECATTR_FAILURE);
            Debug.traceText(debug, className, methodName, "Notifying zERT");
            this.sendzERT(ioctl);
        }
        catch (Exception e) {
            Debug.traceText(debug, className, methodName, "Unable to notify zERT");
            Debug.traceException(debug, className, methodName, e);
        }
        Debug.traceExit(debug, className, methodName);
    }

    private void addZERTInformation(SiocSSecattr ioctl, SSLSession session) {
        String methodName = "addZERTInformation";
        Debug.traceEntry(debug, className, methodName, ioctl, session);
        this.addProtocolProvider(ioctl);
        this.addProtVer(ioctl, session);
        this.addHandshakeRole(ioctl, session);
        this.addCipherSuiteInformation(ioctl, session);
        this.addFipsMode(ioctl);
        this.addEncThenMac(ioctl);
        this.addSessionID(ioctl, session);
        this.addCertificateInformation(ioctl, session);
        Debug.traceExit(debug, className, methodName);
    }

    private short getProtVer(SSLSession session) {
        String methodName = "getProtVer";
        Debug.traceEntry(debug, className, methodName, session);
        short secattriTlsProtVer = 0;
        try {
            String protocol = session.getProtocol();
            switch (protocol.toUpperCase()) {
                case "SSLV2": {
                    secattriTlsProtVer = 512;
                    break;
                }
                case "SSLV3": {
                    secattriTlsProtVer = 768;
                    break;
                }
                case "TLSV1": {
                    secattriTlsProtVer = 769;
                    break;
                }
                case "TLSV1.1": {
                    secattriTlsProtVer = 770;
                    break;
                }
                case "TLSV1.2": {
                    secattriTlsProtVer = 771;
                    break;
                }
                default: {
                    Debug.traceText(debug, className, methodName, "Protocol version not found, defaulting to unknown");
                    break;
                }
            }
        }
        catch (Exception e) {
            Debug.traceText(debug, className, methodName, "Unable to obtain protocol version for zERT");
            Debug.traceException(debug, className, methodName, e);
        }
        Debug.traceExit(debug, className, methodName, secattriTlsProtVer);
        return secattriTlsProtVer;
    }

    private byte getHandshakeRole(SSLSession session) {
        String methodName = "getHandshakeRole";
        Debug.traceEntry(debug, className, methodName, session);
        byte secattriTlsHandshakeRole = 0;
        try {
            secattriTlsHandshakeRole = this.getUseClientMode() ? (byte)1 : (this.getPeerAuth(session) ? (byte)3 : 2);
        }
        catch (Exception e) {
            Debug.traceText(debug, className, methodName, "Unable to obtain handshake role for zERT");
            Debug.traceException(debug, className, methodName, e);
        }
        Debug.traceExit(debug, className, methodName, secattriTlsHandshakeRole);
        return secattriTlsHandshakeRole;
    }

    private boolean getPeerAuth(SSLSession session) {
        String methodName = "getPeerAuth";
        Debug.traceEntry(debug, className, methodName, session);
        boolean isPeerAuth = false;
        try {
            session.getPeerCertificates();
            isPeerAuth = true;
        }
        catch (SSLPeerUnverifiedException e) {
            Debug.traceText(debug, className, methodName, "No peer certificate information available for zERT, peer was not authenticated");
        }
        catch (Exception e) {
            Debug.traceText(debug, className, methodName, "Error when trying to obtain peer certificate information for zERT");
            Debug.traceException(debug, className, methodName, e);
            Debug.traceExit(debug, className, methodName, isPeerAuth);
        }
        Debug.traceExit(debug, className, methodName, isPeerAuth);
        return isPeerAuth;
    }

    private String getNegCipher(SSLSession session) {
        String methodName = "getNegCipher";
        Debug.traceEntry(debug, className, methodName, session);
        String secattriTlsNegCipher = "";
        try {
            secattriTlsNegCipher = session.getCipherSuite();
        }
        catch (Exception e) {
            Debug.traceText(debug, className, methodName, "Unable to obtain negotiated cipher suite for zERT");
            Debug.traceException(debug, className, methodName, e);
        }
        Debug.traceExit(debug, className, methodName, secattriTlsNegCipher);
        return secattriTlsNegCipher;
    }

    private ZERTCipherInformation getCipherSuiteInformation(SSLSession session) {
        String methodName = "getCipherSuiteInformation";
        Debug.traceEntry(debug, className, methodName, session);
        ZERTCipherInformation cipherInfo = new ZERTCipherInformation();
        try {
            String negCipher = this.getNegCipher(session);
            cipherInfo = new ZERTCipherInformation(negCipher);
        }
        catch (Exception e) {
            Debug.traceText(debug, className, methodName, "Unable to obtain negotiated cipher suite information for zERT");
            Debug.traceException(debug, className, methodName, e);
        }
        Debug.traceExit(debug, className, methodName, cipherInfo);
        return cipherInfo;
    }

    private byte[] getSessionID(SSLSession session) {
        String methodName = "getSessionID";
        Debug.traceEntry(debug, className, methodName, session);
        byte[] secattriTlsSessionID = null;
        try {
            secattriTlsSessionID = session.getId();
        }
        catch (Exception e) {
            Debug.traceText(debug, className, methodName, "Unable to obtain session ID for zERT");
            Debug.traceException(debug, className, methodName, e);
        }
        Debug.traceExit(debug, className, methodName, secattriTlsSessionID);
        return secattriTlsSessionID;
    }

    private void addProtocolProvider(SiocSSecattr ioctl) {
        String methodName = "addProtocolProvider";
        Debug.traceEntry(debug, className, methodName, ioctl);
        try {
            String secattriProtocolProvider = "IBM JSSE";
            Debug.traceText(debug, className, methodName, "Calling setSecattriProtocolProvider with secattriProtocolProvider: " + secattriProtocolProvider);
            ioctl.setSecattriProtocolProvider(secattriProtocolProvider);
            Debug.traceText(debug, className, methodName, "Called setSecattriProtocolProvider successfully, ioctl: " + ioctl);
        }
        catch (Exception e) {
            Debug.traceText(debug, className, methodName, "Unable to send protocol provider to zERT");
            Debug.traceException(debug, className, methodName, e);
        }
        Debug.traceExit(debug, className, methodName);
    }

    private void addProtVer(SiocSSecattr ioctl, SSLSession session) {
        String methodName = "addProtVer";
        Debug.traceEntry(debug, className, methodName, ioctl, session);
        try {
            short secattriTlsProtVer = this.getProtVer(session);
            Debug.traceText(debug, className, methodName, "Calling setSecattriTlsProtVer with secattriTlsProtVer: " + secattriTlsProtVer);
            ioctl.setSecattriTlsProtVer(Short.valueOf(secattriTlsProtVer));
            Debug.traceText(debug, className, methodName, "Called setSecattriTlsProtVer successfully, ioctl: " + ioctl);
        }
        catch (Exception e) {
            Debug.traceText(debug, className, methodName, "Unable to send protocol version to zERT");
            Debug.traceException(debug, className, methodName, e);
        }
        Debug.traceExit(debug, className, methodName);
    }

    private void addHandshakeRole(SiocSSecattr ioctl, SSLSession session) {
        String methodName = "addHandshakeRole";
        Debug.traceEntry(debug, className, methodName, ioctl, session);
        try {
            byte secattriTlsHandshakeRole = this.getHandshakeRole(session);
            Debug.traceText(debug, className, methodName, "Calling setSecattriTlsHandshakeRole with secattriTlsHandshakeRole: " + secattriTlsHandshakeRole);
            ioctl.setSecattriTlsHandshakeRole(Byte.valueOf(secattriTlsHandshakeRole));
            Debug.traceText(debug, className, methodName, "Called setSecattriTlsHandshakeRole successfully, ioctl: " + ioctl);
        }
        catch (Exception e) {
            Debug.traceText(debug, className, methodName, "Unable to send handshake role to zERT");
            Debug.traceException(debug, className, methodName, e);
        }
        Debug.traceExit(debug, className, methodName);
    }

    private void addNegCipher(SiocSSecattr ioctl, String secattriTlsNegCipher) {
        String methodName = "addNegCipher";
        Debug.traceEntry(debug, className, methodName, ioctl, secattriTlsNegCipher);
        try {
            Debug.traceText(debug, className, methodName, "Calling setSecattriTlsNegCipher with secattriTlsNegCipher: " + secattriTlsNegCipher);
            ioctl.setSecattriTlsNegCipher(secattriTlsNegCipher);
            Debug.traceText(debug, className, methodName, "Called setSecattriTlsNegCipher successfully, ioctl: " + ioctl);
        }
        catch (Exception e) {
            Debug.traceText(debug, className, methodName, "Unable to send negotiated cipher suite to zERT");
            Debug.traceException(debug, className, methodName, e);
        }
        Debug.traceExit(debug, className, methodName);
    }

    private void addCSEncAlg(SiocSSecattr ioctl, short secattriTlsCSEncAlg) {
        String methodName = "addCSEncAlg";
        Debug.traceEntry(debug, className, methodName, ioctl, secattriTlsCSEncAlg);
        try {
            Debug.traceText(debug, className, methodName, "Calling setSecattriTlsCSEncAlg with secattriTlsCSEncAlg: " + secattriTlsCSEncAlg);
            ioctl.setSecattriTlsCSEncAlg(Short.valueOf(secattriTlsCSEncAlg));
            Debug.traceText(debug, className, methodName, "Called setSecattriTlsCSEncAlg successfully, ioctl: " + ioctl);
        }
        catch (Exception e) {
            Debug.traceText(debug, className, methodName, "Unable to send encryption algorithm to zERT");
            Debug.traceException(debug, className, methodName, e);
        }
        Debug.traceExit(debug, className, methodName);
    }

    private void addCSMsgAuth(SiocSSecattr ioctl, short secattriTlsCSMsgAuth) {
        String methodName = "addCSMsgAuth";
        Debug.traceEntry(debug, className, methodName, ioctl, secattriTlsCSMsgAuth);
        try {
            Debug.traceText(debug, className, methodName, "Calling setSecattriTlsCSMsgAuth with secattriTlsCSMsgAuth: " + secattriTlsCSMsgAuth);
            ioctl.setSecattriTlsCSMsgAuth(Short.valueOf(secattriTlsCSMsgAuth));
            Debug.traceText(debug, className, methodName, "Called setSecattriTlsCSMsgAuth successfully, ioctl: " + ioctl);
        }
        catch (Exception e) {
            Debug.traceText(debug, className, methodName, "Unable to send message authentication algorithm to zERT");
            Debug.traceException(debug, className, methodName, e);
        }
        Debug.traceExit(debug, className, methodName);
    }

    private void addCSKexAlg(SiocSSecattr ioctl, short secattriTlsCSKexAlg) {
        String methodName = "addCSKexAlg";
        Debug.traceEntry(debug, className, methodName, ioctl, secattriTlsCSKexAlg);
        try {
            Debug.traceText(debug, className, methodName, "Calling setSecattriTlsCSKexAlg with secattriTlsCSKexAlg: " + secattriTlsCSKexAlg);
            ioctl.setSecattriTlsCSKexAlg(Short.valueOf(secattriTlsCSKexAlg));
            Debug.traceText(debug, className, methodName, "Called setSecattriTlsCSKexAlg successfully, ioctl: " + ioctl);
        }
        catch (Exception e) {
            Debug.traceText(debug, className, methodName, "Unable to send key encryption algorithm to zERT");
            Debug.traceException(debug, className, methodName, e);
        }
        Debug.traceExit(debug, className, methodName);
    }

    private void addCipherSuiteInformation(SiocSSecattr ioctl, SSLSession session) {
        String methodName = "addCipherSuiteInformation";
        Debug.traceEntry(debug, className, methodName, ioctl, session);
        try {
            ZERTCipherInformation cipherInfo = this.getCipherSuiteInformation(session);
            this.addNegCipher(ioctl, cipherInfo.secattriTlsNegCipher);
            this.addCSEncAlg(ioctl, cipherInfo.secattriTlsCSEncAlg);
            this.addCSMsgAuth(ioctl, cipherInfo.secattriTlsCSMsgAuth);
            this.addCSKexAlg(ioctl, cipherInfo.secattriTlsCSKexAlg);
        }
        catch (Exception e) {
            Debug.traceText(debug, className, methodName, "Unable to send negotiated cipher suite information to zERT");
            Debug.traceException(debug, className, methodName, e);
        }
        Debug.traceExit(debug, className, methodName);
    }

    private void addFipsMode(SiocSSecattr ioctl) {
        String methodName = "addFipsMode";
        Debug.traceEntry(debug, className, methodName, ioctl);
        try {
            byte secattriTlsFipsMode = 0;
            Debug.traceText(debug, className, methodName, "Calling setSecattriTlsFipsMode with secattriTlsFipsMode: " + secattriTlsFipsMode);
            ioctl.setSecattriTlsFipsMode(Byte.valueOf(secattriTlsFipsMode));
            Debug.traceText(debug, className, methodName, "Called setSecattriTlsFipsMode successfully, ioctl: " + ioctl);
        }
        catch (Exception e) {
            Debug.traceText(debug, className, methodName, "Unable to send FIPS mode to zERT");
            Debug.traceException(debug, className, methodName, e);
        }
        Debug.traceExit(debug, className, methodName);
    }

    private void addEncThenMac(SiocSSecattr ioctl) {
        String methodName = "addEncThenMac";
        Debug.traceEntry(debug, className, methodName, ioctl);
        try {
            boolean secattriTlsEncThenMac = false;
            Debug.traceText(debug, className, methodName, "Calling setSecattriTlsEncThenMac with secattriTlsEncThenMac: " + secattriTlsEncThenMac);
            ioctl.setSecattriTlsEncThenMac(Boolean.valueOf(secattriTlsEncThenMac));
            Debug.traceText(debug, className, methodName, "Called setSecattriTlsEncThenMac successfully, ioctl: " + ioctl);
        }
        catch (Exception e) {
            Debug.traceText(debug, className, methodName, "Unable to send Encrypt-then-MAC flag to zERT");
            Debug.traceException(debug, className, methodName, e);
        }
        Debug.traceExit(debug, className, methodName);
    }

    private void addSessionID(SiocSSecattr ioctl, SSLSession session) {
        String methodName = "addSessionID";
        Debug.traceEntry(debug, className, methodName, ioctl, session);
        try {
            byte[] secattriTlsSessionID = this.getSessionID(session);
            Debug.traceText(debug, className, methodName, "Calling setSecattriTlsSessionID with secattriTlsSessionID: " + secattriTlsSessionID);
            ioctl.setSecattriTlsSessionID(secattriTlsSessionID);
            Debug.traceText(debug, className, methodName, "Called setSecattriTlsSessionID successfully, ioctl: " + ioctl);
        }
        catch (Exception e) {
            Debug.traceText(debug, className, methodName, "Unable to send session ID to zERT");
            Debug.traceException(debug, className, methodName, e);
        }
        Debug.traceExit(debug, className, methodName);
    }

    private void addCertificateInformation(SiocSSecattr ioctl, SSLSession session) {
        String methodName = "addCertificateInformation";
        Debug.traceEntry(debug, className, methodName, ioctl, session);
        boolean clientMode = this.getUseClientMode();
        SiocSSecattr.Status status = this.getzERTStatus();
        if (clientMode) {
            Debug.traceText(debug, className, methodName, "Using local certificates for client certificates and peer certificates for server certificates");
            this.addCertificateInformation(ioctl, session, status, Role.CLIENT, Role.SERVER);
        } else {
            Debug.traceText(debug, className, methodName, "Using local certificates for server certificates and peer certificates for client certificates");
            this.addCertificateInformation(ioctl, session, status, Role.SERVER, Role.CLIENT);
        }
        Debug.traceExit(debug, className, methodName);
    }

    private void addCertificateInformation(SiocSSecattr ioctl, SSLSession session, SiocSSecattr.Status status, Role localRole, Role peerRole) {
        String methodName = "addCertificateInformation";
        Debug.traceEntry(debug, className, methodName, ioctl, "session: " + session + ", status: " + status + ", localRole: " + (Object)((Object)localRole) + ", peerRole: " + (Object)((Object)peerRole));
        try {
            Certificate[] localCertificates = session.getLocalCertificates();
            this.addCertificateInformation(ioctl, localCertificates, status, localRole);
        }
        catch (Exception e) {
            Debug.traceText(debug, className, methodName, "Unable to obtain local certificate information for zERT");
            Debug.traceException(debug, className, methodName, e);
        }
        try {
            Certificate[] peerCertificates = session.getPeerCertificates();
            this.addCertificateInformation(ioctl, peerCertificates, status, peerRole);
        }
        catch (SSLPeerUnverifiedException e) {
            Debug.traceText(debug, className, methodName, "No peer certificate information available for zERT");
            ZERTCertificateUtils.addNULLCertificateInformation(ioctl, peerRole);
        }
        catch (Exception e) {
            Debug.traceText(debug, className, methodName, "Unable to obtain peer certificate information for zERT");
            Debug.traceException(debug, className, methodName, e);
        }
    }

    private void addCertificateInformation(SiocSSecattr ioctl, Certificate[] certificates, SiocSSecattr.Status status, Role role) {
        String methodName = "addCertificateInformation";
        Debug.traceEntry(debug, className, methodName, ioctl, "certificates: " + certificates + ", status: " + status + ", role: " + (Object)((Object)role));
        try {
            if (certificates != null) {
                Certificate cert = certificates[0];
                X509Certificate x509Cert = (X509Certificate)cert;
                ZERTCertificateUtils.addCertificateInformation(ioctl, x509Cert, status, role);
            } else {
                ZERTCertificateUtils.addNULLCertificateInformation(ioctl, role);
            }
        }
        catch (Exception e) {
            Debug.traceExit(debug, className, methodName);
            throw e;
        }
        Debug.traceExit(debug, className, methodName);
    }
}

