/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zertjsse;

import com.ibm.zertjsse.Debug;
import com.ibm.zertjsse.ZERTSSLServerSocketFactoryImpl;
import com.ibm.zertjsse.ZERTSSLSocketFactoryImpl;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLContextSpi;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

class ZERTSSLContextImpl
extends SSLContextSpi {
    protected static final Debug debug = Debug.getInstance("zertjsse");
    private static final String className = "com.ibm.zertjsse.ZERTSSLContextImpl";
    private SSLContext context;

    public ZERTSSLContextImpl(String protocol) throws NoSuchAlgorithmException, NoSuchProviderException {
        String methodName = "ZERTSSLContextImpl";
        Debug.traceEntry(debug, className, methodName, protocol);
        try {
            this.context = SSLContext.getInstance(protocol, "IBMJSSE2");
        }
        catch (Exception e) {
            Debug.traceException(debug, className, methodName, e);
            Debug.traceExit(debug, className, methodName);
            throw e;
        }
        Debug.traceExit(debug, className, methodName);
    }

    @Override
    protected void engineInit(KeyManager[] km, TrustManager[] tm, SecureRandom sr) throws KeyManagementException {
        String methodName = "engineInit";
        Debug.traceEntry(debug, className, methodName, "km: " + km + ", tm: " + tm + ", sr: " + sr);
        try {
            this.context.init(km, tm, sr);
        }
        catch (Exception e) {
            Debug.traceException(debug, className, methodName, e);
            Debug.traceExit(debug, className, methodName);
            throw e;
        }
        Debug.traceExit(debug, className, methodName);
    }

    @Override
    protected SSLSocketFactory engineGetSocketFactory() throws IllegalStateException {
        String methodName = "engineGetSocketFactory";
        Debug.traceEntry(debug, className, methodName);
        ZERTSSLSocketFactoryImpl factory = null;
        try {
            factory = new ZERTSSLSocketFactoryImpl(this.context.getSocketFactory());
        }
        catch (Exception e) {
            Debug.traceException(debug, className, methodName, e);
            Debug.traceExit(debug, className, methodName);
            throw e;
        }
        Debug.traceExit(debug, className, methodName, factory);
        return factory;
    }

    @Override
    protected SSLServerSocketFactory engineGetServerSocketFactory() throws IllegalStateException {
        String methodName = "engineGetServerSocketFactory";
        Debug.traceEntry(debug, className, methodName);
        ZERTSSLServerSocketFactoryImpl factory = null;
        try {
            factory = new ZERTSSLServerSocketFactoryImpl(this.context.getServerSocketFactory());
        }
        catch (Exception e) {
            Debug.traceException(debug, className, methodName, e);
            Debug.traceExit(debug, className, methodName);
            throw e;
        }
        Debug.traceExit(debug, className, methodName, factory);
        return factory;
    }

    @Override
    protected SSLEngine engineCreateSSLEngine() throws IllegalStateException {
        String methodName = "engineCreateSSLEngine";
        Debug.traceEntry(debug, className, methodName);
        SSLEngine engine = null;
        try {
            engine = this.context.createSSLEngine();
        }
        catch (Exception e) {
            Debug.traceException(debug, className, methodName, e);
            Debug.traceExit(debug, className, methodName);
            throw e;
        }
        Debug.traceExit(debug, className, methodName, engine);
        return engine;
    }

    @Override
    protected SSLEngine engineCreateSSLEngine(String host, int port) throws IllegalStateException {
        String methodName = "engineCreateSSLEngine";
        Debug.traceEntry(debug, className, methodName, host, port);
        SSLEngine engine = null;
        try {
            engine = this.context.createSSLEngine(host, port);
        }
        catch (Exception e) {
            Debug.traceException(debug, className, methodName, e);
            Debug.traceExit(debug, className, methodName);
            throw e;
        }
        Debug.traceExit(debug, className, methodName, engine);
        return engine;
    }

    @Override
    protected SSLSessionContext engineGetServerSessionContext() {
        String methodName = "engineGetServerSessionContext";
        Debug.traceEntry(debug, className, methodName);
        SSLSessionContext sessionContext = null;
        try {
            sessionContext = this.context.getServerSessionContext();
        }
        catch (Exception e) {
            Debug.traceException(debug, className, methodName, e);
            Debug.traceExit(debug, className, methodName);
            throw e;
        }
        Debug.traceExit(debug, className, methodName, sessionContext);
        return sessionContext;
    }

    @Override
    protected SSLSessionContext engineGetClientSessionContext() {
        String methodName = "engineGetClientSessionContext";
        Debug.traceEntry(debug, className, methodName);
        SSLSessionContext sessionContext = null;
        try {
            sessionContext = this.context.getClientSessionContext();
        }
        catch (Exception e) {
            Debug.traceException(debug, className, methodName, e);
            Debug.traceExit(debug, className, methodName);
            throw e;
        }
        Debug.traceExit(debug, className, methodName, sessionContext);
        return sessionContext;
    }

    @Override
    protected SSLParameters engineGetDefaultSSLParameters() throws UnsupportedOperationException {
        String methodName = "engineGetDefaultSSLParameters";
        Debug.traceEntry(debug, className, methodName);
        SSLParameters params = null;
        try {
            params = this.context.getDefaultSSLParameters();
        }
        catch (Exception e) {
            Debug.traceException(debug, className, methodName, e);
            Debug.traceExit(debug, className, methodName);
            throw e;
        }
        Debug.traceExit(debug, className, methodName, params);
        return params;
    }

    @Override
    protected SSLParameters engineGetSupportedSSLParameters() throws UnsupportedOperationException {
        String methodName = "engineGetSupportedSSLParameters";
        Debug.traceEntry(debug, className, methodName);
        SSLParameters params = null;
        try {
            params = this.context.getSupportedSSLParameters();
        }
        catch (Exception e) {
            Debug.traceException(debug, className, methodName, e);
            Debug.traceExit(debug, className, methodName);
            throw e;
        }
        Debug.traceExit(debug, className, methodName, params);
        return params;
    }
}

