/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.zertjsse;

import com.ibm.zertjsse.Debug;
import java.security.PublicKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import javax.crypto.interfaces.DHPublicKey;

class ZERTPublicKeyInformation {
    private static Debug debug = Debug.getInstance("zertjsse");
    private static final String className = "com.ibm.zertjsse.ZERTPublicKeyInformation";
    protected short secattriTlsCertKeyType = 0;
    protected short secattriTlsCertKeyLen = 0;

    protected ZERTPublicKeyInformation() {
        String methodName = "ZERTPublicKeyInformation";
        Debug.traceEntry(debug, className, methodName);
        Debug.traceExit(debug, className, methodName);
    }

    protected ZERTPublicKeyInformation(PublicKey key) {
        String methodName = "ZERTPublicKeyInformation";
        Debug.traceEntry(debug, className, methodName, key);
        try {
            if (key instanceof RSAPublicKey) {
                RSAPublicKey rsakey = (RSAPublicKey)key;
                this.secattriTlsCertKeyType = (short)2;
                this.secattriTlsCertKeyLen = (short)rsakey.getModulus().bitLength();
            } else if (key instanceof DSAPublicKey) {
                DSAPublicKey dsakey = (DSAPublicKey)key;
                this.secattriTlsCertKeyType = (short)3;
                this.secattriTlsCertKeyLen = (short)dsakey.getParams().getP().bitLength();
            } else if (key instanceof DHPublicKey) {
                DHPublicKey dhkey = (DHPublicKey)key;
                this.secattriTlsCertKeyType = (short)4;
                this.secattriTlsCertKeyLen = (short)dhkey.getParams().getP().bitLength();
            } else if (key instanceof ECPublicKey) {
                ECPublicKey eckey = (ECPublicKey)key;
                this.secattriTlsCertKeyType = (short)5;
                this.secattriTlsCertKeyLen = (short)eckey.getParams().getOrder().bitLength();
            } else {
                Debug.traceText(debug, className, methodName, "Unable to find public key type for zERT, using default unknown values");
            }
        }
        catch (Exception e) {
            Debug.traceText(debug, className, methodName, "There was an issue trying to obtain public key information for zERT");
            Debug.traceException(debug, className, methodName, e);
        }
        Debug.traceText(debug, className, methodName, "secattriTlsCertKeyType: " + this.secattriTlsCertKeyType + ", secattriTlsCertKeyLen: " + this.secattriTlsCertKeyLen);
        Debug.traceExit(debug, className, methodName);
    }
}

